(function ($) {
  var nbSliderAnimation = function ($scope, $) {
    $(".elementor-widget-nb-slider-animation").each(function (index, el) {
      var $this = $(el);
      var swiperSlider = new Swiper(
        ".elementor-nb_slider-wrapper.swiper-container",
        {
          slidesPerView: 1,
          loop: true,
          navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
          },
          pagination: {
            el: ".swiper-pagination",
            clickable: true,
          },
        }
      );
      swiperSlider.on("slideChangeTransitionStart", function () {
        var index = swiperSlider.realIndex;
        var headingActive = $("h2.index-" + index);

        var dataHeading = headingActive.attr("data-heading-animation");
        if (dataHeading) {
          headingActive.css("opacity", "0");
          headingActive.removeClass(dataHeading);
        }

        var descriptionActive = $(".description.index-" + index);

        var dataDescription = descriptionActive.attr("data-description-animation");
        if (dataDescription) {
          descriptionActive.css("opacity", "0");
          descriptionActive.removeClass(dataDescription);
        }

        var btn1Active = $(".button_1.index-" + index);

        var btn1Description = btn1Active.attr("data-button-1-animation");
        if (btn1Description) {
          btn1Active.css("opacity", "0");
          btn1Active.removeClass(btn1Description);
        }

        var btn2Active = $(".button_2.index-" + index);

        var btn2Description = btn2Active.attr("data-button-2-animation");
        if (btn2Description) {
          btn2Active.css("opacity", "0");
          btn2Active.removeClass(btn2Description);
        }
      });
      swiperSlider.on("slideChangeTransitionEnd", function () {
        var index = swiperSlider.realIndex;
        
        var headingActive = $("h2.index-" + index);
        var dataHeading = headingActive.attr("data-heading-animation");
        if (dataHeading) {
          headingActive.css("opacity", "1");
          headingActive.addClass(dataHeading);
        }

        var descriptionActive = $(".description.index-" + index);
        var dataDescription = descriptionActive.attr("data-description-animation");
        if (dataDescription) {
          descriptionActive.css("opacity", "1");
          descriptionActive.addClass(dataDescription);
        }

        var btn1Active = $(".button_1.index-" + index);
        var btn1Description = btn1Active.attr("data-button-1-animation");
        if (btn1Description) {
          btn1Active.css("opacity", "1");
          btn1Active.addClass(btn1Description);
        }

        var btn2Active = $(".button_2.index-" + index);
        var btn2Description = btn2Active.attr("data-button-2-animation");
        if (btn2Description) {
          btn2Active.css("opacity", "1");
          btn2Active.addClass(btn2Description);
        }
      });
    });
  };

  $(window).on("elementor/frontend/init", function () {
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/nb-slider-animation.default",
      nbSliderAnimation
    );
  });
})(jQuery);