"use strict";
(function ($) {
  $.block_top_reviews = function (element, options) {
    let defaults = {
      row_state_template: ""
    };
    let plugin = this;
    plugin.settings = {}
    let $element = $(element);
    plugin.init = function () {
      plugin.settings = $.extend({}, defaults, options);
      let $block_arrow = $element.find(".block-arrow");
      if ($element.hasClass('style1')) {
        $element.find(".content").slick({
          infinite: true,
          slidesToShow: 1,
          slidesToScroll: 1,
          adaptiveHeight: true,
          prevArrow: $block_arrow.find(".prev-arrow"),
          nextArrow: $block_arrow.find(".next-arrow"),
        });
      } else if ($element.hasClass('style2')) {
        $element.find(".content").slick({
          infinite: true,
          slidesToShow: 2,
          slidesToScroll: 1,
          adaptiveHeight: true,
          dots: true,
          arrow: false,
          responsive: [
            {
              breakpoint: 768,
              settings: {
                slidesToShow: 1,
                slidesToScroll: 1,
                adaptiveHeight: true,
              },
            },
            {
              breakpoint: 480,
              settings: {
                slidesToShow: 1,
                slidesToScroll: 1,
                adaptiveHeight: true,
              },
            },
            // You can unslick at a given breakpoint now by adding:
            // settings: "unslick"
            // instead of a settings object
          ],
        });
      }
      else if ($element.hasClass('style3')) {
        $element.find(".content").slick({
          infinite: true,
          slidesToShow: 3,
          slidesToScroll: 1,
          adaptiveHeight: true,
          dots: true,
          arrow: false,
          responsive: [
            {
              breakpoint: 1200,
              settings: {
                slidesToShow: 2,
                slidesToScroll: 1,
              },
            },
            {
              breakpoint: 768,
              settings: {
                slidesToShow: 1,
                slidesToScroll: 1,
              },
            },
          ],
        });
      }
            
    };
    plugin.init();
  }
  $.fn.block_top_reviews = function (options) {
    return this.each(function () {
      if (undefined == $(this).data('block_top_reviews')) {
        let plugin = new $.block_top_reviews(this, options);
        $(this).data('block_top_reviews', plugin);
      }
    });
  }
})(jQuery);
