"use strict";
(function ($) {
    $.block_popular_hotel = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $block_arrow=$element.find(".block-arrow");
            if ($element.hasClass('style2')){
                $element.find('.slide').slick({
                    infinite: true,
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    prevArrow: $block_arrow.find('.prev-arrow'),
                    nextArrow: $block_arrow.find('.next-arrow'),
                    responsive: [
                        {
                            breakpoint: 1441,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1,
                                infinite: true,
                            }
                        },
                        {
                            breakpoint: 1025,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                                dots: true,
                            }
                        },
                        {
                            breakpoint: 481,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                arrows: false,
                                dots: true,
    
                            }
                        }
                    ]
                });
            }else{
                $element.find('.slide').slick({
                    infinite: true,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    prevArrow: $block_arrow.find('.prev-arrow'),
                    nextArrow: $block_arrow.find('.next-arrow'),
                    responsive: [
                        {
                            breakpoint: 1199,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1,
                                infinite: true,
                            }
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 576,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                dots: true,
                                arrows: false
    
                            }
                        }
                    ]
                });
            }
           
            $element.find('.heart').on('click',function(e){
                let $hotel_item = $(this).closest('.wishlist-item');
                let hotel_id = $hotel_item.data('hotel_id');
                let user_id = $hotel_item.data('user_id');
                let $wishlist_icon = $(this);
                if(user_id==""){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    hotel_id: hotel_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookinghotel_root_url + wpbookinghotel_api_task,
                    data: data,
                    beforeSend: function () {
                        $wishlist_icon.toggleClass("active");
                        $wishlist_icon.find('i').removeClass("fa-heart").addClass("fa-spinner fa-spin");
                    },
                    error: function (xhr) {
                         
                    },
                    complete: function () {
                        $wishlist_icon.find('i').addClass("fa-heart").removeClass("fa-spinner fa-spin");
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })

        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_popular_hotel = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('block_popular_hotel')) {
                let plugin = new $.block_popular_hotel(this, options);
                $(this).data('block_popular_hotel', plugin);
            }
        });
    }
    $('div.dropdown-menu').on('click', function(event){
        // The event won't be propagated up to the document NODE and
        // therefore delegated events won't be fired
        event.stopPropagation();
    });
})(jQuery);
