"use strict";
(function ($) {
    $.block_popular_hotel = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $block_arrow=$element.find(".block-arrow");
            if ($element.hasClass('style2')){
                $element.find('.slide').slick({
                    infinite: true,
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    prevArrow: $block_arrow.find('.prev-arrow'),
                    nextArrow: $block_arrow.find('.next-arrow'),
                    responsive: [
                        {
                            breakpoint: 1441,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1,
                                infinite: true,
                            }
                        },
                        {
                            breakpoint: 1025,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                                dots: true,
                            }
                        },
                        {
                            breakpoint: 481,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                arrows: false,
                                dots: true,
    
                            }
                        }
                    ]
                });
            }else{
                $element.find('.slide').slick({
                    infinite: true,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    prevArrow: $block_arrow.find('.prev-arrow'),
                    nextArrow: $block_arrow.find('.next-arrow'),
                    responsive: [
                        {
                            breakpoint: 1199,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1,
                                infinite: true,
                            }
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 576,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                dots: true,
                                arrows: false
    
                            }
                        }
                    ]
                });
            }
           
            $element.find('.heart').on('click',function(e){
                let $hotel_item = $(this).closest('.wishlist-item');
                let hotel_id = $hotel_item.data('hotel_id');
                let user_id = $hotel_item.data('user_id');
                let $wishlist_icon = $(this);
                if(user_id==""){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    hotel_id: hotel_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookinghotel_root_url + wpbookinghotel_api_task,
                    data: data,
                    beforeSend: function () {
                        $wishlist_icon.toggleClass("active");
                        $wishlist_icon.find('i').removeClass("fa-heart").addClass("fa-spinner fa-spin");
                    },
                    error: function (xhr) {
                         
                    },
                    complete: function () {
                        $wishlist_icon.find('i').addClass("fa-heart").removeClass("fa-spinner fa-spin");
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })

        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_popular_hotel = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('block_popular_hotel')) {
                let plugin = new $.block_popular_hotel(this, options);
                $(this).data('block_popular_hotel', plugin);
            }
        });
    }
    $('div.dropdown-menu').on('click', function(event){
        // The event won't be propagated up to the document NODE and
        // therefore delegated events won't be fired
        event.stopPropagation();
    });
})(jQuery);

"use strict";
(function ($) {
    $.block_top_destinations_hotel = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $block_arrow=$element.find(".block-arrow");
            if($element.hasClass('style2')){
                $element.find(".box-hotel").slick({
                    infinite: true,
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    adaptiveHeight: true,
                    prevArrow: $block_arrow.find('.prev-arrow'),
                    nextArrow: $block_arrow.find('.next-arrow'),
                    responsive: [
                        {
                          breakpoint: 1024,
                          settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                            infinite: true,
                          }
                        },
                        {
                          breakpoint: 768,
                          settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1
                          }
                        },
                        {
                          breakpoint: 576,
                          settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots:true,
                            arrow:false,
                          }
                        }
                        // You can unslick at a given breakpoint now by adding:
                        // settings: "unslick"
                        // instead of a settings object
                      ]
                });
            }
            
        };
        
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_top_destinations_hotel = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('block_top_destinations_hotel')) {
                let plugin = new $.block_top_destinations_hotel(this, options);
                $(this).data('block_top_destinations_hotel', plugin);
            }
        });
    }
    $('div.dropdown-menu').on('click', function(event){
        // The event won't be propagated up to the document NODE and
        // therefore delegated events won't be fired
        event.stopPropagation();
    });
})(jQuery);

"use strict";
(function ($) {
  $.block_top_reviews = function (element, options) {
    let defaults = {
      row_state_template: ""
    };
    let plugin = this;
    plugin.settings = {}
    let $element = $(element);
    plugin.init = function () {
      plugin.settings = $.extend({}, defaults, options);
      let $block_arrow = $element.find(".block-arrow");
      if ($element.hasClass('style1')) {
        $element.find(".content").slick({
          infinite: true,
          slidesToShow: 1,
          slidesToScroll: 1,
          adaptiveHeight: true,
          prevArrow: $block_arrow.find(".prev-arrow"),
          nextArrow: $block_arrow.find(".next-arrow"),
        });
      } else if ($element.hasClass('style2')) {
        $element.find(".content").slick({
          infinite: true,
          slidesToShow: 2,
          slidesToScroll: 1,
          adaptiveHeight: true,
          dots: true,
          arrow: false,
          responsive: [
            {
              breakpoint: 768,
              settings: {
                slidesToShow: 1,
                slidesToScroll: 1,
                adaptiveHeight: true,
              },
            },
            {
              breakpoint: 480,
              settings: {
                slidesToShow: 1,
                slidesToScroll: 1,
                adaptiveHeight: true,
              },
            },
            // You can unslick at a given breakpoint now by adding:
            // settings: "unslick"
            // instead of a settings object
          ],
        });
      }
      else if ($element.hasClass('style3')) {
        $element.find(".content").slick({
          infinite: true,
          slidesToShow: 3,
          slidesToScroll: 1,
          adaptiveHeight: true,
          dots: true,
          arrow: false,
          responsive: [
            {
              breakpoint: 1200,
              settings: {
                slidesToShow: 2,
                slidesToScroll: 1,
              },
            },
            {
              breakpoint: 768,
              settings: {
                slidesToShow: 1,
                slidesToScroll: 1,
              },
            },
          ],
        });
      }
            
    };
    plugin.init();
  }
  $.fn.block_top_reviews = function (options) {
    return this.each(function () {
      if (undefined == $(this).data('block_top_reviews')) {
        let plugin = new $.block_top_reviews(this, options);
        $(this).data('block_top_reviews', plugin);
      }
    });
  }
})(jQuery);

jQuery(document).ready(function() {
    jQuery(".has-account a,.lost").click(function() {
        jQuery(".tab_content_login").hide();
        var activeTab = jQuery(this).attr("href");
        jQuery(activeTab).show();
    });
});
jQuery(document).ready(function($) {
    $('a#show_login,a.show_login').on('click', function(e){
        $('.hotelier-singup-register').after('<div class="login_overlay"></div>');
        $('.hotelier-singup-register').fadeIn(500);
        $('div.login_overlay, #login-register-password a.close').on('click', function(event){
            event.preventDefault();
            $('div.login_overlay').remove();
            $('.hotelier-singup-register').hide();
        });
        e.preventDefault();
    });
});
jQuery(document).ready(function($) {
    let $login = $('.hotelier-singup-register').find('.tab_container_login');
    let $url_add = hotelier_elements.siteUrl+'/sellercenter/wb_hotel/?layout=form';
    if ($login.length > 0) {
        $('li.button-header,.add-hotel a').on('click', function(e){
            $('.hotelier-singup-register').after('<div class="login_overlay"></div>');
            $('.hotelier-singup-register').fadeIn(500);
            $('div.login_overlay, #login-register-password a.close').on('click', function(event){
                event.preventDefault();
                $('div.login_overlay').remove();
                $('.hotelier-singup-register').hide();
            });
            e.preventDefault();
        });
    }
    else{
        $('li.button-header>a,.add-hotel a').attr('href',$url_add);
    }
});


jQuery(document).ready(function () {
    // Show the first tab and hide the rest
    jQuery('.widget_nb_recent_posts_widget #tabs-nav li:first-child').addClass('active');
    jQuery('.widget_nb_recent_posts_widget .tab-content').hide();
    jQuery('.widget_nb_recent_posts_widget .tab-content:first').show();

    // Click function
    jQuery('.widget_nb_recent_posts_widget #tabs-nav li').click(function () {
        jQuery('.widget_nb_recent_posts_widget #tabs-nav li').removeClass('active');
        jQuery(this).addClass('active');
        jQuery('.widget_nb_recent_posts_widget .tab-content').hide();

        var activeTab = jQuery(this).find('a').attr('href');
        jQuery(activeTab).fadeIn();
        return false;
    });
});
(function ($) {
  var nbSliderAnimation = function ($scope, $) {
    $(".elementor-widget-nb-slider-animation").each(function (index, el) {
      var $this = $(el);
      var swiperSlider = new Swiper(
        ".elementor-nb_slider-wrapper.swiper-container",
        {
          slidesPerView: 1,
          loop: true,
          navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
          },
          pagination: {
            el: ".swiper-pagination",
            clickable: true,
          },
        }
      );
      swiperSlider.on("slideChangeTransitionStart", function () {
        var index = swiperSlider.realIndex;
        var headingActive = $("h2.index-" + index);

        var dataHeading = headingActive.attr("data-heading-animation");
        if (dataHeading) {
          headingActive.css("opacity", "0");
          headingActive.removeClass(dataHeading);
        }

        var descriptionActive = $(".description.index-" + index);

        var dataDescription = descriptionActive.attr("data-description-animation");
        if (dataDescription) {
          descriptionActive.css("opacity", "0");
          descriptionActive.removeClass(dataDescription);
        }

        var btn1Active = $(".button_1.index-" + index);

        var btn1Description = btn1Active.attr("data-button-1-animation");
        if (btn1Description) {
          btn1Active.css("opacity", "0");
          btn1Active.removeClass(btn1Description);
        }

        var btn2Active = $(".button_2.index-" + index);

        var btn2Description = btn2Active.attr("data-button-2-animation");
        if (btn2Description) {
          btn2Active.css("opacity", "0");
          btn2Active.removeClass(btn2Description);
        }
      });
      swiperSlider.on("slideChangeTransitionEnd", function () {
        var index = swiperSlider.realIndex;
        
        var headingActive = $("h2.index-" + index);
        var dataHeading = headingActive.attr("data-heading-animation");
        if (dataHeading) {
          headingActive.css("opacity", "1");
          headingActive.addClass(dataHeading);
        }

        var descriptionActive = $(".description.index-" + index);
        var dataDescription = descriptionActive.attr("data-description-animation");
        if (dataDescription) {
          descriptionActive.css("opacity", "1");
          descriptionActive.addClass(dataDescription);
        }

        var btn1Active = $(".button_1.index-" + index);
        var btn1Description = btn1Active.attr("data-button-1-animation");
        if (btn1Description) {
          btn1Active.css("opacity", "1");
          btn1Active.addClass(btn1Description);
        }

        var btn2Active = $(".button_2.index-" + index);
        var btn2Description = btn2Active.attr("data-button-2-animation");
        if (btn2Description) {
          btn2Active.css("opacity", "1");
          btn2Active.addClass(btn2Description);
        }
      });
    });
  };

  $(window).on("elementor/frontend/init", function () {
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/nb-slider-animation.default",
      nbSliderAnimation
    );
  });
})(jQuery);

jQuery(document).ready(function ($) {

    "use strict";
    $(window).on('elementor/frontend/init', function() {
        
        elementorFrontend.hooks.addAction( 'frontend/element_ready/section', function( $element ) {
            $(".nb-testimonials-container").each(function(){
        
                var $this           = $(this),
                    currentID       = $this.attr('id'),
                    style           = $this.attr('data-style'),
                    currentSelector = '#' + currentID + ' .nb-testimonials-wrapper';
    
                
                if(style == "multiple_column") {
                    var testimonialParams = {
                        grabCursor: false,
                        slidesPerView: 1,                        
                        spaceBetween: 30,
                        pagination: {
                            el: '#' + currentID + ' .swiper-pagination',
                            clickable: true,
                        },
                        navigation: {
                            nextEl: '#' + currentID + ' .swiper-button-next',
                            prevEl: '#' + currentID + ' .swiper-button-prev',
                        },
                        observer: true,
                        observeParents: true,
                        breakpoints: {
                            // when window width is >= 576px
                            576: {
                                slidesPerView: 1,
                                spaceBetween: 20
                            },
                            // when window width is >= 768px
                            768: {
                                slidesPerView: 2,
                                spaceBetween: 20
                            },
                            // when window width is >= 992px
                            992: {
                                slidesPerView: 2
                            }
                        }
                    }
                    var testimonialSwiper = new Swiper(currentSelector, testimonialParams);                    
                }
                else if(style == "one_column") {
                    var testimonialParams = {
                        grabCursor: false,
                        slidesPerView: 1,
                        slidesPerColumn: 1,
                        pagination: {
                            el: '#' + currentID + ' .swiper-pagination',
                            clickable: true,
                        },
                        observer: true,
                        observeParents: true,
                        navigation: {
                            nextEl: '#' + currentID + ' .swiper-button-next',
                            prevEl: '#' + currentID + ' .swiper-button-prev',
                        },
                    }
                    var testimonialSwiper = new Swiper(currentSelector, testimonialParams);

                    testimonialSwiper.on('slideChange', function () {
                        $('#' + currentID + " .swiper-pagination-bullet").removeClass("swiper-pagination-bullet-active");
                        $('#' + currentID + " .swiper-pagination-bullet:eq("+testimonialSwiper.activeIndex+")").addClass("swiper-pagination-bullet-active");
                    });
                }
                else if(style == "sync_thumbnail_content") {
    
                    var avatarParams = {
                        initialSlide: 1,
                        slidesPerView: 3,
                        centeredSlides: true,
                        slideToClickedSlide: true,
                        observer: true,
                        observeParents: true,
                        // spaceBetween:
                    };
    
                    var contentParams = {
                        grabCursor: false,
                        initialSlide: 1,
                        slidesPerView: 1,
                        centeredSlides: true,
                        observer: true,
                        observeParents: true,
                        pagination: {
                            el: '.testimonial-pagination',
                            clickable: true,
                        },
                        navigation: {
                            nextEl: '.swiper-button-next',
                            prevEl: '.swiper-button-prev',
                        },
                    };
    
    
                    var avatarSelector = '#' + currentID + ' .nb-testimonials-avatar-wrapper';
                    var contentSelector = '#' + currentID + ' .nb-testimonials-content-wrapper';
                    
                    var avatarSwiper = new Swiper(avatarSelector, avatarParams);
                    var contentSwiper = new Swiper(contentSelector, contentParams);
    
                    avatarSwiper.on( 'slideChange', function () {
    
                        var currentIndex = avatarSwiper.activeIndex;
                        contentSwiper.slideTo( currentIndex, 300, false );
    
                    });
    
                    contentSwiper.on('slideChange', function () {
    
                        var currentIndex = contentSwiper.activeIndex;
                        avatarSwiper.slideTo( currentIndex, 300, false );
                        contentSwiper.update();
    
                    });
                }
    
                
            });
        });

    });
});
"use strict";
(function($) {
    $.view_hotel_detail = function(element, options) {
        let defaults = {
            render_list_review: "",
            items_per_page: 6,
            visiblePages: 3,
        }
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function() {
            plugin.settings = $.extend({}, defaults, options);
            let $block_slide = $element.find('.block-slide');
            if($element.hasClass('style-1')){
                $element.find('.gallery-slide').slick({
                    infinite: false,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    arrows: true,
                    prevArrow: $block_slide.find('.arrow-prev'),
                    nextArrow: $block_slide.find('.arrow-next'),
                    responsive: [{
                            breakpoint: 1199,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1,
                            }
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 576,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                dots: true,
                                arrows: false

                            }
                        }
                    ]
                });
                $('.block-magnifig').magnificPopup({
                    delegate: 'a',
                    type: 'image',
                    gallery:{enabled:true},
                });   
                // let $img_popup = $element.find('.block-magnifig a');
                // $('.gallery-slide .slick-slide' ).on('click', function(){
                //     let $index = $(this).index();
                //     $($img_popup[$index]).trigger('click');
                // })
                $(function() {
                    var $img_popup = $element.find('.block-magnifig a');
                    var isDragging = false;
                    $('.gallery-slide .slick-slide' )
                        .mousedown(function() { 
                            $(window).mousemove(function() {
                                    isDragging = true;
                                    $(window).unbind("mousemove");
                            });
                        })
                        .mouseup(function() {
                            var wasDragging = isDragging;
                            isDragging = false;
                            $(window).unbind("mousemove");
                            if(!wasDragging){
                                let $index = $(this).index();
                                $($img_popup[$index]).trigger('click');
                            }
                        })
                });
            }else if($element.hasClass('style-3')){
                    var n;
                    function thumbImg(){
                        n =  8;
                        let width_window = window.innerWidth;
                        if(width_window < 1200 && width_window > 768){
                            n = 6;
                        }else if(width_window <= 768 && width_window > 320){
                            n = 5;
                        }else if(width_window <= 320){
                            n = 4;
                        }
                    }
                    thumbImg();
                    $(window).resize(function(){
                        thumbImg();
                    })
                    let srcs = plugin.settings.srcs;
                    let $space_Between = 10;
                    var galleryTop = new Swiper('.gallery-top', {
                        spaceBetween:0,
                        loop: false,
                        navigation: {
                        nextEl: '.swiper-button-next',
                        prevEl: '.swiper-button-prev',
                        },
                        observer: true,
                        observeParents: true,
                        pagination: {
                            el: '.swiper-pagination',
                                clickable: true,
                                renderBullet: function (index, className) {    
                                    let classClick = " ";
                                    if(index == (n-1)) {
                                        classClick = " click-in";
                                    }   
                                    return '<a href="'+ srcs[index]+'" class="' + className + classClick + '"><div style="background-image: url('+srcs[index]+');"></div></a>';                                                        
                                },
                        },
                    });
                    let $swiper_wrapper = $element.find('.gallery-top .swiper-wrapper');
                    let $swiper_wrapper_img = $swiper_wrapper.find('.img-block')
                    let $gallery_top = $element.find('.gallery-top .swiper-slide');
                    let $thumbs = $element.find('.swiper-pagination');
                    let $thumbs_img = $thumbs.find('.swiper-pagination-bullet');
                    let $thumbs_number = $('.swiper-pagination .swiper-pagination-bullet').length;

                    
                    
    
                    function fixSize() {
                        $($thumbs_img).css('margin-right','0px')
                        for (let i = 0; i < (n-1);i++){
                            $($thumbs_img[i]).css('margin-right',''+ $space_Between +'px')
                        }
                        let $rest_thumbs_number = $thumbs_number - n;
                        $($thumbs_img.find('p.rest')).remove();
                        if ($rest_thumbs_number > 0){
                            $($thumbs_img[n-1]).append("<p class='rest'>+"+ $rest_thumbs_number +"</p>");
                        }
                        $($thumbs_img).removeClass('click-in');
                        $($thumbs_img[n-1]).addClass('click-in');
                        let $width_wrapper = $swiper_wrapper.width();
                        let $width_thumb = $thumbs.width();
                        $swiper_wrapper_img.height((2*$width_wrapper)/3);
                        $swiper_wrapper_img.width($width_wrapper);
                        let $size = ($width_thumb-(n-1)*10)/n
                        let $bottom = $size + 75;
                        // Set width,height thumbs 
                        $thumbs_img.width($size);
                        $thumbs_img.height($size);
                        $thumbs.height($size);
        
                        $thumbs.css('bottom',''+ -$size - 10+'px')
    
                        $('.slide-detail').css('padding-bottom',''+ $bottom +'px')
                    }
                    fixSize();
    
                    $(window).resize(function(){
                        fixSize();
                    });
    
                    $('a.click-in').on('click',function(){
                        var $this = $(this);
                        $(".swiper-pagination a").not(this).addClass('click-in');
                        $('.swiper-pagination').magnificPopup({
                            delegate: 'a.click-in',
                            type: 'image',
                            gallery:{enabled:true},
                            callbacks: {
                                close: function(){
                                    $(".swiper-pagination a").not($this).removeClass('click-in');
                                }
                            }
                        });                    
                    })
            }
            $element.find('.wishlist-detail').on('click',function(e){

                let hotel_id = $(this).data('hotel_id');
                let user_id = $(this).data('user_id');
                let $wishlist_icon = $(this);
                if(user_id==""){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    hotel_id: hotel_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookinghotel_root_url + wpbookinghotel_api_task,
                    data: data,
                    beforeSend: function () {
                        if(!$wishlist_icon.hasClass("active")){
                            $wishlist_icon.find('i').hide();
                            $wishlist_icon.addClass('loading-item');
                        }
                        else{
                            $wishlist_icon.toggleClass('active');
                        }
                    },
                    error: function (xhr) {
                         
                    },
                    complete: function () {
                         $wishlist_icon.find('i').show();
                            if($wishlist_icon.hasClass('loading-item')){
                                $wishlist_icon.toggleClass('active');
                            }
                            $wishlist_icon.removeClass('loading-item');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })

            $element.find('form[name="form-review"]').each(function(e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.share-link .btn-note li a').on('click',function(){
                window.open(this.href,this.title,'width=500,height=500,top=300px,left=300px'); 
                return false;
            })
            $element.find('.btn-save-review').on('click', function() {
                let $form = $(this).closest('form[name="form-review"]');
                let rating = $form.find('input[name="rating"]').val();
                if (rating === '') {
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please rating star</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    return false;
                }
                $form.submit();
            });

            let nowDate = new Date();
            let today = new Date(nowDate.getFullYear(), nowDate.getMonth(), nowDate.getDate(), 0, 0, 0, 0);
            $element.find('input[id="check-in"]').on('change', function() {
                let date = moment($element.find('input[id="check-in"]').val(), "YYYY-MM-DD").add(1, 'd');
                $element.find('input[id="check-out"]').data('daterangepicker').minDate = date;
                $element.find('input[id="check-out"]').data('daterangepicker').startDate = date;
                $element.find('input[id="check-out"]').val(date.format("YYYY-MM-DD"));
                $element.find('input[name="check_out"]').val(date.format("YYYY-MM-DD"));
            });
            $element.find('input[id="check-out"]').on('change', function() {
                let date = moment($element.find('input[id="check-out"]').val(), "YYYY-MM-DD").subtract(1, 'd');
                $element.find('input[id="check-in"]').data('daterangepicker').maxDate = date;
            });

            $element.find('.btn-select-room-type').on('click', function() {
                let $box_room = $(this).closest('.box-room');
                let room_type_id = $box_room.data('roomtype_id');
                $element.find('select[name="roomtype_id"]').val(room_type_id).trigger('change');
                $('body,html').animate({
                    scrollTop: $element.find('.input-right').offset().top
                }, 500, "linear");
            })

            $element.find('.btn-booking-hotel').on('click', function() {
                let $form = $(this).closest('form[name="booking-form"]');
                let date_checkin = $form.find('input[name="check_in"]').val();
                let date_checkout = $form.find('input[name="check_out"]').val();
                let roomtype_id = $form.find('select[name="roomtype_id"]').val();
                if (date_checkin === '') {
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your date checkin</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (date_checkout === '') {
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your date checkout</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (roomtype_id === '') {
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your roomtype</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    return false;
                }
                $form.submit();
            });

            let $wrapper_list_review = $element.find('.wrapper-list-review');
            let $render_list_review = $(plugin.settings.render_list_review);
            let $render_item_review = $render_list_review.filter('.render-item-review');
            let items_per_page = plugin.settings.items_per_page;
            let total_result = $render_item_review.length;
            let total_page = Math.ceil(total_result / items_per_page);
            let visiblePages = (total_page <= 4) ? (total_page % 4) : 4;

            $element.find('.pagination-review').twbsPagination({
                totalPages: (total_page === 0) ? 1 : total_page,
                visiblePages: visiblePages,
                hideOnlyOnePage: true,
                first: '',
                prev: '<i class="fas fa-arrow-left"></i>',
                next: '<i class="fas fa-arrow-right"></i>',
                last: '',
                onPageClick: function(event, page) {
                    var data_page = $render_item_review.slice((page - 1) * items_per_page, page * items_per_page);
                    $wrapper_list_review.empty();

                    $.each(data_page, function(index, review) {
                        $wrapper_list_review.append(review.outerHTML);
                    });

                }
            });
            
            // var sidebar = new StickySidebar('.hotelier-sticky .content-right', {topSpacing: 20});
            // $('.hotelier-sticky .content-right').stickySidebar({
            //     topSpacing: 60,
            //     bottomSpacing: 60
            // });
            plugin.sticky_sidebar()
            $(window).on('resize', function () {
                plugin.sticky_sidebar()
            });

        };
        plugin.example_function = function() {};
        plugin.sticky_sidebar=function(){
            var $sticky = $element.find('.hotelier-sticky .content-right');
            if ($sticky.length > 0) {
                $($sticky).stick_in_parent()
                    .on('sticky_kit:bottom', function(e) {
                        $($sticky).removeClass('custom-sticky');
                    })
                    .on('sticky_kit:unbottom', function(e) {
                        $($sticky).addClass('custom-sticky');
                    });

                $(window).on('resize', function () {
                    $($sticky).trigger('sticky_kit:detach');
                });
            }
        }
        plugin.init();
    }
    $.fn.view_hotel_detail = function(options) {
        return this.each(function() {
            if (undefined == $(this).data('view_hotel_detail')) {
                let plugin = new $.view_hotel_detail(this, options);
                $(this).data('view_hotel_detail', plugin);
            }
        });
    }
})(jQuery);
"use strict";
(function ($) {
    $.view_list_hotels = function (element, options) {
        let defaults = {
            render_hotel_grid:"",
            render_hotel_list:"",
            items_per_page: 9,
            visiblePages: 3,
        };
        var wrapHeight = $('.data-listservice-ajax').height() + $('.data-listservice-ajax').offset().top;
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('select.block-sort').select2();
            let nowDate = new Date();
            let today = new Date(nowDate.getFullYear(), nowDate.getMonth(), nowDate.getDate(), 0, 0, 0, 0);
            $element.find('input[id="check-in"]').on('change', function () {
                let date = moment($element.find('input[id="check-in"]').val(), "YYYY-MM-DD").add(1, 'd');
                $element.find('input[id="check-out"]').data('daterangepicker').minDate = date;
                $element.find('input[id="check-out"]').data('daterangepicker').startDate = date;
                $element.find('input[id="check-out"]').val(date.format("YYYY-MM-DD"));
                $element.find('input[name="check_out"]').val(date.format("YYYY-MM-DD"));
            });
            $element.find('input[id="check-out"]').on('change', function () {
                let date = moment($element.find('input[id="check-out"]').val(), "YYYY-MM-DD").subtract(1, 'd');
                $element.find('input[id="check-in"]').data('daterangepicker').maxDate = date;
            });
            /*
             * Ajax filter list hotels
             */
            

            var filterAjaxEvent = plugin.debounce(function () {
                $element.find('input[name="limit1"]').val(12);
                $element.find('input[name="start"]').val(0);
                $element.find('#pagination-hotels-ajax').hide()
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    if( field.name == 'start' ){
                        dataObj[field.name] = 0;
                    }else if( field.name == 'limit1' ){
                        dataObj[field.name] = 12;
                    }else {
                        dataObj[field.name] = field.value;
                    }
                });
                plugin.filter_ajax(dataObj);
            }, 300);
            var filterAjaxEventLoadMore = plugin.debounce(function () {
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.filter_ajax(dataObj);
                $('html, body').animate({ scrollTop: wrapHeight }, 'slow');
            }, 300);
            var filterAjaxEventLoadMores = plugin.debounce(function () {
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.loadmore_ajax(dataObj);
            }, 300);
            var tabAjaxEvent = plugin.debounce(function () {
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.tab_ajax(dataObj);
            }, 300);
            $element.find('.form-search-hotels input[name="keyword_address"]').on('keyup', filterAjaxEvent);
            $element.find('.form-search-hotels input#check-in').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels input[name="check_in"]').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels input#check-out').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels input[name="check_out"]').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels .btn-minius').on('click', filterAjaxEvent);
            $element.find('.form-search-hotels .btn-plus').on('click', filterAjaxEvent);
            $element.find('.form-search-hotels input.input-field').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels input[name="rating[]"]').on('change', filterAjaxEvent);
            $element.find('.form-search-hotels input[name="room_type_id[]"]').on('change', filterAjaxEvent);
            $('body').on('click','.nav-tabs li', function() {
                let layout = $(this).data('layout');
                $(this).toggleClass('active');
                $element.find('input[name="tab"]').val(layout);
            })
            let limit=parseInt(plugin.settings.limit);
            $element.find('input[name="limit1"]').val(limit);
            let page = parseInt(plugin.settings.page);
            let start = parseInt(plugin.settings.start);
            $element.find('#pagination-hotels-ajax').on('click', function() {
                let input_limit = parseInt($element.find('input[name="limit1"]').val());
                let input_page = page;
                let input_start = parseInt($element.find('input[name="start"]').val());
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                // if( dataObj['keyword_address'] == "" && dataObj['check_in'] == "" && dataObj['check_out'] == "" && dataObj['number_adult'] == "" && dataObj['number_child'] == "" && ( dataObj['rating'] == '' || dataObj['rating'] == undefined ) && ( dataObj['room_type_id[]'] == '' || dataObj['room_type_id[]'] == undefined ) ) {
                //     input_start = parseInt(input_start)+limit;
                //     $element.find('input[name="start"]').val(input_start);
                // }
                input_start = parseInt(input_start)+limit;
                $element.find('input[name="start"]').val(input_start);
                input_limit = parseInt(input_limit)+limit;
                $element.find('input[name="limit1"]').val(input_limit);
                input_page = parseInt(input_page)+page;
                $element.find('input[name="page"]').val(input_page);
            });
            $element.find('#pagination-hotels-ajax').on('click', filterAjaxEventLoadMores);
            $('body').on('click', '.nav-tabs li', tabAjaxEvent);
            $element.find('.sort-display a').click(function(){
                let sort=$(this).data('key_sort');
                let direction=$(this).data('direction');
                $element.find('input[name="key_sort"]').val(sort);
                $element.find('input[name="start"]').val(0);
                $element.find('input[name="direction"]').val(direction);
                $element.find('.sort-by-block .dropdown').removeClass('open');
            });  
            $element.find('.sort-display a').click(filterAjaxEvent);     
            $('body').on('click', '.sort-display a', function(){
                let sort=$(this).data('key_sort');
                let direction=$(this).data('direction');
                $element.find('input[name="key_sort"]').val(sort);
                $element.find('input[name="start"]').val(0);
                $element.find('input[name="direction"]').val(direction);
                $element.find('.sort-by-block .dropdown').removeClass('open');
            });      
            $('body').on('click', '.sort-display a', filterAjaxEvent);   
            /*
             * End Ajax filter list hotels
             */
            $('body').on('click','.heart',function(e){
                let $hotel_item = $(this).closest('.wishlist-item');
                let hotel_id = $hotel_item.data('hotel_id');
                let user_id = $hotel_item.data('user_id');
                let $wishlist_icon = $(this);
                if(user_id=="" && user_id==0){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    hotel_id: hotel_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookinghotel_root_url + wpbookinghotel_api_task,
                    data: data,
                    beforeSend: function () {
                        $wishlist_icon.toggleClass("active");
                        $wishlist_icon.find('i').removeClass("fa-heart").addClass("fa-spinner fa-spin");
                    },
                    error: function (xhr) {

                    },
                    complete: function () {
                        $wishlist_icon.find('i').addClass("fa-heart").removeClass("fa-spinner fa-spin");
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })
        };
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };
        plugin.convert_data_form = function() {
            var dataArray = $element.find('.form-search-hotels').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };
        plugin.filter_ajax = function(dataObj) {
            $.ajax({
                url: wpbookinghotel_root_url+wpbookinghotel_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "hotels.get_list_services_ajax_form",
                    page_hotel_detail: plugin.settings.page_hotel_detail
                },
                beforeSend: function() {
                    $('body').loadingModal();
                },
                success: function(res) {
                    let data= JSON.parse(res);
                    if( data.data.template1 && data.data.template2) {
                            $element.find('.wrapper-hotel-list').empty(data.data.template2);
                            $element.find('.wrapper-hotel-grid').empty(data.data.template1);

                            $element.find('.wrapper-hotel-list').append(data.data.template2);
                            $element.find('.wrapper-hotel-grid').append(data.data.template1);
                    }
                    if(data.data.total) {
                        $element.find('#pagination-hotels-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-hotels-ajax').show();
                        }else {
                            $element.find('#pagination-hotels-ajax').hide();
                        }
                        $element.find('.count1').text(data.data.total_show);
                        $element.find('.count2').text(data.data.total);
                    }
                    var $direction = $element.find('input[name="direction"]').val();
                    var $sort = $element.find('input[name="key_sort"]').val();
                    if($direction === "ASC" && $sort === "a.name"){
                        $element.find('.select-by-default').text('Sort by name from A-Z');
                    } else if($direction === "DESC" && $sort === "a.name"){
                        $element.find('.select-by-default').text('Sort by name from Z-A');
                    } else if($direction === "ASC" && $sort === "a.price"){
                        $element.find('.select-by-default').text('Sort by ascending price');
                    } else if($direction === "DESC" && $sort === "a.price"){
                        $element.find('.select-by-default').text('Sort by descending price');
                    } else {
                        $element.find('.select-by-default').text('Sort by');
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {

                            // if (index == 'start' || index == 'limit' || index == 'total_item' || index == 'page'){
                            //     delete dataObj[index];
                            // }else {
                            //     if( index == "keyword_address" ) {
                            //         $params += "?"+index+"="+val;
                            //     }
                            //     else if ( index == "layout") {
                            //         $params += "&"+index+"="+val;
                            //     }else if ( index == "rating[]") {
                            //         $params += "&rating="+val;
                            //     }
                            //     else {
                            //         $params += "&"+index+"="+val;
                            //     }
                            // }

                            if( index == "keyword_address" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if ( index == "layout") {
                                $params += "&"+index+"="+val;
                            }else if ( index == "rating[]") {
                                $params += "&rating="+val;
                            }
                            else {
                                $params += "&"+index+"="+val;
                            }
                            
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }
                },
            })                        
        };
        var y ;
        plugin.loadmore_ajax = function(dataObj) {
            $.ajax({
                url: wpbookinghotel_root_url+wpbookinghotel_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "hotels.get_list_services_ajax_form",
                    page_hotel_detail: plugin.settings.page_hotel_detail
                },
                beforeSend: function() {
                    $('body').loadingModal();
                    $('#pagination-hotels-ajax i').addClass('fa-spinner fa-spin').css({
                        'position':'absolute',
                        'left':'50%',
                        'top':'50%',
                        'transform':'translate(-50%,-50%)',
                        'margin-top':'-7px',
                    });
                    $('#pagination-hotels-ajax span').css('opacity','0');
                     y = window.pageYOffset;
                },
                success: function(res) {
                    let data= JSON.parse(res);
                    if( data.data.template1 || data.data.template2) {
                            $element.find('.wrapper-hotel-list').append(data.data.template2);
                            $element.find('.wrapper-hotel-grid').append(data.data.template1);
                    }
                    if(data.data.total) {
                        $element.find('#pagination-hotels-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-hotels-ajax').show();
                        }else {
                            $element.find('#pagination-hotels-ajax').hide();
                        }
                        $element.find('.count1').text(data.data.total_show);
                        $element.find('.count2').text(data.data.total);
                    }
                    if(data.data.layout) {
                        $element.find('.nav-tabs li').each(function(index, el) {
                            $(el).removeClass('active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('active');
                            }

                        });
                        $element.find('.tab-contents > div').each(function(index, el) {
                            $(el).removeClass('in active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('in active');
                            }

                        });
                    }
                    var $direction = $element.find('input[name="direction"]').val();
                    var $sort = $element.find('input[name="key_sort"]').val();
                    if($direction === "ASC" && $sort === "a.name"){
                        $element.find('.select-by-default').text('Sort by name from A-Z');
                    } else if($direction === "DESC" && $sort === "a.name"){
                        $element.find('.select-by-default').text('Sort by name from Z-A');
                    } else if($direction === "ASC" && $sort === "a.price"){
                        $element.find('.select-by-default').text('Sort by ascending price');
                    } else if($direction === "DESC" && $sort === "a.price"){
                        $element.find('.select-by-default').text('Sort by descending price');
                    } else {
                        $element.find('.select-by-default').text('Sort by');
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {

                            // if (index == 'start' || index == 'limit' || index == 'total_item' || index == 'page'){
                            //     delete dataObj[index];
                            // }else {
                            //     if( index == "keyword_address" ) {
                            //         $params += "?"+index+"="+val;
                            //     }
                            //     else if ( index == "layout") {
                            //         $params += "&"+index+"="+val;
                            //     }else if ( index == "rating[]") {
                            //         $params += "&rating="+val;
                            //     }
                            //     else {
                            //         $params += "&"+index+"="+val;
                            //     }
                            // }

                            if( index == "keyword_address" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if ( index == "layout") {
                                $params += "&"+index+"="+val;
                            }else if ( index == "rating[]") {
                                $params += "&rating="+val;
                            }
                            else {
                                $params += "&"+index+"="+val;
                            }

                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }
                    $('#pagination-hotels-ajax i').removeClass('fa-spinner fa-spin');
                    $('#pagination-hotels-ajax span').css('opacity','1');
                    window.scrollTo(0,y);
                },
            })                        
        };
        plugin.tab_ajax = function(dataObj) {
            $.ajax({
                url: wpbookinghotel_root_url+wpbookinghotel_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "hotels.get_list_services_ajax_form",
                    page_hotel_detail: plugin.settings.page_hotel_detail
                },
                beforeSend: function() {
                    $('body').loadingModal();
                },
                success: function(res) {
                    let data= JSON.parse(res);
                    if(data.data.layout) {
                        $element.find('.nav-tabs li').each(function(index, el) {
                            $(el).removeClass('active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('active');
                            }

                        });
                        $element.find('.tab-contents > div').each(function(index, el) {
                            $(el).removeClass('in active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('in active');
                            }

                        });
                    }
                    if(data.data.total) {
                        $element.find('#pagination-hotels-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-hotels-ajax').show();
                        }else {
                            $element.find('#pagination-hotels-ajax').hide();
                        }
                        $element.find('.count1').text(data.data.total_show);
                        $element.find('.count2').text(data.data.total);
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {

                            // if (index == 'start' || index == 'limit' || index == 'total_item' || index == 'page'){
                            //     delete dataObj[index];
                            // }else {
                            //     if( index == "keyword_address" ) {
                            //         $params += "?"+index+"="+val;
                            //     }
                            //     else if ( index == "layout") {
                            //         $params += "&"+index+"="+val;
                            //     }else if ( index == "rating[]") {
                            //         $params += "&rating="+val;
                            //     }
                            //     else {
                            //         $params += "&"+index+"="+val;
                            //     }
                            // }

                            if( index == "keyword_address" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if ( index == "layout") {
                                $params += "&"+index+"="+val;
                            }else if ( index == "rating[]") {
                                $params += "&rating="+val;
                            }
                            else {
                                $params += "&"+index+"="+val;
                            }

                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }

                },
            })                        
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_hotels = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_hotels')) {
                let plugin = new $.view_list_hotels(this, options);
                $(this).data('view_list_hotels', plugin);
            }
        });
    }
})(jQuery);
