<?php
if (!defined('ABSPATH')) {
    die('-1');
}

// Check vc active or no active
if (class_exists("WPBakeryShortCode") && class_exists('WeDevs_Dokan')) {

    // Begin Netbase Elements
    class nb_vc_dokan_elements extends WPBakeryShortCode {

        // Element Init
        function __construct() {
            add_action('init', array($this, 'netbase_elements_map'));
			
			remove_shortcode("dokan-stores");
			add_shortcode('dokan-stores', array($this, 'nb_dokan_store_listing'));
        }

        // Element Mapping
        public function netbase_elements_map() {
            vc_map(array(
                "name" => __("NB - Store Listing"),
                "base" => "dokan-stores",
                "category" => __('Handmade Elements', 'nb-fw'),
                "params" => array(
                    array(
                        'type' => 'dropdown',
                        'heading' => __('Vendor list', 'nb-fw'),
                        'param_name' => 'style',
                        'value' => array(
                            __('Default', 'nb-fw') => '',
                            __('Style 1', 'nb-fw') => 'style-1',
                            __('Style 2', 'nb-fw') => 'style-2',
                            __('Style 3', 'nb-fw') => 'style-3',
                        ),
                    ),
					array(
						'type' => 'checkbox',
						'heading' => __('Search', 'nb-fw'),
						'param_name' => 'search',
						'description' => __('Show / Hide search form', 'nb-fw'),
						'value' => array(__('Yes', 'nb-fw') => 'yes'),
						'save_always' => true,
					),
                    array(
                        'type' => 'textfield',
                        'heading' => __('Vendor per page', 'nb-fw'),
                        'param_name' => 'per_page',
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __('Columns - Large Desktops', 'nb-fw'),
                        'value' => array(
                            '1' => '1',
                            '2' => '2',
                            '3' => '3',
                            '4' => '4',
                            '6' => '6',
                        ),
                        'std' => '4',
                        'param_name' => 'per_row_xl',
                        'save_always' => true,
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __('Columns - Desktops', 'nb-fw'),
                        'value' => array(
                            '1' => '1',
                            '2' => '2',
                            '3' => '3',
                            '4' => '4',
                            '6' => '6',
                        ),
                        'std' => '4',
                        'param_name' => 'per_row_lg',
                        'save_always' => true,
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __('Columns - Tablets', 'nb-fw'),
                        'value' => array(
                            '1' => '1',
                            '2' => '2',
                            '3' => '3',
                            '4' => '4',
                            '6' => '6',
                        ),
                        'std' => '3',
                        'param_name' => 'per_row_md',
                        'save_always' => true,
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __('Columns - Mobile Landscape', 'nb-fw'),
                        'value' => array(
                            '1' => '1',
                            '2' => '2',
                            '3' => '3',
                            '4' => '4',
                            '6' => '6',
                        ),
                        'std' => '2',
                        'param_name' => 'per_row_sm',
                        'save_always' => true,
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
					array(
						'type' => 'checkbox',
						'heading' => __('Featured', 'nb-fw'),
						'param_name' => 'featured',
						'description' => __('Only featured vendor', 'nb-fw'),
						'value' => array(__('Yes', 'nb-fw') => 'yes'),
					),
                    array(
                        'type' => 'textfield',
                        'heading' => __('Extra class name', 'nb-fw'),
                        'param_name' => 'class',
                        'description' => __('Style particular content element differently - add a class name and refer to it in custom CSS.', 'nb-fw'),
                    ),
                    array(
                        'type' => 'css_editor',
                        'heading' => __('CSS box', 'nb-fw'),
                        'param_name' => 'css',
                        'group' => __('Design Options', 'nb-fw'),
                    ),
                )
            ));
        }

        // Element HTML
        function nb_dokan_store_listing( $atts ) {
			/**
			 * Filter return the number of store listing number per page.
			 *
			 * @since 2.2
			 *
			 * @param array
			 */
			$attr = extract(shortcode_atts( apply_filters( 'dokan_store_listing_per_page', array(
				'per_page' => (get_theme_mod('nbcore_vendors_per_page') ? get_theme_mod('nbcore_vendors_per_page') : 10),
				'search'   => 'yes',
				'per_row_xl'  => '',
				'per_row_lg'  => '',
				'per_row_md'  => '',
				'per_row_sm'  => '',
				'featured'  => 'no',
				'style' => '',
				'class' => '',
				'css' => ''
			) ), $atts ));
			$paged   = max( 1, get_query_var( 'paged' ) );
			$limit   = $per_page;
			$offset  = ( $paged - 1 ) * $limit;

			$seller_args = array(
				'number' => $limit,
				'offset' => $offset
			);

			// if search is enabled, perform a search
			if ( 'yes' == $search ) {
				$search_term = isset( $_GET['dokan_seller_search'] ) ? sanitize_text_field( $_GET['dokan_seller_search'] ) : '';
				if ( '' != $search_term ) {

					$seller_args['meta_query'] = array(
						array(
							'key'     => 'dokan_enable_selling',
							'value'   => 'yes',
							'compare' => '='
						),
						 array(
							'key'     => 'dokan_store_name',
							'value'   => $search_term,
							'compare' => 'LIKE'
						)
					);
				}
			}

			if ( $featured == 'yes' ) {
				$seller_args['meta_query'][] = array(
												'key'     => 'dokan_feature_seller',
												'value'   => 'yes',
												'compare' => '='
											);
			}

			$sellers = dokan_get_sellers( apply_filters( 'dokan_seller_listing_args', $seller_args ) );

			/**
			 * Filter for store listing args
			 *
			 * @since 2.4.9
			 */
			$template_args = apply_filters( 'dokan_store_list_args', array(
				'sellers'		=> $sellers,
				'limit'			=> $limit,
				'offset'		=> $offset,
				'paged'			=> $paged,
				'image_size'	=> 'full',
				'search'		=> $search,
				'per_row_xl'	=> $per_row_xl,
				'per_row_lg'	=> $per_row_lg,
				'per_row_md'	=> $per_row_md,
				'per_row_sm'	=> $per_row_sm,
				'style'			=> $style
			) );
			ob_start();
			dokan_get_template_part( 'store-lists', false, $template_args );
			$content = ob_get_clean();

			// return apply_filters( 'dokan_seller_listing', $content, $attr );
			$css_class = 'nb_dokan_seller_listing';
            $css_class = implode(' ', array($css_class, $class));
            $css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $css_class . vc_shortcode_custom_css_class($css, ' '), 'nb_dokan_seller_listing', $atts);
            $css_class = trim(preg_replace('/\s+/', ' ', $css_class));
            $output = '<div class="' . esc_attr($css_class) . '" >'
                    . apply_filters( 'dokan_seller_listing', $content, $attr )
                    . '</div>';

            return $output;
		}

    }

}
