<?php
if (!defined('ABSPATH')) {
    die('-1');
}

// Check vc active or no active
if (class_exists("WPBakeryShortCode")) {

    // Begin Netbase Elements
    class nb_vc_ot_elements extends WPBakeryShortCode {

        // Element Init
        function __construct() {
            add_action('init', array($this, 'netbase_elements_map'));
			
			add_shortcode('nb_opentable_widget', array($this, 'nb_opentable_widget'));
        }

        // Element Mapping
        public function netbase_elements_map() {
            vc_map(array(
                "name" => __("NB - Open Table Widget"),
                "base" => "nb_opentable_widget",
                "category" => __('Foody Elements', 'nb-fw'),
                "params" => array(
                    array(
                        'type' => 'textfield',
                        'heading' => __('Restaurant ID', 'nb-fw'),
                        'param_name' => 'rid',
                        'value' => '',
                    ),
					array(
						'type' => 'dropdown',
						'heading' => __('Type', 'nb-fw'),
						'param_name' => 'type',
						'description' => __('Form style', 'nb-fw'),
						'value' => array(
                            __('Standard', 'nb-fw') => 'standard',
                            __('Tall', 'nb-fw') => 'tall',
                            __('Wide ', 'nb-fw') => 'wide',
                            __('Button', 'nb-fw') => 'button',
                        ),
					),
					array(
						'type' => 'dropdown',
						'heading' => __('Stype', 'nb-fw'),
						'param_name' => 'layout',
						'description' => __('Form style', 'nb-fw'),
						'value' => array(
                            __('Default', 'nb-fw') => 'default',
                            __('Style 1', 'nb-fw') => 'style1',
                        ),
					),
					array(
						'type' => 'checkbox',
						'heading' => __('Open in Popup', 'nb-fw'),
						'param_name' => 'reservation',
						'description' => __('Show in popup after searching for a table.', 'nb-fw'),
						'value' => array(__('Yes', 'nb-fw') => 'true'),
					),
					array(
						'type' => 'checkbox',
						'heading' => __('Not load the widget in an iFrame?', 'nb-fw'),
						'param_name' => 'noiframe',
						'description' => __('Widget will appear in an iframe or not and prevent the restaurant website code from changing its styling.', 'nb-fw'),
						'value' => array(__('Yes', 'nb-fw') => 'true'),
					),
					array(
						'type' => 'dropdown',
						'heading' => __('Hide Powered By', 'nb-fw'),
						'param_name' => 'poweredby',
						'description' => __('Show / Hide logo OpenTable.', 'nb-fw'),
						'value' => array(
                            __('Default', 'nb-fw') => 'default',
                            __('Hidden', 'nb-fw') => 'hidden',
                            __('Text', 'nb-fw') => 'text',
                        ),
						'dependency' => array(
                            'element' => 'noiframe',
                            'not_empty' => true,
                        ),
					),
                    array(
                        'type' => 'textfield',
                        'heading' => __('Extra class name', 'nb-fw'),
                        'param_name' => 'class',
                        'description' => __('Style particular content element differently - add a class name and refer to it in custom CSS.', 'nb-fw'),
                    ),
                    array(
                        'type' => 'css_editor',
                        'heading' => __('CSS box', 'nb-fw'),
                        'param_name' => 'css',
                        'group' => __('Design Options', 'nb-fw'),
                    ),
                )
            ));
        }

        // Element HTML
        function nb_opentable_widget( $atts ) {
			extract(shortcode_atts(
				array(
					'rid' => '',
					'type' => '',
					'layout' => 'default',
					'reservation' => '',
					'noiframe' => '',
					'poweredby' => 'default',
					'class' => '',
					'css' => '',
                ), $atts, 'nb_opentable_widget'
            ));
			$src = '//www.opentable.com/widget/reservation/loader?rid=' . $rid
				. '&domain=com&type=' . ($type == 'button' ? 'button' : 'standard')
				. '&theme=' . $type
				. '&lang=' . (get_bloginfo('language') ? get_bloginfo('language') : '')
				. '&overlay=' . ($reservation ? 'true' : 'false')
				. '&iframe=' . ($noiframe ? 'false' : 'true');
			
			$css_class = 'nb_opentable_widget nb_opentable_' . $layout . ($poweredby ? (' nb_opentable_poweredby_' . $poweredby) : '');
            $css_class = implode(' ', array($css_class, $class));
            $css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $css_class . vc_shortcode_custom_css_class($css, ' '), 'nb_opentable_widget', $atts);
            $css_class = trim(preg_replace('/\s+/', ' ', $css_class));
            $output = '<div class="' . esc_attr($css_class) . '" >';
			$output .= "<script type='text/javascript' src='". esc_attr($src) . "'></script>";
            $output .= '</div>';

            return $output;
		}

    }

}
