<?php
class nb_product_featured extends WP_Widget {
    function __construct()
    {
        parent::__construct(
            'nb_product_featured',
            esc_html__('Product Featured', 'core-wp'),
            array( 'description' => esc_html__( 'Product Featured', 'core-wp' ), )
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $limit = (int) $instance['limit'];
        $operator = 'IN';
        $meta_query = WC()->query->get_meta_query();
        $tax_query = WC()->query->get_tax_query();
        $tax_query[] = array(
            'taxonomy' => 'product_visibility',
            'field' => 'name',
            'terms' => 'featured',
            'operator' => 'IN',
        );
        $latest_posts = new WP_Query(apply_filters('widget_posts_args', array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'posts_per_page' => $limit,
            'meta_query' => $meta_query,
            'tax_query' => $tax_query,
        )));
       ?>
        <div class="featured_product">
            <?php if (!empty($title)):
                echo (string) $args['before_title'] . $title . $args['after_title'];
            endif;?>
            <div class="product_item">
                <?php if ($latest_posts->have_posts()) :
                while ($latest_posts->have_posts()) : $latest_posts->the_post();
                $variation_product = new WC_Product_Variable( $latest_posts->post->ID );?>            
                <div class="item">
                    <a href="<?php echo get_permalink($latest_posts->post->ID) ?>"><?php the_post_thumbnail($latest_posts->post->ID);?></a> 
                    <h2><a href="<?php echo get_permalink($latest_posts->post->ID) ?>"><?php the_title();?></a></h2>
                    <div class="price">
                        <span><?php echo $variation_product ->get_price_html(); ?></span>
                    </div>
                </div>
                <?php
                endwhile;
                endif; ?>
            </div>
        </div>
        <?php
    }

    public function form($instance)
    {
        $title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        $limit = isset( $instance['limit'] ) ? absint($instance['limit']) : 5;
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e('Title:', 'nb-fw'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('limit')); ?>"><?php _e('Total items:', 'nb-fw'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('limit')); ?>" name="<?php echo esc_attr($this->get_field_name('limit')); ?>" type="text" value="<?php echo esc_attr($limit); ?>" />
        </p>
        <?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title']) ) ? strip_tags($new_instance['title']) : '';
        $instance['limit'] = (!empty($new_instance['limit']) ) ? (int) $new_instance['limit'] : '5';
        return $instance;
    }
}