<?php
class nb_product_cat extends WP_Widget {
    function __construct()
    {
        parent::__construct(
            'nb_product_cat',
            esc_html__('Product category', 'core-wp'),
            array( 'description' => esc_html__( 'Product category', 'core-wp' ), )
        );
    }

    public function widget($args, $instance)
    {
        $args = array(
            'type' => 'post',
            'child_of' => 0,
            'parent' => '',
            'orderby' => 'parent',
            'order' => 'ASC',
            'hide_empty' => false,
            'hierarchical' => 1,
            'exclude' => '',
            'include' => '',
            'number' => '',
            'taxonomy' => 'product_cat',
            'pad_counts' => false,
        );

        $limit = (int) $instance['limit'];
        $cat = (string) $instance['category'] ;
        $operator = 'IN';
        $meta_query = WC()->query->get_meta_query();
        $tax_query = WC()->query->get_tax_query();
        $name_cat = explode("-",$cat);
        ?>
        
        <div class="product_category">
            <div class="product_tab">
                <div class="tab"><?php foreach($name_cat as $name){echo $name." ";} ?></div>
            </div>
            <div class="product_content">
                <?php
                $tax_query[] = array(
                    'taxonomy' => 'product_cat',
                    'terms' => $cat,
                    'field' => 'slug',
                    'operator' => $operator,
                );

                $query_args = new WP_Query(apply_filters('widget_posts_args', array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'meta_query' => $meta_query,
                    'posts_per_page' => $limit,
                    'tax_query' => $tax_query,
                )));
                ?>
                <?php if ($query_args->have_posts()) :
                    while ($query_args->have_posts()) : $query_args->the_post();  
                    $variation_product = new WC_Product_Variable( $query_args->post->ID );?>
                    <div class="product_item">
                        <a href="<?php echo get_permalink($query_args->post->ID) ?>"><?php the_post_thumbnail($query_args->post->ID);?></a> 
                        <h2><a href="<?php echo get_permalink($query_args->post->ID) ?>"><?php the_title();?></a></h2>
                        <div class="price">
                            <span><?php echo $variation_product ->get_price_html(); ?></span>
                        </div>
                    </div>
                    <?php
                    endwhile;
                endif; 
                ?>
            </div>
        </div>
        <?php
    }

    public function form($instance)
    {
        
        $limit = isset( $instance['limit'] ) ? absint($instance['limit']) : 5;
        $category = isset( $instance['category'] ) ? esc_attr( $instance['category'] ) : '';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('limit')); ?>"><?php _e('Total items:', 'nb-fw'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('limit')); ?>" name="<?php echo esc_attr($this->get_field_name('limit')); ?>" type="text" value="<?php echo esc_attr($limit); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('category')); ?>"><?php _e('Slug category:', 'nb-fw'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('category')); ?>" name="<?php echo esc_attr($this->get_field_name('category')); ?>" type="text" value="<?php echo esc_attr($category); ?>" />
        </p>
        <?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['limit'] = (!empty($new_instance['limit']) ) ? (int) $new_instance['limit'] : '5';
        $instance['category'] = isset( $new_instance['category'] ) ? esc_attr( $new_instance['category'] ) : '';
        return $instance;
    }

    protected function getCategoryChildsFull( $parent_id, $pos, $array, $level, &$dropdown ) {

        for ( $i = $pos; $i < count( $array ); $i ++ ) {

            if ( $array[ $i ]->category_parent == $parent_id ) {
                $name = str_repeat( '- ', $level ) . $array[ $i ]->name;
                $value = $array[ $i ]->slug;
                $dropdown[] = array(
                    'label' => $name,
                    'value' => $value,
                );
                $this->getCategoryChildsFull( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
            }
        }
    }
}