<?php
// Creating the widget
class NB_latest_post_widget extends WP_Widget {

    function __construct() {
        parent::__construct(
                // Base ID of your widget
                'nbcore_latest_post_widget',
                // Widget name will appear in UI
                __('NB - Latest Posts Widget', 'nb-fw'),
                // Widget description
                array('description' => __('Latest Posts Widget', 'nb-fw'),)
        );
    }

    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        $limit = (int) $instance['limit'];
        $showdate = isset( $instance['showdate'] ) ? $instance['showdate'] : false;
        $change_style = isset( $instance['change_style'] ) ? (bool) $instance['change_style'] : false;  
        $words = (int) $instance['words'];
        $readmore = $instance['readmore'];
        $latest_posts = new WP_Query(apply_filters('widget_posts_args', array(
                    'posts_per_page' => $limit,
                    'no_found_rows' => true,
                    'post_status' => 'publish',
                    'ignore_sticky_posts' => true
        )));
        if ($latest_posts->have_posts()) :
            echo (string) $args['before_widget'];
            if (!empty($title)):
                echo (string) $args['before_title'] . $title . $args['after_title'];
            endif;
            ?>
            <div class="nb_latest_post <?php if($change_style == true){echo 'nb_new_style';} ?>">
                <?php while ($latest_posts->have_posts()) : $latest_posts->the_post(); 
                if($change_style == true){
                ?>
                    <div class="nb_latest_item">
                        <?php if (has_post_thumbnail() && !post_password_required() && !is_attachment()) :
							$img_src = wp_get_attachment_image_src(get_post_thumbnail_id(), 'thumbnail');
						?>
                            <a class="nb_post_thumb" href="<?php the_permalink(); ?>">
                                <img src="<?php echo $img_src[0]; ?>" alt="<?php get_the_title() ? the_title() : the_ID(); ?>" />
                            </a>
                        <?php endif; ?>
                        <div class="nb_post_desc">
                            <?php if ($showdate): ?>
								<div class="entry-meta nb_post_meta">
                                    <span class="nb_day"><?php echo get_the_date('F');?></span>
                                    <span class="nb_month"><?php echo get_the_date('jS');?></span>
                                    <span class="nb_year"><?php echo get_the_date('Y');?></span>
								</div>
                            <?php endif;?>

                            <h4 class="nb_post_title">
                                <a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a>
                            </h4>
                            <div class="nb_wrap">
                                <div class="nb_post_author">
                                    <span>by</span>
                                    <?php
                                    if (nbfoody_get_options('nbcore_blog_meta_author')) {
                                
                                        $byline = sprintf(
                                            esc_html_x('%s', 'post author', 'nb-foody'),
                                            '<span class="author vcard"><a class="url fn n" href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '">' . esc_html(get_the_author()) . '</a></span>'
                                        );
                                        echo '<span class="byline">' . $byline . '</span>';
                                    }
                                    ?>
                                </div>
                                <div class="nb_post_comment">
                                <?php
                                    $comments_count = wp_count_comments(get_the_ID());
                                    echo $comments_count->total_comments." comments";
                                ?>
                                </div>
                            </div>
                            <?php
							if ($words != 0):
								if (has_excerpt() && $words != 0) :
									echo '<p>' . wp_trim_words(get_the_excerpt(), $words, '...') . '</p>';
								else :
									echo '<p>' . wp_trim_words(get_the_content(), $words, '...') . '</p>';
								endif;
                            endif;
                            if (!empty($readmore) && $readmore!=''):
                                echo '<a class="bt-4 nb-secondary-button" href="'.get_permalink().'">'. $readmore . '</a>';
                            endif;
                            ?>
                        </div>
                    </div>
                <?php
                }else{
                ?>
                    <div class="nb_latest_item">
                        <?php if (has_post_thumbnail() && !post_password_required() && !is_attachment()) :
							$img_src = wp_get_attachment_image_src(get_post_thumbnail_id(), 'thumbnail');
						?>
                            <a class="nb_post_thumb" href="<?php the_permalink(); ?>">
                                <?php //the_post_thumbnail('thumbnail'); ?>
								<span style="background-image:url(<?php echo $img_src[0]; ?>);"></span>
                            </a>
                        <?php endif; ?>
                        <div class="nb_post_desc">
                            <h4 class="nb_post_title">
                                <a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a>
                            </h4>
							<?php if ($showdate): ?>
								<div class="entry-meta nb_post_meta">
									<span class="posted-on"><?php echo get_the_date(); ?></span>
								</div>
                            <?php endif;
							if ($words != 0):
								if (has_excerpt() && $words != 0) :
									echo '<p>' . wp_trim_words(get_the_excerpt(), $words, '...') . '</p>';
								else :
									echo '<p>' . wp_trim_words(get_the_content(), $words, '...') . '</p>';
								endif;
                            endif;
                            if (!empty($readmore) && $readmore!=''):
                                echo '<a class="nb_post_lnk" href="'.get_permalink().'">'. $readmore . '</a>';
                            endif;
                            ?>
                        </div>
                    </div>
                <?php }
                endwhile; ?>
            </div>
            <?php
            echo (string) $args['after_widget'];
        endif;
    }

    public function form($instance) {
     
		$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        $limit = isset( $instance['limit'] ) ? absint($instance['limit']) : 5;
        $words = isset( $instance['words'] ) ? absint($instance['words']) : 15;
        $readmore = isset( $instance['readmore'] ) ? $instance['readmore'] : '';
        $showdate = isset( $instance['showdate'] ) ? (bool) $instance['showdate'] : false; 
        $change_style = isset( $instance['change_style'] ) ? (bool) $instance['change_style'] : false;        
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e('Title:', 'nb-fw'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('limit')); ?>"><?php _e('Total items:', 'nb-fw'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('limit')); ?>" name="<?php echo esc_attr($this->get_field_name('limit')); ?>" type="text" value="<?php echo esc_attr($limit); ?>" />
        </p>
        <p>
			<input class="checkbox" type="checkbox" <?php checked( $showdate ); ?> id="<?php echo esc_attr($this->get_field_id('showdate')); ?>" name="<?php echo esc_attr($this->get_field_name('showdate')); ?>">
            <label for="<?php echo esc_attr($this->get_field_id('showdate')); ?>"><?php _e('Display post date?', 'nb-fw'); ?></label>
        </p>
        <p>
			<input class="checkbox" type="checkbox" <?php checked( $change_style ); ?> id="<?php echo esc_attr($this->get_field_id('change_style')); ?>" name="<?php echo esc_attr($this->get_field_name('change_style')); ?>">
            <label for="<?php echo esc_attr($this->get_field_id('change_style')); ?>"><?php _e('Change style post?', 'nb-fw'); ?></label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('words')); ?>"><?php _e('Content words limit:', 'nb-fw'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('words')); ?>" name="<?php echo esc_attr($this->get_field_name('words')); ?>" type="text" value="<?php echo esc_attr($words); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('readmore')); ?>"><?php _e('Read more text:', 'nb-fw'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('readmore')); ?>" name="<?php echo esc_attr($this->get_field_name('readmore')); ?>" type="text" value="<?php echo esc_attr($readmore); ?>" />
        </p>
        
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title']) ) ? strip_tags($new_instance['title']) : '';
        $instance['limit'] = (!empty($new_instance['limit']) ) ? (int) $new_instance['limit'] : '5';
        $instance['words'] = (!empty($new_instance['words']) ) ? (int) $new_instance['words'] : ($new_instance['words'] == 0 ? '0' : '15');
        $instance['readmore'] = (!empty($new_instance['readmore']) ) ? strip_tags($new_instance['readmore']) : '';
        $instance['showdate'] = isset( $new_instance['showdate'] ) ? (bool) $new_instance['showdate'] : false;
        $instance['change_style'] = isset( $new_instance['change_style'] ) ? (bool) $new_instance['change_style'] : false; 
        return $instance;
    }

}
