<?php

// Creating the widget
class NB_facebook_widget extends WP_Widget {

    function __construct() {
        parent::__construct(
        // Base ID of your widget
            'nbcore_facebook_widget',

            // Widget name will appear in UI
            __('NB Facebook Like Box', 'nb-fw'),

            // Widget description
            array( 'description' => __( 'Facebook Like Box Widget', 'nb-fw' ), )
		);
		 add_action('wp_enqueue_scripts', array( $this, 'js_sdk_root' ));
    }


    public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );
		$furl = $instance['furl'] ? $instance['furl'] : '';
		$ftabs = $instance['ftabs'] ? $instance['ftabs'] : '';
		$fwidth = $instance['fwidth'] ? (int)$instance['fwidth'] : '';
		$fheight = $instance['fheight'] ? (int)$instance['fheight'] : '';
		$small_header = $instance['small_header'] ? 'true' : 'false';
		$hide_cover = $instance['hide_cover'] ? 'true' : 'false';
		$container_width = $instance['container_width'] ? 'true' : 'false';
		$show_facepile = $instance['show_facepile'] ? 'true' : 'false';
		if ($furl):			
			echo (string)$args['before_widget'];
				if ( ! empty( $title ) ):
					echo (string)$args['before_title'] . $title . '<span><i class="ftl ftl-bag"></i></span>' . $args['after_title'];
				endif; ?>
				<div class="fb-page-widget">
					<div class="fb-page"
						data-href="<?php echo esc_url($furl); ?>"
						data-tabs="<?php echo esc_attr($ftabs); ?>"
						<?php echo ($fwidth ? 'data-width="'.$fwidth.'"' : ''); ?>
						<?php echo ($fheight ? 'data-height="'.$fheight.'"' : ''); ?>
						data-small-header="<?php echo ($small_header); ?>"
						data-adapt-container-width="<?php echo ($container_width); ?>"
						data-hide-cover="<?php echo ($hide_cover); ?>"
						data-show-facepile="<?php echo esc_attr($show_facepile); ?>">
						<blockquote cite="<?php echo esc_url($furl); ?>" class="fb-xfbml-parse-ignore"><a href="<?php echo esc_url($furl); ?>"></a></blockquote>
					</div>
				</div>
			<?php echo (string)$args['after_widget'];
		endif;
    }
	
	public static function js_sdk_root() {
		wp_enqueue_script('facebook-jssdk', '//connect.facebook.net/'.get_locale().'/sdk.js#xfbml=1&version=v2.8&appId=503595753002055', array('jquery'), '2.8', true);
			
	}

    public function form( $instance ) {
		$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$furl = isset( $instance['furl'] ) ? esc_url( $instance['furl'] ) : '';
		$ftabs = isset( $instance['ftabs'] ) ? esc_attr( $instance['ftabs'] ) : '';
		$fwidth = isset( $instance['fwidth'] ) ? absint($instance['fwidth']) : '';
		$fheight = isset( $instance['fheight'] ) ? absint($instance['fheight']) : '';
		$small_header = isset( $instance['small_header'] ) ? (bool) $instance['small_header'] : false;
		$hide_cover = isset( $instance['hide_cover'] ) ? (bool) $instance['hide_cover'] : false;
		$container_width = isset( $instance['container_width'] ) ? (bool) $instance['container_width'] : false;
		$show_facepile = isset( $instance['show_facepile'] ) ? (bool) $instance['show_facepile'] : false;
        ?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title:','nb-fw' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'furl' )); ?>"><?php _e( 'Facebook Page URL:','nb-fw' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'furl' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'furl' )); ?>" type="url" value="<?php echo esc_attr( $furl ); ?>" placeholder="<?php _e( 'The URL of the Facebook Page','nb-fw' ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'ftabs' )); ?>"><?php _e( 'Tabs:','nb-fw' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'ftabs' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'ftabs' )); ?>" type="text" value="<?php echo esc_attr( $ftabs ); ?>" placeholder="<?php _e( 'e.g., timeline, messages, events','nb-fw' ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'fwidth' )); ?>"><?php _e( 'Width:','nb-fw' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'fwidth' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'fwidth' )); ?>" type="text" value="<?php echo esc_attr( $fwidth ); ?>" placeholder="<?php _e( 'The pixel width of the embed (Min. 180 to Max. 500)','nb-fw' ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'fheight' )); ?>"><?php _e( 'Height:','nb-fw' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'fheight' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'fheight' )); ?>" type="text" value="<?php echo esc_attr( $fheight ); ?>" placeholder="<?php _e( 'The pixel height of the embed (Min. 70)','nb-fw' ); ?>" />
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $small_header ); ?> id="<?php echo esc_attr($this->get_field_id('small_header')); ?>" name="<?php echo esc_attr($this->get_field_name('small_header')); ?>">
            <label for="<?php echo esc_attr($this->get_field_id('small_header')); ?>"><?php _e('Use Small Header', 'nb-fw'); ?></label>
        </p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $hide_cover ); ?> id="<?php echo esc_attr($this->get_field_id('hide_cover')); ?>" name="<?php echo esc_attr($this->get_field_name('hide_cover')); ?>">
            <label for="<?php echo esc_attr($this->get_field_id('hide_cover')); ?>"><?php _e('Hide Cover Photo', 'nb-fw'); ?></label>
        </p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $container_width ); ?> id="<?php echo esc_attr($this->get_field_id('container_width')); ?>" name="<?php echo esc_attr($this->get_field_name('container_width')); ?>">
            <label for="<?php echo esc_attr($this->get_field_id('container_width')); ?>"><?php _e('Adapt to plugin container width', 'nb-fw'); ?></label>
        </p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked( $show_facepile ); ?> id="<?php echo esc_attr($this->get_field_id('show_facepile')); ?>" name="<?php echo esc_attr($this->get_field_name('show_facepile')); ?>">
            <label for="<?php echo esc_attr($this->get_field_id('show_facepile')); ?>"><?php _e('Show Friend\'s Faces', 'nb-fw'); ?></label>
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
		$instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
		$instance['furl'] = (!empty($new_instance['furl'])) ? strip_tags($new_instance['furl']) : '';
		$instance['ftabs'] = (!empty($new_instance['ftabs'])) ? strip_tags($new_instance['ftabs']) : '';
		$instance['fwidth'] = (!empty($new_instance['fwidth'])) ? (int)$new_instance['fwidth'] : '';
		$instance['fheight'] = (!empty($new_instance['fheight'])) ? (int)$new_instance['fheight'] : '';
		$instance['small_header'] = (!empty($new_instance['small_header'])) ? (bool)$new_instance['small_header'] : false;
		$instance['hide_cover'] = (!empty($new_instance['hide_cover'])) ? (bool)$new_instance['hide_cover'] : false;
		$instance['container_width'] = (!empty($new_instance['container_width'])) ? (bool)$new_instance['container_width'] : false;
		$instance['show_facepile'] = (!empty($new_instance['show_facepile'])) ? (bool)$new_instance['show_facepile'] : false;

        return $instance;
    }
}

