(function webpackUniversalModuleDefinition(root, factory) {
    if(typeof exports === 'object' && typeof module === 'object')
        module.exports = factory(require("jQuery"));
    else if(typeof define === 'function' && define.amd)
        define("hyDrawer", ["jQuery"], factory);
    else if(typeof exports === 'object')
        exports["hyDrawer"] = factory(require("jQuery"));
    else
        root["hyDrawer"] = factory(root["jQuery"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_53__) {
    return /******/ (function(modules) { // webpackBootstrap
        /******/ 	// The module cache
        /******/ 	var installedModules = {};
        /******/
        /******/ 	// The require function
        /******/ 	function __webpack_require__(moduleId) {
            /******/
            /******/ 		// Check if module is in cache
            /******/ 		if(installedModules[moduleId]) {
                /******/ 			return installedModules[moduleId].exports;
                /******/ 		}
            /******/ 		// Create a new module (and put it into the cache)
            /******/ 		var module = installedModules[moduleId] = {
                /******/ 			i: moduleId,
                /******/ 			l: false,
                /******/ 			exports: {}
                /******/ 		};
            /******/
            /******/ 		// Execute the module function
            /******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
            /******/
            /******/ 		// Flag the module as loaded
            /******/ 		module.l = true;
            /******/
            /******/ 		// Return the exports of the module
            /******/ 		return module.exports;
            /******/ 	}
        /******/
        /******/
        /******/ 	// expose the modules object (__webpack_modules__)
        /******/ 	__webpack_require__.m = modules;
        /******/
        /******/ 	// expose the module cache
        /******/ 	__webpack_require__.c = installedModules;
        /******/
        /******/ 	// define getter function for harmony exports
        /******/ 	__webpack_require__.d = function(exports, name, getter) {
            /******/ 		if(!__webpack_require__.o(exports, name)) {
                /******/ 			Object.defineProperty(exports, name, {
                    /******/ 				configurable: false,
                    /******/ 				enumerable: true,
                    /******/ 				get: getter
                    /******/ 			});
                /******/ 		}
            /******/ 	};
        /******/
        /******/ 	// getDefaultExport function for compatibility with non-harmony modules
        /******/ 	__webpack_require__.n = function(module) {
            /******/ 		var getter = module && module.__esModule ?
                /******/ 			function getDefault() { return module['default']; } :
                /******/ 			function getModuleExports() { return module; };
            /******/ 		__webpack_require__.d(getter, 'a', getter);
            /******/ 		return getter;
            /******/ 	};
        /******/
        /******/ 	// Object.prototype.hasOwnProperty.call
        /******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
        /******/
        /******/ 	// __webpack_public_path__
        /******/ 	__webpack_require__.p = "";
        /******/
        /******/ 	// Load entry module and return exports
        /******/ 	return __webpack_require__(__webpack_require__.s = 68);
        /******/ })
    /************************************************************************/
    /******/ ([
        /* 0 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var root_1 = __webpack_require__(4);
            var toSubscriber_1 = __webpack_require__(100);
            var observable_1 = __webpack_require__(42);
            var pipe_1 = __webpack_require__(102);
            /**
             * A representation of any set of values over any amount of time. This is the most basic building block
             * of RxJS.
             *
             * @class Observable<T>
             */
            var Observable = (function () {
                /**
                 * @constructor
                 * @param {Function} subscribe the function that is called when the Observable is
                 * initially subscribed to. This function is given a Subscriber, to which new values
                 * can be `next`ed, or an `error` method can be called to raise an error, or
                 * `complete` can be called to notify of a successful completion.
                 */
                function Observable(subscribe) {
                    this._isScalar = false;
                    if (subscribe) {
                        this._subscribe = subscribe;
                    }
                }
                /**
                 * Creates a new Observable, with this Observable as the source, and the passed
                 * operator defined as the new observable's operator.
                 * @method lift
                 * @param {Operator} operator the operator defining the operation to take on the observable
                 * @return {Observable} a new observable with the Operator applied
                 */
                Observable.prototype.lift = function (operator) {
                    var observable = new Observable();
                    observable.source = this;
                    observable.operator = operator;
                    return observable;
                };
                /**
                 * Invokes an execution of an Observable and registers Observer handlers for notifications it will emit.
                 *
                 * <span class="informal">Use it when you have all these Observables, but still nothing is happening.</span>
                 *
                 * `subscribe` is not a regular operator, but a method that calls Observable's internal `subscribe` function. It
                 * might be for example a function that you passed to a {@link create} static factory, but most of the time it is
                 * a library implementation, which defines what and when will be emitted by an Observable. This means that calling
                 * `subscribe` is actually the moment when Observable starts its work, not when it is created, as it is often
                 * thought.
                 *
                 * Apart from starting the execution of an Observable, this method allows you to listen for values
                 * that an Observable emits, as well as for when it completes or errors. You can achieve this in two
                 * following ways.
                 *
                 * The first way is creating an object that implements {@link Observer} interface. It should have methods
                 * defined by that interface, but note that it should be just a regular JavaScript object, which you can create
                 * yourself in any way you want (ES6 class, classic function constructor, object literal etc.). In particular do
                 * not attempt to use any RxJS implementation details to create Observers - you don't need them. Remember also
                 * that your object does not have to implement all methods. If you find yourself creating a method that doesn't
                 * do anything, you can simply omit it. Note however, that if `error` method is not provided, all errors will
                 * be left uncaught.
                 *
                 * The second way is to give up on Observer object altogether and simply provide callback functions in place of its methods.
                 * This means you can provide three functions as arguments to `subscribe`, where first function is equivalent
                 * of a `next` method, second of an `error` method and third of a `complete` method. Just as in case of Observer,
                 * if you do not need to listen for something, you can omit a function, preferably by passing `undefined` or `null`,
                 * since `subscribe` recognizes these functions by where they were placed in function call. When it comes
                 * to `error` function, just as before, if not provided, errors emitted by an Observable will be thrown.
                 *
                 * Whatever style of calling `subscribe` you use, in both cases it returns a Subscription object.
                 * This object allows you to call `unsubscribe` on it, which in turn will stop work that an Observable does and will clean
                 * up all resources that an Observable used. Note that cancelling a subscription will not call `complete` callback
                 * provided to `subscribe` function, which is reserved for a regular completion signal that comes from an Observable.
                 *
                 * Remember that callbacks provided to `subscribe` are not guaranteed to be called asynchronously.
                 * It is an Observable itself that decides when these functions will be called. For example {@link of}
                 * by default emits all its values synchronously. Always check documentation for how given Observable
                 * will behave when subscribed and if its default behavior can be modified with a {@link Scheduler}.
                 *
                 * @example <caption>Subscribe with an Observer</caption>
                 * const sumObserver = {
                 *   sum: 0,
                 *   next(value) {
                 *     console.log('Adding: ' + value);
                 *     this.sum = this.sum + value;
                 *   },
                 *   error() { // We actually could just remove this method,
                 *   },        // since we do not really care about errors right now.
                 *   complete() {
                 *     console.log('Sum equals: ' + this.sum);
                 *   }
                 * };
                 *
                 * Rx.Observable.of(1, 2, 3) // Synchronously emits 1, 2, 3 and then completes.
                 * .subscribe(sumObserver);
                 *
                 * // Logs:
                 * // "Adding: 1"
                 * // "Adding: 2"
                 * // "Adding: 3"
                 * // "Sum equals: 6"
                 *
                 *
                 * @example <caption>Subscribe with functions</caption>
                 * let sum = 0;
                 *
                 * Rx.Observable.of(1, 2, 3)
                 * .subscribe(
                 *   function(value) {
                 *     console.log('Adding: ' + value);
                 *     sum = sum + value;
                 *   },
                 *   undefined,
                 *   function() {
                 *     console.log('Sum equals: ' + sum);
                 *   }
                 * );
                 *
                 * // Logs:
                 * // "Adding: 1"
                 * // "Adding: 2"
                 * // "Adding: 3"
                 * // "Sum equals: 6"
                 *
                 *
                 * @example <caption>Cancel a subscription</caption>
                 * const subscription = Rx.Observable.interval(1000).subscribe(
                 *   num => console.log(num),
                 *   undefined,
                 *   () => console.log('completed!') // Will not be called, even
                 * );                                // when cancelling subscription
                 *
                 *
                 * setTimeout(() => {
                 *   subscription.unsubscribe();
                 *   console.log('unsubscribed!');
                 * }, 2500);
                 *
                 * // Logs:
                 * // 0 after 1s
                 * // 1 after 2s
                 * // "unsubscribed!" after 2.5s
                 *
                 *
                 * @param {Observer|Function} observerOrNext (optional) Either an observer with methods to be called,
                 *  or the first of three possible handlers, which is the handler for each value emitted from the subscribed
                 *  Observable.
                 * @param {Function} error (optional) A handler for a terminal event resulting from an error. If no error handler is provided,
                 *  the error will be thrown as unhandled.
                 * @param {Function} complete (optional) A handler for a terminal event resulting from successful completion.
                 * @return {ISubscription} a subscription reference to the registered handlers
                 * @method subscribe
                 */
                Observable.prototype.subscribe = function (observerOrNext, error, complete) {
                    var operator = this.operator;
                    var sink = toSubscriber_1.toSubscriber(observerOrNext, error, complete);
                    if (operator) {
                        operator.call(sink, this.source);
                    }
                    else {
                        sink.add(this.source ? this._subscribe(sink) : this._trySubscribe(sink));
                    }
                    if (sink.syncErrorThrowable) {
                        sink.syncErrorThrowable = false;
                        if (sink.syncErrorThrown) {
                            throw sink.syncErrorValue;
                        }
                    }
                    return sink;
                };
                Observable.prototype._trySubscribe = function (sink) {
                    try {
                        return this._subscribe(sink);
                    }
                    catch (err) {
                        sink.syncErrorThrown = true;
                        sink.syncErrorValue = err;
                        sink.error(err);
                    }
                };
                /**
                 * @method forEach
                 * @param {Function} next a handler for each value emitted by the observable
                 * @param {PromiseConstructor} [PromiseCtor] a constructor function used to instantiate the Promise
                 * @return {Promise} a promise that either resolves on observable completion or
                 *  rejects with the handled error
                 */
                Observable.prototype.forEach = function (next, PromiseCtor) {
                    var _this = this;
                    if (!PromiseCtor) {
                        if (root_1.root.Rx && root_1.root.Rx.config && root_1.root.Rx.config.Promise) {
                            PromiseCtor = root_1.root.Rx.config.Promise;
                        }
                        else if (root_1.root.Promise) {
                            PromiseCtor = root_1.root.Promise;
                        }
                    }
                    if (!PromiseCtor) {
                        throw new Error('no Promise impl found');
                    }
                    return new PromiseCtor(function (resolve, reject) {
                        // Must be declared in a separate statement to avoid a RefernceError when
                        // accessing subscription below in the closure due to Temporal Dead Zone.
                        var subscription;
                        subscription = _this.subscribe(function (value) {
                            if (subscription) {
                                // if there is a subscription, then we can surmise
                                // the next handling is asynchronous. Any errors thrown
                                // need to be rejected explicitly and unsubscribe must be
                                // called manually
                                try {
                                    next(value);
                                }
                                catch (err) {
                                    reject(err);
                                    subscription.unsubscribe();
                                }
                            }
                            else {
                                // if there is NO subscription, then we're getting a nexted
                                // value synchronously during subscription. We can just call it.
                                // If it errors, Observable's `subscribe` will ensure the
                                // unsubscription logic is called, then synchronously rethrow the error.
                                // After that, Promise will trap the error and send it
                                // down the rejection path.
                                next(value);
                            }
                        }, reject, resolve);
                    });
                };
                Observable.prototype._subscribe = function (subscriber) {
                    return this.source.subscribe(subscriber);
                };
                /**
                 * An interop point defined by the es7-observable spec https://github.com/zenparsing/es-observable
                 * @method Symbol.observable
                 * @return {Observable} this instance of the observable
                 */
                Observable.prototype[observable_1.observable] = function () {
                    return this;
                };
                /* tslint:enable:max-line-length */
                /**
                 * Used to stitch together functional operators into a chain.
                 * @method pipe
                 * @return {Observable} the Observable result of all of the operators having
                 * been called in the order they were passed in.
                 *
                 * @example
                 *
                 * import { map, filter, scan } from 'rxjs/operators';
                 *
                 * Rx.Observable.interval(1000)
                 *   .pipe(
                 *     filter(x => x % 2 === 0),
                 *     map(x => x + x),
                 *     scan((acc, x) => acc + x)
                 *   )
                 *   .subscribe(x => console.log(x))
                 */
                Observable.prototype.pipe = function () {
                    var operations = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        operations[_i - 0] = arguments[_i];
                    }
                    if (operations.length === 0) {
                        return this;
                    }
                    return pipe_1.pipeFromArray(operations)(this);
                };
                /* tslint:enable:max-line-length */
                Observable.prototype.toPromise = function (PromiseCtor) {
                    var _this = this;
                    if (!PromiseCtor) {
                        if (root_1.root.Rx && root_1.root.Rx.config && root_1.root.Rx.config.Promise) {
                            PromiseCtor = root_1.root.Rx.config.Promise;
                        }
                        else if (root_1.root.Promise) {
                            PromiseCtor = root_1.root.Promise;
                        }
                    }
                    if (!PromiseCtor) {
                        throw new Error('no Promise impl found');
                    }
                    return new PromiseCtor(function (resolve, reject) {
                        var value;
                        _this.subscribe(function (x) { return value = x; }, function (err) { return reject(err); }, function () { return resolve(value); });
                    });
                };
                // HACK: Since TypeScript inherits static properties too, we have to
                // fight against TypeScript here so Subject can have a different static create signature
                /**
                 * Creates a new cold Observable by calling the Observable constructor
                 * @static true
                 * @owner Observable
                 * @method create
                 * @param {Function} subscribe? the subscriber function to be passed to the Observable constructor
                 * @return {Observable} a new cold observable
                 */
                Observable.create = function (subscribe) {
                    return new Observable(subscribe);
                };
                return Observable;
            }());
            exports.Observable = Observable;
//# sourceMappingURL=Observable.js.map

            /***/ }),
        /* 1 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var isFunction_1 = __webpack_require__(39);
            var Subscription_1 = __webpack_require__(9);
            var Observer_1 = __webpack_require__(59);
            var rxSubscriber_1 = __webpack_require__(41);
            /**
             * Implements the {@link Observer} interface and extends the
             * {@link Subscription} class. While the {@link Observer} is the public API for
             * consuming the values of an {@link Observable}, all Observers get converted to
             * a Subscriber, in order to provide Subscription-like capabilities such as
             * `unsubscribe`. Subscriber is a common type in RxJS, and crucial for
             * implementing operators, but it is rarely used as a public API.
             *
             * @class Subscriber<T>
             */
            var Subscriber = (function (_super) {
                __extends(Subscriber, _super);
                /**
                 * @param {Observer|function(value: T): void} [destinationOrNext] A partially
                 * defined Observer or a `next` callback function.
                 * @param {function(e: ?any): void} [error] The `error` callback of an
                 * Observer.
                 * @param {function(): void} [complete] The `complete` callback of an
                 * Observer.
                 */
                function Subscriber(destinationOrNext, error, complete) {
                    _super.call(this);
                    this.syncErrorValue = null;
                    this.syncErrorThrown = false;
                    this.syncErrorThrowable = false;
                    this.isStopped = false;
                    switch (arguments.length) {
                        case 0:
                            this.destination = Observer_1.empty;
                            break;
                        case 1:
                            if (!destinationOrNext) {
                                this.destination = Observer_1.empty;
                                break;
                            }
                            if (typeof destinationOrNext === 'object') {
                                if (destinationOrNext instanceof Subscriber) {
                                    this.destination = destinationOrNext;
                                    this.destination.add(this);
                                }
                                else {
                                    this.syncErrorThrowable = true;
                                    this.destination = new SafeSubscriber(this, destinationOrNext);
                                }
                                break;
                            }
                        default:
                            this.syncErrorThrowable = true;
                            this.destination = new SafeSubscriber(this, destinationOrNext, error, complete);
                            break;
                    }
                }
                Subscriber.prototype[rxSubscriber_1.rxSubscriber] = function () { return this; };
                /**
                 * A static factory for a Subscriber, given a (potentially partial) definition
                 * of an Observer.
                 * @param {function(x: ?T): void} [next] The `next` callback of an Observer.
                 * @param {function(e: ?any): void} [error] The `error` callback of an
                 * Observer.
                 * @param {function(): void} [complete] The `complete` callback of an
                 * Observer.
                 * @return {Subscriber<T>} A Subscriber wrapping the (partially defined)
                 * Observer represented by the given arguments.
                 */
                Subscriber.create = function (next, error, complete) {
                    var subscriber = new Subscriber(next, error, complete);
                    subscriber.syncErrorThrowable = false;
                    return subscriber;
                };
                /**
                 * The {@link Observer} callback to receive notifications of type `next` from
                 * the Observable, with a value. The Observable may call this method 0 or more
                 * times.
                 * @param {T} [value] The `next` value.
                 * @return {void}
                 */
                Subscriber.prototype.next = function (value) {
                    if (!this.isStopped) {
                        this._next(value);
                    }
                };
                /**
                 * The {@link Observer} callback to receive notifications of type `error` from
                 * the Observable, with an attached {@link Error}. Notifies the Observer that
                 * the Observable has experienced an error condition.
                 * @param {any} [err] The `error` exception.
                 * @return {void}
                 */
                Subscriber.prototype.error = function (err) {
                    if (!this.isStopped) {
                        this.isStopped = true;
                        this._error(err);
                    }
                };
                /**
                 * The {@link Observer} callback to receive a valueless notification of type
                 * `complete` from the Observable. Notifies the Observer that the Observable
                 * has finished sending push-based notifications.
                 * @return {void}
                 */
                Subscriber.prototype.complete = function () {
                    if (!this.isStopped) {
                        this.isStopped = true;
                        this._complete();
                    }
                };
                Subscriber.prototype.unsubscribe = function () {
                    if (this.closed) {
                        return;
                    }
                    this.isStopped = true;
                    _super.prototype.unsubscribe.call(this);
                };
                Subscriber.prototype._next = function (value) {
                    this.destination.next(value);
                };
                Subscriber.prototype._error = function (err) {
                    this.destination.error(err);
                    this.unsubscribe();
                };
                Subscriber.prototype._complete = function () {
                    this.destination.complete();
                    this.unsubscribe();
                };
                Subscriber.prototype._unsubscribeAndRecycle = function () {
                    var _a = this, _parent = _a._parent, _parents = _a._parents;
                    this._parent = null;
                    this._parents = null;
                    this.unsubscribe();
                    this.closed = false;
                    this.isStopped = false;
                    this._parent = _parent;
                    this._parents = _parents;
                    return this;
                };
                return Subscriber;
            }(Subscription_1.Subscription));
            exports.Subscriber = Subscriber;
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var SafeSubscriber = (function (_super) {
                __extends(SafeSubscriber, _super);
                function SafeSubscriber(_parentSubscriber, observerOrNext, error, complete) {
                    _super.call(this);
                    this._parentSubscriber = _parentSubscriber;
                    var next;
                    var context = this;
                    if (isFunction_1.isFunction(observerOrNext)) {
                        next = observerOrNext;
                    }
                    else if (observerOrNext) {
                        next = observerOrNext.next;
                        error = observerOrNext.error;
                        complete = observerOrNext.complete;
                        if (observerOrNext !== Observer_1.empty) {
                            context = Object.create(observerOrNext);
                            if (isFunction_1.isFunction(context.unsubscribe)) {
                                this.add(context.unsubscribe.bind(context));
                            }
                            context.unsubscribe = this.unsubscribe.bind(this);
                        }
                    }
                    this._context = context;
                    this._next = next;
                    this._error = error;
                    this._complete = complete;
                }
                SafeSubscriber.prototype.next = function (value) {
                    if (!this.isStopped && this._next) {
                        var _parentSubscriber = this._parentSubscriber;
                        if (!_parentSubscriber.syncErrorThrowable) {
                            this.__tryOrUnsub(this._next, value);
                        }
                        else if (this.__tryOrSetError(_parentSubscriber, this._next, value)) {
                            this.unsubscribe();
                        }
                    }
                };
                SafeSubscriber.prototype.error = function (err) {
                    if (!this.isStopped) {
                        var _parentSubscriber = this._parentSubscriber;
                        if (this._error) {
                            if (!_parentSubscriber.syncErrorThrowable) {
                                this.__tryOrUnsub(this._error, err);
                                this.unsubscribe();
                            }
                            else {
                                this.__tryOrSetError(_parentSubscriber, this._error, err);
                                this.unsubscribe();
                            }
                        }
                        else if (!_parentSubscriber.syncErrorThrowable) {
                            this.unsubscribe();
                            throw err;
                        }
                        else {
                            _parentSubscriber.syncErrorValue = err;
                            _parentSubscriber.syncErrorThrown = true;
                            this.unsubscribe();
                        }
                    }
                };
                SafeSubscriber.prototype.complete = function () {
                    var _this = this;
                    if (!this.isStopped) {
                        var _parentSubscriber = this._parentSubscriber;
                        if (this._complete) {
                            var wrappedComplete = function () { return _this._complete.call(_this._context); };
                            if (!_parentSubscriber.syncErrorThrowable) {
                                this.__tryOrUnsub(wrappedComplete);
                                this.unsubscribe();
                            }
                            else {
                                this.__tryOrSetError(_parentSubscriber, wrappedComplete);
                                this.unsubscribe();
                            }
                        }
                        else {
                            this.unsubscribe();
                        }
                    }
                };
                SafeSubscriber.prototype.__tryOrUnsub = function (fn, value) {
                    try {
                        fn.call(this._context, value);
                    }
                    catch (err) {
                        this.unsubscribe();
                        throw err;
                    }
                };
                SafeSubscriber.prototype.__tryOrSetError = function (parent, fn, value) {
                    try {
                        fn.call(this._context, value);
                    }
                    catch (err) {
                        parent.syncErrorValue = err;
                        parent.syncErrorThrown = true;
                        return true;
                    }
                    return false;
                };
                SafeSubscriber.prototype._unsubscribe = function () {
                    var _parentSubscriber = this._parentSubscriber;
                    this._context = null;
                    this._parentSubscriber = null;
                    _parentSubscriber.unsubscribe();
                };
                return SafeSubscriber;
            }(Subscriber));
//# sourceMappingURL=Subscriber.js.map

            /***/ }),
        /* 2 */
        /***/ (function(module, exports) {

            var core = module.exports = { version: '2.5.1' };
            if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


            /***/ }),
        /* 3 */
        /***/ (function(module, exports, __webpack_require__) {

            var store = __webpack_require__(50)('wks');
            var uid = __webpack_require__(30);
            var Symbol = __webpack_require__(8).Symbol;
            var USE_SYMBOL = typeof Symbol == 'function';

            var $exports = module.exports = function (name) {
                return store[name] || (store[name] =
                    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
            };

            $exports.store = store;


            /***/ }),
        /* 4 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";
            /* WEBPACK VAR INJECTION */(function(global) {
// CommonJS / Node have global context exposed as "global" variable.
// We don't want to include the whole node.d.ts this this compilation unit so we'll just fake
// the global "global" var for now.
                var __window = typeof window !== 'undefined' && window;
                var __self = typeof self !== 'undefined' && typeof WorkerGlobalScope !== 'undefined' &&
                    self instanceof WorkerGlobalScope && self;
                var __global = typeof global !== 'undefined' && global;
                var _root = __window || __global || __self;
                exports.root = _root;
// Workaround Closure Compiler restriction: The body of a goog.module cannot use throw.
// This is needed when used with angular/tsickle which inserts a goog.module statement.
// Wrap in IIFE
                (function () {
                    if (!_root) {
                        throw new Error('RxJS could not find any global context (window, self, global)');
                    }
                })();
//# sourceMappingURL=root.js.map
                /* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17)))

            /***/ }),
        /* 5 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var OuterSubscriber = (function (_super) {
                __extends(OuterSubscriber, _super);
                function OuterSubscriber() {
                    _super.apply(this, arguments);
                }
                OuterSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {
                    this.destination.next(innerValue);
                };
                OuterSubscriber.prototype.notifyError = function (error, innerSub) {
                    this.destination.error(error);
                };
                OuterSubscriber.prototype.notifyComplete = function (innerSub) {
                    this.destination.complete();
                };
                return OuterSubscriber;
            }(Subscriber_1.Subscriber));
            exports.OuterSubscriber = OuterSubscriber;
//# sourceMappingURL=OuterSubscriber.js.map

            /***/ }),
        /* 6 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var root_1 = __webpack_require__(4);
            var isArrayLike_1 = __webpack_require__(62);
            var isPromise_1 = __webpack_require__(63);
            var isObject_1 = __webpack_require__(58);
            var Observable_1 = __webpack_require__(0);
            var iterator_1 = __webpack_require__(44);
            var InnerSubscriber_1 = __webpack_require__(119);
            var observable_1 = __webpack_require__(42);
            function subscribeToResult(outerSubscriber, result, outerValue, outerIndex) {
                var destination = new InnerSubscriber_1.InnerSubscriber(outerSubscriber, outerValue, outerIndex);
                if (destination.closed) {
                    return null;
                }
                if (result instanceof Observable_1.Observable) {
                    if (result._isScalar) {
                        destination.next(result.value);
                        destination.complete();
                        return null;
                    }
                    else {
                        destination.syncErrorThrowable = true;
                        return result.subscribe(destination);
                    }
                }
                else if (isArrayLike_1.isArrayLike(result)) {
                    for (var i = 0, len = result.length; i < len && !destination.closed; i++) {
                        destination.next(result[i]);
                    }
                    if (!destination.closed) {
                        destination.complete();
                    }
                }
                else if (isPromise_1.isPromise(result)) {
                    result.then(function (value) {
                        if (!destination.closed) {
                            destination.next(value);
                            destination.complete();
                        }
                    }, function (err) { return destination.error(err); })
                        .then(null, function (err) {
                            // Escaping the Promise trap: globally throw unhandled errors
                            root_1.root.setTimeout(function () { throw err; });
                        });
                    return destination;
                }
                else if (result && typeof result[iterator_1.iterator] === 'function') {
                    var iterator = result[iterator_1.iterator]();
                    do {
                        var item = iterator.next();
                        if (item.done) {
                            destination.complete();
                            break;
                        }
                        destination.next(item.value);
                        if (destination.closed) {
                            break;
                        }
                    } while (true);
                }
                else if (result && typeof result[observable_1.observable] === 'function') {
                    var obs = result[observable_1.observable]();
                    if (typeof obs.subscribe !== 'function') {
                        destination.error(new TypeError('Provided object does not correctly implement Symbol.observable'));
                    }
                    else {
                        return obs.subscribe(new InnerSubscriber_1.InnerSubscriber(outerSubscriber, outerValue, outerIndex));
                    }
                }
                else {
                    var value = isObject_1.isObject(result) ? 'an invalid object' : "'" + result + "'";
                    var msg = ("You provided " + value + " where a stream was expected.")
                        + ' You can provide an Observable, Promise, Array, or Iterable.';
                    destination.error(new TypeError(msg));
                }
                return null;
            }
            exports.subscribeToResult = subscribeToResult;
//# sourceMappingURL=subscribeToResult.js.map

            /***/ }),
        /* 7 */
        /***/ (function(module, exports, __webpack_require__) {

            var global = __webpack_require__(8);
            var core = __webpack_require__(2);
            var hide = __webpack_require__(20);
            var redefine = __webpack_require__(47);
            var ctx = __webpack_require__(31);
            var PROTOTYPE = 'prototype';

            var $export = function (type, name, source) {
                var IS_FORCED = type & $export.F;
                var IS_GLOBAL = type & $export.G;
                var IS_STATIC = type & $export.S;
                var IS_PROTO = type & $export.P;
                var IS_BIND = type & $export.B;
                var target = IS_GLOBAL ? global : IS_STATIC ? global[name] || (global[name] = {}) : (global[name] || {})[PROTOTYPE];
                var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
                var expProto = exports[PROTOTYPE] || (exports[PROTOTYPE] = {});
                var key, own, out, exp;
                if (IS_GLOBAL) source = name;
                for (key in source) {
                    // contains in native
                    own = !IS_FORCED && target && target[key] !== undefined;
                    // export native or passed
                    out = (own ? target : source)[key];
                    // bind timers to global for call from export context
                    exp = IS_BIND && own ? ctx(out, global) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
                    // extend global
                    if (target) redefine(target, key, out, type & $export.U);
                    // export
                    if (exports[key] != out) hide(exports, key, exp);
                    if (IS_PROTO && expProto[key] != out) expProto[key] = out;
                }
            };
            global.core = core;
// type bitmap
            $export.F = 1;   // forced
            $export.G = 2;   // global
            $export.S = 4;   // static
            $export.P = 8;   // proto
            $export.B = 16;  // bind
            $export.W = 32;  // wrap
            $export.U = 64;  // safe
            $export.R = 128; // real proto method for `library`
            module.exports = $export;


            /***/ }),
        /* 8 */
        /***/ (function(module, exports) {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
            var global = module.exports = typeof window != 'undefined' && window.Math == Math
                ? window : typeof self != 'undefined' && self.Math == Math ? self
                    // eslint-disable-next-line no-new-func
                    : Function('return this')();
            if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


            /***/ }),
        /* 9 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var isArray_1 = __webpack_require__(22);
            var isObject_1 = __webpack_require__(58);
            var isFunction_1 = __webpack_require__(39);
            var tryCatch_1 = __webpack_require__(40);
            var errorObject_1 = __webpack_require__(23);
            var UnsubscriptionError_1 = __webpack_require__(101);
            /**
             * Represents a disposable resource, such as the execution of an Observable. A
             * Subscription has one important method, `unsubscribe`, that takes no argument
             * and just disposes the resource held by the subscription.
             *
             * Additionally, subscriptions may be grouped together through the `add()`
             * method, which will attach a child Subscription to the current Subscription.
             * When a Subscription is unsubscribed, all its children (and its grandchildren)
             * will be unsubscribed as well.
             *
             * @class Subscription
             */
            var Subscription = (function () {
                /**
                 * @param {function(): void} [unsubscribe] A function describing how to
                 * perform the disposal of resources when the `unsubscribe` method is called.
                 */
                function Subscription(unsubscribe) {
                    /**
                     * A flag to indicate whether this Subscription has already been unsubscribed.
                     * @type {boolean}
                     */
                    this.closed = false;
                    this._parent = null;
                    this._parents = null;
                    this._subscriptions = null;
                    if (unsubscribe) {
                        this._unsubscribe = unsubscribe;
                    }
                }
                /**
                 * Disposes the resources held by the subscription. May, for instance, cancel
                 * an ongoing Observable execution or cancel any other type of work that
                 * started when the Subscription was created.
                 * @return {void}
                 */
                Subscription.prototype.unsubscribe = function () {
                    var hasErrors = false;
                    var errors;
                    if (this.closed) {
                        return;
                    }
                    var _a = this, _parent = _a._parent, _parents = _a._parents, _unsubscribe = _a._unsubscribe, _subscriptions = _a._subscriptions;
                    this.closed = true;
                    this._parent = null;
                    this._parents = null;
                    // null out _subscriptions first so any child subscriptions that attempt
                    // to remove themselves from this subscription will noop
                    this._subscriptions = null;
                    var index = -1;
                    var len = _parents ? _parents.length : 0;
                    // if this._parent is null, then so is this._parents, and we
                    // don't have to remove ourselves from any parent subscriptions.
                    while (_parent) {
                        _parent.remove(this);
                        // if this._parents is null or index >= len,
                        // then _parent is set to null, and the loop exits
                        _parent = ++index < len && _parents[index] || null;
                    }
                    if (isFunction_1.isFunction(_unsubscribe)) {
                        var trial = tryCatch_1.tryCatch(_unsubscribe).call(this);
                        if (trial === errorObject_1.errorObject) {
                            hasErrors = true;
                            errors = errors || (errorObject_1.errorObject.e instanceof UnsubscriptionError_1.UnsubscriptionError ?
                                flattenUnsubscriptionErrors(errorObject_1.errorObject.e.errors) : [errorObject_1.errorObject.e]);
                        }
                    }
                    if (isArray_1.isArray(_subscriptions)) {
                        index = -1;
                        len = _subscriptions.length;
                        while (++index < len) {
                            var sub = _subscriptions[index];
                            if (isObject_1.isObject(sub)) {
                                var trial = tryCatch_1.tryCatch(sub.unsubscribe).call(sub);
                                if (trial === errorObject_1.errorObject) {
                                    hasErrors = true;
                                    errors = errors || [];
                                    var err = errorObject_1.errorObject.e;
                                    if (err instanceof UnsubscriptionError_1.UnsubscriptionError) {
                                        errors = errors.concat(flattenUnsubscriptionErrors(err.errors));
                                    }
                                    else {
                                        errors.push(err);
                                    }
                                }
                            }
                        }
                    }
                    if (hasErrors) {
                        throw new UnsubscriptionError_1.UnsubscriptionError(errors);
                    }
                };
                /**
                 * Adds a tear down to be called during the unsubscribe() of this
                 * Subscription.
                 *
                 * If the tear down being added is a subscription that is already
                 * unsubscribed, is the same reference `add` is being called on, or is
                 * `Subscription.EMPTY`, it will not be added.
                 *
                 * If this subscription is already in an `closed` state, the passed
                 * tear down logic will be executed immediately.
                 *
                 * @param {TeardownLogic} teardown The additional logic to execute on
                 * teardown.
                 * @return {Subscription} Returns the Subscription used or created to be
                 * added to the inner subscriptions list. This Subscription can be used with
                 * `remove()` to remove the passed teardown logic from the inner subscriptions
                 * list.
                 */
                Subscription.prototype.add = function (teardown) {
                    if (!teardown || (teardown === Subscription.EMPTY)) {
                        return Subscription.EMPTY;
                    }
                    if (teardown === this) {
                        return this;
                    }
                    var subscription = teardown;
                    switch (typeof teardown) {
                        case 'function':
                            subscription = new Subscription(teardown);
                        case 'object':
                            if (subscription.closed || typeof subscription.unsubscribe !== 'function') {
                                return subscription;
                            }
                            else if (this.closed) {
                                subscription.unsubscribe();
                                return subscription;
                            }
                            else if (typeof subscription._addParent !== 'function' /* quack quack */) {
                                var tmp = subscription;
                                subscription = new Subscription();
                                subscription._subscriptions = [tmp];
                            }
                            break;
                        default:
                            throw new Error('unrecognized teardown ' + teardown + ' added to Subscription.');
                    }
                    var subscriptions = this._subscriptions || (this._subscriptions = []);
                    subscriptions.push(subscription);
                    subscription._addParent(this);
                    return subscription;
                };
                /**
                 * Removes a Subscription from the internal list of subscriptions that will
                 * unsubscribe during the unsubscribe process of this Subscription.
                 * @param {Subscription} subscription The subscription to remove.
                 * @return {void}
                 */
                Subscription.prototype.remove = function (subscription) {
                    var subscriptions = this._subscriptions;
                    if (subscriptions) {
                        var subscriptionIndex = subscriptions.indexOf(subscription);
                        if (subscriptionIndex !== -1) {
                            subscriptions.splice(subscriptionIndex, 1);
                        }
                    }
                };
                Subscription.prototype._addParent = function (parent) {
                    var _a = this, _parent = _a._parent, _parents = _a._parents;
                    if (!_parent || _parent === parent) {
                        // If we don't have a parent, or the new parent is the same as the
                        // current parent, then set this._parent to the new parent.
                        this._parent = parent;
                    }
                    else if (!_parents) {
                        // If there's already one parent, but not multiple, allocate an Array to
                        // store the rest of the parent Subscriptions.
                        this._parents = [parent];
                    }
                    else if (_parents.indexOf(parent) === -1) {
                        // Only add the new parent to the _parents list if it's not already there.
                        _parents.push(parent);
                    }
                };
                Subscription.EMPTY = (function (empty) {
                    empty.closed = true;
                    return empty;
                }(new Subscription()));
                return Subscription;
            }());
            exports.Subscription = Subscription;
            function flattenUnsubscriptionErrors(errors) {
                return errors.reduce(function (errs, err) { return errs.concat((err instanceof UnsubscriptionError_1.UnsubscriptionError) ? err.errors : err); }, []);
            }
//# sourceMappingURL=Subscription.js.map

            /***/ }),
        /* 10 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Observable_1 = __webpack_require__(0);
            var ScalarObservable_1 = __webpack_require__(43);
            var EmptyObservable_1 = __webpack_require__(25);
            var isScheduler_1 = __webpack_require__(19);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @extends {Ignored}
             * @hide true
             */
            var ArrayObservable = (function (_super) {
                __extends(ArrayObservable, _super);
                function ArrayObservable(array, scheduler) {
                    _super.call(this);
                    this.array = array;
                    this.scheduler = scheduler;
                    if (!scheduler && array.length === 1) {
                        this._isScalar = true;
                        this.value = array[0];
                    }
                }
                ArrayObservable.create = function (array, scheduler) {
                    return new ArrayObservable(array, scheduler);
                };
                /**
                 * Creates an Observable that emits some values you specify as arguments,
                 * immediately one after the other, and then emits a complete notification.
                 *
                 * <span class="informal">Emits the arguments you provide, then completes.
                 * </span>
                 *
                 * <img src="./img/of.png" width="100%">
                 *
                 * This static operator is useful for creating a simple Observable that only
                 * emits the arguments given, and the complete notification thereafter. It can
                 * be used for composing with other Observables, such as with {@link concat}.
                 * By default, it uses a `null` IScheduler, which means the `next`
                 * notifications are sent synchronously, although with a different IScheduler
                 * it is possible to determine when those notifications will be delivered.
                 *
                 * @example <caption>Emit 10, 20, 30, then 'a', 'b', 'c', then start ticking every second.</caption>
                 * var numbers = Rx.Observable.of(10, 20, 30);
                 * var letters = Rx.Observable.of('a', 'b', 'c');
                 * var interval = Rx.Observable.interval(1000);
                 * var result = numbers.concat(letters).concat(interval);
                 * result.subscribe(x => console.log(x));
                 *
                 * @see {@link create}
                 * @see {@link empty}
                 * @see {@link never}
                 * @see {@link throw}
                 *
                 * @param {...T} values Arguments that represent `next` values to be emitted.
                 * @param {Scheduler} [scheduler] A {@link IScheduler} to use for scheduling
                 * the emissions of the `next` notifications.
                 * @return {Observable<T>} An Observable that emits each given input value.
                 * @static true
                 * @name of
                 * @owner Observable
                 */
                ArrayObservable.of = function () {
                    var array = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        array[_i - 0] = arguments[_i];
                    }
                    var scheduler = array[array.length - 1];
                    if (isScheduler_1.isScheduler(scheduler)) {
                        array.pop();
                    }
                    else {
                        scheduler = null;
                    }
                    var len = array.length;
                    if (len > 1) {
                        return new ArrayObservable(array, scheduler);
                    }
                    else if (len === 1) {
                        return new ScalarObservable_1.ScalarObservable(array[0], scheduler);
                    }
                    else {
                        return new EmptyObservable_1.EmptyObservable(scheduler);
                    }
                };
                ArrayObservable.dispatch = function (state) {
                    var array = state.array, index = state.index, count = state.count, subscriber = state.subscriber;
                    if (index >= count) {
                        subscriber.complete();
                        return;
                    }
                    subscriber.next(array[index]);
                    if (subscriber.closed) {
                        return;
                    }
                    state.index = index + 1;
                    this.schedule(state);
                };
                ArrayObservable.prototype._subscribe = function (subscriber) {
                    var index = 0;
                    var array = this.array;
                    var count = array.length;
                    var scheduler = this.scheduler;
                    if (scheduler) {
                        return scheduler.schedule(ArrayObservable.dispatch, 0, {
                            array: array, index: index, count: count, subscriber: subscriber
                        });
                    }
                    else {
                        for (var i = 0; i < count && !subscriber.closed; i++) {
                            subscriber.next(array[i]);
                        }
                        subscriber.complete();
                    }
                };
                return ArrayObservable;
            }(Observable_1.Observable));
            exports.ArrayObservable = ArrayObservable;
//# sourceMappingURL=ArrayObservable.js.map

            /***/ }),
        /* 11 */
        /***/ (function(module, exports, __webpack_require__) {

            var anObject = __webpack_require__(21);
            var IE8_DOM_DEFINE = __webpack_require__(73);
            var toPrimitive = __webpack_require__(74);
            var dP = Object.defineProperty;

            exports.f = __webpack_require__(13) ? Object.defineProperty : function defineProperty(O, P, Attributes) {
                anObject(O);
                P = toPrimitive(P, true);
                anObject(Attributes);
                if (IE8_DOM_DEFINE) try {
                    return dP(O, P, Attributes);
                } catch (e) { /* empty */ }
                if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
                if ('value' in Attributes) O[P] = Attributes.value;
                return O;
            };


            /***/ }),
        /* 12 */
        /***/ (function(module, exports) {

            module.exports = function (it) {
                return typeof it === 'object' ? it !== null : typeof it === 'function';
            };


            /***/ }),
        /* 13 */
        /***/ (function(module, exports, __webpack_require__) {

// Thank's IE8 for his funny defineProperty
            module.exports = !__webpack_require__(14)(function () {
                return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
            });


            /***/ }),
        /* 14 */
        /***/ (function(module, exports) {

            module.exports = function (exec) {
                try {
                    return !!exec();
                } catch (e) {
                    return true;
                }
            };


            /***/ }),
        /* 15 */
        /***/ (function(module, exports) {

            var hasOwnProperty = {}.hasOwnProperty;
            module.exports = function (it, key) {
                return hasOwnProperty.call(it, key);
            };


            /***/ }),
        /* 16 */
        /***/ (function(module, exports, __webpack_require__) {

// 7.1.13 ToObject(argument)
            var defined = __webpack_require__(28);
            module.exports = function (it) {
                return Object(defined(it));
            };


            /***/ }),
        /* 17 */
        /***/ (function(module, exports) {

            var g;

// This works in non-strict mode
            g = (function() {
                return this;
            })();

            try {
                // This works if eval is allowed (see CSP)
                g = g || Function("return this")() || (1,eval)("this");
            } catch(e) {
                // This works if the window reference is available
                if(typeof window === "object")
                    g = window;
            }

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

            module.exports = g;


            /***/ }),
        /* 18 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";
            /* WEBPACK VAR INJECTION */(function(global) {

                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
// # src / symbols.js
// Copyright (c) 2017 Florian Klampfer <https://qwtel.com/>
// Licensed under MIT

                var _Symbol = global.Symbol || function (x) {
                    return '_' + x;
                };

                var sSetup = exports.sSetup = _Symbol('setup');
                var sSetupDOM = exports.sSetupDOM = _Symbol('setupDOM');
                var sGetRoot = exports.sGetRoot = _Symbol('getRoot');
                var sGetEl = exports.sGetEl = _Symbol('getElement');
                var sFire = exports.sFire = _Symbol('fire');
                var sSetState = exports.sSetState = _Symbol('setState');
                var sGetTemplate = exports.sGetTemplate = _Symbol('getTemplate');
                /* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17)))

            /***/ }),
        /* 19 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            function isScheduler(value) {
                return value && typeof value.schedule === 'function';
            }
            exports.isScheduler = isScheduler;
//# sourceMappingURL=isScheduler.js.map

            /***/ }),
        /* 20 */
        /***/ (function(module, exports, __webpack_require__) {

            var dP = __webpack_require__(11);
            var createDesc = __webpack_require__(29);
            module.exports = __webpack_require__(13) ? function (object, key, value) {
                return dP.f(object, key, createDesc(1, value));
            } : function (object, key, value) {
                object[key] = value;
                return object;
            };


            /***/ }),
        /* 21 */
        /***/ (function(module, exports, __webpack_require__) {

            var isObject = __webpack_require__(12);
            module.exports = function (it) {
                if (!isObject(it)) throw TypeError(it + ' is not an object!');
                return it;
            };


            /***/ }),
        /* 22 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            exports.isArray = Array.isArray || (function (x) { return x && typeof x.length === 'number'; });
//# sourceMappingURL=isArray.js.map

            /***/ }),
        /* 23 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

// typeof any so that it we don't have to cast when comparing a result to the error object
            exports.errorObject = { e: {} };
//# sourceMappingURL=errorObject.js.map

            /***/ }),
        /* 24 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Observable_1 = __webpack_require__(0);
            var Subscriber_1 = __webpack_require__(1);
            var Subscription_1 = __webpack_require__(9);
            var ObjectUnsubscribedError_1 = __webpack_require__(115);
            var SubjectSubscription_1 = __webpack_require__(116);
            var rxSubscriber_1 = __webpack_require__(41);
            /**
             * @class SubjectSubscriber<T>
             */
            var SubjectSubscriber = (function (_super) {
                __extends(SubjectSubscriber, _super);
                function SubjectSubscriber(destination) {
                    _super.call(this, destination);
                    this.destination = destination;
                }
                return SubjectSubscriber;
            }(Subscriber_1.Subscriber));
            exports.SubjectSubscriber = SubjectSubscriber;
            /**
             * @class Subject<T>
             */
            var Subject = (function (_super) {
                __extends(Subject, _super);
                function Subject() {
                    _super.call(this);
                    this.observers = [];
                    this.closed = false;
                    this.isStopped = false;
                    this.hasError = false;
                    this.thrownError = null;
                }
                Subject.prototype[rxSubscriber_1.rxSubscriber] = function () {
                    return new SubjectSubscriber(this);
                };
                Subject.prototype.lift = function (operator) {
                    var subject = new AnonymousSubject(this, this);
                    subject.operator = operator;
                    return subject;
                };
                Subject.prototype.next = function (value) {
                    if (this.closed) {
                        throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError();
                    }
                    if (!this.isStopped) {
                        var observers = this.observers;
                        var len = observers.length;
                        var copy = observers.slice();
                        for (var i = 0; i < len; i++) {
                            copy[i].next(value);
                        }
                    }
                };
                Subject.prototype.error = function (err) {
                    if (this.closed) {
                        throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError();
                    }
                    this.hasError = true;
                    this.thrownError = err;
                    this.isStopped = true;
                    var observers = this.observers;
                    var len = observers.length;
                    var copy = observers.slice();
                    for (var i = 0; i < len; i++) {
                        copy[i].error(err);
                    }
                    this.observers.length = 0;
                };
                Subject.prototype.complete = function () {
                    if (this.closed) {
                        throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError();
                    }
                    this.isStopped = true;
                    var observers = this.observers;
                    var len = observers.length;
                    var copy = observers.slice();
                    for (var i = 0; i < len; i++) {
                        copy[i].complete();
                    }
                    this.observers.length = 0;
                };
                Subject.prototype.unsubscribe = function () {
                    this.isStopped = true;
                    this.closed = true;
                    this.observers = null;
                };
                Subject.prototype._trySubscribe = function (subscriber) {
                    if (this.closed) {
                        throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError();
                    }
                    else {
                        return _super.prototype._trySubscribe.call(this, subscriber);
                    }
                };
                Subject.prototype._subscribe = function (subscriber) {
                    if (this.closed) {
                        throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError();
                    }
                    else if (this.hasError) {
                        subscriber.error(this.thrownError);
                        return Subscription_1.Subscription.EMPTY;
                    }
                    else if (this.isStopped) {
                        subscriber.complete();
                        return Subscription_1.Subscription.EMPTY;
                    }
                    else {
                        this.observers.push(subscriber);
                        return new SubjectSubscription_1.SubjectSubscription(this, subscriber);
                    }
                };
                Subject.prototype.asObservable = function () {
                    var observable = new Observable_1.Observable();
                    observable.source = this;
                    return observable;
                };
                Subject.create = function (destination, source) {
                    return new AnonymousSubject(destination, source);
                };
                return Subject;
            }(Observable_1.Observable));
            exports.Subject = Subject;
            /**
             * @class AnonymousSubject<T>
             */
            var AnonymousSubject = (function (_super) {
                __extends(AnonymousSubject, _super);
                function AnonymousSubject(destination, source) {
                    _super.call(this);
                    this.destination = destination;
                    this.source = source;
                }
                AnonymousSubject.prototype.next = function (value) {
                    var destination = this.destination;
                    if (destination && destination.next) {
                        destination.next(value);
                    }
                };
                AnonymousSubject.prototype.error = function (err) {
                    var destination = this.destination;
                    if (destination && destination.error) {
                        this.destination.error(err);
                    }
                };
                AnonymousSubject.prototype.complete = function () {
                    var destination = this.destination;
                    if (destination && destination.complete) {
                        this.destination.complete();
                    }
                };
                AnonymousSubject.prototype._subscribe = function (subscriber) {
                    var source = this.source;
                    if (source) {
                        return this.source.subscribe(subscriber);
                    }
                    else {
                        return Subscription_1.Subscription.EMPTY;
                    }
                };
                return AnonymousSubject;
            }(Subject));
            exports.AnonymousSubject = AnonymousSubject;
//# sourceMappingURL=Subject.js.map

            /***/ }),
        /* 25 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Observable_1 = __webpack_require__(0);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @extends {Ignored}
             * @hide true
             */
            var EmptyObservable = (function (_super) {
                __extends(EmptyObservable, _super);
                function EmptyObservable(scheduler) {
                    _super.call(this);
                    this.scheduler = scheduler;
                }
                /**
                 * Creates an Observable that emits no items to the Observer and immediately
                 * emits a complete notification.
                 *
                 * <span class="informal">Just emits 'complete', and nothing else.
                 * </span>
                 *
                 * <img src="./img/empty.png" width="100%">
                 *
                 * This static operator is useful for creating a simple Observable that only
                 * emits the complete notification. It can be used for composing with other
                 * Observables, such as in a {@link mergeMap}.
                 *
                 * @example <caption>Emit the number 7, then complete.</caption>
                 * var result = Rx.Observable.empty().startWith(7);
                 * result.subscribe(x => console.log(x));
                 *
                 * @example <caption>Map and flatten only odd numbers to the sequence 'a', 'b', 'c'</caption>
                 * var interval = Rx.Observable.interval(1000);
                 * var result = interval.mergeMap(x =>
                 *   x % 2 === 1 ? Rx.Observable.of('a', 'b', 'c') : Rx.Observable.empty()
                 * );
                 * result.subscribe(x => console.log(x));
                 *
                 * // Results in the following to the console:
                 * // x is equal to the count on the interval eg(0,1,2,3,...)
                 * // x will occur every 1000ms
                 * // if x % 2 is equal to 1 print abc
                 * // if x % 2 is not equal to 1 nothing will be output
                 *
                 * @see {@link create}
                 * @see {@link never}
                 * @see {@link of}
                 * @see {@link throw}
                 *
                 * @param {Scheduler} [scheduler] A {@link IScheduler} to use for scheduling
                 * the emission of the complete notification.
                 * @return {Observable} An "empty" Observable: emits only the complete
                 * notification.
                 * @static true
                 * @name empty
                 * @owner Observable
                 */
                EmptyObservable.create = function (scheduler) {
                    return new EmptyObservable(scheduler);
                };
                EmptyObservable.dispatch = function (arg) {
                    var subscriber = arg.subscriber;
                    subscriber.complete();
                };
                EmptyObservable.prototype._subscribe = function (subscriber) {
                    var scheduler = this.scheduler;
                    if (scheduler) {
                        return scheduler.schedule(EmptyObservable.dispatch, 0, { subscriber: subscriber });
                    }
                    else {
                        subscriber.complete();
                    }
                };
                return EmptyObservable;
            }(Observable_1.Observable));
            exports.EmptyObservable = EmptyObservable;
//# sourceMappingURL=EmptyObservable.js.map

            /***/ }),
        /* 26 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var AsyncAction_1 = __webpack_require__(133);
            var AsyncScheduler_1 = __webpack_require__(135);
            /**
             *
             * Async Scheduler
             *
             * <span class="informal">Schedule task as if you used setTimeout(task, duration)</span>
             *
             * `async` scheduler schedules tasks asynchronously, by putting them on the JavaScript
             * event loop queue. It is best used to delay tasks in time or to schedule tasks repeating
             * in intervals.
             *
             * If you just want to "defer" task, that is to perform it right after currently
             * executing synchronous code ends (commonly achieved by `setTimeout(deferredTask, 0)`),
             * better choice will be the {@link asap} scheduler.
             *
             * @example <caption>Use async scheduler to delay task</caption>
             * const task = () => console.log('it works!');
             *
             * Rx.Scheduler.async.schedule(task, 2000);
             *
             * // After 2 seconds logs:
             * // "it works!"
             *
             *
             * @example <caption>Use async scheduler to repeat task in intervals</caption>
             * function task(state) {
             *   console.log(state);
             *   this.schedule(state + 1, 1000); // `this` references currently executing Action,
             *                                   // which we reschedule with new state and delay
             * }
             *
             * Rx.Scheduler.async.schedule(task, 3000, 0);
             *
             * // Logs:
             * // 0 after 3s
             * // 1 after 4s
             * // 2 after 5s
             * // 3 after 6s
             *
             * @static true
             * @name async
             * @owner Scheduler
             */
            exports.async = new AsyncScheduler_1.AsyncScheduler(AsyncAction_1.AsyncAction);
//# sourceMappingURL=async.js.map

            /***/ }),
        /* 27 */
        /***/ (function(module, exports) {

// 7.1.4 ToInteger
            var ceil = Math.ceil;
            var floor = Math.floor;
            module.exports = function (it) {
                return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
            };


            /***/ }),
        /* 28 */
        /***/ (function(module, exports) {

// 7.2.1 RequireObjectCoercible(argument)
            module.exports = function (it) {
                if (it == undefined) throw TypeError("Can't call method on  " + it);
                return it;
            };


            /***/ }),
        /* 29 */
        /***/ (function(module, exports) {

            module.exports = function (bitmap, value) {
                return {
                    enumerable: !(bitmap & 1),
                    configurable: !(bitmap & 2),
                    writable: !(bitmap & 4),
                    value: value
                };
            };


            /***/ }),
        /* 30 */
        /***/ (function(module, exports) {

            var id = 0;
            var px = Math.random();
            module.exports = function (key) {
                return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
            };


            /***/ }),
        /* 31 */
        /***/ (function(module, exports, __webpack_require__) {

// optional / simple context binding
            var aFunction = __webpack_require__(48);
            module.exports = function (fn, that, length) {
                aFunction(fn);
                if (that === undefined) return fn;
                switch (length) {
                    case 1: return function (a) {
                        return fn.call(that, a);
                    };
                    case 2: return function (a, b) {
                        return fn.call(that, a, b);
                    };
                    case 3: return function (a, b, c) {
                        return fn.call(that, a, b, c);
                    };
                }
                return function (/* ...args */) {
                    return fn.apply(that, arguments);
                };
            };


            /***/ }),
        /* 32 */
        /***/ (function(module, exports) {

            module.exports = {};


            /***/ }),
        /* 33 */
        /***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 / 15.2.3.14 Object.keys(O)
            var $keys = __webpack_require__(78);
            var enumBugKeys = __webpack_require__(51);

            module.exports = Object.keys || function keys(O) {
                return $keys(O, enumBugKeys);
            };


            /***/ }),
        /* 34 */
        /***/ (function(module, exports, __webpack_require__) {

// fallback for non-array-like ES3 and non-enumerable old V8 strings
            var cof = __webpack_require__(35);
// eslint-disable-next-line no-prototype-builtins
            module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
                return cof(it) == 'String' ? it.split('') : Object(it);
            };


            /***/ }),
        /* 35 */
        /***/ (function(module, exports) {

            var toString = {}.toString;

            module.exports = function (it) {
                return toString.call(it).slice(8, -1);
            };


            /***/ }),
        /* 36 */
        /***/ (function(module, exports, __webpack_require__) {

// 7.1.15 ToLength
            var toInteger = __webpack_require__(27);
            var min = Math.min;
            module.exports = function (it) {
                return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
            };


            /***/ }),
        /* 37 */
        /***/ (function(module, exports, __webpack_require__) {

            var shared = __webpack_require__(50)('keys');
            var uid = __webpack_require__(30);
            module.exports = function (key) {
                return shared[key] || (shared[key] = uid(key));
            };


            /***/ }),
        /* 38 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";
            /* WEBPACK VAR INJECTION */(function(global) {

                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Set = exports.string = exports.regex = exports.number = exports.bool = exports.arrayOf = exports.array = undefined;

                var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; // # src / common.js
// Copyright (c) 2017 Florian Klampfer <https://qwtel.com/>
// Licensed under MIT

                exports.simpleType = simpleType;

                var _types = __webpack_require__(56);

                exports.array = _types.array;
                exports.arrayOf = _types.arrayOf;
                exports.bool = _types.bool;
                exports.number = _types.number;
                exports.regex = _types.regex;
                exports.string = _types.string;

// Quick-and-Dirty `Set` implementation.
                /* eslint-disable */

                var Set = exports.Set = global.Set || function () {
                    var a = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

                    a = a.filter(function (x, i) {
                        return i === a.indexOf(x);
                    });
                    a.size = a.length;
                    a.has = function (x) {
                        return a.indexOf(x) > -1;
                    };
                    a.add = function (x) {
                        if (!a.has(x)) {
                            a.size++;a.push(x);
                        }return a;
                    };
                    a.delete = function (x) {
                        var t = void 0;if (t = a.has(x)) {
                            a.size--;delete a[a.indexOf(x)];
                        }return t;
                    };
                    a.keys = a.values = function () {
                        return a[Symbol.iterator]();
                    };
                    a.clear = function () {
                        while (a.pop()) {}a.size = 0;
                    };
                    return a;
                };
                /* eslint-enable */

                function simpleType(type, defVal, attr) {
                    // Use the provided type, if any.
                    if (type && type === _types.bool) return type(attr);else if (type) return !attr ? defVal : type(attr);

                    // Otherwise, infer primitive types form `defVal`.
                    else if (typeof defVal === 'boolean') return (0, _types.bool)(attr);else if (typeof defVal === 'number') return !attr ? defVal : (0, _types.number)(attr);else if ((typeof defVal === 'undefined' ? 'undefined' : _typeof(defVal)) === 'object' && defVal) return !attr ? defVal : (0, _types.array)(attr);else if (typeof defVal === 'string') return !attr ? defVal : (0, _types.string)(attr);

                    if (true) console.warn('No type provided for attribute ' + attr + ' and can\'t infer from defaults');
                    return undefined;
                }
                /* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17)))

            /***/ }),
        /* 39 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            function isFunction(x) {
                return typeof x === 'function';
            }
            exports.isFunction = isFunction;
//# sourceMappingURL=isFunction.js.map

            /***/ }),
        /* 40 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var errorObject_1 = __webpack_require__(23);
            var tryCatchTarget;
            function tryCatcher() {
                try {
                    return tryCatchTarget.apply(this, arguments);
                }
                catch (e) {
                    errorObject_1.errorObject.e = e;
                    return errorObject_1.errorObject;
                }
            }
            function tryCatch(fn) {
                tryCatchTarget = fn;
                return tryCatcher;
            }
            exports.tryCatch = tryCatch;
            ;
//# sourceMappingURL=tryCatch.js.map

            /***/ }),
        /* 41 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var root_1 = __webpack_require__(4);
            var Symbol = root_1.root.Symbol;
            exports.rxSubscriber = (typeof Symbol === 'function' && typeof Symbol.for === 'function') ?
                Symbol.for('rxSubscriber') : '@@rxSubscriber';
            /**
             * @deprecated use rxSubscriber instead
             */
            exports.$$rxSubscriber = exports.rxSubscriber;
//# sourceMappingURL=rxSubscriber.js.map

            /***/ }),
        /* 42 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var root_1 = __webpack_require__(4);
            function getSymbolObservable(context) {
                var $$observable;
                var Symbol = context.Symbol;
                if (typeof Symbol === 'function') {
                    if (Symbol.observable) {
                        $$observable = Symbol.observable;
                    }
                    else {
                        $$observable = Symbol('observable');
                        Symbol.observable = $$observable;
                    }
                }
                else {
                    $$observable = '@@observable';
                }
                return $$observable;
            }
            exports.getSymbolObservable = getSymbolObservable;
            exports.observable = getSymbolObservable(root_1.root);
            /**
             * @deprecated use observable instead
             */
            exports.$$observable = exports.observable;
//# sourceMappingURL=observable.js.map

            /***/ }),
        /* 43 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Observable_1 = __webpack_require__(0);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @extends {Ignored}
             * @hide true
             */
            var ScalarObservable = (function (_super) {
                __extends(ScalarObservable, _super);
                function ScalarObservable(value, scheduler) {
                    _super.call(this);
                    this.value = value;
                    this.scheduler = scheduler;
                    this._isScalar = true;
                    if (scheduler) {
                        this._isScalar = false;
                    }
                }
                ScalarObservable.create = function (value, scheduler) {
                    return new ScalarObservable(value, scheduler);
                };
                ScalarObservable.dispatch = function (state) {
                    var done = state.done, value = state.value, subscriber = state.subscriber;
                    if (done) {
                        subscriber.complete();
                        return;
                    }
                    subscriber.next(value);
                    if (subscriber.closed) {
                        return;
                    }
                    state.done = true;
                    this.schedule(state);
                };
                ScalarObservable.prototype._subscribe = function (subscriber) {
                    var value = this.value;
                    var scheduler = this.scheduler;
                    if (scheduler) {
                        return scheduler.schedule(ScalarObservable.dispatch, 0, {
                            done: false, value: value, subscriber: subscriber
                        });
                    }
                    else {
                        subscriber.next(value);
                        if (!subscriber.closed) {
                            subscriber.complete();
                        }
                    }
                };
                return ScalarObservable;
            }(Observable_1.Observable));
            exports.ScalarObservable = ScalarObservable;
//# sourceMappingURL=ScalarObservable.js.map

            /***/ }),
        /* 44 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var root_1 = __webpack_require__(4);
            function symbolIteratorPonyfill(root) {
                var Symbol = root.Symbol;
                if (typeof Symbol === 'function') {
                    if (!Symbol.iterator) {
                        Symbol.iterator = Symbol('iterator polyfill');
                    }
                    return Symbol.iterator;
                }
                else {
                    // [for Mozilla Gecko 27-35:](https://mzl.la/2ewE1zC)
                    var Set_1 = root.Set;
                    if (Set_1 && typeof new Set_1()['@@iterator'] === 'function') {
                        return '@@iterator';
                    }
                    var Map_1 = root.Map;
                    // required for compatability with es6-shim
                    if (Map_1) {
                        var keys = Object.getOwnPropertyNames(Map_1.prototype);
                        for (var i = 0; i < keys.length; ++i) {
                            var key = keys[i];
                            // according to spec, Map.prototype[@@iterator] and Map.orototype.entries must be equal.
                            if (key !== 'entries' && key !== 'size' && Map_1.prototype[key] === Map_1.prototype['entries']) {
                                return key;
                            }
                        }
                    }
                    return '@@iterator';
                }
            }
            exports.symbolIteratorPonyfill = symbolIteratorPonyfill;
            exports.iterator = symbolIteratorPonyfill(root_1.root);
            /**
             * @deprecated use iterator instead
             */
            exports.$$iterator = exports.iterator;
//# sourceMappingURL=iterator.js.map

            /***/ }),
        /* 45 */
        /***/ (function(module, exports, __webpack_require__) {

            __webpack_require__(69);
            __webpack_require__(83);
            module.exports = __webpack_require__(2).Array.from;


            /***/ }),
        /* 46 */
        /***/ (function(module, exports, __webpack_require__) {

            var isObject = __webpack_require__(12);
            var document = __webpack_require__(8).document;
// typeof document.createElement is 'object' in old IE
            var is = isObject(document) && isObject(document.createElement);
            module.exports = function (it) {
                return is ? document.createElement(it) : {};
            };


            /***/ }),
        /* 47 */
        /***/ (function(module, exports, __webpack_require__) {

            var global = __webpack_require__(8);
            var hide = __webpack_require__(20);
            var has = __webpack_require__(15);
            var SRC = __webpack_require__(30)('src');
            var TO_STRING = 'toString';
            var $toString = Function[TO_STRING];
            var TPL = ('' + $toString).split(TO_STRING);

            __webpack_require__(2).inspectSource = function (it) {
                return $toString.call(it);
            };

            (module.exports = function (O, key, val, safe) {
                var isFunction = typeof val == 'function';
                if (isFunction) has(val, 'name') || hide(val, 'name', key);
                if (O[key] === val) return;
                if (isFunction) has(val, SRC) || hide(val, SRC, O[key] ? '' + O[key] : TPL.join(String(key)));
                if (O === global) {
                    O[key] = val;
                } else if (!safe) {
                    delete O[key];
                    hide(O, key, val);
                } else if (O[key]) {
                    O[key] = val;
                } else {
                    hide(O, key, val);
                }
// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
            })(Function.prototype, TO_STRING, function toString() {
                return typeof this == 'function' && this[SRC] || $toString.call(this);
            });


            /***/ }),
        /* 48 */
        /***/ (function(module, exports) {

            module.exports = function (it) {
                if (typeof it != 'function') throw TypeError(it + ' is not a function!');
                return it;
            };


            /***/ }),
        /* 49 */
        /***/ (function(module, exports, __webpack_require__) {

// to indexed object, toObject with fallback for non-array-like ES3 strings
            var IObject = __webpack_require__(34);
            var defined = __webpack_require__(28);
            module.exports = function (it) {
                return IObject(defined(it));
            };


            /***/ }),
        /* 50 */
        /***/ (function(module, exports, __webpack_require__) {

            var global = __webpack_require__(8);
            var SHARED = '__core-js_shared__';
            var store = global[SHARED] || (global[SHARED] = {});
            module.exports = function (key) {
                return store[key] || (store[key] = {});
            };


            /***/ }),
        /* 51 */
        /***/ (function(module, exports) {

// IE 8- don't enum bug keys
            module.exports = (
                'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
            ).split(',');


            /***/ }),
        /* 52 */
        /***/ (function(module, exports, __webpack_require__) {

            var def = __webpack_require__(11).f;
            var has = __webpack_require__(15);
            var TAG = __webpack_require__(3)('toStringTag');

            module.exports = function (it, tag, stat) {
                if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
            };


            /***/ }),
        /* 53 */
        /***/ (function(module, exports) {

            module.exports = __WEBPACK_EXTERNAL_MODULE_53__;

            /***/ }),
        /* 54 */
        /***/ (function(module, exports, __webpack_require__) {

            __webpack_require__(91);
            module.exports = __webpack_require__(2).Array.forEach;


            /***/ }),
        /* 55 */
        /***/ (function(module, exports, __webpack_require__) {

            __webpack_require__(97);
            module.exports = __webpack_require__(2).Object.keys;


            /***/ }),
        /* 56 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";


            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            exports.array = array;
            exports.arrayOf = arrayOf;
            exports.string = string;
            exports.bool = bool;
            exports.number = number;
            exports.regex = regex;
            exports.oneOf = oneOf;
// # src / types.js
// Copyright (c) 2017 Florian Klampfer <https://qwtel.com/>
// Licensed under MIT

            function array(attr) {
                return attr.trim().replace(/^\[?(.*?)\]?$/, '$1').split(',').map(function (x) {
                    return x.trim();
                });
            }

            function arrayOf(type) {
                return function (attr) {
                    return array(attr).map(type);
                };
            }

            function string(attr) {
                return attr;
            }

            function bool(attr) {
                if (attr === true || attr === 'true') return true;else if (attr === false || attr === 'false') return false;
                return attr != null;
            }

            function number(attr) {
                return Number(attr);
            }

            function regex(attr) {
                var match = attr.match(/^\/?(.*?)(\/([gimy]*))?$/);
                return new RegExp(match[1], match[3]);
            }

            function oneOf(alts) {
                return function (attr) {
                    var i = alts.indexOf(attr);
                    if (true && i === -1) console.warn('\'' + attr + '\' is not \'oneOf\': ' + alts.join(', '));
                    return i > -1 ? alts[i] : null;
                };
            }

            /***/ }),
        /* 57 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";


            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            exports.Set = undefined;
            exports.createTween = createTween;
            exports.linearTween = linearTween;

            var _Observable = __webpack_require__(0);

            var _common = __webpack_require__(38);

// # src / common.js
// Copyright (c) 2017 Florian Klampfer <https://qwtel.com/>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
            exports.Set = _common.Set;

// Creates an observable that emits samples from an easing function on every animation frame
// for a duration `d` ms.
//
// The first emitted value will be a sample form the easing function at `t = 0`,
// and the last emitted value is guaranteed to be the easing function at `t = d`.
//
// It can be used with any of [Robert Penner's easing functions](http://robertpenner.com/easing/),
// i.e. functions with a signature of `(t, b, c, d, s)`, where
// `t`: current time,
// `b`: beginning value,
// `c`: change in value,
// `d`: total duration,
// `s`: optional.

            function createTween(easingFunction, b, c, d, s) {
                return _Observable.Observable.create(function (observer) {
                    var startTime = void 0;
                    var id = requestAnimationFrame(function sample(time) {
                        startTime = startTime || time;
                        var t = time - startTime;
                        if (t < d) {
                            observer.next(easingFunction(t, b, c, d, s));
                            id = requestAnimationFrame(sample);
                        } else {
                            observer.next(easingFunction(d, b, c, d, s));
                            id = requestAnimationFrame(function () {
                                return observer.complete();
                            });
                        }
                    });
                    return function () {
                        if (id) {
                            cancelAnimationFrame(id);
                        }
                    };
                });
            }

// The linear easing function...
            function linearTween(t, b, c, d) {
                return c * t / d + b;
            }

            /***/ }),
        /* 58 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            function isObject(x) {
                return x != null && typeof x === 'object';
            }
            exports.isObject = isObject;
//# sourceMappingURL=isObject.js.map

            /***/ }),
        /* 59 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            exports.empty = {
                closed: true,
                next: function (value) { },
                error: function (err) { throw err; },
                complete: function () { }
            };
//# sourceMappingURL=Observer.js.map

            /***/ }),
        /* 60 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            /* tslint:disable:no-empty */
            function noop() { }
            exports.noop = noop;
//# sourceMappingURL=noop.js.map

            /***/ }),
        /* 61 */
        /***/ (function(module, exports, __webpack_require__) {

            __webpack_require__(108);
            module.exports = __webpack_require__(2).Object.assign;


            /***/ }),
        /* 62 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            exports.isArrayLike = (function (x) { return x && typeof x.length === 'number'; });
//# sourceMappingURL=isArrayLike.js.map

            /***/ }),
        /* 63 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            function isPromise(value) {
                return value && typeof value.subscribe !== 'function' && typeof value.then === 'function';
            }
            exports.isPromise = isPromise;
//# sourceMappingURL=isPromise.js.map

            /***/ }),
        /* 64 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var Observable_1 = __webpack_require__(0);
            var ArrayObservable_1 = __webpack_require__(10);
            var mergeAll_1 = __webpack_require__(65);
            var isScheduler_1 = __webpack_require__(19);
            /* tslint:enable:max-line-length */
            function merge() {
                var observables = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    observables[_i - 0] = arguments[_i];
                }
                return function (source) { return source.lift.call(mergeStatic.apply(void 0, [source].concat(observables))); };
            }
            exports.merge = merge;
            /* tslint:enable:max-line-length */
            /**
             * Creates an output Observable which concurrently emits all values from every
             * given input Observable.
             *
             * <span class="informal">Flattens multiple Observables together by blending
             * their values into one Observable.</span>
             *
             * <img src="./img/merge.png" width="100%">
             *
             * `merge` subscribes to each given input Observable (as arguments), and simply
             * forwards (without doing any transformation) all the values from all the input
             * Observables to the output Observable. The output Observable only completes
             * once all input Observables have completed. Any error delivered by an input
             * Observable will be immediately emitted on the output Observable.
             *
             * @example <caption>Merge together two Observables: 1s interval and clicks</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var timer = Rx.Observable.interval(1000);
             * var clicksOrTimer = Rx.Observable.merge(clicks, timer);
             * clicksOrTimer.subscribe(x => console.log(x));
             *
             * // Results in the following:
             * // timer will emit ascending values, one every second(1000ms) to console
             * // clicks logs MouseEvents to console everytime the "document" is clicked
             * // Since the two streams are merged you see these happening
             * // as they occur.
             *
             * @example <caption>Merge together 3 Observables, but only 2 run concurrently</caption>
             * var timer1 = Rx.Observable.interval(1000).take(10);
             * var timer2 = Rx.Observable.interval(2000).take(6);
             * var timer3 = Rx.Observable.interval(500).take(10);
             * var concurrent = 2; // the argument
             * var merged = Rx.Observable.merge(timer1, timer2, timer3, concurrent);
             * merged.subscribe(x => console.log(x));
             *
             * // Results in the following:
             * // - First timer1 and timer2 will run concurrently
             * // - timer1 will emit a value every 1000ms for 10 iterations
             * // - timer2 will emit a value every 2000ms for 6 iterations
             * // - after timer1 hits it's max iteration, timer2 will
             * //   continue, and timer3 will start to run concurrently with timer2
             * // - when timer2 hits it's max iteration it terminates, and
             * //   timer3 will continue to emit a value every 500ms until it is complete
             *
             * @see {@link mergeAll}
             * @see {@link mergeMap}
             * @see {@link mergeMapTo}
             * @see {@link mergeScan}
             *
             * @param {...ObservableInput} observables Input Observables to merge together.
             * @param {number} [concurrent=Number.POSITIVE_INFINITY] Maximum number of input
             * Observables being subscribed to concurrently.
             * @param {Scheduler} [scheduler=null] The IScheduler to use for managing
             * concurrency of input Observables.
             * @return {Observable} an Observable that emits items that are the result of
             * every input Observable.
             * @static true
             * @name merge
             * @owner Observable
             */
            function mergeStatic() {
                var observables = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    observables[_i - 0] = arguments[_i];
                }
                var concurrent = Number.POSITIVE_INFINITY;
                var scheduler = null;
                var last = observables[observables.length - 1];
                if (isScheduler_1.isScheduler(last)) {
                    scheduler = observables.pop();
                    if (observables.length > 1 && typeof observables[observables.length - 1] === 'number') {
                        concurrent = observables.pop();
                    }
                }
                else if (typeof last === 'number') {
                    concurrent = observables.pop();
                }
                if (scheduler === null && observables.length === 1 && observables[0] instanceof Observable_1.Observable) {
                    return observables[0];
                }
                return mergeAll_1.mergeAll(concurrent)(new ArrayObservable_1.ArrayObservable(observables, scheduler));
            }
            exports.mergeStatic = mergeStatic;
//# sourceMappingURL=merge.js.map

            /***/ }),
        /* 65 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var mergeMap_1 = __webpack_require__(126);
            var identity_1 = __webpack_require__(127);
            /**
             * Converts a higher-order Observable into a first-order Observable which
             * concurrently delivers all values that are emitted on the inner Observables.
             *
             * <span class="informal">Flattens an Observable-of-Observables.</span>
             *
             * <img src="./img/mergeAll.png" width="100%">
             *
             * `mergeAll` subscribes to an Observable that emits Observables, also known as
             * a higher-order Observable. Each time it observes one of these emitted inner
             * Observables, it subscribes to that and delivers all the values from the
             * inner Observable on the output Observable. The output Observable only
             * completes once all inner Observables have completed. Any error delivered by
             * a inner Observable will be immediately emitted on the output Observable.
             *
             * @example <caption>Spawn a new interval Observable for each click event, and blend their outputs as one Observable</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var higherOrder = clicks.map((ev) => Rx.Observable.interval(1000));
             * var firstOrder = higherOrder.mergeAll();
             * firstOrder.subscribe(x => console.log(x));
             *
             * @example <caption>Count from 0 to 9 every second for each click, but only allow 2 concurrent timers</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var higherOrder = clicks.map((ev) => Rx.Observable.interval(1000).take(10));
             * var firstOrder = higherOrder.mergeAll(2);
             * firstOrder.subscribe(x => console.log(x));
             *
             * @see {@link combineAll}
             * @see {@link concatAll}
             * @see {@link exhaust}
             * @see {@link merge}
             * @see {@link mergeMap}
             * @see {@link mergeMapTo}
             * @see {@link mergeScan}
             * @see {@link switch}
             * @see {@link zipAll}
             *
             * @param {number} [concurrent=Number.POSITIVE_INFINITY] Maximum number of inner
             * Observables being subscribed to concurrently.
             * @return {Observable} An Observable that emits values coming from all the
             * inner Observables emitted by the source Observable.
             * @method mergeAll
             * @owner Observable
             */
            function mergeAll(concurrent) {
                if (concurrent === void 0) { concurrent = Number.POSITIVE_INFINITY; }
                return mergeMap_1.mergeMap(identity_1.identity, null, concurrent);
            }
            exports.mergeAll = mergeAll;
//# sourceMappingURL=mergeAll.js.map

            /***/ }),
        /* 66 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            /**
             * Applies a given `project` function to each value emitted by the source
             * Observable, and emits the resulting values as an Observable.
             *
             * <span class="informal">Like [Array.prototype.map()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map),
             * it passes each source value through a transformation function to get
             * corresponding output values.</span>
             *
             * <img src="./img/map.png" width="100%">
             *
             * Similar to the well known `Array.prototype.map` function, this operator
             * applies a projection to each value and emits that projection in the output
             * Observable.
             *
             * @example <caption>Map every click to the clientX position of that click</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var positions = clicks.map(ev => ev.clientX);
             * positions.subscribe(x => console.log(x));
             *
             * @see {@link mapTo}
             * @see {@link pluck}
             *
             * @param {function(value: T, index: number): R} project The function to apply
             * to each `value` emitted by the source Observable. The `index` parameter is
             * the number `i` for the i-th emission that has happened since the
             * subscription, starting from the number `0`.
             * @param {any} [thisArg] An optional argument to define what `this` is in the
             * `project` function.
             * @return {Observable<R>} An Observable that emits the values from the source
             * Observable transformed by the given `project` function.
             * @method map
             * @owner Observable
             */
            function map(project, thisArg) {
                return function mapOperation(source) {
                    if (typeof project !== 'function') {
                        throw new TypeError('argument is not a function. Are you looking for `mapTo()`?');
                    }
                    return source.lift(new MapOperator(project, thisArg));
                };
            }
            exports.map = map;
            var MapOperator = (function () {
                function MapOperator(project, thisArg) {
                    this.project = project;
                    this.thisArg = thisArg;
                }
                MapOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new MapSubscriber(subscriber, this.project, this.thisArg));
                };
                return MapOperator;
            }());
            exports.MapOperator = MapOperator;
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var MapSubscriber = (function (_super) {
                __extends(MapSubscriber, _super);
                function MapSubscriber(destination, project, thisArg) {
                    _super.call(this, destination);
                    this.project = project;
                    this.count = 0;
                    this.thisArg = thisArg || this;
                }
                // NOTE: This looks unoptimized, but it's actually purposefully NOT
                // using try/catch optimizations.
                MapSubscriber.prototype._next = function (value) {
                    var result;
                    try {
                        result = this.project.call(this.thisArg, value, this.count++);
                    }
                    catch (err) {
                        this.destination.error(err);
                        return;
                    }
                    this.destination.next(result);
                };
                return MapSubscriber;
            }(Subscriber_1.Subscriber));
//# sourceMappingURL=map.js.map

            /***/ }),
        /* 67 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            function refCount() {
                return function refCountOperatorFunction(source) {
                    return source.lift(new RefCountOperator(source));
                };
            }
            exports.refCount = refCount;
            var RefCountOperator = (function () {
                function RefCountOperator(connectable) {
                    this.connectable = connectable;
                }
                RefCountOperator.prototype.call = function (subscriber, source) {
                    var connectable = this.connectable;
                    connectable._refCount++;
                    var refCounter = new RefCountSubscriber(subscriber, connectable);
                    var subscription = source.subscribe(refCounter);
                    if (!refCounter.closed) {
                        refCounter.connection = connectable.connect();
                    }
                    return subscription;
                };
                return RefCountOperator;
            }());
            var RefCountSubscriber = (function (_super) {
                __extends(RefCountSubscriber, _super);
                function RefCountSubscriber(destination, connectable) {
                    _super.call(this, destination);
                    this.connectable = connectable;
                }
                RefCountSubscriber.prototype._unsubscribe = function () {
                    var connectable = this.connectable;
                    if (!connectable) {
                        this.connection = null;
                        return;
                    }
                    this.connectable = null;
                    var refCount = connectable._refCount;
                    if (refCount <= 0) {
                        this.connection = null;
                        return;
                    }
                    connectable._refCount = refCount - 1;
                    if (refCount > 1) {
                        this.connection = null;
                        return;
                    }
                    ///
                    // Compare the local RefCountSubscriber's connection Subscription to the
                    // connection Subscription on the shared ConnectableObservable. In cases
                    // where the ConnectableObservable source synchronously emits values, and
                    // the RefCountSubscriber's downstream Observers synchronously unsubscribe,
                    // execution continues to here before the RefCountOperator has a chance to
                    // supply the RefCountSubscriber with the shared connection Subscription.
                    // For example:
                    // ```
                    // Observable.range(0, 10)
                    //   .publish()
                    //   .refCount()
                    //   .take(5)
                    //   .subscribe();
                    // ```
                    // In order to account for this case, RefCountSubscriber should only dispose
                    // the ConnectableObservable's shared connection Subscription if the
                    // connection Subscription exists, *and* either:
                    //   a. RefCountSubscriber doesn't have a reference to the shared connection
                    //      Subscription yet, or,
                    //   b. RefCountSubscriber's connection Subscription reference is identical
                    //      to the shared connection Subscription
                    ///
                    var connection = this.connection;
                    var sharedConnection = connectable._connection;
                    this.connection = null;
                    if (sharedConnection && (!connection || sharedConnection === connection)) {
                        sharedConnection.unsubscribe();
                    }
                };
                return RefCountSubscriber;
            }(Subscriber_1.Subscriber));
//# sourceMappingURL=refCount.js.map

            /***/ }),
        /* 68 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";


            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            exports.JQUERY_FEATURE_TESTS = undefined;

            var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

            __webpack_require__(45);

            var _jquery = __webpack_require__(53);

            var _jquery2 = _interopRequireDefault(_jquery);

            var _defineJqueryComponent = __webpack_require__(90);

            var _symbols = __webpack_require__(18);

            var _common = __webpack_require__(57);

            var _mixin = __webpack_require__(103);

            __webpack_require__(178);

            function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

            function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

            function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

            function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

            function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } // # src / jquery / index.js
// Copyright (c) 2017 Florian Klampfer <https://qwtel.com/>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// eslint-disable-line import/no-extraneous-dependencies

            var JQUERY_FEATURE_TESTS = exports.JQUERY_FEATURE_TESTS = new _common.Set([].concat(_toConsumableArray(_mixin.MIXIN_FEATURE_TESTS)));
            JQUERY_FEATURE_TESTS.delete('customevent');

            (0, _defineJqueryComponent.defineJQueryComponent)('hy.drawer', function (_drawerMixin) {
                _inherits(_class, _drawerMixin);

                function _class() {
                    _classCallCheck(this, _class);

                    return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
                }

                _createClass(_class, [{
                    key: _symbols.sSetupDOM,
                    value: function value($el) {
                        var children = $el.children().detach();

                        $el.append((0, _jquery2.default)('<div class="hy-drawer-scrim" />')).append((0, _jquery2.default)('<div class="hy-drawer-content" />').append(children));

                        return $el;
                    }
                }]);

                return _class;
            }((0, _mixin.drawerMixin)(_defineJqueryComponent.JQueryComponent)));

            /***/ }),
        /* 69 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var $at = __webpack_require__(70)(true);

// 21.1.3.27 String.prototype[@@iterator]()
            __webpack_require__(71)(String, 'String', function (iterated) {
                this._t = String(iterated); // target
                this._i = 0;                // next index
// 21.1.5.2.1 %StringIteratorPrototype%.next()
            }, function () {
                var O = this._t;
                var index = this._i;
                var point;
                if (index >= O.length) return { value: undefined, done: true };
                point = $at(O, index);
                this._i += point.length;
                return { value: point, done: false };
            });


            /***/ }),
        /* 70 */
        /***/ (function(module, exports, __webpack_require__) {

            var toInteger = __webpack_require__(27);
            var defined = __webpack_require__(28);
// true  -> String#at
// false -> String#codePointAt
            module.exports = function (TO_STRING) {
                return function (that, pos) {
                    var s = String(defined(that));
                    var i = toInteger(pos);
                    var l = s.length;
                    var a, b;
                    if (i < 0 || i >= l) return TO_STRING ? '' : undefined;
                    a = s.charCodeAt(i);
                    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
                        ? TO_STRING ? s.charAt(i) : a
                        : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
                };
            };


            /***/ }),
        /* 71 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var LIBRARY = __webpack_require__(72);
            var $export = __webpack_require__(7);
            var redefine = __webpack_require__(47);
            var hide = __webpack_require__(20);
            var has = __webpack_require__(15);
            var Iterators = __webpack_require__(32);
            var $iterCreate = __webpack_require__(75);
            var setToStringTag = __webpack_require__(52);
            var getPrototypeOf = __webpack_require__(82);
            var ITERATOR = __webpack_require__(3)('iterator');
            var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
            var FF_ITERATOR = '@@iterator';
            var KEYS = 'keys';
            var VALUES = 'values';

            var returnThis = function () { return this; };

            module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
                $iterCreate(Constructor, NAME, next);
                var getMethod = function (kind) {
                    if (!BUGGY && kind in proto) return proto[kind];
                    switch (kind) {
                        case KEYS: return function keys() { return new Constructor(this, kind); };
                        case VALUES: return function values() { return new Constructor(this, kind); };
                    } return function entries() { return new Constructor(this, kind); };
                };
                var TAG = NAME + ' Iterator';
                var DEF_VALUES = DEFAULT == VALUES;
                var VALUES_BUG = false;
                var proto = Base.prototype;
                var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
                var $default = $native || getMethod(DEFAULT);
                var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
                var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
                var methods, key, IteratorPrototype;
                // Fix native
                if ($anyNative) {
                    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
                    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
                        // Set @@toStringTag to native iterators
                        setToStringTag(IteratorPrototype, TAG, true);
                        // fix for some old engines
                        if (!LIBRARY && !has(IteratorPrototype, ITERATOR)) hide(IteratorPrototype, ITERATOR, returnThis);
                    }
                }
                // fix Array#{values, @@iterator}.name in V8 / FF
                if (DEF_VALUES && $native && $native.name !== VALUES) {
                    VALUES_BUG = true;
                    $default = function values() { return $native.call(this); };
                }
                // Define iterator
                if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
                    hide(proto, ITERATOR, $default);
                }
                // Plug for library
                Iterators[NAME] = $default;
                Iterators[TAG] = returnThis;
                if (DEFAULT) {
                    methods = {
                        values: DEF_VALUES ? $default : getMethod(VALUES),
                        keys: IS_SET ? $default : getMethod(KEYS),
                        entries: $entries
                    };
                    if (FORCED) for (key in methods) {
                        if (!(key in proto)) redefine(proto, key, methods[key]);
                    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
                }
                return methods;
            };


            /***/ }),
        /* 72 */
        /***/ (function(module, exports) {

            module.exports = false;


            /***/ }),
        /* 73 */
        /***/ (function(module, exports, __webpack_require__) {

            module.exports = !__webpack_require__(13) && !__webpack_require__(14)(function () {
                return Object.defineProperty(__webpack_require__(46)('div'), 'a', { get: function () { return 7; } }).a != 7;
            });


            /***/ }),
        /* 74 */
        /***/ (function(module, exports, __webpack_require__) {

// 7.1.1 ToPrimitive(input [, PreferredType])
            var isObject = __webpack_require__(12);
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
            module.exports = function (it, S) {
                if (!isObject(it)) return it;
                var fn, val;
                if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
                if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
                if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
                throw TypeError("Can't convert object to primitive value");
            };


            /***/ }),
        /* 75 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var create = __webpack_require__(76);
            var descriptor = __webpack_require__(29);
            var setToStringTag = __webpack_require__(52);
            var IteratorPrototype = {};

// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
            __webpack_require__(20)(IteratorPrototype, __webpack_require__(3)('iterator'), function () { return this; });

            module.exports = function (Constructor, NAME, next) {
                Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });
                setToStringTag(Constructor, NAME + ' Iterator');
            };


            /***/ }),
        /* 76 */
        /***/ (function(module, exports, __webpack_require__) {

// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
            var anObject = __webpack_require__(21);
            var dPs = __webpack_require__(77);
            var enumBugKeys = __webpack_require__(51);
            var IE_PROTO = __webpack_require__(37)('IE_PROTO');
            var Empty = function () { /* empty */ };
            var PROTOTYPE = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
            var createDict = function () {
                // Thrash, waste and sodomy: IE GC bug
                var iframe = __webpack_require__(46)('iframe');
                var i = enumBugKeys.length;
                var lt = '<';
                var gt = '>';
                var iframeDocument;
                iframe.style.display = 'none';
                __webpack_require__(81).appendChild(iframe);
                iframe.src = 'javascript:'; // eslint-disable-line no-script-url
                // createDict = iframe.contentWindow.Object;
                // html.removeChild(iframe);
                iframeDocument = iframe.contentWindow.document;
                iframeDocument.open();
                iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
                iframeDocument.close();
                createDict = iframeDocument.F;
                while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
                return createDict();
            };

            module.exports = Object.create || function create(O, Properties) {
                var result;
                if (O !== null) {
                    Empty[PROTOTYPE] = anObject(O);
                    result = new Empty();
                    Empty[PROTOTYPE] = null;
                    // add "__proto__" for Object.getPrototypeOf polyfill
                    result[IE_PROTO] = O;
                } else result = createDict();
                return Properties === undefined ? result : dPs(result, Properties);
            };


            /***/ }),
        /* 77 */
        /***/ (function(module, exports, __webpack_require__) {

            var dP = __webpack_require__(11);
            var anObject = __webpack_require__(21);
            var getKeys = __webpack_require__(33);

            module.exports = __webpack_require__(13) ? Object.defineProperties : function defineProperties(O, Properties) {
                anObject(O);
                var keys = getKeys(Properties);
                var length = keys.length;
                var i = 0;
                var P;
                while (length > i) dP.f(O, P = keys[i++], Properties[P]);
                return O;
            };


            /***/ }),
        /* 78 */
        /***/ (function(module, exports, __webpack_require__) {

            var has = __webpack_require__(15);
            var toIObject = __webpack_require__(49);
            var arrayIndexOf = __webpack_require__(79)(false);
            var IE_PROTO = __webpack_require__(37)('IE_PROTO');

            module.exports = function (object, names) {
                var O = toIObject(object);
                var i = 0;
                var result = [];
                var key;
                for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
                // Don't enum bug & hidden keys
                while (names.length > i) if (has(O, key = names[i++])) {
                    ~arrayIndexOf(result, key) || result.push(key);
                }
                return result;
            };


            /***/ }),
        /* 79 */
        /***/ (function(module, exports, __webpack_require__) {

// false -> Array#indexOf
// true  -> Array#includes
            var toIObject = __webpack_require__(49);
            var toLength = __webpack_require__(36);
            var toAbsoluteIndex = __webpack_require__(80);
            module.exports = function (IS_INCLUDES) {
                return function ($this, el, fromIndex) {
                    var O = toIObject($this);
                    var length = toLength(O.length);
                    var index = toAbsoluteIndex(fromIndex, length);
                    var value;
                    // Array#includes uses SameValueZero equality algorithm
                    // eslint-disable-next-line no-self-compare
                    if (IS_INCLUDES && el != el) while (length > index) {
                        value = O[index++];
                        // eslint-disable-next-line no-self-compare
                        if (value != value) return true;
                        // Array#indexOf ignores holes, Array#includes - not
                    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
                        if (O[index] === el) return IS_INCLUDES || index || 0;
                    } return !IS_INCLUDES && -1;
                };
            };


            /***/ }),
        /* 80 */
        /***/ (function(module, exports, __webpack_require__) {

            var toInteger = __webpack_require__(27);
            var max = Math.max;
            var min = Math.min;
            module.exports = function (index, length) {
                index = toInteger(index);
                return index < 0 ? max(index + length, 0) : min(index, length);
            };


            /***/ }),
        /* 81 */
        /***/ (function(module, exports, __webpack_require__) {

            var document = __webpack_require__(8).document;
            module.exports = document && document.documentElement;


            /***/ }),
        /* 82 */
        /***/ (function(module, exports, __webpack_require__) {

// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
            var has = __webpack_require__(15);
            var toObject = __webpack_require__(16);
            var IE_PROTO = __webpack_require__(37)('IE_PROTO');
            var ObjectProto = Object.prototype;

            module.exports = Object.getPrototypeOf || function (O) {
                O = toObject(O);
                if (has(O, IE_PROTO)) return O[IE_PROTO];
                if (typeof O.constructor == 'function' && O instanceof O.constructor) {
                    return O.constructor.prototype;
                } return O instanceof Object ? ObjectProto : null;
            };


            /***/ }),
        /* 83 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var ctx = __webpack_require__(31);
            var $export = __webpack_require__(7);
            var toObject = __webpack_require__(16);
            var call = __webpack_require__(84);
            var isArrayIter = __webpack_require__(85);
            var toLength = __webpack_require__(36);
            var createProperty = __webpack_require__(86);
            var getIterFn = __webpack_require__(87);

            $export($export.S + $export.F * !__webpack_require__(89)(function (iter) { Array.from(iter); }), 'Array', {
                // 22.1.2.1 Array.from(arrayLike, mapfn = undefined, thisArg = undefined)
                from: function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
                    var O = toObject(arrayLike);
                    var C = typeof this == 'function' ? this : Array;
                    var aLen = arguments.length;
                    var mapfn = aLen > 1 ? arguments[1] : undefined;
                    var mapping = mapfn !== undefined;
                    var index = 0;
                    var iterFn = getIterFn(O);
                    var length, result, step, iterator;
                    if (mapping) mapfn = ctx(mapfn, aLen > 2 ? arguments[2] : undefined, 2);
                    // if object isn't iterable or it's array with default iterator - use simple case
                    if (iterFn != undefined && !(C == Array && isArrayIter(iterFn))) {
                        for (iterator = iterFn.call(O), result = new C(); !(step = iterator.next()).done; index++) {
                            createProperty(result, index, mapping ? call(iterator, mapfn, [step.value, index], true) : step.value);
                        }
                    } else {
                        length = toLength(O.length);
                        for (result = new C(length); length > index; index++) {
                            createProperty(result, index, mapping ? mapfn(O[index], index) : O[index]);
                        }
                    }
                    result.length = index;
                    return result;
                }
            });


            /***/ }),
        /* 84 */
        /***/ (function(module, exports, __webpack_require__) {

// call something on iterator step with safe closing on error
            var anObject = __webpack_require__(21);
            module.exports = function (iterator, fn, value, entries) {
                try {
                    return entries ? fn(anObject(value)[0], value[1]) : fn(value);
                    // 7.4.6 IteratorClose(iterator, completion)
                } catch (e) {
                    var ret = iterator['return'];
                    if (ret !== undefined) anObject(ret.call(iterator));
                    throw e;
                }
            };


            /***/ }),
        /* 85 */
        /***/ (function(module, exports, __webpack_require__) {

// check on default Array iterator
            var Iterators = __webpack_require__(32);
            var ITERATOR = __webpack_require__(3)('iterator');
            var ArrayProto = Array.prototype;

            module.exports = function (it) {
                return it !== undefined && (Iterators.Array === it || ArrayProto[ITERATOR] === it);
            };


            /***/ }),
        /* 86 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var $defineProperty = __webpack_require__(11);
            var createDesc = __webpack_require__(29);

            module.exports = function (object, index, value) {
                if (index in object) $defineProperty.f(object, index, createDesc(0, value));
                else object[index] = value;
            };


            /***/ }),
        /* 87 */
        /***/ (function(module, exports, __webpack_require__) {

            var classof = __webpack_require__(88);
            var ITERATOR = __webpack_require__(3)('iterator');
            var Iterators = __webpack_require__(32);
            module.exports = __webpack_require__(2).getIteratorMethod = function (it) {
                if (it != undefined) return it[ITERATOR]
                    || it['@@iterator']
                    || Iterators[classof(it)];
            };


            /***/ }),
        /* 88 */
        /***/ (function(module, exports, __webpack_require__) {

// getting tag from 19.1.3.6 Object.prototype.toString()
            var cof = __webpack_require__(35);
            var TAG = __webpack_require__(3)('toStringTag');
// ES3 wrong here
            var ARG = cof(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
            var tryGet = function (it, key) {
                try {
                    return it[key];
                } catch (e) { /* empty */ }
            };

            module.exports = function (it) {
                var O, T, B;
                return it === undefined ? 'Undefined' : it === null ? 'Null'
                    // @@toStringTag case
                    : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T
                        // builtinTag case
                        : ARG ? cof(O)
                            // ES3 arguments fallback
                            : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
            };


            /***/ }),
        /* 89 */
        /***/ (function(module, exports, __webpack_require__) {

            var ITERATOR = __webpack_require__(3)('iterator');
            var SAFE_CLOSING = false;

            try {
                var riter = [7][ITERATOR]();
                riter['return'] = function () { SAFE_CLOSING = true; };
                // eslint-disable-next-line no-throw-literal
                Array.from(riter, function () { throw 2; });
            } catch (e) { /* empty */ }

            module.exports = function (exec, skipClosing) {
                if (!skipClosing && !SAFE_CLOSING) return false;
                var safe = false;
                try {
                    var arr = [7];
                    var iter = arr[ITERATOR]();
                    iter.next = function () { return { done: safe = true }; };
                    arr[ITERATOR] = function () { return iter; };
                    exec(arr);
                } catch (e) { /* empty */ }
                return safe;
            };


            /***/ }),
        /* 90 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";


            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            exports.JQueryComponent = exports.sSetupDOM = exports.sSetup = undefined;

            var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

            var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

            var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

            exports.defineJQueryComponent = defineJQueryComponent;

            __webpack_require__(54);

            __webpack_require__(55);

            var _jquery = __webpack_require__(53);

            var _jquery2 = _interopRequireDefault(_jquery);

            var _common = __webpack_require__(38);

            var _symbols = __webpack_require__(18);

            var _vanilla = __webpack_require__(99);

            function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

            function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

            function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

            function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // # src / define-jquery-compnent.js
// Copyright (c) 2017 Florian Klampfer <https://qwtel.com/>
// Licensed under MIT

// jQuery predates arrow functions and makes use of binding a functions's `this`,
// so that passing arrow functions results in errors in many cases.
// We modify eslint to allow passing anonymous `function`s:
            /* eslint-disable func-names, consistent-return */

// jQuery is an optional dependency
// eslint-disable-line import/no-extraneous-dependencies

            exports.sSetup = _symbols.sSetup;
            exports.sSetupDOM = _symbols.sSetupDOM;
            var JQueryComponent = exports.JQueryComponent = _vanilla.VanillaComponent;

            function defineJQueryComponent(name, Component) {
                var ns = name.toLowerCase();

                var Constructor = function (_Component) {
                    _inherits(Constructor, _Component);

                    function Constructor() {
                        _classCallCheck(this, Constructor);

                        return _possibleConstructorReturn(this, (Constructor.__proto__ || Object.getPrototypeOf(Constructor)).apply(this, arguments));
                    }

                    _createClass(Constructor, [{
                        key: _symbols.sSetupDOM,
                        value: function value(el) {
                            this.$element = _get(Constructor.prototype.__proto__ || Object.getPrototypeOf(Constructor.prototype), _symbols.sSetupDOM, this).call(this, (0, _jquery2.default)(el));
                            return this.$element[0];
                        }
                    }, {
                        key: _symbols.sFire,
                        value: function value(eventName, data) {
                            var event = _jquery2.default.Event(eventName + '.' + ns, data);
                            this.$element.trigger(event);
                        }
                    }]);

                    return Constructor;
                }(Component);

                function plugin(option, arg) {
                    for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
                        args[_key - 2] = arguments[_key];
                    }

                    var key = typeof option === 'string' ? option : null;

                    return this.each(function () {
                        var $this = (0, _jquery2.default)(this);
                        var data = $this.data(ns);

                        if (!data) {
                            var defaults = Component.defaults,
                                types = Component.types;

                            var dataProps = $this.data();

                            Object.keys(defaults).forEach(function (dft) {
                                if (dataProps[dft]) {
                                    dataProps[dft] = (0, _common.simpleType)(types[dft], defaults[dft], dataProps[dft]);
                                }
                            });
                            var props = _jquery2.default.extend({}, dataProps, (typeof option === 'undefined' ? 'undefined' : _typeof(option)) === 'object' && option);

                            $this.data(ns, new Constructor(this, props));
                        } else if (key && typeof data[key] === 'function') {
                            data[key].apply(data, [arg].concat(args));
                        } else if ((typeof option === 'undefined' ? 'undefined' : _typeof(option)) === 'object' && option) {
                            _jquery2.default.extend(data, option);
                        }
                    });
                }

                var fName = ns.split('.').pop();

                var old = _jquery2.default.fn[fName];

                _jquery2.default.fn[fName] = plugin;
                _jquery2.default.fn[fName].Constructor = Constructor;

                _jquery2.default.fn[fName].noConflict = function () {
                    _jquery2.default.fn[fName] = old;
                    return this;
                };
            }

            /***/ }),
        /* 91 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var $export = __webpack_require__(7);
            var $forEach = __webpack_require__(92)(0);
            var STRICT = __webpack_require__(96)([].forEach, true);

            $export($export.P + $export.F * !STRICT, 'Array', {
                // 22.1.3.10 / 15.4.4.18 Array.prototype.forEach(callbackfn [, thisArg])
                forEach: function forEach(callbackfn /* , thisArg */) {
                    return $forEach(this, callbackfn, arguments[1]);
                }
            });


            /***/ }),
        /* 92 */
        /***/ (function(module, exports, __webpack_require__) {

// 0 -> Array#forEach
// 1 -> Array#map
// 2 -> Array#filter
// 3 -> Array#some
// 4 -> Array#every
// 5 -> Array#find
// 6 -> Array#findIndex
            var ctx = __webpack_require__(31);
            var IObject = __webpack_require__(34);
            var toObject = __webpack_require__(16);
            var toLength = __webpack_require__(36);
            var asc = __webpack_require__(93);
            module.exports = function (TYPE, $create) {
                var IS_MAP = TYPE == 1;
                var IS_FILTER = TYPE == 2;
                var IS_SOME = TYPE == 3;
                var IS_EVERY = TYPE == 4;
                var IS_FIND_INDEX = TYPE == 6;
                var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
                var create = $create || asc;
                return function ($this, callbackfn, that) {
                    var O = toObject($this);
                    var self = IObject(O);
                    var f = ctx(callbackfn, that, 3);
                    var length = toLength(self.length);
                    var index = 0;
                    var result = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
                    var val, res;
                    for (;length > index; index++) if (NO_HOLES || index in self) {
                        val = self[index];
                        res = f(val, index, O);
                        if (TYPE) {
                            if (IS_MAP) result[index] = res;   // map
                            else if (res) switch (TYPE) {
                                case 3: return true;             // some
                                case 5: return val;              // find
                                case 6: return index;            // findIndex
                                case 2: result.push(val);        // filter
                            } else if (IS_EVERY) return false; // every
                        }
                    }
                    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;
                };
            };


            /***/ }),
        /* 93 */
        /***/ (function(module, exports, __webpack_require__) {

// 9.4.2.3 ArraySpeciesCreate(originalArray, length)
            var speciesConstructor = __webpack_require__(94);

            module.exports = function (original, length) {
                return new (speciesConstructor(original))(length);
            };


            /***/ }),
        /* 94 */
        /***/ (function(module, exports, __webpack_require__) {

            var isObject = __webpack_require__(12);
            var isArray = __webpack_require__(95);
            var SPECIES = __webpack_require__(3)('species');

            module.exports = function (original) {
                var C;
                if (isArray(original)) {
                    C = original.constructor;
                    // cross-realm fallback
                    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;
                    if (isObject(C)) {
                        C = C[SPECIES];
                        if (C === null) C = undefined;
                    }
                } return C === undefined ? Array : C;
            };


            /***/ }),
        /* 95 */
        /***/ (function(module, exports, __webpack_require__) {

// 7.2.2 IsArray(argument)
            var cof = __webpack_require__(35);
            module.exports = Array.isArray || function isArray(arg) {
                return cof(arg) == 'Array';
            };


            /***/ }),
        /* 96 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var fails = __webpack_require__(14);

            module.exports = function (method, arg) {
                return !!method && fails(function () {
                    // eslint-disable-next-line no-useless-call
                    arg ? method.call(null, function () { /* empty */ }, 1) : method.call(null);
                });
            };


            /***/ }),
        /* 97 */
        /***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 Object.keys(O)
            var toObject = __webpack_require__(16);
            var $keys = __webpack_require__(33);

            __webpack_require__(98)('keys', function () {
                return function keys(it) {
                    return $keys(toObject(it));
                };
            });


            /***/ }),
        /* 98 */
        /***/ (function(module, exports, __webpack_require__) {

// most Object methods by ES6 should accept primitives
            var $export = __webpack_require__(7);
            var core = __webpack_require__(2);
            var fails = __webpack_require__(14);
            module.exports = function (KEY, exec) {
                var fn = (core.Object || {})[KEY] || Object[KEY];
                var exp = {};
                exp[KEY] = exec(fn);
                $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
            };


            /***/ }),
        /* 99 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";


            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            exports.sSetupDOM = exports.sSetup = exports.VanillaComponent = undefined;

            var _symbols = __webpack_require__(18);

            function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } // # src / vanilla.js
// Copyright (c) 2017 Florian Klampfer <https://qwtel.com/>
// Licensed under MIT

            var VanillaComponent = exports.VanillaComponent = function VanillaComponent(el, props) {
                _classCallCheck(this, VanillaComponent);

                this[_symbols.sSetup](el, props);
            };

            exports.sSetup = _symbols.sSetup;
            exports.sSetupDOM = _symbols.sSetupDOM;

            /***/ }),
        /* 100 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var Subscriber_1 = __webpack_require__(1);
            var rxSubscriber_1 = __webpack_require__(41);
            var Observer_1 = __webpack_require__(59);
            function toSubscriber(nextOrObserver, error, complete) {
                if (nextOrObserver) {
                    if (nextOrObserver instanceof Subscriber_1.Subscriber) {
                        return nextOrObserver;
                    }
                    if (nextOrObserver[rxSubscriber_1.rxSubscriber]) {
                        return nextOrObserver[rxSubscriber_1.rxSubscriber]();
                    }
                }
                if (!nextOrObserver && !error && !complete) {
                    return new Subscriber_1.Subscriber(Observer_1.empty);
                }
                return new Subscriber_1.Subscriber(nextOrObserver, error, complete);
            }
            exports.toSubscriber = toSubscriber;
//# sourceMappingURL=toSubscriber.js.map

            /***/ }),
        /* 101 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            /**
             * An error thrown when one or more errors have occurred during the
             * `unsubscribe` of a {@link Subscription}.
             */
            var UnsubscriptionError = (function (_super) {
                __extends(UnsubscriptionError, _super);
                function UnsubscriptionError(errors) {
                    _super.call(this);
                    this.errors = errors;
                    var err = Error.call(this, errors ?
                        errors.length + " errors occurred during unsubscription:\n  " + errors.map(function (err, i) { return ((i + 1) + ") " + err.toString()); }).join('\n  ') : '');
                    this.name = err.name = 'UnsubscriptionError';
                    this.stack = err.stack;
                    this.message = err.message;
                }
                return UnsubscriptionError;
            }(Error));
            exports.UnsubscriptionError = UnsubscriptionError;
//# sourceMappingURL=UnsubscriptionError.js.map

            /***/ }),
        /* 102 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var noop_1 = __webpack_require__(60);
            /* tslint:enable:max-line-length */
            function pipe() {
                var fns = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    fns[_i - 0] = arguments[_i];
                }
                return pipeFromArray(fns);
            }
            exports.pipe = pipe;
            /* @internal */
            function pipeFromArray(fns) {
                if (!fns) {
                    return noop_1.noop;
                }
                if (fns.length === 1) {
                    return fns[0];
                }
                return function piped(input) {
                    return fns.reduce(function (prev, fn) { return fn(prev); }, input);
                };
            }
            exports.pipeFromArray = pipeFromArray;
//# sourceMappingURL=pipe.js.map

            /***/ }),
        /* 103 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";
            /* WEBPACK VAR INJECTION */(function(global) {

                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.sSetupDOM = exports.sSetup = exports.MIXIN_FEATURE_TESTS = undefined;

                var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

                var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

                var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

                exports.drawerMixin = drawerMixin;

                __webpack_require__(45);

                __webpack_require__(104);

                __webpack_require__(61);

                var _component = __webpack_require__(112);

                var _symbols = __webpack_require__(18);

                var _types = __webpack_require__(56);

                var _Observable = __webpack_require__(0);

                var _Subject = __webpack_require__(24);

                var _combineLatest = __webpack_require__(117);

                var _defer = __webpack_require__(120);

                var _fromEvent = __webpack_require__(122);

                var _merge = __webpack_require__(124);

                var _never = __webpack_require__(128);

                var _do = __webpack_require__(130);

                var _debounceTime = __webpack_require__(132);

                var _filter = __webpack_require__(138);

                var _map = __webpack_require__(140);

                var _mapTo = __webpack_require__(141);

                var _pairwise = __webpack_require__(143);

                var _repeatWhen = __webpack_require__(145);

                var _sample = __webpack_require__(147);

                var _share = __webpack_require__(149);

                var _skipWhile = __webpack_require__(153);

                var _startWith = __webpack_require__(155);

                var _switchMap = __webpack_require__(167);

                var _take = __webpack_require__(169);

                var _takeUntil = __webpack_require__(172);

                var _timestamp = __webpack_require__(174);

                var _withLatestFrom = __webpack_require__(176);

                var _common = __webpack_require__(57);

                function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

                function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

                function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

                function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

                function _toArray(arr) { return Array.isArray(arr) ? arr : Array.from(arr); }

                function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } // # src / mixin / index.js
// Copyright (c) 2017 Florian Klampfer <https://qwtel.com/>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// ## Overview
// This component is written in [RxJS] and reading its code requires some basic understanding
// of how RxJS works. It may also serve as an example of how to use RxJS (or how not to use it...).
//
// Other than RxJS, you should be familiar with the (non-standard) function-bind syntax `::`,
// which is extremely helpful with using RxJS operators *as if* they were class methods,
// as well as writing private functions for our mixin.
//
// Finally, the export is a [ES6 Mixin][esmixins],
// which is a clever way of using the ES6 class syntax to achieve inheritance-based mixins.
//
// ## Table of Contents
// {:.no_toc}
// * Table of Contents
// {:toc}

// ## Imports
// ES6+ functions that we use.


// Importing the hy-compontent base libary,
// which helps with making multiple versions of the component (Vanilla JS, WebComponent, etc...).


// As mentioned before, we only import the RxJS function that we need.


// Some helper functions to create observable tweens. See [src / common.js](../common.md).


// ## Constants
// A set of [Modernizr] tests that are required for this component to work.
                var MIXIN_FEATURE_TESTS = exports.MIXIN_FEATURE_TESTS = new _common.Set([].concat(_toConsumableArray(_component.COMPONENT_FEATURE_TESTS), ['eventlistener', 'queryselector', 'requestanimationframe', 'classlist', 'opacity', 'csstransforms', 'csspointerevents']));

// We export the setup symbols,
// so that mixin users don't have to import them from hy-compnent separately.
                exports.sSetup = _symbols.sSetup;
                exports.sSetupDOM = _symbols.sSetupDOM;

// The duration (in ms) of the animation when releasing the drawer.

                var TRANSITION_DURATION = 200;

// Minimum velocity of the drawer (in px/ms) when releasing to make it fling to opened/closed state.
                var VELOCITY_THRESHOLD = 0.15;

// If `Symbol` isn't supported, just use underscore naming convention for private properties.
                var _Symbol = global.Symbol || function (x) {
                    return '_' + x;
                };

// We use `Symbol`s for all internal variables, to avoid naming conflicts when using the mixin.
// Instead of using UPPERCASE names for symbols, which makes the code too verbose,
// we prefix every symbol with the letter 's'.
                var sOpened$ = _Symbol('openedObservable');
                var sAlign$ = _Symbol('alignObservable');
                var sPersitent$ = _Symbol('persistentObservable');
                var sPreventDefault$ = _Symbol('preventDefaultObservable');
                var sMouseEvents$ = _Symbol('mouseEventsObservable');
                var sBackButton$ = _Symbol('backButtonObservable');
                var sAnimateTo$ = _Symbol('animateToObservable');
                var sDrawerWidth = _Symbol('drawerWidth');
                var sScrimEl = _Symbol('scrimElement');
                var sContentEl = _Symbol('contentElement');
                var sScrollEl = _Symbol('scrollElement');

// Using shorthands for common functions
                var assign = Object.assign.bind(Object);
                var abs = Math.abs.bind(Math);
                var min = Math.min.bind(Math);
                var max = Math.max.bind(Math);

// ## Fuctions
// ### Observable extensions
// #### Filter when
// This operator is like `filter`, but it takes an observable of booleans as input,
// instead of a predicate function.
                function filterWhen(p$) {
                    for (var _len = arguments.length, others = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                        others[_key - 1] = arguments[_key];
                    }

                    if (true && !p$) throw Error();else if (others.length === 0) {
                        var _context;

                        return (_context = (_context =

                            // Finally, we take the start position of the finger, the start position of the drawer,
                            // and the current position of the finger to calculate the next `translateX` value.

                            // By using `switchMap` we ensure that subsequent events that trigger an animation
                            // don't cause more than one animation to be played at a time.
                            _withLatestFrom.withLatestFrom.call(this, p$),
                            // Since we are at the mercy of the browser firing move events,
                            // we make sure that some time has passed since the last move event.
                            _filter.filter).call(_context, function (_ref) {
                            var _ref2 = _slicedToArray(_ref, 2),
                                p = _ref2[1];

                            return p;
                        }),
                            /* TODO: drawerWdith could be outdated */

                            // Now we are save to calculate the current velocity without divide by zero errors.
                            _map.map).call(_context, function (_ref3) {
                            var _ref4 = _slicedToArray(_ref3, 1),
                                x = _ref4[0];

                            return x;
                        });

                        // When providing more than one observable, the result observable will only emit values
                        // when `every` input observable has emitted a truthy value.
                    } else {
                        var _context2;

                        return (_context2 = (_context2 = _withLatestFrom.withLatestFrom.call.apply(_withLatestFrom.withLatestFrom, [this, p$].concat(others)), _filter.filter).call(_context2, function (_ref5) {
                            var _ref6 = _toArray(_ref5),
                                ps = _ref6.slice(1);

                            return ps.every(function (p) {
                                return p;
                            });
                        }), _map.map).call(_context2, function (_ref7) {
                            var _ref8 = _slicedToArray(_ref7, 1),
                                x = _ref8[0];

                            return x;
                        });
                    }
                }

// #### Subscribe when
// This operator is like `filterWhen`, but it will unsubscribe from the source observable
// when the input observable emits `false`, and re-subscribe when it emits `true`.
                function subscribeWhen(p$) {
                    var _this = this;

                    if (true && !p$) throw Error();
                    return _switchMap.switchMap.call(p$, function (p) {
                        return p ? _this : _never.never.call(_Observable.Observable);
                    });
                }

// ### Private Methods
// The functions are used as "private" methods on the mixin, using the `::` syntax.

// #### Is in range?
// Given a x-coordinate, `isInRange` will  determine whether it is within range from where
// to pull the drawer. The x-coordinate *must* be larger than the lower bound,
// but when the drawer is opened it may be anywhere on the screen.
// Otherwise it must be below the upper bound.
                function isInRange(clientX, opened) {
                    switch (this.align) {
                        case 'left':
                            return clientX > this.range[0] && (opened || clientX < this.range[1]);
                        case 'right':
                            return clientX < window.innerWidth - this.range[0] && (opened || clientX > window.innerWidth - this.range[1]);
                        default:
                            throw Error();
                    }
                }

// #### Calculate 'Will open?'
// Based on current velocity and position of the drawer,
// should the drawer slide open, or snap back?
// TODO: could incorporate the current open state of the drawer.
                function calcWillOpen(velocity, translateX) {
                    switch (this.align) {
                        case 'left':
                        {
                            if (velocity > VELOCITY_THRESHOLD) return true;else if (velocity < -VELOCITY_THRESHOLD) return false;else if (translateX >= this[sDrawerWidth] / 2) return true;else return false;
                        }
                        case 'right':
                        {
                            if (-velocity > VELOCITY_THRESHOLD) return true;else if (-velocity < -VELOCITY_THRESHOLD) return false;else if (translateX <= -this[sDrawerWidth] / 2) return true;else return false;
                        }
                        default:
                            throw Error();
                    }
                }

// #### Calculate translate X
// Calcuate the current position of the drawer,
// by taking the difference between the current and starting postion of the finger,
// then adding that difference to the starting position of the drawer.
// This way, we avoid the drawer jumping to the finger, when "catching" it during an animation.
// The function will also clip the position at 0 and the width of the drawer.
                function calcTranslateX(clientX, startX, startTranslateX) {
                    switch (this.align) {
                        case 'left':
                        {
                            var deltaX = clientX - startX;
                            var translateX = startTranslateX + deltaX;
                            return max(0, min(this[sDrawerWidth], translateX));
                        }
                        case 'right':
                        {
                            var _deltaX = clientX - startX;
                            var _translateX = startTranslateX + _deltaX;
                            return min(0, max(-this[sDrawerWidth], _translateX));
                        }
                        default:
                            throw Error();
                    }
                }

// #### Get movable drawer width
// One feature of hy-drawer is to allow the drawer to "peek" over the edge.
// This effect is achieved by setting a smaller negative `left` (`right`) CSS property,
// than is the width of the drawer,
// The 'moveable' part of the drawer, then, is equal to that the inverse of that property.
// See [Styling](../../styling.md) for more.
                function getMovableDrawerWidth() {
                    return -parseFloat(getComputedStyle(this[sContentEl])[this.align]);
                }

// #### Prepare and cleanup interaction
// `prepareInteraction` causes various side effects before sliding the drawer.
//
// Note that the drawer receives the `hy-drawer-opened` CSS class when it is opened.
// This class makes the drawer appear open by setting the CSS `left` (`right`) property, instead
// of an absoulte `transform` value.
// This way, the drawer's width can change while it is open without having to
// recalculate `translateX` on every `resize`.
// However, it has to be removed before we move the drawer via `translateX` again.
                function prepareInteraction() {
                    this[sContentEl].style.willChange = 'transform';
                    this[sScrimEl].style.willChange = 'opacity';
                    this[sContentEl].classList.remove('hy-drawer-opened');
                }

                function histId() {
                    return this.el.id || this.constructor.componentName;
                }

// Cleanup code after a completed interaction.
// Will add/remove the beforementioned `hy-drawer-opened` class.
                function cleanupInteraction(opened) {
                    this[sScrimEl].style.willChange = '';
                    this[sContentEl].style.willChange = '';

                    if (opened) {
                        this[sScrimEl].style.pointerEvents = 'all';
                        this[sContentEl].classList.add('hy-drawer-opened');
                    } else {
                        this[sScrimEl].style.pointerEvents = '';
                        this[sContentEl].classList.remove('hy-drawer-opened');
                    }

                    // If the experimental back button feature is enabled we hack the history API,
                    // so that it matches the state of the drawer...
                    if (this._backButton) {
                        var id = histId.call(this);
                        var hash = '#' + id + '--opened';

                        if (opened && window.location.hash !== hash) {
                            window.history.pushState(_defineProperty({}, id, true), document.title, hash);
                        }

                        if (!opened && window.history.state && window.history.state[histId.call(this)] && window.location.hash !== '') {
                            window.history.back();
                        }
                    }

                    // Once we're finished cleaning up, we fire the `transitioned` event.
                    this[_symbols.sFire]('transitioned', { detail: opened });
                }

// #### Update DOM
// In the end, we only modify two properties: The x-coordinate of the drawer,
// and the opacity of the scrim, which is handled by `updateDOM`.
                function updateDOM(translateX) {
                    var inv = this.align === 'left' ? 1 : -1;
                    this[sContentEl].style.transform = 'translateX(' + translateX + 'px)';
                    this[sScrimEl].style.opacity = translateX / this[sDrawerWidth] * inv;
                }

// #### Get start observable
// The following function returns an observable of all "start" events.
// Usually, that's just `touchstart` event of the first finger touching the screen,
// however since the compontent also supports mouse events,
// we may listen for `mousedown` events.
                function getStartObservable() {
                    var _context3;

                    // Since the `mouseEvents` option may change at any point, we `switchMap` to reflect the changes.
                    return (_context3 = this[sMouseEvents$], _switchMap.switchMap).call(_context3, function (mouseEvents) {
                        var _context4;

                        // The touchstart observable is passive since we won't be calling `preventDefault`.
                        // Also, we're only interested in the first `touchstart`.
                        var touchstart$ = (_context4 = (_context4 = _fromEvent.fromEvent.call(_Observable.Observable, document, 'touchstart', { passive: true }), _filter.filter).call(_context4, function (_ref9) {
                            var touches = _ref9.touches;
                            return touches.length === 1;
                        }), _map.map).call(_context4, function (_ref10) {
                            var touches = _ref10.touches;
                            return touches[0];
                        });

                        // If mouse events aren't enabled, we're done here.
                        if (!mouseEvents) return touchstart$;

                        // Otherwise we also include `mousedown` events in the output.
                        var mousedown$ = _fromEvent.fromEvent.call(_Observable.Observable, document, 'mousedown', { passive: true });
                        return _merge.merge.call(_Observable.Observable, touchstart$, mousedown$);
                    });
                }

// #### Get move observable
// This function returns an observable of all move events. Usually that's just `touchmove`,
// but may also include `mousemove` events while the mouse button is down.
                function getMoveObservable(start$, end$) {
                    var _context5;

                    // Since the `mouseEvents` or `preventDefault` option may change at any point,
                    // we `switchMap` to reflect the changes.
                    // Nice: `combineLatest` provides us with the functionality of emitting
                    // when either of the inputs change, but not before all inputs have their first value set.
                    return (_context5 = _combineLatest.combineLatest.call(_Observable.Observable, this[sMouseEvents$], this[sPreventDefault$]), _switchMap.switchMap).call(_context5, function (_ref11) {
                        var _context6;

                        var _ref12 = _slicedToArray(_ref11, 2),
                            mouseEvents = _ref12[0],
                            preventDefault = _ref12[1];

                        // We're only keeping track of the first finger.
                        // Should the user remove the finger that started the interaction, we use the next instead.
                        // Note that this doesn't occur under normal circumstances,
                        // and exists primarliy to ensure that the interaction continues without hiccups.
                        // Note that the event listener is only passive when the `preventDefault` option is falsy.
                        var touchmove$ = (_context6 = _fromEvent.fromEvent.call(_Observable.Observable, document, 'touchmove', {
                            passive: !preventDefault
                        }), _map.map).call(_context6, function (event) {
                            return assign(event.touches[0], { event: event });
                        });

                        // If mouse events aren't enabled, we're done here.
                        if (!mouseEvents) return touchmove$;

                        // Otherwise we listen for `mousemove` events,
                        // but only those between a `start` and `end` event, i.e. while the user is sliding.
                        // We unsubscribe form the source observable outside of those contraints.
                        // Again, the listener is only marked as passive when the `preventDefault` option is falsy.
                        var mousemove$ = (_context6 = (_context6 = _fromEvent.fromEvent.call(_Observable.Observable, document, 'mousemove', {
                            passive: !preventDefault
                        }), subscribeWhen).call(_context6, _merge.merge.call(_Observable.Observable, _mapTo.mapTo.call(start$, true), _mapTo.mapTo.call(end$, false))), _map.map).call(_context6, function (event) {
                            return assign(event, { event: event });
                        });

                        return _merge.merge.call(_Observable.Observable, touchmove$, mousemove$);
                    });
                }

// #### Get end observable
// This function returns an observable of end events.
// Usually, this is the `touchend` event of the last finger, but may also include `mouseup` events,
// when the `mouseEvents` option is enabled.
                function getEndObservable() {
                    var _context7;

                    // Since the `mouseEvents` option may change at any point, we `switchMap` to reflect the changes.
                    return (_context7 = this[sMouseEvents$], _switchMap.switchMap).call(_context7, function (mouseEvents) {
                        var _context8;

                        // We're only interested in the last `touchend`.
                        // Otherwise there's at least one finger left on the screen,
                        // that can be used to slide the drawer.
                        var touchend$ = (_context8 = _fromEvent.fromEvent.call(_Observable.Observable, document, 'touchend', { passive: true }), _filter.filter).call(_context8, function (_ref13) {
                            var touches = _ref13.touches;
                            return touches.length === 0;
                        });

                        // If mouse events aren't enabled, we're done here.
                        if (!mouseEvents) return touchend$;

                        // Otherwise we include `mouseup` events.
                        var mouseup$ = _fromEvent.fromEvent.call(_Observable.Observable, document, 'mouseup', { passive: true });
                        return _merge.merge.call(_Observable.Observable, touchend$, mouseup$);
                    });
                }

// #### Get "Is sliding?" observable
// An observable that emits `true` when the user is *sliding* the drawer,
// (i.e. moving the finger along the x-axis), or `false` when *scrolling* the page
// (i.e. moving the finger along the y-axis).
                function getIsSlidingObservable(move$, start$) {
                    var _this2 = this;

                    // If the threshold options is set, we delay the decision until
                    // the finger has moved at least `threshold` pixels in either direction.
                    if (this.threshold) {
                        var _context9;

                        return (_context9 = (_context9 = _withLatestFrom.withLatestFrom.call(move$, start$), _skipWhile.skipWhile).call(_context9, function (_ref14) {
                            var _ref15 = _slicedToArray(_ref14, 2),
                                _ref15$ = _ref15[0],
                                clientX = _ref15$.clientX,
                                clientY = _ref15$.clientY,
                                _ref15$2 = _ref15[1],
                                startX = _ref15$2.clientX,
                                startY = _ref15$2.clientY;

                            return abs(startY - clientY) < _this2.threshold && abs(startX - clientX) < _this2.threshold;
                        }), _map.map).call(_context9, function (_ref16) {
                            var _ref17 = _slicedToArray(_ref16, 2),
                                _ref17$ = _ref17[0],
                                clientX = _ref17$.clientX,
                                clientY = _ref17$.clientY,
                                _ref17$2 = _ref17[1],
                                startX = _ref17$2.clientX,
                                startY = _ref17$2.clientY;

                            return abs(startX - clientX) >= abs(startY - clientY);
                        });

                        // If the threshold option is set to `0` (or `false`) we make a decision immediately.
                        // This is intended for Safari and possibly other browsers that have a built-in threshold.
                        // Additionally, Safari ignores all calls to `preventDefault`, except on the first move event
                        // after a start event, so that we *have to* make a decision immediately.
                    } else {
                        var _context10;

                        return (_context10 = _withLatestFrom.withLatestFrom.call(move$, start$), _map.map).call(_context10, function (_ref18) {
                            var _ref19 = _slicedToArray(_ref18, 2),
                                _ref19$ = _ref19[0],
                                clientX = _ref19$.clientX,
                                clientY = _ref19$.clientY,
                                event = _ref19$.event,
                                _ref19$2 = _ref19[1],
                                startX = _ref19$2.clientX,
                                startY = _ref19$2.clientY;

                            var isSliding = abs(startX - clientX) >= abs(startY - clientY);
                            if (_this2.preventDefault && isSliding) event.preventDefault();
                            return isSliding;
                        });
                    }
                }

// ### Setup observables
// This function sets up the observable "pipeline".
                function setupObservables() {
                    var _context11,
                        _this3 = this;

                    // Observables used for side effects caused by changing settings on the component.
                    // The are used to emit the new vale whenever properties get changed on the component.
                    this[sOpened$] = new _Subject.Subject();
                    this[sAlign$] = new _Subject.Subject();
                    this[sPersitent$] = new _Subject.Subject();
                    this[sPreventDefault$] = new _Subject.Subject();
                    this[sMouseEvents$] = new _Subject.Subject();
                    this[sBackButton$] = new _Subject.Subject();
                    this[sAnimateTo$] = new _Subject.Subject();

                    // Emitts a value every time you change the `persistent` property of the drawer.
                    // Interally, we invert it and call it `active`.
                    var active$ = (_context11 = (_context11 = this[sPersitent$], _map.map).call(_context11, function (x) {
                        return !x;
                    }),

                        // `share`ing the observable between many subscribers:
                        _share.share).call(_context11);

                    // We use this to get references to observables that aren't defined yet.
                    var ref = {};

                    // #### Start observable
                    // Emits a value every time a start event *could* intiate an interaction.
                    // Each emitted value is a hash containing a `clientX` and `clientY` key.
                    var start$ = (_context11 = (_context11 = getStartObservable.call(this), filterWhen).call(_context11, active$), _share.share).call(_context11);

                    // An observable that emits `true`, as long as the drawer isn't fully closed
                    // (as long as the scrim is visible the user can still "catch" the drawer).
                    // It references the yet-to-be-defined `translateX` obsevable, so we wrap it inside a `defer`.
                    var isScrimVisible$ = _defer.defer.call(_Observable.Observable, function () {
                        var _context12;

                        return (_context12 = ref.translateX$, _map.map).call(_context12, function (translateX) {
                            return _this3.align === 'left' ? translateX > 0 : translateX < _this3[sDrawerWidth];
                        });
                    });

                    // TODO: ...
                    var isInRange$ = (_context11 = (_context11 = (_context11 = _withLatestFrom.withLatestFrom.call(start$, isScrimVisible$), _map.map).call(_context11, function (_ref20) {
                        var _ref21 = _slicedToArray(_ref20, 2),
                            clientX = _ref21[0].clientX,
                            isScrimVisible = _ref21[1];

                        return isInRange.call(_this3, clientX, isScrimVisible);
                    }),

                        // When the user is sliding, fire the `slidestart` event.
                        // Experimental: Set `overflow: hidden` on some container element.

                        // Usually the cleanup code would run at the end of the fling animation,
                        // but since there is no animation in this case, we call it directly.
                        _do._do).call(_context11, function (inRange) {
                        if (inRange) prepareInteraction.call(_this3);
                    }), _share.share).call(_context11);

                    // #### End observable
                    // The observable of all relevant "end" events, i.e. the last `touchend` (or `mouseup`),
                    var end$ = (_context11 = (_context11 = getEndObservable.call(this), filterWhen).call(_context11, active$, isInRange$), _share.share).call(_context11);

                    // #### Move observable
                    // The observable of all relevant "move" events.
                    var move$ = (_context11 = (_context11 = getMoveObservable.call(this, start$, end$), filterWhen).call(_context11, active$, isInRange$), _share.share).call(_context11);

                    // #### 'Is sliding?' observable
                    // The value is `undefind` until we are ready to make a decision
                    // An observable that emits `true` when the user is *sliding* the drawer,
                    // (i.e. moving the finger along the x-axis), or `false` when *scrolling* the page
                    // (i.e. moving the finger along the y-axis), and `undefined` while we aren't sure yet.
                    //
                    // (see [`getIsSlidingObservable`](#get-is-sliding-observable)),
                    // then it remains `true`/`false` for the remainder of the interaction,
                    // and is `undefined` again once the interaction `end`s.
                    var isSliding$ = (_context11 = (_context11 = (_context11 = (_context11 = getIsSlidingObservable.call(this, move$, start$), _take.take).call(_context11, 1),
                        // The initial velocity is zero.
                        _startWith.startWith).call(_context11, undefined), _repeatWhen.repeatWhen).call(_context11, function () {
                        return end$;
                    }), _do._do).call(_context11, function (isSliding) {
                        if (isSliding) {
                            if (_this3[sScrollEl]) _this3[sScrollEl].style.overflow = 'hidden';
                            _this3[_symbols.sFire]('slidestart', { detail: _this3.opened });
                        }
                    });

                    // #### Translate X observable
                    // The `translateX` observable is the central observable of this component.
                    // It emits the current x-coordinate of the drawer, which
                    // can be modified by either of 3 incoming observables:
                    //
                    // 1. The move observable (the user's finger/mouse moving across the screen),
                    // 2. the animation/tween observable, and
                    // 3. direct modifications of the `opened` state.
                    //
                    // It is wrapped in a `defer` because it depends on previous values of itself.
                    ref.translateX$ = (_context11 = _defer.defer.call(_Observable.Observable, function () {
                        var _context13;

                        return _merge.merge.call(_Observable.Observable,
                            // 1)
                            // We only let move events modify the drawer's position when we are sure
                            // that the user is sliding. In case the `preventDefault` option is enabled,
                            // this is also when we're sure to call `preventDefault`.
                            (_context13 = (_context13 = (_context13 = filterWhen.call(move$, isSliding$), _do._do).call(_context13, function (_ref22) {
                                var event = _ref22.event;
                                if (_this3.preventDefault) event.preventDefault();
                            }), _withLatestFrom.withLatestFrom).call(_context13, start$, ref.startTranslateX$), _map.map).call(_context13, function (_ref23) {
                                var _ref24 = _slicedToArray(_ref23, 3),
                                    clientX = _ref24[0].clientX,
                                    startX = _ref24[1].clientX,
                                    startTranslateX = _ref24[2];

                                return calcTranslateX.call(_this3, clientX, startX, startTranslateX);
                            }),

                            // 2)
                            // The tween observable can be used unmodified (see below),
                            // but isn't defined yet, because it depends on previous values of `translateX$`.
                            ref.tween$,

                            // 3)
                            // When the `opened` state changes, we "jump" to the new position,
                            // which is either 0 (when closed) or the width of the drawer (when open).
                            // We also want to jump when `align` chagnes, in this case to the other side of the viewport.
                            (_context13 = (_context13 = _combineLatest.combineLatest.call(_Observable.Observable, _this3[sOpened$], _this3[sAlign$]), _do._do).call(_context13, function (_ref25) {
                                var _ref26 = _slicedToArray(_ref25, 1),
                                    opened = _ref26[0];

                                return cleanupInteraction.call(_this3, opened);
                            }), _map.map).call(_context13, function (_ref27) {
                                var _ref28 = _slicedToArray(_ref27, 2),
                                    opened = _ref28[0],
                                    align = _ref28[1];

                                return !opened ? 0 : _this3[sDrawerWidth] * (align === 'left' ? 1 : -1);
                            }));
                    }), _share.share).call(_context11);

                    // The `translateX` value at the start of an interaction.
                    // Typically this would be either 0 or `drawerWidth`, but since the user can initiate
                    // an interaction *during the animation*, it may be every value inbetween.
                    // We obtain it by sampling the translate X observable at the beginning of each interaction.
                    ref.startTranslateX$ = (_context11 = ref.translateX$, _sample.sample).call(_context11, start$);

                    // #### Tween observable
                    // For the tween animations we first need an observable that tracks
                    // the current velocity of the drawer,
                    // which we will use to determine whether the drawer should flinging in its direction,
                    // or snap back into place.
                    var velocity$ = (_context11 = (_context11 = (_context11 = (_context11 = (_context11 = ref.translateX$, _timestamp.timestamp).call(_context11), _pairwise.pairwise).call(_context11), _filter.filter).call(_context11, function (_ref29) {
                        var _ref30 = _slicedToArray(_ref29, 2),
                            prevTime = _ref30[0].timestamp,
                            time = _ref30[1].timestamp;

                        return time - prevTime > 0;
                    }), _map.map).call(_context11, function (_ref31) {
                        var _ref32 = _slicedToArray(_ref31, 2),
                            _ref32$ = _ref32[0],
                            prevX = _ref32$.value,
                            prevTime = _ref32$.timestamp,
                            _ref32$2 = _ref32[1],
                            x = _ref32$2.value,
                            time = _ref32$2.timestamp;

                        return (x - prevX) / (time - prevTime);
                    }), _startWith.startWith).call(_context11, 0);

                    // There are 2 things that can trigger an animation:
                    // 1. The end of an interaction, i.e. the user releases the finger/mouse while moving the slider.
                    // 2. A call to a method like `open` or `close` (represented by a value on the animate observable)
                    var tweenTrigger$ = _merge.merge.call(_Observable.Observable,
                        // 1) When the user releases the finger/mouse, we take the current velocity of the drawer and
                        // calculate whether it should open or close.
                        (_context11 = (_context11 = _withLatestFrom.withLatestFrom.call(end$, ref.translateX$, velocity$), _map.map).call(_context11, function (_ref33) {
                            var _ref34 = _slicedToArray(_ref33, 3),
                                translateX = _ref34[1],
                                velocity = _ref34[2];

                            return calcWillOpen.call(_this3, velocity, translateX);
                        }), _do._do).call(_context11, function (willOpen) {
                            return _this3[_symbols.sFire]('slideend', { detail: willOpen });
                        }),

                        // 2) In this case we need to call the prepare code directly,
                        // which would have been called at the beginning of the interaction otherwise.
                        (_context11 = this[sAnimateTo$], _do._do).call(_context11, prepareInteraction.bind(this)));

                    // We silently set the new `opened` state here,
                    // so that the next interaction will do the right thing even while the animation is
                    // still playing, e.g. a call to `toggle` will cancel the current animation
                    // and initiate an animation to the opposite state.
                    ref.tween$ = (_context11 = (_context11 = _do._do.call(tweenTrigger$, function (willOpen) {
                        _this3[_symbols.sSetState]('opened', willOpen);
                        if (_this3[sScrollEl] && !willOpen) _this3[sScrollEl].style.overflow = '';
                    }), _withLatestFrom.withLatestFrom).call(_context11, ref.translateX$), _switchMap.switchMap).call(_context11, function (_ref35) {
                        var _context14;

                        var _ref36 = _slicedToArray(_ref35, 2),
                            opened = _ref36[0],
                            translateX = _ref36[1];

                        // We return a tween observable that runs cleanup code when it completes
                        // --- unless a new interaction is initiated, in which case it is canceled.
                        var inv = _this3.align === 'left' ? 1 : -1;
                        var endTranslateX = opened ? _this3[sDrawerWidth] * inv : 0;
                        var diffTranslateX = endTranslateX - translateX;

                        return (_context14 = (_context14 = (_context14 = (0, _common.createTween)(_common.linearTween, translateX, diffTranslateX, TRANSITION_DURATION), _do._do).call(_context14, { complete: function complete() {
                                return _this3[sOpened$].next(opened);
                            } }), _takeUntil.takeUntil).call(_context14, start$), _takeUntil.takeUntil).call(_context14, _this3[sAlign$]);
                    });

                    // #### Subscriptions
                    // Now we are ready to cause some side effects.
                    //
                    // The end result is always to update the (shadow) DOM, which happens here.
                    // Note that the call to subscribe sets the whole process in motion,
                    // and causes the code inside the above `defer` observables to run.
                    ref.translateX$.subscribe(updateDOM.bind(this));

                    // A click on the scrim should close the drawer.
                    _fromEvent.fromEvent.call(_Observable.Observable, this[sScrimEl], 'click').subscribe(function () {
                        return _this3.close();
                    });

                    // Other than preventing sliding, setting `persistent` will also hide the scrim.
                    active$.subscribe(function (active) {
                        _this3[sScrimEl].style.display = active ? 'block' : 'none';
                    });

                    // Whenever the alignment of the drawer changes, update the CSS classes.
                    this[sAlign$].subscribe(function (align) {
                        var oldAlign = align === 'left' ? 'right' : 'left';
                        _this3[sContentEl].classList.remove('hy-drawer-' + oldAlign);
                        _this3[sContentEl].classList.add('hy-drawer-' + align);
                    });

                    // If the experimental back button feature is enabled, handle popstate events...
                    (_context11 = _fromEvent.fromEvent.call(_Observable.Observable, window, 'popstate'), subscribeWhen).call(_context11, this[sBackButton$]).subscribe(function () {
                        var hash = '#' + histId.call(_this3) + '--opened';
                        var willOpen = window.location.hash === hash;
                        if (willOpen !== _this3.opened) _this3[sAnimateTo$].next(willOpen);
                    });

                    // Now we set the initial opend state.
                    // If the experimental back button feature is enabled, we check the location hash...
                    if (this._backButton) {
                        var hash = '#' + histId.call(this) + '--opened';
                        if (window.location.hash === hash) this[_symbols.sSetState]('opened', true);
                    }

                    // Putting initial values on the side-effect--observables:
                    this[sOpened$].next(this.opened);
                    this[sAlign$].next(this.align);
                    this[sPersitent$].next(this.persistent);
                    this[sPreventDefault$].next(this.preventDefault);
                    this[sMouseEvents$].next(this.mouseEvents);
                    this[sBackButton$].next(this._backButton);
                }

// ## Drawer Mixin
                function drawerMixin(C) {
                    // TODO: see ES6 mixins...
                    return function (_componentMixin) {
                        _inherits(_class, _componentMixin);

                        function _class() {
                            _classCallCheck(this, _class);

                            return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
                        }

                        _createClass(_class, [{
                            key: _symbols.sSetup,


                            // ### Setup
                            // Overriding the setup function.
                            value: function value(el, props) {
                                var _context15,
                                    _this5 = this;

                                _get(_class.prototype.__proto__ || Object.getPrototypeOf(_class.prototype), _symbols.sSetup, this).call(this, el, props);

                                // Cache DOM elements.
                                this[sScrimEl] = this.root.querySelector('.hy-drawer-scrim');
                                this[sContentEl] = this.root.querySelector('.hy-drawer-content');
                                if (this._hideOverflow) this[sScrollEl] = document.querySelector(this._hideOverflow);

                                // Set the initial alignment class.
                                this[sContentEl].classList.add('hy-drawer-' + this.align);

                                // Measure the current drawer width...
                                this[sDrawerWidth] = getMovableDrawerWidth.call(this);

                                // ...and keep it up-to-date.
                                // Note that we need to temporarily remove the opened class to get the correct measures.
                                (_context15 = _fromEvent.fromEvent.call(_Observable.Observable, window, 'resize', { passive: true }), _debounceTime.debounceTime).call(_context15, 100).subscribe(function () {
                                    if (_this5.opened) _this5[sContentEl].classList.remove('hy-drawer-opened');
                                    _this5[sDrawerWidth] = getMovableDrawerWidth.call(_this5);
                                    if (_this5.opened) _this5[sContentEl].classList.add('hy-drawer-opened');
                                });

                                // Finally, calling the [setup observables function](#setup-observables) function.
                                setupObservables.call(this);

                                // Firing an event to let the outside world know the drawer is ready.
                                this[_symbols.sFire]('init', { detail: this.opened });

                                // Allow function chaining.
                                return this;
                            }

                            // ### Options
                            // The default values (and types) of the configuration options (required by hy-component)
                            // See [Options](../../options.md) for usage information.

                        }, {
                            key: 'open',


                            // ### Methods
                            // Public methods of this component. See [Methods](../../methods.md) for more.
                            value: function open() {
                                var animated = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

                                if (animated) this[sAnimateTo$].next(true);else this.opened = true;
                                return this;
                            }
                        }, {
                            key: 'close',
                            value: function close() {
                                var animated = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

                                if (animated) this[sAnimateTo$].next(false);else this.opened = false;
                                return this;
                            }
                        }, {
                            key: 'toggle',
                            value: function toggle() {
                                var animated = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

                                if (animated) this[sAnimateTo$].next(!this.opened);else this.opened = !this.opened;
                                return this;
                            }
                        }], [{
                            key: 'componentName',

                            // The name of the component (required by hy-component)
                            get: function get() {
                                return 'hy-drawer';
                            }
                        }, {
                            key: 'defaults',
                            get: function get() {
                                return {
                                    opened: false,
                                    align: 'left',
                                    persistent: false,
                                    range: [0, 100],
                                    threshold: 10,
                                    preventDefault: false,
                                    mouseEvents: false,
                                    _backButton: false,
                                    _hideOverflow: null
                                };
                            }
                        }, {
                            key: 'types',
                            get: function get() {
                                return {
                                    opened: _types.bool,
                                    align: (0, _types.oneOf)(['left', 'right']),
                                    persistent: _types.bool,
                                    range: (0, _types.arrayOf)(_types.number),
                                    threshold: _types.number,
                                    preventDefault: _types.bool,
                                    mouseEvents: _types.bool,
                                    _backButton: _types.bool,
                                    _hideOverflow: _types.string
                                };
                            }

                            // Side effects of changing configuration options (if any).
                            // Mostly we just put the value on an observable and deal with it from there.

                        }, {
                            key: 'sideEffects',
                            get: function get() {
                                return {
                                    opened: function opened(x) {
                                        this[sOpened$].next(x);
                                    },
                                    align: function align(x) {
                                        this[sAlign$].next(x);
                                    },
                                    persistent: function persistent(x) {
                                        this[sPersitent$].next(x);
                                    },
                                    preventDefault: function preventDefault(x) {
                                        this[sPreventDefault$].next(x);
                                    },
                                    mouseEvents: function mouseEvents(x) {
                                        this[sMouseEvents$].next(x);
                                    },
                                    _backButton: function _backButton(x) {
                                        this[sBackButton$].next(x);
                                    },
                                    _hideOverflow: function _hideOverflow(selector) {
                                        if (this[sScrollEl]) this[sScrollEl].style.overflow = '';
                                        this[sScrollEl] = document.querySelector(selector);
                                    }
                                };
                            }
                        }]);

                        return _class;
                    }((0, _component.componentMixin)(C));
                }

// This concludes the implementation of push-state mixin.
// You can now check out
//
// * [vanilla / index.js](../vanilla/index.md)
// * [jquery / index.js](../jquery/index.md)
// * [webcomponent / index.js](../webcomponent/index.md)
//
// to see how it is used.
//
// [rxjs]: https://github.com/ReactiveX/rxjs
// [esmixins]: http://justinfagnani.com/2015/12/21/real-mixins-with-javascript-classes/
// [modernizr]: https://modernizr.com/
                /* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17)))

            /***/ }),
        /* 104 */
        /***/ (function(module, exports, __webpack_require__) {

            __webpack_require__(105);
            module.exports = __webpack_require__(2).Function.bind;


            /***/ }),
        /* 105 */
        /***/ (function(module, exports, __webpack_require__) {

// 19.2.3.2 / 15.3.4.5 Function.prototype.bind(thisArg, args...)
            var $export = __webpack_require__(7);

            $export($export.P, 'Function', { bind: __webpack_require__(106) });


            /***/ }),
        /* 106 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var aFunction = __webpack_require__(48);
            var isObject = __webpack_require__(12);
            var invoke = __webpack_require__(107);
            var arraySlice = [].slice;
            var factories = {};

            var construct = function (F, len, args) {
                if (!(len in factories)) {
                    for (var n = [], i = 0; i < len; i++) n[i] = 'a[' + i + ']';
                    // eslint-disable-next-line no-new-func
                    factories[len] = Function('F,a', 'return new F(' + n.join(',') + ')');
                } return factories[len](F, args);
            };

            module.exports = Function.bind || function bind(that /* , ...args */) {
                var fn = aFunction(this);
                var partArgs = arraySlice.call(arguments, 1);
                var bound = function (/* args... */) {
                    var args = partArgs.concat(arraySlice.call(arguments));
                    return this instanceof bound ? construct(fn, args.length, args) : invoke(fn, args, that);
                };
                if (isObject(fn.prototype)) bound.prototype = fn.prototype;
                return bound;
            };


            /***/ }),
        /* 107 */
        /***/ (function(module, exports) {

// fast apply, http://jsperf.lnkit.com/fast-apply/5
            module.exports = function (fn, args, that) {
                var un = that === undefined;
                switch (args.length) {
                    case 0: return un ? fn()
                        : fn.call(that);
                    case 1: return un ? fn(args[0])
                        : fn.call(that, args[0]);
                    case 2: return un ? fn(args[0], args[1])
                        : fn.call(that, args[0], args[1]);
                    case 3: return un ? fn(args[0], args[1], args[2])
                        : fn.call(that, args[0], args[1], args[2]);
                    case 4: return un ? fn(args[0], args[1], args[2], args[3])
                        : fn.call(that, args[0], args[1], args[2], args[3]);
                } return fn.apply(that, args);
            };


            /***/ }),
        /* 108 */
        /***/ (function(module, exports, __webpack_require__) {

// 19.1.3.1 Object.assign(target, source)
            var $export = __webpack_require__(7);

            $export($export.S + $export.F, 'Object', { assign: __webpack_require__(109) });


            /***/ }),
        /* 109 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

// 19.1.2.1 Object.assign(target, source, ...)
            var getKeys = __webpack_require__(33);
            var gOPS = __webpack_require__(110);
            var pIE = __webpack_require__(111);
            var toObject = __webpack_require__(16);
            var IObject = __webpack_require__(34);
            var $assign = Object.assign;

// should work with symbols and should have deterministic property order (V8 bug)
            module.exports = !$assign || __webpack_require__(14)(function () {
                var A = {};
                var B = {};
                // eslint-disable-next-line no-undef
                var S = Symbol();
                var K = 'abcdefghijklmnopqrst';
                A[S] = 7;
                K.split('').forEach(function (k) { B[k] = k; });
                return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
            }) ? function assign(target, source) { // eslint-disable-line no-unused-vars
                var T = toObject(target);
                var aLen = arguments.length;
                var index = 1;
                var getSymbols = gOPS.f;
                var isEnum = pIE.f;
                while (aLen > index) {
                    var S = IObject(arguments[index++]);
                    var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);
                    var length = keys.length;
                    var j = 0;
                    var key;
                    while (length > j) if (isEnum.call(S, key = keys[j++])) T[key] = S[key];
                } return T;
            } : $assign;


            /***/ }),
        /* 110 */
        /***/ (function(module, exports) {

            exports.f = Object.getOwnPropertySymbols;


            /***/ }),
        /* 111 */
        /***/ (function(module, exports) {

            exports.f = {}.propertyIsEnumerable;


            /***/ }),
        /* 112 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";
            /* WEBPACK VAR INJECTION */(function(global) {

                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.COMPONENT_FEATURE_TESTS = undefined;

                var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

                exports.componentMixin = componentMixin;

                __webpack_require__(54);

                __webpack_require__(61);

                __webpack_require__(113);

                __webpack_require__(55);

                var _common = __webpack_require__(38);

                var _symbols = __webpack_require__(18);

                function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

                function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

                function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } // # src / component.js
// Copyright (c) 2017 Florian Klampfer <https://qwtel.com/>
// Licensed under MIT

                var COMPONENT_FEATURE_TESTS = exports.COMPONENT_FEATURE_TESTS = new _common.Set(['customevent']);

                var _Symbol = global.Symbol || function (x) {
                    return '_' + x;
                };
                var sRoot = _Symbol('root');
                var sState = _Symbol('state');

                function setupProperty(key, sideEffect) {
                    var _this = this;

                    Object.defineProperty(this, key, {
                        get: function get() {
                            return _this[sState][key];
                        },
                        set: function set(value) {
                            var oldValue = _this[sState][key];
                            _this[_symbols.sSetState](key, value);
                            if (sideEffect) sideEffect.call(_this, value, oldValue);
                        },
                        enumerable: true,
                        configurable: true
                    });
                }

                function setupProperties() {
                    var _this2 = this;

                    var sideEffects = this.constructor.sideEffects;


                    Object.keys(this[sState]).forEach(function (key) {
                        var sideEffect = sideEffects[key];
                        setupProperty.call(_this2, key, sideEffect);
                    });
                }

                var Component = function Component() {
                    _classCallCheck(this, Component);
                };

                function componentMixin() {
                    var C = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : Component;

                    return function (_C) {
                        _inherits(_class, _C);

                        function _class() {
                            _classCallCheck(this, _class);

                            return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
                        }

                        _createClass(_class, [{
                            key: _symbols.sSetup,
                            value: function value(el, state) {
                                var defaults = this.constructor.defaults;


                                if (true) {
                                    var _constructor = this.constructor,
                                        componentName = _constructor.componentName,
                                        sideEffects = _constructor.sideEffects;

                                    if (!componentName) console.warn('Component needs to have a name, e.g. `my-tag`. To set a name, provide a static getter called `componentName`.');
                                    if (!defaults) console.warn('No default properties provided. Implement a static getter called `defaults`.');
                                    if (!sideEffects) console.warn('No side effects provided. Implement a static getter called `sideEffects`.');
                                }

                                this[sState] = Object.assign({}, defaults, state);
                                setupProperties.call(this);
                                this[sRoot] = this[_symbols.sSetupDOM](el);
                                return this;
                            }
                        }, {
                            key: _symbols.sSetupDOM,
                            value: function value(el) {
                                return el;
                            }
                        }, {
                            key: _symbols.sGetRoot,
                            value: function value() {
                                return this[sRoot];
                            }
                        }, {
                            key: _symbols.sGetEl,
                            value: function value() {
                                return this[sRoot];
                            }
                        }, {
                            key: _symbols.sFire,
                            value: function value(eventName, data) {
                                var componentName = this.constructor.componentName;

                                var event = new CustomEvent(componentName + '-' + eventName, data);
                                this.el.dispatchEvent(event);
                            }
                        }, {
                            key: _symbols.sSetState,
                            value: function value(key, _value) {
                                this[sState][key] = _value;
                            }
                        }, {
                            key: 'root',
                            get: function get() {
                                return this[_symbols.sGetRoot]();
                            }
                        }, {
                            key: 'el',
                            get: function get() {
                                return this[_symbols.sGetEl]();
                            }
                        }]);

                        return _class;
                    }(C);
                }
                /* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(17)))

            /***/ }),
        /* 113 */
        /***/ (function(module, exports, __webpack_require__) {

            __webpack_require__(114);
            var $Object = __webpack_require__(2).Object;
            module.exports = function defineProperty(it, key, desc) {
                return $Object.defineProperty(it, key, desc);
            };


            /***/ }),
        /* 114 */
        /***/ (function(module, exports, __webpack_require__) {

            var $export = __webpack_require__(7);
// 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)
            $export($export.S + $export.F * !__webpack_require__(13), 'Object', { defineProperty: __webpack_require__(11).f });


            /***/ }),
        /* 115 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            /**
             * An error thrown when an action is invalid because the object has been
             * unsubscribed.
             *
             * @see {@link Subject}
             * @see {@link BehaviorSubject}
             *
             * @class ObjectUnsubscribedError
             */
            var ObjectUnsubscribedError = (function (_super) {
                __extends(ObjectUnsubscribedError, _super);
                function ObjectUnsubscribedError() {
                    var err = _super.call(this, 'object unsubscribed');
                    this.name = err.name = 'ObjectUnsubscribedError';
                    this.stack = err.stack;
                    this.message = err.message;
                }
                return ObjectUnsubscribedError;
            }(Error));
            exports.ObjectUnsubscribedError = ObjectUnsubscribedError;
//# sourceMappingURL=ObjectUnsubscribedError.js.map

            /***/ }),
        /* 116 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscription_1 = __webpack_require__(9);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var SubjectSubscription = (function (_super) {
                __extends(SubjectSubscription, _super);
                function SubjectSubscription(subject, subscriber) {
                    _super.call(this);
                    this.subject = subject;
                    this.subscriber = subscriber;
                    this.closed = false;
                }
                SubjectSubscription.prototype.unsubscribe = function () {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    var subject = this.subject;
                    var observers = subject.observers;
                    this.subject = null;
                    if (!observers || observers.length === 0 || subject.isStopped || subject.closed) {
                        return;
                    }
                    var subscriberIndex = observers.indexOf(this.subscriber);
                    if (subscriberIndex !== -1) {
                        observers.splice(subscriberIndex, 1);
                    }
                };
                return SubjectSubscription;
            }(Subscription_1.Subscription));
            exports.SubjectSubscription = SubjectSubscription;
//# sourceMappingURL=SubjectSubscription.js.map

            /***/ }),
        /* 117 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var isScheduler_1 = __webpack_require__(19);
            var isArray_1 = __webpack_require__(22);
            var ArrayObservable_1 = __webpack_require__(10);
            var combineLatest_1 = __webpack_require__(118);
            /* tslint:enable:max-line-length */
            /**
             * Combines multiple Observables to create an Observable whose values are
             * calculated from the latest values of each of its input Observables.
             *
             * <span class="informal">Whenever any input Observable emits a value, it
             * computes a formula using the latest values from all the inputs, then emits
             * the output of that formula.</span>
             *
             * <img src="./img/combineLatest.png" width="100%">
             *
             * `combineLatest` combines the values from all the Observables passed as
             * arguments. This is done by subscribing to each Observable in order and,
             * whenever any Observable emits, collecting an array of the most recent
             * values from each Observable. So if you pass `n` Observables to operator,
             * returned Observable will always emit an array of `n` values, in order
             * corresponding to order of passed Observables (value from the first Observable
             * on the first place and so on).
             *
             * Static version of `combineLatest` accepts either an array of Observables
             * or each Observable can be put directly as an argument. Note that array of
             * Observables is good choice, if you don't know beforehand how many Observables
             * you will combine. Passing empty array will result in Observable that
             * completes immediately.
             *
             * To ensure output array has always the same length, `combineLatest` will
             * actually wait for all input Observables to emit at least once,
             * before it starts emitting results. This means if some Observable emits
             * values before other Observables started emitting, all that values but last
             * will be lost. On the other hand, is some Observable does not emit value but
             * completes, resulting Observable will complete at the same moment without
             * emitting anything, since it will be now impossible to include value from
             * completed Observable in resulting array. Also, if some input Observable does
             * not emit any value and never completes, `combineLatest` will also never emit
             * and never complete, since, again, it will wait for all streams to emit some
             * value.
             *
             * If at least one Observable was passed to `combineLatest` and all passed Observables
             * emitted something, resulting Observable will complete when all combined
             * streams complete. So even if some Observable completes, result of
             * `combineLatest` will still emit values when other Observables do. In case
             * of completed Observable, its value from now on will always be the last
             * emitted value. On the other hand, if any Observable errors, `combineLatest`
             * will error immediately as well, and all other Observables will be unsubscribed.
             *
             * `combineLatest` accepts as optional parameter `project` function, which takes
             * as arguments all values that would normally be emitted by resulting Observable.
             * `project` can return any kind of value, which will be then emitted by Observable
             * instead of default array. Note that `project` does not take as argument that array
             * of values, but values themselves. That means default `project` can be imagined
             * as function that takes all its arguments and puts them into an array.
             *
             *
             * @example <caption>Combine two timer Observables</caption>
             * const firstTimer = Rx.Observable.timer(0, 1000); // emit 0, 1, 2... after every second, starting from now
             * const secondTimer = Rx.Observable.timer(500, 1000); // emit 0, 1, 2... after every second, starting 0,5s from now
             * const combinedTimers = Rx.Observable.combineLatest(firstTimer, secondTimer);
             * combinedTimers.subscribe(value => console.log(value));
             * // Logs
             * // [0, 0] after 0.5s
             * // [1, 0] after 1s
             * // [1, 1] after 1.5s
             * // [2, 1] after 2s
             *
             *
             * @example <caption>Combine an array of Observables</caption>
             * const observables = [1, 5, 10].map(
             *   n => Rx.Observable.of(n).delay(n * 1000).startWith(0) // emit 0 and then emit n after n seconds
             * );
             * const combined = Rx.Observable.combineLatest(observables);
             * combined.subscribe(value => console.log(value));
             * // Logs
             * // [0, 0, 0] immediately
             * // [1, 0, 0] after 1s
             * // [1, 5, 0] after 5s
             * // [1, 5, 10] after 10s
             *
             *
             * @example <caption>Use project function to dynamically calculate the Body-Mass Index</caption>
             * var weight = Rx.Observable.of(70, 72, 76, 79, 75);
             * var height = Rx.Observable.of(1.76, 1.77, 1.78);
             * var bmi = Rx.Observable.combineLatest(weight, height, (w, h) => w / (h * h));
             * bmi.subscribe(x => console.log('BMI is ' + x));
             *
             * // With output to console:
             * // BMI is 24.212293388429753
             * // BMI is 23.93948099205209
             * // BMI is 23.671253629592222
             *
             *
             * @see {@link combineAll}
             * @see {@link merge}
             * @see {@link withLatestFrom}
             *
             * @param {ObservableInput} observable1 An input Observable to combine with other Observables.
             * @param {ObservableInput} observable2 An input Observable to combine with other Observables.
             * More than one input Observables may be given as arguments
             * or an array of Observables may be given as the first argument.
             * @param {function} [project] An optional function to project the values from
             * the combined latest values into a new value on the output Observable.
             * @param {Scheduler} [scheduler=null] The IScheduler to use for subscribing to
             * each input Observable.
             * @return {Observable} An Observable of projected values from the most recent
             * values from each input Observable, or an array of the most recent values from
             * each input Observable.
             * @static true
             * @name combineLatest
             * @owner Observable
             */
            function combineLatest() {
                var observables = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    observables[_i - 0] = arguments[_i];
                }
                var project = null;
                var scheduler = null;
                if (isScheduler_1.isScheduler(observables[observables.length - 1])) {
                    scheduler = observables.pop();
                }
                if (typeof observables[observables.length - 1] === 'function') {
                    project = observables.pop();
                }
                // if the first and only other argument besides the resultSelector is an array
                // assume it's been called with `combineLatest([obs1, obs2, obs3], project)`
                if (observables.length === 1 && isArray_1.isArray(observables[0])) {
                    observables = observables[0];
                }
                return new ArrayObservable_1.ArrayObservable(observables, scheduler).lift(new combineLatest_1.CombineLatestOperator(project));
            }
            exports.combineLatest = combineLatest;
//# sourceMappingURL=combineLatest.js.map

            /***/ }),
        /* 118 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var ArrayObservable_1 = __webpack_require__(10);
            var isArray_1 = __webpack_require__(22);
            var OuterSubscriber_1 = __webpack_require__(5);
            var subscribeToResult_1 = __webpack_require__(6);
            var none = {};
            /* tslint:enable:max-line-length */
            /**
             * Combines multiple Observables to create an Observable whose values are
             * calculated from the latest values of each of its input Observables.
             *
             * <span class="informal">Whenever any input Observable emits a value, it
             * computes a formula using the latest values from all the inputs, then emits
             * the output of that formula.</span>
             *
             * <img src="./img/combineLatest.png" width="100%">
             *
             * `combineLatest` combines the values from this Observable with values from
             * Observables passed as arguments. This is done by subscribing to each
             * Observable, in order, and collecting an array of each of the most recent
             * values any time any of the input Observables emits, then either taking that
             * array and passing it as arguments to an optional `project` function and
             * emitting the return value of that, or just emitting the array of recent
             * values directly if there is no `project` function.
             *
             * @example <caption>Dynamically calculate the Body-Mass Index from an Observable of weight and one for height</caption>
             * var weight = Rx.Observable.of(70, 72, 76, 79, 75);
             * var height = Rx.Observable.of(1.76, 1.77, 1.78);
             * var bmi = weight.combineLatest(height, (w, h) => w / (h * h));
             * bmi.subscribe(x => console.log('BMI is ' + x));
             *
             * // With output to console:
             * // BMI is 24.212293388429753
             * // BMI is 23.93948099205209
             * // BMI is 23.671253629592222
             *
             * @see {@link combineAll}
             * @see {@link merge}
             * @see {@link withLatestFrom}
             *
             * @param {ObservableInput} other An input Observable to combine with the source
             * Observable. More than one input Observables may be given as argument.
             * @param {function} [project] An optional function to project the values from
             * the combined latest values into a new value on the output Observable.
             * @return {Observable} An Observable of projected values from the most recent
             * values from each input Observable, or an array of the most recent values from
             * each input Observable.
             * @method combineLatest
             * @owner Observable
             */
            function combineLatest() {
                var observables = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    observables[_i - 0] = arguments[_i];
                }
                var project = null;
                if (typeof observables[observables.length - 1] === 'function') {
                    project = observables.pop();
                }
                // if the first and only other argument besides the resultSelector is an array
                // assume it's been called with `combineLatest([obs1, obs2, obs3], project)`
                if (observables.length === 1 && isArray_1.isArray(observables[0])) {
                    observables = observables[0].slice();
                }
                return function (source) { return source.lift.call(new ArrayObservable_1.ArrayObservable([source].concat(observables)), new CombineLatestOperator(project)); };
            }
            exports.combineLatest = combineLatest;
            var CombineLatestOperator = (function () {
                function CombineLatestOperator(project) {
                    this.project = project;
                }
                CombineLatestOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new CombineLatestSubscriber(subscriber, this.project));
                };
                return CombineLatestOperator;
            }());
            exports.CombineLatestOperator = CombineLatestOperator;
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var CombineLatestSubscriber = (function (_super) {
                __extends(CombineLatestSubscriber, _super);
                function CombineLatestSubscriber(destination, project) {
                    _super.call(this, destination);
                    this.project = project;
                    this.active = 0;
                    this.values = [];
                    this.observables = [];
                }
                CombineLatestSubscriber.prototype._next = function (observable) {
                    this.values.push(none);
                    this.observables.push(observable);
                };
                CombineLatestSubscriber.prototype._complete = function () {
                    var observables = this.observables;
                    var len = observables.length;
                    if (len === 0) {
                        this.destination.complete();
                    }
                    else {
                        this.active = len;
                        this.toRespond = len;
                        for (var i = 0; i < len; i++) {
                            var observable = observables[i];
                            this.add(subscribeToResult_1.subscribeToResult(this, observable, observable, i));
                        }
                    }
                };
                CombineLatestSubscriber.prototype.notifyComplete = function (unused) {
                    if ((this.active -= 1) === 0) {
                        this.destination.complete();
                    }
                };
                CombineLatestSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {
                    var values = this.values;
                    var oldVal = values[outerIndex];
                    var toRespond = !this.toRespond
                        ? 0
                        : oldVal === none ? --this.toRespond : this.toRespond;
                    values[outerIndex] = innerValue;
                    if (toRespond === 0) {
                        if (this.project) {
                            this._tryProject(values);
                        }
                        else {
                            this.destination.next(values.slice());
                        }
                    }
                };
                CombineLatestSubscriber.prototype._tryProject = function (values) {
                    var result;
                    try {
                        result = this.project.apply(this, values);
                    }
                    catch (err) {
                        this.destination.error(err);
                        return;
                    }
                    this.destination.next(result);
                };
                return CombineLatestSubscriber;
            }(OuterSubscriber_1.OuterSubscriber));
            exports.CombineLatestSubscriber = CombineLatestSubscriber;
//# sourceMappingURL=combineLatest.js.map

            /***/ }),
        /* 119 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var InnerSubscriber = (function (_super) {
                __extends(InnerSubscriber, _super);
                function InnerSubscriber(parent, outerValue, outerIndex) {
                    _super.call(this);
                    this.parent = parent;
                    this.outerValue = outerValue;
                    this.outerIndex = outerIndex;
                    this.index = 0;
                }
                InnerSubscriber.prototype._next = function (value) {
                    this.parent.notifyNext(this.outerValue, value, this.outerIndex, this.index++, this);
                };
                InnerSubscriber.prototype._error = function (error) {
                    this.parent.notifyError(error, this);
                    this.unsubscribe();
                };
                InnerSubscriber.prototype._complete = function () {
                    this.parent.notifyComplete(this);
                    this.unsubscribe();
                };
                return InnerSubscriber;
            }(Subscriber_1.Subscriber));
            exports.InnerSubscriber = InnerSubscriber;
//# sourceMappingURL=InnerSubscriber.js.map

            /***/ }),
        /* 120 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var DeferObservable_1 = __webpack_require__(121);
            exports.defer = DeferObservable_1.DeferObservable.create;
//# sourceMappingURL=defer.js.map

            /***/ }),
        /* 121 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Observable_1 = __webpack_require__(0);
            var subscribeToResult_1 = __webpack_require__(6);
            var OuterSubscriber_1 = __webpack_require__(5);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @extends {Ignored}
             * @hide true
             */
            var DeferObservable = (function (_super) {
                __extends(DeferObservable, _super);
                function DeferObservable(observableFactory) {
                    _super.call(this);
                    this.observableFactory = observableFactory;
                }
                /**
                 * Creates an Observable that, on subscribe, calls an Observable factory to
                 * make an Observable for each new Observer.
                 *
                 * <span class="informal">Creates the Observable lazily, that is, only when it
                 * is subscribed.
                 * </span>
                 *
                 * <img src="./img/defer.png" width="100%">
                 *
                 * `defer` allows you to create the Observable only when the Observer
                 * subscribes, and create a fresh Observable for each Observer. It waits until
                 * an Observer subscribes to it, and then it generates an Observable,
                 * typically with an Observable factory function. It does this afresh for each
                 * subscriber, so although each subscriber may think it is subscribing to the
                 * same Observable, in fact each subscriber gets its own individual
                 * Observable.
                 *
                 * @example <caption>Subscribe to either an Observable of clicks or an Observable of interval, at random</caption>
                 * var clicksOrInterval = Rx.Observable.defer(function () {
                 *   if (Math.random() > 0.5) {
                 *     return Rx.Observable.fromEvent(document, 'click');
                 *   } else {
                 *     return Rx.Observable.interval(1000);
                 *   }
                 * });
                 * clicksOrInterval.subscribe(x => console.log(x));
                 *
                 * // Results in the following behavior:
                 * // If the result of Math.random() is greater than 0.5 it will listen
                 * // for clicks anywhere on the "document"; when document is clicked it
                 * // will log a MouseEvent object to the console. If the result is less
                 * // than 0.5 it will emit ascending numbers, one every second(1000ms).
                 *
                 * @see {@link create}
                 *
                 * @param {function(): SubscribableOrPromise} observableFactory The Observable
                 * factory function to invoke for each Observer that subscribes to the output
                 * Observable. May also return a Promise, which will be converted on the fly
                 * to an Observable.
                 * @return {Observable} An Observable whose Observers' subscriptions trigger
                 * an invocation of the given Observable factory function.
                 * @static true
                 * @name defer
                 * @owner Observable
                 */
                DeferObservable.create = function (observableFactory) {
                    return new DeferObservable(observableFactory);
                };
                DeferObservable.prototype._subscribe = function (subscriber) {
                    return new DeferSubscriber(subscriber, this.observableFactory);
                };
                return DeferObservable;
            }(Observable_1.Observable));
            exports.DeferObservable = DeferObservable;
            var DeferSubscriber = (function (_super) {
                __extends(DeferSubscriber, _super);
                function DeferSubscriber(destination, factory) {
                    _super.call(this, destination);
                    this.factory = factory;
                    this.tryDefer();
                }
                DeferSubscriber.prototype.tryDefer = function () {
                    try {
                        this._callFactory();
                    }
                    catch (err) {
                        this._error(err);
                    }
                };
                DeferSubscriber.prototype._callFactory = function () {
                    var result = this.factory();
                    if (result) {
                        this.add(subscribeToResult_1.subscribeToResult(this, result));
                    }
                };
                return DeferSubscriber;
            }(OuterSubscriber_1.OuterSubscriber));
//# sourceMappingURL=DeferObservable.js.map

            /***/ }),
        /* 122 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var FromEventObservable_1 = __webpack_require__(123);
            exports.fromEvent = FromEventObservable_1.FromEventObservable.create;
//# sourceMappingURL=fromEvent.js.map

            /***/ }),
        /* 123 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Observable_1 = __webpack_require__(0);
            var tryCatch_1 = __webpack_require__(40);
            var isFunction_1 = __webpack_require__(39);
            var errorObject_1 = __webpack_require__(23);
            var Subscription_1 = __webpack_require__(9);
            var toString = Object.prototype.toString;
            function isNodeStyleEventEmitter(sourceObj) {
                return !!sourceObj && typeof sourceObj.addListener === 'function' && typeof sourceObj.removeListener === 'function';
            }
            function isJQueryStyleEventEmitter(sourceObj) {
                return !!sourceObj && typeof sourceObj.on === 'function' && typeof sourceObj.off === 'function';
            }
            function isNodeList(sourceObj) {
                return !!sourceObj && toString.call(sourceObj) === '[object NodeList]';
            }
            function isHTMLCollection(sourceObj) {
                return !!sourceObj && toString.call(sourceObj) === '[object HTMLCollection]';
            }
            function isEventTarget(sourceObj) {
                return !!sourceObj && typeof sourceObj.addEventListener === 'function' && typeof sourceObj.removeEventListener === 'function';
            }
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @extends {Ignored}
             * @hide true
             */
            var FromEventObservable = (function (_super) {
                __extends(FromEventObservable, _super);
                function FromEventObservable(sourceObj, eventName, selector, options) {
                    _super.call(this);
                    this.sourceObj = sourceObj;
                    this.eventName = eventName;
                    this.selector = selector;
                    this.options = options;
                }
                /* tslint:enable:max-line-length */
                /**
                 * Creates an Observable that emits events of a specific type coming from the
                 * given event target.
                 *
                 * <span class="informal">Creates an Observable from DOM events, or Node.js
                 * EventEmitter events or others.</span>
                 *
                 * <img src="./img/fromEvent.png" width="100%">
                 *
                 * `fromEvent` accepts as a first argument event target, which is an object with methods
                 * for registering event handler functions. As a second argument it takes string that indicates
                 * type of event we want to listen for. `fromEvent` supports selected types of event targets,
                 * which are described in detail below. If your event target does not match any of the ones listed,
                 * you should use {@link fromEventPattern}, which can be used on arbitrary APIs.
                 * When it comes to APIs supported by `fromEvent`, their methods for adding and removing event
                 * handler functions have different names, but they all accept a string describing event type
                 * and function itself, which will be called whenever said event happens.
                 *
                 * Every time resulting Observable is subscribed, event handler function will be registered
                 * to event target on given event type. When that event fires, value
                 * passed as a first argument to registered function will be emitted by output Observable.
                 * When Observable is unsubscribed, function will be unregistered from event target.
                 *
                 * Note that if event target calls registered function with more than one argument, second
                 * and following arguments will not appear in resulting stream. In order to get access to them,
                 * you can pass to `fromEvent` optional project function, which will be called with all arguments
                 * passed to event handler. Output Observable will then emit value returned by project function,
                 * instead of the usual value.
                 *
                 * Remember that event targets listed below are checked via duck typing. It means that
                 * no matter what kind of object you have and no matter what environment you work in,
                 * you can safely use `fromEvent` on that object if it exposes described methods (provided
                 * of course they behave as was described above). So for example if Node.js library exposes
                 * event target which has the same method names as DOM EventTarget, `fromEvent` is still
                 * a good choice.
                 *
                 * If the API you use is more callback then event handler oriented (subscribed
                 * callback function fires only once and thus there is no need to manually
                 * unregister it), you should use {@link bindCallback} or {@link bindNodeCallback}
                 * instead.
                 *
                 * `fromEvent` supports following types of event targets:
                 *
                 * **DOM EventTarget**
                 *
                 * This is an object with `addEventListener` and `removeEventListener` methods.
                 *
                 * In the browser, `addEventListener` accepts - apart from event type string and event
                 * handler function arguments - optional third parameter, which is either an object or boolean,
                 * both used for additional configuration how and when passed function will be called. When
                 * `fromEvent` is used with event target of that type, you can provide this values
                 * as third parameter as well.
                 *
                 * **Node.js EventEmitter**
                 *
                 * An object with `addListener` and `removeListener` methods.
                 *
                 * **JQuery-style event target**
                 *
                 * An object with `on` and `off` methods
                 *
                 * **DOM NodeList**
                 *
                 * List of DOM Nodes, returned for example by `document.querySelectorAll` or `Node.childNodes`.
                 *
                 * Although this collection is not event target in itself, `fromEvent` will iterate over all Nodes
                 * it contains and install event handler function in every of them. When returned Observable
                 * is unsubscribed, function will be removed from all Nodes.
                 *
                 * **DOM HtmlCollection**
                 *
                 * Just as in case of NodeList it is a collection of DOM nodes. Here as well event handler function is
                 * installed and removed in each of elements.
                 *
                 *
                 * @example <caption>Emits clicks happening on the DOM document</caption>
                 * var clicks = Rx.Observable.fromEvent(document, 'click');
                 * clicks.subscribe(x => console.log(x));
                 *
                 * // Results in:
                 * // MouseEvent object logged to console every time a click
                 * // occurs on the document.
                 *
                 *
                 * @example <caption>Use addEventListener with capture option</caption>
                 * var clicksInDocument = Rx.Observable.fromEvent(document, 'click', true); // note optional configuration parameter
                 *                                                                          // which will be passed to addEventListener
                 * var clicksInDiv = Rx.Observable.fromEvent(someDivInDocument, 'click');
                 *
                 * clicksInDocument.subscribe(() => console.log('document'));
                 * clicksInDiv.subscribe(() => console.log('div'));
                 *
                 * // By default events bubble UP in DOM tree, so normally
                 * // when we would click on div in document
                 * // "div" would be logged first and then "document".
                 * // Since we specified optional `capture` option, document
                 * // will catch event when it goes DOWN DOM tree, so console
                 * // will log "document" and then "div".
                 *
                 * @see {@link bindCallback}
                 * @see {@link bindNodeCallback}
                 * @see {@link fromEventPattern}
                 *
                 * @param {EventTargetLike} target The DOM EventTarget, Node.js
                 * EventEmitter, JQuery-like event target, NodeList or HTMLCollection to attach the event handler to.
                 * @param {string} eventName The event name of interest, being emitted by the
                 * `target`.
                 * @param {EventListenerOptions} [options] Options to pass through to addEventListener
                 * @param {SelectorMethodSignature<T>} [selector] An optional function to
                 * post-process results. It takes the arguments from the event handler and
                 * should return a single value.
                 * @return {Observable<T>}
                 * @static true
                 * @name fromEvent
                 * @owner Observable
                 */
                FromEventObservable.create = function (target, eventName, options, selector) {
                    if (isFunction_1.isFunction(options)) {
                        selector = options;
                        options = undefined;
                    }
                    return new FromEventObservable(target, eventName, selector, options);
                };
                FromEventObservable.setupSubscription = function (sourceObj, eventName, handler, subscriber, options) {
                    var unsubscribe;
                    if (isNodeList(sourceObj) || isHTMLCollection(sourceObj)) {
                        for (var i = 0, len = sourceObj.length; i < len; i++) {
                            FromEventObservable.setupSubscription(sourceObj[i], eventName, handler, subscriber, options);
                        }
                    }
                    else if (isEventTarget(sourceObj)) {
                        var source_1 = sourceObj;
                        sourceObj.addEventListener(eventName, handler, options);
                        unsubscribe = function () { return source_1.removeEventListener(eventName, handler); };
                    }
                    else if (isJQueryStyleEventEmitter(sourceObj)) {
                        var source_2 = sourceObj;
                        sourceObj.on(eventName, handler);
                        unsubscribe = function () { return source_2.off(eventName, handler); };
                    }
                    else if (isNodeStyleEventEmitter(sourceObj)) {
                        var source_3 = sourceObj;
                        sourceObj.addListener(eventName, handler);
                        unsubscribe = function () { return source_3.removeListener(eventName, handler); };
                    }
                    else {
                        throw new TypeError('Invalid event target');
                    }
                    subscriber.add(new Subscription_1.Subscription(unsubscribe));
                };
                FromEventObservable.prototype._subscribe = function (subscriber) {
                    var sourceObj = this.sourceObj;
                    var eventName = this.eventName;
                    var options = this.options;
                    var selector = this.selector;
                    var handler = selector ? function () {
                        var args = [];
                        for (var _i = 0; _i < arguments.length; _i++) {
                            args[_i - 0] = arguments[_i];
                        }
                        var result = tryCatch_1.tryCatch(selector).apply(void 0, args);
                        if (result === errorObject_1.errorObject) {
                            subscriber.error(errorObject_1.errorObject.e);
                        }
                        else {
                            subscriber.next(result);
                        }
                    } : function (e) { return subscriber.next(e); };
                    FromEventObservable.setupSubscription(sourceObj, eventName, handler, subscriber, options);
                };
                return FromEventObservable;
            }(Observable_1.Observable));
            exports.FromEventObservable = FromEventObservable;
//# sourceMappingURL=FromEventObservable.js.map

            /***/ }),
        /* 124 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var merge_1 = __webpack_require__(125);
            exports.merge = merge_1.mergeStatic;
//# sourceMappingURL=merge.js.map

            /***/ }),
        /* 125 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var merge_1 = __webpack_require__(64);
            var merge_2 = __webpack_require__(64);
            exports.mergeStatic = merge_2.mergeStatic;
            /* tslint:enable:max-line-length */
            /**
             * Creates an output Observable which concurrently emits all values from every
             * given input Observable.
             *
             * <span class="informal">Flattens multiple Observables together by blending
             * their values into one Observable.</span>
             *
             * <img src="./img/merge.png" width="100%">
             *
             * `merge` subscribes to each given input Observable (either the source or an
             * Observable given as argument), and simply forwards (without doing any
             * transformation) all the values from all the input Observables to the output
             * Observable. The output Observable only completes once all input Observables
             * have completed. Any error delivered by an input Observable will be immediately
             * emitted on the output Observable.
             *
             * @example <caption>Merge together two Observables: 1s interval and clicks</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var timer = Rx.Observable.interval(1000);
             * var clicksOrTimer = clicks.merge(timer);
             * clicksOrTimer.subscribe(x => console.log(x));
             *
             * @example <caption>Merge together 3 Observables, but only 2 run concurrently</caption>
             * var timer1 = Rx.Observable.interval(1000).take(10);
             * var timer2 = Rx.Observable.interval(2000).take(6);
             * var timer3 = Rx.Observable.interval(500).take(10);
             * var concurrent = 2; // the argument
             * var merged = timer1.merge(timer2, timer3, concurrent);
             * merged.subscribe(x => console.log(x));
             *
             * @see {@link mergeAll}
             * @see {@link mergeMap}
             * @see {@link mergeMapTo}
             * @see {@link mergeScan}
             *
             * @param {ObservableInput} other An input Observable to merge with the source
             * Observable. More than one input Observables may be given as argument.
             * @param {number} [concurrent=Number.POSITIVE_INFINITY] Maximum number of input
             * Observables being subscribed to concurrently.
             * @param {Scheduler} [scheduler=null] The IScheduler to use for managing
             * concurrency of input Observables.
             * @return {Observable} An Observable that emits items that are the result of
             * every input Observable.
             * @method merge
             * @owner Observable
             */
            function merge() {
                var observables = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    observables[_i - 0] = arguments[_i];
                }
                return merge_1.merge.apply(void 0, observables)(this);
            }
            exports.merge = merge;
//# sourceMappingURL=merge.js.map

            /***/ }),
        /* 126 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var subscribeToResult_1 = __webpack_require__(6);
            var OuterSubscriber_1 = __webpack_require__(5);
            /* tslint:enable:max-line-length */
            /**
             * Projects each source value to an Observable which is merged in the output
             * Observable.
             *
             * <span class="informal">Maps each value to an Observable, then flattens all of
             * these inner Observables using {@link mergeAll}.</span>
             *
             * <img src="./img/mergeMap.png" width="100%">
             *
             * Returns an Observable that emits items based on applying a function that you
             * supply to each item emitted by the source Observable, where that function
             * returns an Observable, and then merging those resulting Observables and
             * emitting the results of this merger.
             *
             * @example <caption>Map and flatten each letter to an Observable ticking every 1 second</caption>
             * var letters = Rx.Observable.of('a', 'b', 'c');
             * var result = letters.mergeMap(x =>
             *   Rx.Observable.interval(1000).map(i => x+i)
             * );
             * result.subscribe(x => console.log(x));
             *
             * // Results in the following:
             * // a0
             * // b0
             * // c0
             * // a1
             * // b1
             * // c1
             * // continues to list a,b,c with respective ascending integers
             *
             * @see {@link concatMap}
             * @see {@link exhaustMap}
             * @see {@link merge}
             * @see {@link mergeAll}
             * @see {@link mergeMapTo}
             * @see {@link mergeScan}
             * @see {@link switchMap}
             *
             * @param {function(value: T, ?index: number): ObservableInput} project A function
             * that, when applied to an item emitted by the source Observable, returns an
             * Observable.
             * @param {function(outerValue: T, innerValue: I, outerIndex: number, innerIndex: number): any} [resultSelector]
             * A function to produce the value on the output Observable based on the values
             * and the indices of the source (outer) emission and the inner Observable
             * emission. The arguments passed to this function are:
             * - `outerValue`: the value that came from the source
             * - `innerValue`: the value that came from the projected Observable
             * - `outerIndex`: the "index" of the value that came from the source
             * - `innerIndex`: the "index" of the value from the projected Observable
             * @param {number} [concurrent=Number.POSITIVE_INFINITY] Maximum number of input
             * Observables being subscribed to concurrently.
             * @return {Observable} An Observable that emits the result of applying the
             * projection function (and the optional `resultSelector`) to each item emitted
             * by the source Observable and merging the results of the Observables obtained
             * from this transformation.
             * @method mergeMap
             * @owner Observable
             */
            function mergeMap(project, resultSelector, concurrent) {
                if (concurrent === void 0) { concurrent = Number.POSITIVE_INFINITY; }
                return function mergeMapOperatorFunction(source) {
                    if (typeof resultSelector === 'number') {
                        concurrent = resultSelector;
                        resultSelector = null;
                    }
                    return source.lift(new MergeMapOperator(project, resultSelector, concurrent));
                };
            }
            exports.mergeMap = mergeMap;
            var MergeMapOperator = (function () {
                function MergeMapOperator(project, resultSelector, concurrent) {
                    if (concurrent === void 0) { concurrent = Number.POSITIVE_INFINITY; }
                    this.project = project;
                    this.resultSelector = resultSelector;
                    this.concurrent = concurrent;
                }
                MergeMapOperator.prototype.call = function (observer, source) {
                    return source.subscribe(new MergeMapSubscriber(observer, this.project, this.resultSelector, this.concurrent));
                };
                return MergeMapOperator;
            }());
            exports.MergeMapOperator = MergeMapOperator;
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var MergeMapSubscriber = (function (_super) {
                __extends(MergeMapSubscriber, _super);
                function MergeMapSubscriber(destination, project, resultSelector, concurrent) {
                    if (concurrent === void 0) { concurrent = Number.POSITIVE_INFINITY; }
                    _super.call(this, destination);
                    this.project = project;
                    this.resultSelector = resultSelector;
                    this.concurrent = concurrent;
                    this.hasCompleted = false;
                    this.buffer = [];
                    this.active = 0;
                    this.index = 0;
                }
                MergeMapSubscriber.prototype._next = function (value) {
                    if (this.active < this.concurrent) {
                        this._tryNext(value);
                    }
                    else {
                        this.buffer.push(value);
                    }
                };
                MergeMapSubscriber.prototype._tryNext = function (value) {
                    var result;
                    var index = this.index++;
                    try {
                        result = this.project(value, index);
                    }
                    catch (err) {
                        this.destination.error(err);
                        return;
                    }
                    this.active++;
                    this._innerSub(result, value, index);
                };
                MergeMapSubscriber.prototype._innerSub = function (ish, value, index) {
                    this.add(subscribeToResult_1.subscribeToResult(this, ish, value, index));
                };
                MergeMapSubscriber.prototype._complete = function () {
                    this.hasCompleted = true;
                    if (this.active === 0 && this.buffer.length === 0) {
                        this.destination.complete();
                    }
                };
                MergeMapSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {
                    if (this.resultSelector) {
                        this._notifyResultSelector(outerValue, innerValue, outerIndex, innerIndex);
                    }
                    else {
                        this.destination.next(innerValue);
                    }
                };
                MergeMapSubscriber.prototype._notifyResultSelector = function (outerValue, innerValue, outerIndex, innerIndex) {
                    var result;
                    try {
                        result = this.resultSelector(outerValue, innerValue, outerIndex, innerIndex);
                    }
                    catch (err) {
                        this.destination.error(err);
                        return;
                    }
                    this.destination.next(result);
                };
                MergeMapSubscriber.prototype.notifyComplete = function (innerSub) {
                    var buffer = this.buffer;
                    this.remove(innerSub);
                    this.active--;
                    if (buffer.length > 0) {
                        this._next(buffer.shift());
                    }
                    else if (this.active === 0 && this.hasCompleted) {
                        this.destination.complete();
                    }
                };
                return MergeMapSubscriber;
            }(OuterSubscriber_1.OuterSubscriber));
            exports.MergeMapSubscriber = MergeMapSubscriber;
//# sourceMappingURL=mergeMap.js.map

            /***/ }),
        /* 127 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            function identity(x) {
                return x;
            }
            exports.identity = identity;
//# sourceMappingURL=identity.js.map

            /***/ }),
        /* 128 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var NeverObservable_1 = __webpack_require__(129);
            exports.never = NeverObservable_1.NeverObservable.create;
//# sourceMappingURL=never.js.map

            /***/ }),
        /* 129 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Observable_1 = __webpack_require__(0);
            var noop_1 = __webpack_require__(60);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @extends {Ignored}
             * @hide true
             */
            var NeverObservable = (function (_super) {
                __extends(NeverObservable, _super);
                function NeverObservable() {
                    _super.call(this);
                }
                /**
                 * Creates an Observable that emits no items to the Observer.
                 *
                 * <span class="informal">An Observable that never emits anything.</span>
                 *
                 * <img src="./img/never.png" width="100%">
                 *
                 * This static operator is useful for creating a simple Observable that emits
                 * neither values nor errors nor the completion notification. It can be used
                 * for testing purposes or for composing with other Observables. Please note
                 * that by never emitting a complete notification, this Observable keeps the
                 * subscription from being disposed automatically. Subscriptions need to be
                 * manually disposed.
                 *
                 * @example <caption>Emit the number 7, then never emit anything else (not even complete).</caption>
                 * function info() {
                 *   console.log('Will not be called');
                 * }
                 * var result = Rx.Observable.never().startWith(7);
                 * result.subscribe(x => console.log(x), info, info);
                 *
                 * @see {@link create}
                 * @see {@link empty}
                 * @see {@link of}
                 * @see {@link throw}
                 *
                 * @return {Observable} A "never" Observable: never emits anything.
                 * @static true
                 * @name never
                 * @owner Observable
                 */
                NeverObservable.create = function () {
                    return new NeverObservable();
                };
                NeverObservable.prototype._subscribe = function (subscriber) {
                    noop_1.noop();
                };
                return NeverObservable;
            }(Observable_1.Observable));
            exports.NeverObservable = NeverObservable;
//# sourceMappingURL=NeverObservable.js.map

            /***/ }),
        /* 130 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var tap_1 = __webpack_require__(131);
            /* tslint:enable:max-line-length */
            /**
             * Perform a side effect for every emission on the source Observable, but return
             * an Observable that is identical to the source.
             *
             * <span class="informal">Intercepts each emission on the source and runs a
             * function, but returns an output which is identical to the source as long as errors don't occur.</span>
             *
             * <img src="./img/do.png" width="100%">
             *
             * Returns a mirrored Observable of the source Observable, but modified so that
             * the provided Observer is called to perform a side effect for every value,
             * error, and completion emitted by the source. Any errors that are thrown in
             * the aforementioned Observer or handlers are safely sent down the error path
             * of the output Observable.
             *
             * This operator is useful for debugging your Observables for the correct values
             * or performing other side effects.
             *
             * Note: this is different to a `subscribe` on the Observable. If the Observable
             * returned by `do` is not subscribed, the side effects specified by the
             * Observer will never happen. `do` therefore simply spies on existing
             * execution, it does not trigger an execution to happen like `subscribe` does.
             *
             * @example <caption>Map every click to the clientX position of that click, while also logging the click event</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var positions = clicks
             *   .do(ev => console.log(ev))
             *   .map(ev => ev.clientX);
             * positions.subscribe(x => console.log(x));
             *
             * @see {@link map}
             * @see {@link subscribe}
             *
             * @param {Observer|function} [nextOrObserver] A normal Observer object or a
             * callback for `next`.
             * @param {function} [error] Callback for errors in the source.
             * @param {function} [complete] Callback for the completion of the source.
             * @return {Observable} An Observable identical to the source, but runs the
             * specified Observer or callback(s) for each item.
             * @method do
             * @name do
             * @owner Observable
             */
            function _do(nextOrObserver, error, complete) {
                return tap_1.tap(nextOrObserver, error, complete)(this);
            }
            exports._do = _do;
//# sourceMappingURL=do.js.map

            /***/ }),
        /* 131 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            /* tslint:enable:max-line-length */
            /**
             * Perform a side effect for every emission on the source Observable, but return
             * an Observable that is identical to the source.
             *
             * <span class="informal">Intercepts each emission on the source and runs a
             * function, but returns an output which is identical to the source as long as errors don't occur.</span>
             *
             * <img src="./img/do.png" width="100%">
             *
             * Returns a mirrored Observable of the source Observable, but modified so that
             * the provided Observer is called to perform a side effect for every value,
             * error, and completion emitted by the source. Any errors that are thrown in
             * the aforementioned Observer or handlers are safely sent down the error path
             * of the output Observable.
             *
             * This operator is useful for debugging your Observables for the correct values
             * or performing other side effects.
             *
             * Note: this is different to a `subscribe` on the Observable. If the Observable
             * returned by `do` is not subscribed, the side effects specified by the
             * Observer will never happen. `do` therefore simply spies on existing
             * execution, it does not trigger an execution to happen like `subscribe` does.
             *
             * @example <caption>Map every click to the clientX position of that click, while also logging the click event</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var positions = clicks
             *   .do(ev => console.log(ev))
             *   .map(ev => ev.clientX);
             * positions.subscribe(x => console.log(x));
             *
             * @see {@link map}
             * @see {@link subscribe}
             *
             * @param {Observer|function} [nextOrObserver] A normal Observer object or a
             * callback for `next`.
             * @param {function} [error] Callback for errors in the source.
             * @param {function} [complete] Callback for the completion of the source.
             * @return {Observable} An Observable identical to the source, but runs the
             * specified Observer or callback(s) for each item.
             * @name tap
             */
            function tap(nextOrObserver, error, complete) {
                return function tapOperatorFunction(source) {
                    return source.lift(new DoOperator(nextOrObserver, error, complete));
                };
            }
            exports.tap = tap;
            var DoOperator = (function () {
                function DoOperator(nextOrObserver, error, complete) {
                    this.nextOrObserver = nextOrObserver;
                    this.error = error;
                    this.complete = complete;
                }
                DoOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new DoSubscriber(subscriber, this.nextOrObserver, this.error, this.complete));
                };
                return DoOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var DoSubscriber = (function (_super) {
                __extends(DoSubscriber, _super);
                function DoSubscriber(destination, nextOrObserver, error, complete) {
                    _super.call(this, destination);
                    var safeSubscriber = new Subscriber_1.Subscriber(nextOrObserver, error, complete);
                    safeSubscriber.syncErrorThrowable = true;
                    this.add(safeSubscriber);
                    this.safeSubscriber = safeSubscriber;
                }
                DoSubscriber.prototype._next = function (value) {
                    var safeSubscriber = this.safeSubscriber;
                    safeSubscriber.next(value);
                    if (safeSubscriber.syncErrorThrown) {
                        this.destination.error(safeSubscriber.syncErrorValue);
                    }
                    else {
                        this.destination.next(value);
                    }
                };
                DoSubscriber.prototype._error = function (err) {
                    var safeSubscriber = this.safeSubscriber;
                    safeSubscriber.error(err);
                    if (safeSubscriber.syncErrorThrown) {
                        this.destination.error(safeSubscriber.syncErrorValue);
                    }
                    else {
                        this.destination.error(err);
                    }
                };
                DoSubscriber.prototype._complete = function () {
                    var safeSubscriber = this.safeSubscriber;
                    safeSubscriber.complete();
                    if (safeSubscriber.syncErrorThrown) {
                        this.destination.error(safeSubscriber.syncErrorValue);
                    }
                    else {
                        this.destination.complete();
                    }
                };
                return DoSubscriber;
            }(Subscriber_1.Subscriber));
//# sourceMappingURL=tap.js.map

            /***/ }),
        /* 132 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var async_1 = __webpack_require__(26);
            var debounceTime_1 = __webpack_require__(137);
            /**
             * Emits a value from the source Observable only after a particular time span
             * has passed without another source emission.
             *
             * <span class="informal">It's like {@link delay}, but passes only the most
             * recent value from each burst of emissions.</span>
             *
             * <img src="./img/debounceTime.png" width="100%">
             *
             * `debounceTime` delays values emitted by the source Observable, but drops
             * previous pending delayed emissions if a new value arrives on the source
             * Observable. This operator keeps track of the most recent value from the
             * source Observable, and emits that only when `dueTime` enough time has passed
             * without any other value appearing on the source Observable. If a new value
             * appears before `dueTime` silence occurs, the previous value will be dropped
             * and will not be emitted on the output Observable.
             *
             * This is a rate-limiting operator, because it is impossible for more than one
             * value to be emitted in any time window of duration `dueTime`, but it is also
             * a delay-like operator since output emissions do not occur at the same time as
             * they did on the source Observable. Optionally takes a {@link IScheduler} for
             * managing timers.
             *
             * @example <caption>Emit the most recent click after a burst of clicks</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var result = clicks.debounceTime(1000);
             * result.subscribe(x => console.log(x));
             *
             * @see {@link auditTime}
             * @see {@link debounce}
             * @see {@link delay}
             * @see {@link sampleTime}
             * @see {@link throttleTime}
             *
             * @param {number} dueTime The timeout duration in milliseconds (or the time
             * unit determined internally by the optional `scheduler`) for the window of
             * time required to wait for emission silence before emitting the most recent
             * source value.
             * @param {Scheduler} [scheduler=async] The {@link IScheduler} to use for
             * managing the timers that handle the timeout for each value.
             * @return {Observable} An Observable that delays the emissions of the source
             * Observable by the specified `dueTime`, and may drop some values if they occur
             * too frequently.
             * @method debounceTime
             * @owner Observable
             */
            function debounceTime(dueTime, scheduler) {
                if (scheduler === void 0) { scheduler = async_1.async; }
                return debounceTime_1.debounceTime(dueTime, scheduler)(this);
            }
            exports.debounceTime = debounceTime;
//# sourceMappingURL=debounceTime.js.map

            /***/ }),
        /* 133 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var root_1 = __webpack_require__(4);
            var Action_1 = __webpack_require__(134);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var AsyncAction = (function (_super) {
                __extends(AsyncAction, _super);
                function AsyncAction(scheduler, work) {
                    _super.call(this, scheduler, work);
                    this.scheduler = scheduler;
                    this.work = work;
                    this.pending = false;
                }
                AsyncAction.prototype.schedule = function (state, delay) {
                    if (delay === void 0) { delay = 0; }
                    if (this.closed) {
                        return this;
                    }
                    // Always replace the current state with the new state.
                    this.state = state;
                    // Set the pending flag indicating that this action has been scheduled, or
                    // has recursively rescheduled itself.
                    this.pending = true;
                    var id = this.id;
                    var scheduler = this.scheduler;
                    //
                    // Important implementation note:
                    //
                    // Actions only execute once by default, unless rescheduled from within the
                    // scheduled callback. This allows us to implement single and repeat
                    // actions via the same code path, without adding API surface area, as well
                    // as mimic traditional recursion but across asynchronous boundaries.
                    //
                    // However, JS runtimes and timers distinguish between intervals achieved by
                    // serial `setTimeout` calls vs. a single `setInterval` call. An interval of
                    // serial `setTimeout` calls can be individually delayed, which delays
                    // scheduling the next `setTimeout`, and so on. `setInterval` attempts to
                    // guarantee the interval callback will be invoked more precisely to the
                    // interval period, regardless of load.
                    //
                    // Therefore, we use `setInterval` to schedule single and repeat actions.
                    // If the action reschedules itself with the same delay, the interval is not
                    // canceled. If the action doesn't reschedule, or reschedules with a
                    // different delay, the interval will be canceled after scheduled callback
                    // execution.
                    //
                    if (id != null) {
                        this.id = this.recycleAsyncId(scheduler, id, delay);
                    }
                    this.delay = delay;
                    // If this action has already an async Id, don't request a new one.
                    this.id = this.id || this.requestAsyncId(scheduler, this.id, delay);
                    return this;
                };
                AsyncAction.prototype.requestAsyncId = function (scheduler, id, delay) {
                    if (delay === void 0) { delay = 0; }
                    return root_1.root.setInterval(scheduler.flush.bind(scheduler, this), delay);
                };
                AsyncAction.prototype.recycleAsyncId = function (scheduler, id, delay) {
                    if (delay === void 0) { delay = 0; }
                    // If this action is rescheduled with the same delay time, don't clear the interval id.
                    if (delay !== null && this.delay === delay && this.pending === false) {
                        return id;
                    }
                    // Otherwise, if the action's delay time is different from the current delay,
                    // or the action has been rescheduled before it's executed, clear the interval id
                    return root_1.root.clearInterval(id) && undefined || undefined;
                };
                /**
                 * Immediately executes this action and the `work` it contains.
                 * @return {any}
                 */
                AsyncAction.prototype.execute = function (state, delay) {
                    if (this.closed) {
                        return new Error('executing a cancelled action');
                    }
                    this.pending = false;
                    var error = this._execute(state, delay);
                    if (error) {
                        return error;
                    }
                    else if (this.pending === false && this.id != null) {
                        // Dequeue if the action didn't reschedule itself. Don't call
                        // unsubscribe(), because the action could reschedule later.
                        // For example:
                        // ```
                        // scheduler.schedule(function doWork(counter) {
                        //   /* ... I'm a busy worker bee ... */
                        //   var originalAction = this;
                        //   /* wait 100ms before rescheduling the action */
                        //   setTimeout(function () {
                        //     originalAction.schedule(counter + 1);
                        //   }, 100);
                        // }, 1000);
                        // ```
                        this.id = this.recycleAsyncId(this.scheduler, this.id, null);
                    }
                };
                AsyncAction.prototype._execute = function (state, delay) {
                    var errored = false;
                    var errorValue = undefined;
                    try {
                        this.work(state);
                    }
                    catch (e) {
                        errored = true;
                        errorValue = !!e && e || new Error(e);
                    }
                    if (errored) {
                        this.unsubscribe();
                        return errorValue;
                    }
                };
                AsyncAction.prototype._unsubscribe = function () {
                    var id = this.id;
                    var scheduler = this.scheduler;
                    var actions = scheduler.actions;
                    var index = actions.indexOf(this);
                    this.work = null;
                    this.state = null;
                    this.pending = false;
                    this.scheduler = null;
                    if (index !== -1) {
                        actions.splice(index, 1);
                    }
                    if (id != null) {
                        this.id = this.recycleAsyncId(scheduler, id, null);
                    }
                    this.delay = null;
                };
                return AsyncAction;
            }(Action_1.Action));
            exports.AsyncAction = AsyncAction;
//# sourceMappingURL=AsyncAction.js.map

            /***/ }),
        /* 134 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscription_1 = __webpack_require__(9);
            /**
             * A unit of work to be executed in a {@link Scheduler}. An action is typically
             * created from within a Scheduler and an RxJS user does not need to concern
             * themselves about creating and manipulating an Action.
             *
             * ```ts
             * class Action<T> extends Subscription {
             *   new (scheduler: Scheduler, work: (state?: T) => void);
             *   schedule(state?: T, delay: number = 0): Subscription;
             * }
             * ```
             *
             * @class Action<T>
             */
            var Action = (function (_super) {
                __extends(Action, _super);
                function Action(scheduler, work) {
                    _super.call(this);
                }
                /**
                 * Schedules this action on its parent Scheduler for execution. May be passed
                 * some context object, `state`. May happen at some point in the future,
                 * according to the `delay` parameter, if specified.
                 * @param {T} [state] Some contextual data that the `work` function uses when
                 * called by the Scheduler.
                 * @param {number} [delay] Time to wait before executing the work, where the
                 * time unit is implicit and defined by the Scheduler.
                 * @return {void}
                 */
                Action.prototype.schedule = function (state, delay) {
                    if (delay === void 0) { delay = 0; }
                    return this;
                };
                return Action;
            }(Subscription_1.Subscription));
            exports.Action = Action;
//# sourceMappingURL=Action.js.map

            /***/ }),
        /* 135 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Scheduler_1 = __webpack_require__(136);
            var AsyncScheduler = (function (_super) {
                __extends(AsyncScheduler, _super);
                function AsyncScheduler() {
                    _super.apply(this, arguments);
                    this.actions = [];
                    /**
                     * A flag to indicate whether the Scheduler is currently executing a batch of
                     * queued actions.
                     * @type {boolean}
                     */
                    this.active = false;
                    /**
                     * An internal ID used to track the latest asynchronous task such as those
                     * coming from `setTimeout`, `setInterval`, `requestAnimationFrame`, and
                     * others.
                     * @type {any}
                     */
                    this.scheduled = undefined;
                }
                AsyncScheduler.prototype.flush = function (action) {
                    var actions = this.actions;
                    if (this.active) {
                        actions.push(action);
                        return;
                    }
                    var error;
                    this.active = true;
                    do {
                        if (error = action.execute(action.state, action.delay)) {
                            break;
                        }
                    } while (action = actions.shift()); // exhaust the scheduler queue
                    this.active = false;
                    if (error) {
                        while (action = actions.shift()) {
                            action.unsubscribe();
                        }
                        throw error;
                    }
                };
                return AsyncScheduler;
            }(Scheduler_1.Scheduler));
            exports.AsyncScheduler = AsyncScheduler;
//# sourceMappingURL=AsyncScheduler.js.map

            /***/ }),
        /* 136 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            /**
             * An execution context and a data structure to order tasks and schedule their
             * execution. Provides a notion of (potentially virtual) time, through the
             * `now()` getter method.
             *
             * Each unit of work in a Scheduler is called an {@link Action}.
             *
             * ```ts
             * class Scheduler {
             *   now(): number;
             *   schedule(work, delay?, state?): Subscription;
             * }
             * ```
             *
             * @class Scheduler
             */
            var Scheduler = (function () {
                function Scheduler(SchedulerAction, now) {
                    if (now === void 0) { now = Scheduler.now; }
                    this.SchedulerAction = SchedulerAction;
                    this.now = now;
                }
                /**
                 * Schedules a function, `work`, for execution. May happen at some point in
                 * the future, according to the `delay` parameter, if specified. May be passed
                 * some context object, `state`, which will be passed to the `work` function.
                 *
                 * The given arguments will be processed an stored as an Action object in a
                 * queue of actions.
                 *
                 * @param {function(state: ?T): ?Subscription} work A function representing a
                 * task, or some unit of work to be executed by the Scheduler.
                 * @param {number} [delay] Time to wait before executing the work, where the
                 * time unit is implicit and defined by the Scheduler itself.
                 * @param {T} [state] Some contextual data that the `work` function uses when
                 * called by the Scheduler.
                 * @return {Subscription} A subscription in order to be able to unsubscribe
                 * the scheduled work.
                 */
                Scheduler.prototype.schedule = function (work, delay, state) {
                    if (delay === void 0) { delay = 0; }
                    return new this.SchedulerAction(this, work).schedule(state, delay);
                };
                Scheduler.now = Date.now ? Date.now : function () { return +new Date(); };
                return Scheduler;
            }());
            exports.Scheduler = Scheduler;
//# sourceMappingURL=Scheduler.js.map

            /***/ }),
        /* 137 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            var async_1 = __webpack_require__(26);
            /**
             * Emits a value from the source Observable only after a particular time span
             * has passed without another source emission.
             *
             * <span class="informal">It's like {@link delay}, but passes only the most
             * recent value from each burst of emissions.</span>
             *
             * <img src="./img/debounceTime.png" width="100%">
             *
             * `debounceTime` delays values emitted by the source Observable, but drops
             * previous pending delayed emissions if a new value arrives on the source
             * Observable. This operator keeps track of the most recent value from the
             * source Observable, and emits that only when `dueTime` enough time has passed
             * without any other value appearing on the source Observable. If a new value
             * appears before `dueTime` silence occurs, the previous value will be dropped
             * and will not be emitted on the output Observable.
             *
             * This is a rate-limiting operator, because it is impossible for more than one
             * value to be emitted in any time window of duration `dueTime`, but it is also
             * a delay-like operator since output emissions do not occur at the same time as
             * they did on the source Observable. Optionally takes a {@link IScheduler} for
             * managing timers.
             *
             * @example <caption>Emit the most recent click after a burst of clicks</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var result = clicks.debounceTime(1000);
             * result.subscribe(x => console.log(x));
             *
             * @see {@link auditTime}
             * @see {@link debounce}
             * @see {@link delay}
             * @see {@link sampleTime}
             * @see {@link throttleTime}
             *
             * @param {number} dueTime The timeout duration in milliseconds (or the time
             * unit determined internally by the optional `scheduler`) for the window of
             * time required to wait for emission silence before emitting the most recent
             * source value.
             * @param {Scheduler} [scheduler=async] The {@link IScheduler} to use for
             * managing the timers that handle the timeout for each value.
             * @return {Observable} An Observable that delays the emissions of the source
             * Observable by the specified `dueTime`, and may drop some values if they occur
             * too frequently.
             * @method debounceTime
             * @owner Observable
             */
            function debounceTime(dueTime, scheduler) {
                if (scheduler === void 0) { scheduler = async_1.async; }
                return function (source) { return source.lift(new DebounceTimeOperator(dueTime, scheduler)); };
            }
            exports.debounceTime = debounceTime;
            var DebounceTimeOperator = (function () {
                function DebounceTimeOperator(dueTime, scheduler) {
                    this.dueTime = dueTime;
                    this.scheduler = scheduler;
                }
                DebounceTimeOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new DebounceTimeSubscriber(subscriber, this.dueTime, this.scheduler));
                };
                return DebounceTimeOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var DebounceTimeSubscriber = (function (_super) {
                __extends(DebounceTimeSubscriber, _super);
                function DebounceTimeSubscriber(destination, dueTime, scheduler) {
                    _super.call(this, destination);
                    this.dueTime = dueTime;
                    this.scheduler = scheduler;
                    this.debouncedSubscription = null;
                    this.lastValue = null;
                    this.hasValue = false;
                }
                DebounceTimeSubscriber.prototype._next = function (value) {
                    this.clearDebounce();
                    this.lastValue = value;
                    this.hasValue = true;
                    this.add(this.debouncedSubscription = this.scheduler.schedule(dispatchNext, this.dueTime, this));
                };
                DebounceTimeSubscriber.prototype._complete = function () {
                    this.debouncedNext();
                    this.destination.complete();
                };
                DebounceTimeSubscriber.prototype.debouncedNext = function () {
                    this.clearDebounce();
                    if (this.hasValue) {
                        this.destination.next(this.lastValue);
                        this.lastValue = null;
                        this.hasValue = false;
                    }
                };
                DebounceTimeSubscriber.prototype.clearDebounce = function () {
                    var debouncedSubscription = this.debouncedSubscription;
                    if (debouncedSubscription !== null) {
                        this.remove(debouncedSubscription);
                        debouncedSubscription.unsubscribe();
                        this.debouncedSubscription = null;
                    }
                };
                return DebounceTimeSubscriber;
            }(Subscriber_1.Subscriber));
            function dispatchNext(subscriber) {
                subscriber.debouncedNext();
            }
//# sourceMappingURL=debounceTime.js.map

            /***/ }),
        /* 138 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var filter_1 = __webpack_require__(139);
            /* tslint:enable:max-line-length */
            /**
             * Filter items emitted by the source Observable by only emitting those that
             * satisfy a specified predicate.
             *
             * <span class="informal">Like
             * [Array.prototype.filter()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter),
             * it only emits a value from the source if it passes a criterion function.</span>
             *
             * <img src="./img/filter.png" width="100%">
             *
             * Similar to the well-known `Array.prototype.filter` method, this operator
             * takes values from the source Observable, passes them through a `predicate`
             * function and only emits those values that yielded `true`.
             *
             * @example <caption>Emit only click events whose target was a DIV element</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var clicksOnDivs = clicks.filter(ev => ev.target.tagName === 'DIV');
             * clicksOnDivs.subscribe(x => console.log(x));
             *
             * @see {@link distinct}
             * @see {@link distinctUntilChanged}
             * @see {@link distinctUntilKeyChanged}
             * @see {@link ignoreElements}
             * @see {@link partition}
             * @see {@link skip}
             *
             * @param {function(value: T, index: number): boolean} predicate A function that
             * evaluates each value emitted by the source Observable. If it returns `true`,
             * the value is emitted, if `false` the value is not passed to the output
             * Observable. The `index` parameter is the number `i` for the i-th source
             * emission that has happened since the subscription, starting from the number
             * `0`.
             * @param {any} [thisArg] An optional argument to determine the value of `this`
             * in the `predicate` function.
             * @return {Observable} An Observable of values from the source that were
             * allowed by the `predicate` function.
             * @method filter
             * @owner Observable
             */
            function filter(predicate, thisArg) {
                return filter_1.filter(predicate, thisArg)(this);
            }
            exports.filter = filter;
//# sourceMappingURL=filter.js.map

            /***/ }),
        /* 139 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            /* tslint:enable:max-line-length */
            /**
             * Filter items emitted by the source Observable by only emitting those that
             * satisfy a specified predicate.
             *
             * <span class="informal">Like
             * [Array.prototype.filter()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter),
             * it only emits a value from the source if it passes a criterion function.</span>
             *
             * <img src="./img/filter.png" width="100%">
             *
             * Similar to the well-known `Array.prototype.filter` method, this operator
             * takes values from the source Observable, passes them through a `predicate`
             * function and only emits those values that yielded `true`.
             *
             * @example <caption>Emit only click events whose target was a DIV element</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var clicksOnDivs = clicks.filter(ev => ev.target.tagName === 'DIV');
             * clicksOnDivs.subscribe(x => console.log(x));
             *
             * @see {@link distinct}
             * @see {@link distinctUntilChanged}
             * @see {@link distinctUntilKeyChanged}
             * @see {@link ignoreElements}
             * @see {@link partition}
             * @see {@link skip}
             *
             * @param {function(value: T, index: number): boolean} predicate A function that
             * evaluates each value emitted by the source Observable. If it returns `true`,
             * the value is emitted, if `false` the value is not passed to the output
             * Observable. The `index` parameter is the number `i` for the i-th source
             * emission that has happened since the subscription, starting from the number
             * `0`.
             * @param {any} [thisArg] An optional argument to determine the value of `this`
             * in the `predicate` function.
             * @return {Observable} An Observable of values from the source that were
             * allowed by the `predicate` function.
             * @method filter
             * @owner Observable
             */
            function filter(predicate, thisArg) {
                return function filterOperatorFunction(source) {
                    return source.lift(new FilterOperator(predicate, thisArg));
                };
            }
            exports.filter = filter;
            var FilterOperator = (function () {
                function FilterOperator(predicate, thisArg) {
                    this.predicate = predicate;
                    this.thisArg = thisArg;
                }
                FilterOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new FilterSubscriber(subscriber, this.predicate, this.thisArg));
                };
                return FilterOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var FilterSubscriber = (function (_super) {
                __extends(FilterSubscriber, _super);
                function FilterSubscriber(destination, predicate, thisArg) {
                    _super.call(this, destination);
                    this.predicate = predicate;
                    this.thisArg = thisArg;
                    this.count = 0;
                }
                // the try catch block below is left specifically for
                // optimization and perf reasons. a tryCatcher is not necessary here.
                FilterSubscriber.prototype._next = function (value) {
                    var result;
                    try {
                        result = this.predicate.call(this.thisArg, value, this.count++);
                    }
                    catch (err) {
                        this.destination.error(err);
                        return;
                    }
                    if (result) {
                        this.destination.next(value);
                    }
                };
                return FilterSubscriber;
            }(Subscriber_1.Subscriber));
//# sourceMappingURL=filter.js.map

            /***/ }),
        /* 140 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var map_1 = __webpack_require__(66);
            /**
             * Applies a given `project` function to each value emitted by the source
             * Observable, and emits the resulting values as an Observable.
             *
             * <span class="informal">Like [Array.prototype.map()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map),
             * it passes each source value through a transformation function to get
             * corresponding output values.</span>
             *
             * <img src="./img/map.png" width="100%">
             *
             * Similar to the well known `Array.prototype.map` function, this operator
             * applies a projection to each value and emits that projection in the output
             * Observable.
             *
             * @example <caption>Map every click to the clientX position of that click</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var positions = clicks.map(ev => ev.clientX);
             * positions.subscribe(x => console.log(x));
             *
             * @see {@link mapTo}
             * @see {@link pluck}
             *
             * @param {function(value: T, index: number): R} project The function to apply
             * to each `value` emitted by the source Observable. The `index` parameter is
             * the number `i` for the i-th emission that has happened since the
             * subscription, starting from the number `0`.
             * @param {any} [thisArg] An optional argument to define what `this` is in the
             * `project` function.
             * @return {Observable<R>} An Observable that emits the values from the source
             * Observable transformed by the given `project` function.
             * @method map
             * @owner Observable
             */
            function map(project, thisArg) {
                return map_1.map(project, thisArg)(this);
            }
            exports.map = map;
//# sourceMappingURL=map.js.map

            /***/ }),
        /* 141 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var mapTo_1 = __webpack_require__(142);
            /**
             * Emits the given constant value on the output Observable every time the source
             * Observable emits a value.
             *
             * <span class="informal">Like {@link map}, but it maps every source value to
             * the same output value every time.</span>
             *
             * <img src="./img/mapTo.png" width="100%">
             *
             * Takes a constant `value` as argument, and emits that whenever the source
             * Observable emits a value. In other words, ignores the actual source value,
             * and simply uses the emission moment to know when to emit the given `value`.
             *
             * @example <caption>Map every click to the string 'Hi'</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var greetings = clicks.mapTo('Hi');
             * greetings.subscribe(x => console.log(x));
             *
             * @see {@link map}
             *
             * @param {any} value The value to map each source value to.
             * @return {Observable} An Observable that emits the given `value` every time
             * the source Observable emits something.
             * @method mapTo
             * @owner Observable
             */
            function mapTo(value) {
                return mapTo_1.mapTo(value)(this);
            }
            exports.mapTo = mapTo;
//# sourceMappingURL=mapTo.js.map

            /***/ }),
        /* 142 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            /**
             * Emits the given constant value on the output Observable every time the source
             * Observable emits a value.
             *
             * <span class="informal">Like {@link map}, but it maps every source value to
             * the same output value every time.</span>
             *
             * <img src="./img/mapTo.png" width="100%">
             *
             * Takes a constant `value` as argument, and emits that whenever the source
             * Observable emits a value. In other words, ignores the actual source value,
             * and simply uses the emission moment to know when to emit the given `value`.
             *
             * @example <caption>Map every click to the string 'Hi'</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var greetings = clicks.mapTo('Hi');
             * greetings.subscribe(x => console.log(x));
             *
             * @see {@link map}
             *
             * @param {any} value The value to map each source value to.
             * @return {Observable} An Observable that emits the given `value` every time
             * the source Observable emits something.
             * @method mapTo
             * @owner Observable
             */
            function mapTo(value) {
                return function (source) { return source.lift(new MapToOperator(value)); };
            }
            exports.mapTo = mapTo;
            var MapToOperator = (function () {
                function MapToOperator(value) {
                    this.value = value;
                }
                MapToOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new MapToSubscriber(subscriber, this.value));
                };
                return MapToOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var MapToSubscriber = (function (_super) {
                __extends(MapToSubscriber, _super);
                function MapToSubscriber(destination, value) {
                    _super.call(this, destination);
                    this.value = value;
                }
                MapToSubscriber.prototype._next = function (x) {
                    this.destination.next(this.value);
                };
                return MapToSubscriber;
            }(Subscriber_1.Subscriber));
//# sourceMappingURL=mapTo.js.map

            /***/ }),
        /* 143 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var pairwise_1 = __webpack_require__(144);
            /**
             * Groups pairs of consecutive emissions together and emits them as an array of
             * two values.
             *
             * <span class="informal">Puts the current value and previous value together as
             * an array, and emits that.</span>
             *
             * <img src="./img/pairwise.png" width="100%">
             *
             * The Nth emission from the source Observable will cause the output Observable
             * to emit an array [(N-1)th, Nth] of the previous and the current value, as a
             * pair. For this reason, `pairwise` emits on the second and subsequent
             * emissions from the source Observable, but not on the first emission, because
             * there is no previous value in that case.
             *
             * @example <caption>On every click (starting from the second), emit the relative distance to the previous click</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var pairs = clicks.pairwise();
             * var distance = pairs.map(pair => {
             *   var x0 = pair[0].clientX;
             *   var y0 = pair[0].clientY;
             *   var x1 = pair[1].clientX;
             *   var y1 = pair[1].clientY;
             *   return Math.sqrt(Math.pow(x0 - x1, 2) + Math.pow(y0 - y1, 2));
             * });
             * distance.subscribe(x => console.log(x));
             *
             * @see {@link buffer}
             * @see {@link bufferCount}
             *
             * @return {Observable<Array<T>>} An Observable of pairs (as arrays) of
             * consecutive values from the source Observable.
             * @method pairwise
             * @owner Observable
             */
            function pairwise() {
                return pairwise_1.pairwise()(this);
            }
            exports.pairwise = pairwise;
//# sourceMappingURL=pairwise.js.map

            /***/ }),
        /* 144 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            /**
             * Groups pairs of consecutive emissions together and emits them as an array of
             * two values.
             *
             * <span class="informal">Puts the current value and previous value together as
             * an array, and emits that.</span>
             *
             * <img src="./img/pairwise.png" width="100%">
             *
             * The Nth emission from the source Observable will cause the output Observable
             * to emit an array [(N-1)th, Nth] of the previous and the current value, as a
             * pair. For this reason, `pairwise` emits on the second and subsequent
             * emissions from the source Observable, but not on the first emission, because
             * there is no previous value in that case.
             *
             * @example <caption>On every click (starting from the second), emit the relative distance to the previous click</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var pairs = clicks.pairwise();
             * var distance = pairs.map(pair => {
             *   var x0 = pair[0].clientX;
             *   var y0 = pair[0].clientY;
             *   var x1 = pair[1].clientX;
             *   var y1 = pair[1].clientY;
             *   return Math.sqrt(Math.pow(x0 - x1, 2) + Math.pow(y0 - y1, 2));
             * });
             * distance.subscribe(x => console.log(x));
             *
             * @see {@link buffer}
             * @see {@link bufferCount}
             *
             * @return {Observable<Array<T>>} An Observable of pairs (as arrays) of
             * consecutive values from the source Observable.
             * @method pairwise
             * @owner Observable
             */
            function pairwise() {
                return function (source) { return source.lift(new PairwiseOperator()); };
            }
            exports.pairwise = pairwise;
            var PairwiseOperator = (function () {
                function PairwiseOperator() {
                }
                PairwiseOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new PairwiseSubscriber(subscriber));
                };
                return PairwiseOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var PairwiseSubscriber = (function (_super) {
                __extends(PairwiseSubscriber, _super);
                function PairwiseSubscriber(destination) {
                    _super.call(this, destination);
                    this.hasPrev = false;
                }
                PairwiseSubscriber.prototype._next = function (value) {
                    if (this.hasPrev) {
                        this.destination.next([this.prev, value]);
                    }
                    else {
                        this.hasPrev = true;
                    }
                    this.prev = value;
                };
                return PairwiseSubscriber;
            }(Subscriber_1.Subscriber));
//# sourceMappingURL=pairwise.js.map

            /***/ }),
        /* 145 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var repeatWhen_1 = __webpack_require__(146);
            /**
             * Returns an Observable that mirrors the source Observable with the exception of a `complete`. If the source
             * Observable calls `complete`, this method will emit to the Observable returned from `notifier`. If that Observable
             * calls `complete` or `error`, then this method will call `complete` or `error` on the child subscription. Otherwise
             * this method will resubscribe to the source Observable.
             *
             * <img src="./img/repeatWhen.png" width="100%">
             *
             * @param {function(notifications: Observable): Observable} notifier - Receives an Observable of notifications with
             * which a user can `complete` or `error`, aborting the repetition.
             * @return {Observable} The source Observable modified with repeat logic.
             * @method repeatWhen
             * @owner Observable
             */
            function repeatWhen(notifier) {
                return repeatWhen_1.repeatWhen(notifier)(this);
            }
            exports.repeatWhen = repeatWhen;
//# sourceMappingURL=repeatWhen.js.map

            /***/ }),
        /* 146 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subject_1 = __webpack_require__(24);
            var tryCatch_1 = __webpack_require__(40);
            var errorObject_1 = __webpack_require__(23);
            var OuterSubscriber_1 = __webpack_require__(5);
            var subscribeToResult_1 = __webpack_require__(6);
            /**
             * Returns an Observable that mirrors the source Observable with the exception of a `complete`. If the source
             * Observable calls `complete`, this method will emit to the Observable returned from `notifier`. If that Observable
             * calls `complete` or `error`, then this method will call `complete` or `error` on the child subscription. Otherwise
             * this method will resubscribe to the source Observable.
             *
             * <img src="./img/repeatWhen.png" width="100%">
             *
             * @param {function(notifications: Observable): Observable} notifier - Receives an Observable of notifications with
             * which a user can `complete` or `error`, aborting the repetition.
             * @return {Observable} The source Observable modified with repeat logic.
             * @method repeatWhen
             * @owner Observable
             */
            function repeatWhen(notifier) {
                return function (source) { return source.lift(new RepeatWhenOperator(notifier)); };
            }
            exports.repeatWhen = repeatWhen;
            var RepeatWhenOperator = (function () {
                function RepeatWhenOperator(notifier) {
                    this.notifier = notifier;
                }
                RepeatWhenOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new RepeatWhenSubscriber(subscriber, this.notifier, source));
                };
                return RepeatWhenOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var RepeatWhenSubscriber = (function (_super) {
                __extends(RepeatWhenSubscriber, _super);
                function RepeatWhenSubscriber(destination, notifier, source) {
                    _super.call(this, destination);
                    this.notifier = notifier;
                    this.source = source;
                    this.sourceIsBeingSubscribedTo = true;
                }
                RepeatWhenSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {
                    this.sourceIsBeingSubscribedTo = true;
                    this.source.subscribe(this);
                };
                RepeatWhenSubscriber.prototype.notifyComplete = function (innerSub) {
                    if (this.sourceIsBeingSubscribedTo === false) {
                        return _super.prototype.complete.call(this);
                    }
                };
                RepeatWhenSubscriber.prototype.complete = function () {
                    this.sourceIsBeingSubscribedTo = false;
                    if (!this.isStopped) {
                        if (!this.retries) {
                            this.subscribeToRetries();
                        }
                        else if (this.retriesSubscription.closed) {
                            return _super.prototype.complete.call(this);
                        }
                        this._unsubscribeAndRecycle();
                        this.notifications.next();
                    }
                };
                RepeatWhenSubscriber.prototype._unsubscribe = function () {
                    var _a = this, notifications = _a.notifications, retriesSubscription = _a.retriesSubscription;
                    if (notifications) {
                        notifications.unsubscribe();
                        this.notifications = null;
                    }
                    if (retriesSubscription) {
                        retriesSubscription.unsubscribe();
                        this.retriesSubscription = null;
                    }
                    this.retries = null;
                };
                RepeatWhenSubscriber.prototype._unsubscribeAndRecycle = function () {
                    var _a = this, notifications = _a.notifications, retries = _a.retries, retriesSubscription = _a.retriesSubscription;
                    this.notifications = null;
                    this.retries = null;
                    this.retriesSubscription = null;
                    _super.prototype._unsubscribeAndRecycle.call(this);
                    this.notifications = notifications;
                    this.retries = retries;
                    this.retriesSubscription = retriesSubscription;
                    return this;
                };
                RepeatWhenSubscriber.prototype.subscribeToRetries = function () {
                    this.notifications = new Subject_1.Subject();
                    var retries = tryCatch_1.tryCatch(this.notifier)(this.notifications);
                    if (retries === errorObject_1.errorObject) {
                        return _super.prototype.complete.call(this);
                    }
                    this.retries = retries;
                    this.retriesSubscription = subscribeToResult_1.subscribeToResult(this, retries);
                };
                return RepeatWhenSubscriber;
            }(OuterSubscriber_1.OuterSubscriber));
//# sourceMappingURL=repeatWhen.js.map

            /***/ }),
        /* 147 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var sample_1 = __webpack_require__(148);
            /**
             * Emits the most recently emitted value from the source Observable whenever
             * another Observable, the `notifier`, emits.
             *
             * <span class="informal">It's like {@link sampleTime}, but samples whenever
             * the `notifier` Observable emits something.</span>
             *
             * <img src="./img/sample.png" width="100%">
             *
             * Whenever the `notifier` Observable emits a value or completes, `sample`
             * looks at the source Observable and emits whichever value it has most recently
             * emitted since the previous sampling, unless the source has not emitted
             * anything since the previous sampling. The `notifier` is subscribed to as soon
             * as the output Observable is subscribed.
             *
             * @example <caption>On every click, sample the most recent "seconds" timer</caption>
             * var seconds = Rx.Observable.interval(1000);
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var result = seconds.sample(clicks);
             * result.subscribe(x => console.log(x));
             *
             * @see {@link audit}
             * @see {@link debounce}
             * @see {@link sampleTime}
             * @see {@link throttle}
             *
             * @param {Observable<any>} notifier The Observable to use for sampling the
             * source Observable.
             * @return {Observable<T>} An Observable that emits the results of sampling the
             * values emitted by the source Observable whenever the notifier Observable
             * emits value or completes.
             * @method sample
             * @owner Observable
             */
            function sample(notifier) {
                return sample_1.sample(notifier)(this);
            }
            exports.sample = sample;
//# sourceMappingURL=sample.js.map

            /***/ }),
        /* 148 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var OuterSubscriber_1 = __webpack_require__(5);
            var subscribeToResult_1 = __webpack_require__(6);
            /**
             * Emits the most recently emitted value from the source Observable whenever
             * another Observable, the `notifier`, emits.
             *
             * <span class="informal">It's like {@link sampleTime}, but samples whenever
             * the `notifier` Observable emits something.</span>
             *
             * <img src="./img/sample.png" width="100%">
             *
             * Whenever the `notifier` Observable emits a value or completes, `sample`
             * looks at the source Observable and emits whichever value it has most recently
             * emitted since the previous sampling, unless the source has not emitted
             * anything since the previous sampling. The `notifier` is subscribed to as soon
             * as the output Observable is subscribed.
             *
             * @example <caption>On every click, sample the most recent "seconds" timer</caption>
             * var seconds = Rx.Observable.interval(1000);
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var result = seconds.sample(clicks);
             * result.subscribe(x => console.log(x));
             *
             * @see {@link audit}
             * @see {@link debounce}
             * @see {@link sampleTime}
             * @see {@link throttle}
             *
             * @param {Observable<any>} notifier The Observable to use for sampling the
             * source Observable.
             * @return {Observable<T>} An Observable that emits the results of sampling the
             * values emitted by the source Observable whenever the notifier Observable
             * emits value or completes.
             * @method sample
             * @owner Observable
             */
            function sample(notifier) {
                return function (source) { return source.lift(new SampleOperator(notifier)); };
            }
            exports.sample = sample;
            var SampleOperator = (function () {
                function SampleOperator(notifier) {
                    this.notifier = notifier;
                }
                SampleOperator.prototype.call = function (subscriber, source) {
                    var sampleSubscriber = new SampleSubscriber(subscriber);
                    var subscription = source.subscribe(sampleSubscriber);
                    subscription.add(subscribeToResult_1.subscribeToResult(sampleSubscriber, this.notifier));
                    return subscription;
                };
                return SampleOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var SampleSubscriber = (function (_super) {
                __extends(SampleSubscriber, _super);
                function SampleSubscriber() {
                    _super.apply(this, arguments);
                    this.hasValue = false;
                }
                SampleSubscriber.prototype._next = function (value) {
                    this.value = value;
                    this.hasValue = true;
                };
                SampleSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {
                    this.emitValue();
                };
                SampleSubscriber.prototype.notifyComplete = function () {
                    this.emitValue();
                };
                SampleSubscriber.prototype.emitValue = function () {
                    if (this.hasValue) {
                        this.hasValue = false;
                        this.destination.next(this.value);
                    }
                };
                return SampleSubscriber;
            }(OuterSubscriber_1.OuterSubscriber));
//# sourceMappingURL=sample.js.map

            /***/ }),
        /* 149 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var share_1 = __webpack_require__(150);
            /**
             * Returns a new Observable that multicasts (shares) the original Observable. As long as there is at least one
             * Subscriber this Observable will be subscribed and emitting data. When all subscribers have unsubscribed it will
             * unsubscribe from the source Observable. Because the Observable is multicasting it makes the stream `hot`.
             *
             * This behaves similarly to .publish().refCount(), with a behavior difference when the source observable emits complete.
             * .publish().refCount() will not resubscribe to the original source, however .share() will resubscribe to the original source.
             * Observable.of("test").publish().refCount() will not re-emit "test" on new subscriptions, Observable.of("test").share() will
             * re-emit "test" to new subscriptions.
             *
             * <img src="./img/share.png" width="100%">
             *
             * @return {Observable<T>} An Observable that upon connection causes the source Observable to emit items to its Observers.
             * @method share
             * @owner Observable
             */
            function share() {
                return share_1.share()(this);
            }
            exports.share = share;
            ;
//# sourceMappingURL=share.js.map

            /***/ }),
        /* 150 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var multicast_1 = __webpack_require__(151);
            var refCount_1 = __webpack_require__(67);
            var Subject_1 = __webpack_require__(24);
            function shareSubjectFactory() {
                return new Subject_1.Subject();
            }
            /**
             * Returns a new Observable that multicasts (shares) the original Observable. As long as there is at least one
             * Subscriber this Observable will be subscribed and emitting data. When all subscribers have unsubscribed it will
             * unsubscribe from the source Observable. Because the Observable is multicasting it makes the stream `hot`.
             * This is an alias for .publish().refCount().
             *
             * <img src="./img/share.png" width="100%">
             *
             * @return {Observable<T>} An Observable that upon connection causes the source Observable to emit items to its Observers.
             * @method share
             * @owner Observable
             */
            function share() {
                return function (source) { return refCount_1.refCount()(multicast_1.multicast(shareSubjectFactory)(source)); };
            }
            exports.share = share;
            ;
//# sourceMappingURL=share.js.map

            /***/ }),
        /* 151 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var ConnectableObservable_1 = __webpack_require__(152);
            /* tslint:enable:max-line-length */
            /**
             * Returns an Observable that emits the results of invoking a specified selector on items
             * emitted by a ConnectableObservable that shares a single subscription to the underlying stream.
             *
             * <img src="./img/multicast.png" width="100%">
             *
             * @param {Function|Subject} subjectOrSubjectFactory - Factory function to create an intermediate subject through
             * which the source sequence's elements will be multicast to the selector function
             * or Subject to push source elements into.
             * @param {Function} [selector] - Optional selector function that can use the multicasted source stream
             * as many times as needed, without causing multiple subscriptions to the source stream.
             * Subscribers to the given source will receive all notifications of the source from the
             * time of the subscription forward.
             * @return {Observable} An Observable that emits the results of invoking the selector
             * on the items emitted by a `ConnectableObservable` that shares a single subscription to
             * the underlying stream.
             * @method multicast
             * @owner Observable
             */
            function multicast(subjectOrSubjectFactory, selector) {
                return function multicastOperatorFunction(source) {
                    var subjectFactory;
                    if (typeof subjectOrSubjectFactory === 'function') {
                        subjectFactory = subjectOrSubjectFactory;
                    }
                    else {
                        subjectFactory = function subjectFactory() {
                            return subjectOrSubjectFactory;
                        };
                    }
                    if (typeof selector === 'function') {
                        return source.lift(new MulticastOperator(subjectFactory, selector));
                    }
                    var connectable = Object.create(source, ConnectableObservable_1.connectableObservableDescriptor);
                    connectable.source = source;
                    connectable.subjectFactory = subjectFactory;
                    return connectable;
                };
            }
            exports.multicast = multicast;
            var MulticastOperator = (function () {
                function MulticastOperator(subjectFactory, selector) {
                    this.subjectFactory = subjectFactory;
                    this.selector = selector;
                }
                MulticastOperator.prototype.call = function (subscriber, source) {
                    var selector = this.selector;
                    var subject = this.subjectFactory();
                    var subscription = selector(subject).subscribe(subscriber);
                    subscription.add(source.subscribe(subject));
                    return subscription;
                };
                return MulticastOperator;
            }());
            exports.MulticastOperator = MulticastOperator;
//# sourceMappingURL=multicast.js.map

            /***/ }),
        /* 152 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subject_1 = __webpack_require__(24);
            var Observable_1 = __webpack_require__(0);
            var Subscriber_1 = __webpack_require__(1);
            var Subscription_1 = __webpack_require__(9);
            var refCount_1 = __webpack_require__(67);
            /**
             * @class ConnectableObservable<T>
             */
            var ConnectableObservable = (function (_super) {
                __extends(ConnectableObservable, _super);
                function ConnectableObservable(source, subjectFactory) {
                    _super.call(this);
                    this.source = source;
                    this.subjectFactory = subjectFactory;
                    this._refCount = 0;
                    this._isComplete = false;
                }
                ConnectableObservable.prototype._subscribe = function (subscriber) {
                    return this.getSubject().subscribe(subscriber);
                };
                ConnectableObservable.prototype.getSubject = function () {
                    var subject = this._subject;
                    if (!subject || subject.isStopped) {
                        this._subject = this.subjectFactory();
                    }
                    return this._subject;
                };
                ConnectableObservable.prototype.connect = function () {
                    var connection = this._connection;
                    if (!connection) {
                        this._isComplete = false;
                        connection = this._connection = new Subscription_1.Subscription();
                        connection.add(this.source
                            .subscribe(new ConnectableSubscriber(this.getSubject(), this)));
                        if (connection.closed) {
                            this._connection = null;
                            connection = Subscription_1.Subscription.EMPTY;
                        }
                        else {
                            this._connection = connection;
                        }
                    }
                    return connection;
                };
                ConnectableObservable.prototype.refCount = function () {
                    return refCount_1.refCount()(this);
                };
                return ConnectableObservable;
            }(Observable_1.Observable));
            exports.ConnectableObservable = ConnectableObservable;
            var connectableProto = ConnectableObservable.prototype;
            exports.connectableObservableDescriptor = {
                operator: { value: null },
                _refCount: { value: 0, writable: true },
                _subject: { value: null, writable: true },
                _connection: { value: null, writable: true },
                _subscribe: { value: connectableProto._subscribe },
                _isComplete: { value: connectableProto._isComplete, writable: true },
                getSubject: { value: connectableProto.getSubject },
                connect: { value: connectableProto.connect },
                refCount: { value: connectableProto.refCount }
            };
            var ConnectableSubscriber = (function (_super) {
                __extends(ConnectableSubscriber, _super);
                function ConnectableSubscriber(destination, connectable) {
                    _super.call(this, destination);
                    this.connectable = connectable;
                }
                ConnectableSubscriber.prototype._error = function (err) {
                    this._unsubscribe();
                    _super.prototype._error.call(this, err);
                };
                ConnectableSubscriber.prototype._complete = function () {
                    this.connectable._isComplete = true;
                    this._unsubscribe();
                    _super.prototype._complete.call(this);
                };
                ConnectableSubscriber.prototype._unsubscribe = function () {
                    var connectable = this.connectable;
                    if (connectable) {
                        this.connectable = null;
                        var connection = connectable._connection;
                        connectable._refCount = 0;
                        connectable._subject = null;
                        connectable._connection = null;
                        if (connection) {
                            connection.unsubscribe();
                        }
                    }
                };
                return ConnectableSubscriber;
            }(Subject_1.SubjectSubscriber));
            var RefCountOperator = (function () {
                function RefCountOperator(connectable) {
                    this.connectable = connectable;
                }
                RefCountOperator.prototype.call = function (subscriber, source) {
                    var connectable = this.connectable;
                    connectable._refCount++;
                    var refCounter = new RefCountSubscriber(subscriber, connectable);
                    var subscription = source.subscribe(refCounter);
                    if (!refCounter.closed) {
                        refCounter.connection = connectable.connect();
                    }
                    return subscription;
                };
                return RefCountOperator;
            }());
            var RefCountSubscriber = (function (_super) {
                __extends(RefCountSubscriber, _super);
                function RefCountSubscriber(destination, connectable) {
                    _super.call(this, destination);
                    this.connectable = connectable;
                }
                RefCountSubscriber.prototype._unsubscribe = function () {
                    var connectable = this.connectable;
                    if (!connectable) {
                        this.connection = null;
                        return;
                    }
                    this.connectable = null;
                    var refCount = connectable._refCount;
                    if (refCount <= 0) {
                        this.connection = null;
                        return;
                    }
                    connectable._refCount = refCount - 1;
                    if (refCount > 1) {
                        this.connection = null;
                        return;
                    }
                    ///
                    // Compare the local RefCountSubscriber's connection Subscription to the
                    // connection Subscription on the shared ConnectableObservable. In cases
                    // where the ConnectableObservable source synchronously emits values, and
                    // the RefCountSubscriber's downstream Observers synchronously unsubscribe,
                    // execution continues to here before the RefCountOperator has a chance to
                    // supply the RefCountSubscriber with the shared connection Subscription.
                    // For example:
                    // ```
                    // Observable.range(0, 10)
                    //   .publish()
                    //   .refCount()
                    //   .take(5)
                    //   .subscribe();
                    // ```
                    // In order to account for this case, RefCountSubscriber should only dispose
                    // the ConnectableObservable's shared connection Subscription if the
                    // connection Subscription exists, *and* either:
                    //   a. RefCountSubscriber doesn't have a reference to the shared connection
                    //      Subscription yet, or,
                    //   b. RefCountSubscriber's connection Subscription reference is identical
                    //      to the shared connection Subscription
                    ///
                    var connection = this.connection;
                    var sharedConnection = connectable._connection;
                    this.connection = null;
                    if (sharedConnection && (!connection || sharedConnection === connection)) {
                        sharedConnection.unsubscribe();
                    }
                };
                return RefCountSubscriber;
            }(Subscriber_1.Subscriber));
//# sourceMappingURL=ConnectableObservable.js.map

            /***/ }),
        /* 153 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var skipWhile_1 = __webpack_require__(154);
            /**
             * Returns an Observable that skips all items emitted by the source Observable as long as a specified condition holds
             * true, but emits all further source items as soon as the condition becomes false.
             *
             * <img src="./img/skipWhile.png" width="100%">
             *
             * @param {Function} predicate - A function to test each item emitted from the source Observable.
             * @return {Observable<T>} An Observable that begins emitting items emitted by the source Observable when the
             * specified predicate becomes false.
             * @method skipWhile
             * @owner Observable
             */
            function skipWhile(predicate) {
                return skipWhile_1.skipWhile(predicate)(this);
            }
            exports.skipWhile = skipWhile;
//# sourceMappingURL=skipWhile.js.map

            /***/ }),
        /* 154 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            /**
             * Returns an Observable that skips all items emitted by the source Observable as long as a specified condition holds
             * true, but emits all further source items as soon as the condition becomes false.
             *
             * <img src="./img/skipWhile.png" width="100%">
             *
             * @param {Function} predicate - A function to test each item emitted from the source Observable.
             * @return {Observable<T>} An Observable that begins emitting items emitted by the source Observable when the
             * specified predicate becomes false.
             * @method skipWhile
             * @owner Observable
             */
            function skipWhile(predicate) {
                return function (source) { return source.lift(new SkipWhileOperator(predicate)); };
            }
            exports.skipWhile = skipWhile;
            var SkipWhileOperator = (function () {
                function SkipWhileOperator(predicate) {
                    this.predicate = predicate;
                }
                SkipWhileOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new SkipWhileSubscriber(subscriber, this.predicate));
                };
                return SkipWhileOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var SkipWhileSubscriber = (function (_super) {
                __extends(SkipWhileSubscriber, _super);
                function SkipWhileSubscriber(destination, predicate) {
                    _super.call(this, destination);
                    this.predicate = predicate;
                    this.skipping = true;
                    this.index = 0;
                }
                SkipWhileSubscriber.prototype._next = function (value) {
                    var destination = this.destination;
                    if (this.skipping) {
                        this.tryCallPredicate(value);
                    }
                    if (!this.skipping) {
                        destination.next(value);
                    }
                };
                SkipWhileSubscriber.prototype.tryCallPredicate = function (value) {
                    try {
                        var result = this.predicate(value, this.index++);
                        this.skipping = Boolean(result);
                    }
                    catch (err) {
                        this.destination.error(err);
                    }
                };
                return SkipWhileSubscriber;
            }(Subscriber_1.Subscriber));
//# sourceMappingURL=skipWhile.js.map

            /***/ }),
        /* 155 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var startWith_1 = __webpack_require__(156);
            /* tslint:enable:max-line-length */
            /**
             * Returns an Observable that emits the items you specify as arguments before it begins to emit
             * items emitted by the source Observable.
             *
             * <img src="./img/startWith.png" width="100%">
             *
             * @param {...T} values - Items you want the modified Observable to emit first.
             * @param {Scheduler} [scheduler] - A {@link IScheduler} to use for scheduling
             * the emissions of the `next` notifications.
             * @return {Observable} An Observable that emits the items in the specified Iterable and then emits the items
             * emitted by the source Observable.
             * @method startWith
             * @owner Observable
             */
            function startWith() {
                var array = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    array[_i - 0] = arguments[_i];
                }
                return startWith_1.startWith.apply(void 0, array)(this);
            }
            exports.startWith = startWith;
//# sourceMappingURL=startWith.js.map

            /***/ }),
        /* 156 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var ArrayObservable_1 = __webpack_require__(10);
            var ScalarObservable_1 = __webpack_require__(43);
            var EmptyObservable_1 = __webpack_require__(25);
            var concat_1 = __webpack_require__(157);
            var isScheduler_1 = __webpack_require__(19);
            /* tslint:enable:max-line-length */
            /**
             * Returns an Observable that emits the items you specify as arguments before it begins to emit
             * items emitted by the source Observable.
             *
             * <img src="./img/startWith.png" width="100%">
             *
             * @param {...T} values - Items you want the modified Observable to emit first.
             * @param {Scheduler} [scheduler] - A {@link IScheduler} to use for scheduling
             * the emissions of the `next` notifications.
             * @return {Observable} An Observable that emits the items in the specified Iterable and then emits the items
             * emitted by the source Observable.
             * @method startWith
             * @owner Observable
             */
            function startWith() {
                var array = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    array[_i - 0] = arguments[_i];
                }
                return function (source) {
                    var scheduler = array[array.length - 1];
                    if (isScheduler_1.isScheduler(scheduler)) {
                        array.pop();
                    }
                    else {
                        scheduler = null;
                    }
                    var len = array.length;
                    if (len === 1) {
                        return concat_1.concat(new ScalarObservable_1.ScalarObservable(array[0], scheduler), source);
                    }
                    else if (len > 1) {
                        return concat_1.concat(new ArrayObservable_1.ArrayObservable(array, scheduler), source);
                    }
                    else {
                        return concat_1.concat(new EmptyObservable_1.EmptyObservable(scheduler), source);
                    }
                };
            }
            exports.startWith = startWith;
//# sourceMappingURL=startWith.js.map

            /***/ }),
        /* 157 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var isScheduler_1 = __webpack_require__(19);
            var of_1 = __webpack_require__(158);
            var from_1 = __webpack_require__(159);
            var concatAll_1 = __webpack_require__(166);
            /* tslint:enable:max-line-length */
            /**
             * Creates an output Observable which sequentially emits all values from given
             * Observable and then moves on to the next.
             *
             * <span class="informal">Concatenates multiple Observables together by
             * sequentially emitting their values, one Observable after the other.</span>
             *
             * <img src="./img/concat.png" width="100%">
             *
             * `concat` joins multiple Observables together, by subscribing to them one at a time and
             * merging their results into the output Observable. You can pass either an array of
             * Observables, or put them directly as arguments. Passing an empty array will result
             * in Observable that completes immediately.
             *
             * `concat` will subscribe to first input Observable and emit all its values, without
             * changing or affecting them in any way. When that Observable completes, it will
             * subscribe to then next Observable passed and, again, emit its values. This will be
             * repeated, until the operator runs out of Observables. When last input Observable completes,
             * `concat` will complete as well. At any given moment only one Observable passed to operator
             * emits values. If you would like to emit values from passed Observables concurrently, check out
             * {@link merge} instead, especially with optional `concurrent` parameter. As a matter of fact,
             * `concat` is an equivalent of `merge` operator with `concurrent` parameter set to `1`.
             *
             * Note that if some input Observable never completes, `concat` will also never complete
             * and Observables following the one that did not complete will never be subscribed. On the other
             * hand, if some Observable simply completes immediately after it is subscribed, it will be
             * invisible for `concat`, which will just move on to the next Observable.
             *
             * If any Observable in chain errors, instead of passing control to the next Observable,
             * `concat` will error immediately as well. Observables that would be subscribed after
             * the one that emitted error, never will.
             *
             * If you pass to `concat` the same Observable many times, its stream of values
             * will be "replayed" on every subscription, which means you can repeat given Observable
             * as many times as you like. If passing the same Observable to `concat` 1000 times becomes tedious,
             * you can always use {@link repeat}.
             *
             * @example <caption>Concatenate a timer counting from 0 to 3 with a synchronous sequence from 1 to 10</caption>
             * var timer = Rx.Observable.interval(1000).take(4);
             * var sequence = Rx.Observable.range(1, 10);
             * var result = Rx.Observable.concat(timer, sequence);
             * result.subscribe(x => console.log(x));
             *
             * // results in:
             * // 0 -1000ms-> 1 -1000ms-> 2 -1000ms-> 3 -immediate-> 1 ... 10
             *
             *
             * @example <caption>Concatenate an array of 3 Observables</caption>
             * var timer1 = Rx.Observable.interval(1000).take(10);
             * var timer2 = Rx.Observable.interval(2000).take(6);
             * var timer3 = Rx.Observable.interval(500).take(10);
             * var result = Rx.Observable.concat([timer1, timer2, timer3]); // note that array is passed
             * result.subscribe(x => console.log(x));
             *
             * // results in the following:
             * // (Prints to console sequentially)
             * // -1000ms-> 0 -1000ms-> 1 -1000ms-> ... 9
             * // -2000ms-> 0 -2000ms-> 1 -2000ms-> ... 5
             * // -500ms-> 0 -500ms-> 1 -500ms-> ... 9
             *
             *
             * @example <caption>Concatenate the same Observable to repeat it</caption>
             * const timer = Rx.Observable.interval(1000).take(2);
             *
             * Rx.Observable.concat(timer, timer) // concating the same Observable!
             * .subscribe(
             *   value => console.log(value),
             *   err => {},
             *   () => console.log('...and it is done!')
             * );
             *
             * // Logs:
             * // 0 after 1s
             * // 1 after 2s
             * // 0 after 3s
             * // 1 after 4s
             * // "...and it is done!" also after 4s
             *
             * @see {@link concatAll}
             * @see {@link concatMap}
             * @see {@link concatMapTo}
             *
             * @param {ObservableInput} input1 An input Observable to concatenate with others.
             * @param {ObservableInput} input2 An input Observable to concatenate with others.
             * More than one input Observables may be given as argument.
             * @param {Scheduler} [scheduler=null] An optional IScheduler to schedule each
             * Observable subscription on.
             * @return {Observable} All values of each passed Observable merged into a
             * single Observable, in order, in serial fashion.
             * @static true
             * @name concat
             * @owner Observable
             */
            function concat() {
                var observables = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    observables[_i - 0] = arguments[_i];
                }
                if (observables.length === 1 || (observables.length === 2 && isScheduler_1.isScheduler(observables[1]))) {
                    return from_1.from(observables[0]);
                }
                return concatAll_1.concatAll()(of_1.of.apply(void 0, observables));
            }
            exports.concat = concat;
//# sourceMappingURL=concat.js.map

            /***/ }),
        /* 158 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var ArrayObservable_1 = __webpack_require__(10);
            exports.of = ArrayObservable_1.ArrayObservable.of;
//# sourceMappingURL=of.js.map

            /***/ }),
        /* 159 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var FromObservable_1 = __webpack_require__(160);
            exports.from = FromObservable_1.FromObservable.create;
//# sourceMappingURL=from.js.map

            /***/ }),
        /* 160 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var isArray_1 = __webpack_require__(22);
            var isArrayLike_1 = __webpack_require__(62);
            var isPromise_1 = __webpack_require__(63);
            var PromiseObservable_1 = __webpack_require__(161);
            var IteratorObservable_1 = __webpack_require__(162);
            var ArrayObservable_1 = __webpack_require__(10);
            var ArrayLikeObservable_1 = __webpack_require__(163);
            var iterator_1 = __webpack_require__(44);
            var Observable_1 = __webpack_require__(0);
            var observeOn_1 = __webpack_require__(164);
            var observable_1 = __webpack_require__(42);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @extends {Ignored}
             * @hide true
             */
            var FromObservable = (function (_super) {
                __extends(FromObservable, _super);
                function FromObservable(ish, scheduler) {
                    _super.call(this, null);
                    this.ish = ish;
                    this.scheduler = scheduler;
                }
                /**
                 * Creates an Observable from an Array, an array-like object, a Promise, an
                 * iterable object, or an Observable-like object.
                 *
                 * <span class="informal">Converts almost anything to an Observable.</span>
                 *
                 * <img src="./img/from.png" width="100%">
                 *
                 * Convert various other objects and data types into Observables. `from`
                 * converts a Promise or an array-like or an
                 * [iterable](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols#iterable)
                 * object into an Observable that emits the items in that promise or array or
                 * iterable. A String, in this context, is treated as an array of characters.
                 * Observable-like objects (contains a function named with the ES2015 Symbol
                 * for Observable) can also be converted through this operator.
                 *
                 * @example <caption>Converts an array to an Observable</caption>
                 * var array = [10, 20, 30];
                 * var result = Rx.Observable.from(array);
                 * result.subscribe(x => console.log(x));
                 *
                 * // Results in the following:
                 * // 10 20 30
                 *
                 * @example <caption>Convert an infinite iterable (from a generator) to an Observable</caption>
                 * function* generateDoubles(seed) {
                 *   var i = seed;
                 *   while (true) {
                 *     yield i;
                 *     i = 2 * i; // double it
                 *   }
                 * }
                 *
                 * var iterator = generateDoubles(3);
                 * var result = Rx.Observable.from(iterator).take(10);
                 * result.subscribe(x => console.log(x));
                 *
                 * // Results in the following:
                 * // 3 6 12 24 48 96 192 384 768 1536
                 *
                 * @see {@link create}
                 * @see {@link fromEvent}
                 * @see {@link fromEventPattern}
                 * @see {@link fromPromise}
                 *
                 * @param {ObservableInput<T>} ish A subscribable object, a Promise, an
                 * Observable-like, an Array, an iterable or an array-like object to be
                 * converted.
                 * @param {Scheduler} [scheduler] The scheduler on which to schedule the
                 * emissions of values.
                 * @return {Observable<T>} The Observable whose values are originally from the
                 * input object that was converted.
                 * @static true
                 * @name from
                 * @owner Observable
                 */
                FromObservable.create = function (ish, scheduler) {
                    if (ish != null) {
                        if (typeof ish[observable_1.observable] === 'function') {
                            if (ish instanceof Observable_1.Observable && !scheduler) {
                                return ish;
                            }
                            return new FromObservable(ish, scheduler);
                        }
                        else if (isArray_1.isArray(ish)) {
                            return new ArrayObservable_1.ArrayObservable(ish, scheduler);
                        }
                        else if (isPromise_1.isPromise(ish)) {
                            return new PromiseObservable_1.PromiseObservable(ish, scheduler);
                        }
                        else if (typeof ish[iterator_1.iterator] === 'function' || typeof ish === 'string') {
                            return new IteratorObservable_1.IteratorObservable(ish, scheduler);
                        }
                        else if (isArrayLike_1.isArrayLike(ish)) {
                            return new ArrayLikeObservable_1.ArrayLikeObservable(ish, scheduler);
                        }
                    }
                    throw new TypeError((ish !== null && typeof ish || ish) + ' is not observable');
                };
                FromObservable.prototype._subscribe = function (subscriber) {
                    var ish = this.ish;
                    var scheduler = this.scheduler;
                    if (scheduler == null) {
                        return ish[observable_1.observable]().subscribe(subscriber);
                    }
                    else {
                        return ish[observable_1.observable]().subscribe(new observeOn_1.ObserveOnSubscriber(subscriber, scheduler, 0));
                    }
                };
                return FromObservable;
            }(Observable_1.Observable));
            exports.FromObservable = FromObservable;
//# sourceMappingURL=FromObservable.js.map

            /***/ }),
        /* 161 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var root_1 = __webpack_require__(4);
            var Observable_1 = __webpack_require__(0);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @extends {Ignored}
             * @hide true
             */
            var PromiseObservable = (function (_super) {
                __extends(PromiseObservable, _super);
                function PromiseObservable(promise, scheduler) {
                    _super.call(this);
                    this.promise = promise;
                    this.scheduler = scheduler;
                }
                /**
                 * Converts a Promise to an Observable.
                 *
                 * <span class="informal">Returns an Observable that just emits the Promise's
                 * resolved value, then completes.</span>
                 *
                 * Converts an ES2015 Promise or a Promises/A+ spec compliant Promise to an
                 * Observable. If the Promise resolves with a value, the output Observable
                 * emits that resolved value as a `next`, and then completes. If the Promise
                 * is rejected, then the output Observable emits the corresponding Error.
                 *
                 * @example <caption>Convert the Promise returned by Fetch to an Observable</caption>
                 * var result = Rx.Observable.fromPromise(fetch('http://myserver.com/'));
                 * result.subscribe(x => console.log(x), e => console.error(e));
                 *
                 * @see {@link bindCallback}
                 * @see {@link from}
                 *
                 * @param {PromiseLike<T>} promise The promise to be converted.
                 * @param {Scheduler} [scheduler] An optional IScheduler to use for scheduling
                 * the delivery of the resolved value (or the rejection).
                 * @return {Observable<T>} An Observable which wraps the Promise.
                 * @static true
                 * @name fromPromise
                 * @owner Observable
                 */
                PromiseObservable.create = function (promise, scheduler) {
                    return new PromiseObservable(promise, scheduler);
                };
                PromiseObservable.prototype._subscribe = function (subscriber) {
                    var _this = this;
                    var promise = this.promise;
                    var scheduler = this.scheduler;
                    if (scheduler == null) {
                        if (this._isScalar) {
                            if (!subscriber.closed) {
                                subscriber.next(this.value);
                                subscriber.complete();
                            }
                        }
                        else {
                            promise.then(function (value) {
                                _this.value = value;
                                _this._isScalar = true;
                                if (!subscriber.closed) {
                                    subscriber.next(value);
                                    subscriber.complete();
                                }
                            }, function (err) {
                                if (!subscriber.closed) {
                                    subscriber.error(err);
                                }
                            })
                                .then(null, function (err) {
                                    // escape the promise trap, throw unhandled errors
                                    root_1.root.setTimeout(function () { throw err; });
                                });
                        }
                    }
                    else {
                        if (this._isScalar) {
                            if (!subscriber.closed) {
                                return scheduler.schedule(dispatchNext, 0, { value: this.value, subscriber: subscriber });
                            }
                        }
                        else {
                            promise.then(function (value) {
                                _this.value = value;
                                _this._isScalar = true;
                                if (!subscriber.closed) {
                                    subscriber.add(scheduler.schedule(dispatchNext, 0, { value: value, subscriber: subscriber }));
                                }
                            }, function (err) {
                                if (!subscriber.closed) {
                                    subscriber.add(scheduler.schedule(dispatchError, 0, { err: err, subscriber: subscriber }));
                                }
                            })
                                .then(null, function (err) {
                                    // escape the promise trap, throw unhandled errors
                                    root_1.root.setTimeout(function () { throw err; });
                                });
                        }
                    }
                };
                return PromiseObservable;
            }(Observable_1.Observable));
            exports.PromiseObservable = PromiseObservable;
            function dispatchNext(arg) {
                var value = arg.value, subscriber = arg.subscriber;
                if (!subscriber.closed) {
                    subscriber.next(value);
                    subscriber.complete();
                }
            }
            function dispatchError(arg) {
                var err = arg.err, subscriber = arg.subscriber;
                if (!subscriber.closed) {
                    subscriber.error(err);
                }
            }
//# sourceMappingURL=PromiseObservable.js.map

            /***/ }),
        /* 162 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var root_1 = __webpack_require__(4);
            var Observable_1 = __webpack_require__(0);
            var iterator_1 = __webpack_require__(44);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @extends {Ignored}
             * @hide true
             */
            var IteratorObservable = (function (_super) {
                __extends(IteratorObservable, _super);
                function IteratorObservable(iterator, scheduler) {
                    _super.call(this);
                    this.scheduler = scheduler;
                    if (iterator == null) {
                        throw new Error('iterator cannot be null.');
                    }
                    this.iterator = getIterator(iterator);
                }
                IteratorObservable.create = function (iterator, scheduler) {
                    return new IteratorObservable(iterator, scheduler);
                };
                IteratorObservable.dispatch = function (state) {
                    var index = state.index, hasError = state.hasError, iterator = state.iterator, subscriber = state.subscriber;
                    if (hasError) {
                        subscriber.error(state.error);
                        return;
                    }
                    var result = iterator.next();
                    if (result.done) {
                        subscriber.complete();
                        return;
                    }
                    subscriber.next(result.value);
                    state.index = index + 1;
                    if (subscriber.closed) {
                        if (typeof iterator.return === 'function') {
                            iterator.return();
                        }
                        return;
                    }
                    this.schedule(state);
                };
                IteratorObservable.prototype._subscribe = function (subscriber) {
                    var index = 0;
                    var _a = this, iterator = _a.iterator, scheduler = _a.scheduler;
                    if (scheduler) {
                        return scheduler.schedule(IteratorObservable.dispatch, 0, {
                            index: index, iterator: iterator, subscriber: subscriber
                        });
                    }
                    else {
                        do {
                            var result = iterator.next();
                            if (result.done) {
                                subscriber.complete();
                                break;
                            }
                            else {
                                subscriber.next(result.value);
                            }
                            if (subscriber.closed) {
                                if (typeof iterator.return === 'function') {
                                    iterator.return();
                                }
                                break;
                            }
                        } while (true);
                    }
                };
                return IteratorObservable;
            }(Observable_1.Observable));
            exports.IteratorObservable = IteratorObservable;
            var StringIterator = (function () {
                function StringIterator(str, idx, len) {
                    if (idx === void 0) { idx = 0; }
                    if (len === void 0) { len = str.length; }
                    this.str = str;
                    this.idx = idx;
                    this.len = len;
                }
                StringIterator.prototype[iterator_1.iterator] = function () { return (this); };
                StringIterator.prototype.next = function () {
                    return this.idx < this.len ? {
                        done: false,
                        value: this.str.charAt(this.idx++)
                    } : {
                        done: true,
                        value: undefined
                    };
                };
                return StringIterator;
            }());
            var ArrayIterator = (function () {
                function ArrayIterator(arr, idx, len) {
                    if (idx === void 0) { idx = 0; }
                    if (len === void 0) { len = toLength(arr); }
                    this.arr = arr;
                    this.idx = idx;
                    this.len = len;
                }
                ArrayIterator.prototype[iterator_1.iterator] = function () { return this; };
                ArrayIterator.prototype.next = function () {
                    return this.idx < this.len ? {
                        done: false,
                        value: this.arr[this.idx++]
                    } : {
                        done: true,
                        value: undefined
                    };
                };
                return ArrayIterator;
            }());
            function getIterator(obj) {
                var i = obj[iterator_1.iterator];
                if (!i && typeof obj === 'string') {
                    return new StringIterator(obj);
                }
                if (!i && obj.length !== undefined) {
                    return new ArrayIterator(obj);
                }
                if (!i) {
                    throw new TypeError('object is not iterable');
                }
                return obj[iterator_1.iterator]();
            }
            var maxSafeInteger = Math.pow(2, 53) - 1;
            function toLength(o) {
                var len = +o.length;
                if (isNaN(len)) {
                    return 0;
                }
                if (len === 0 || !numberIsFinite(len)) {
                    return len;
                }
                len = sign(len) * Math.floor(Math.abs(len));
                if (len <= 0) {
                    return 0;
                }
                if (len > maxSafeInteger) {
                    return maxSafeInteger;
                }
                return len;
            }
            function numberIsFinite(value) {
                return typeof value === 'number' && root_1.root.isFinite(value);
            }
            function sign(value) {
                var valueAsNumber = +value;
                if (valueAsNumber === 0) {
                    return valueAsNumber;
                }
                if (isNaN(valueAsNumber)) {
                    return valueAsNumber;
                }
                return valueAsNumber < 0 ? -1 : 1;
            }
//# sourceMappingURL=IteratorObservable.js.map

            /***/ }),
        /* 163 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Observable_1 = __webpack_require__(0);
            var ScalarObservable_1 = __webpack_require__(43);
            var EmptyObservable_1 = __webpack_require__(25);
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @extends {Ignored}
             * @hide true
             */
            var ArrayLikeObservable = (function (_super) {
                __extends(ArrayLikeObservable, _super);
                function ArrayLikeObservable(arrayLike, scheduler) {
                    _super.call(this);
                    this.arrayLike = arrayLike;
                    this.scheduler = scheduler;
                    if (!scheduler && arrayLike.length === 1) {
                        this._isScalar = true;
                        this.value = arrayLike[0];
                    }
                }
                ArrayLikeObservable.create = function (arrayLike, scheduler) {
                    var length = arrayLike.length;
                    if (length === 0) {
                        return new EmptyObservable_1.EmptyObservable();
                    }
                    else if (length === 1) {
                        return new ScalarObservable_1.ScalarObservable(arrayLike[0], scheduler);
                    }
                    else {
                        return new ArrayLikeObservable(arrayLike, scheduler);
                    }
                };
                ArrayLikeObservable.dispatch = function (state) {
                    var arrayLike = state.arrayLike, index = state.index, length = state.length, subscriber = state.subscriber;
                    if (subscriber.closed) {
                        return;
                    }
                    if (index >= length) {
                        subscriber.complete();
                        return;
                    }
                    subscriber.next(arrayLike[index]);
                    state.index = index + 1;
                    this.schedule(state);
                };
                ArrayLikeObservable.prototype._subscribe = function (subscriber) {
                    var index = 0;
                    var _a = this, arrayLike = _a.arrayLike, scheduler = _a.scheduler;
                    var length = arrayLike.length;
                    if (scheduler) {
                        return scheduler.schedule(ArrayLikeObservable.dispatch, 0, {
                            arrayLike: arrayLike, index: index, length: length, subscriber: subscriber
                        });
                    }
                    else {
                        for (var i = 0; i < length && !subscriber.closed; i++) {
                            subscriber.next(arrayLike[i]);
                        }
                        subscriber.complete();
                    }
                };
                return ArrayLikeObservable;
            }(Observable_1.Observable));
            exports.ArrayLikeObservable = ArrayLikeObservable;
//# sourceMappingURL=ArrayLikeObservable.js.map

            /***/ }),
        /* 164 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            var Notification_1 = __webpack_require__(165);
            /**
             *
             * Re-emits all notifications from source Observable with specified scheduler.
             *
             * <span class="informal">Ensure a specific scheduler is used, from outside of an Observable.</span>
             *
             * `observeOn` is an operator that accepts a scheduler as a first parameter, which will be used to reschedule
             * notifications emitted by the source Observable. It might be useful, if you do not have control over
             * internal scheduler of a given Observable, but want to control when its values are emitted nevertheless.
             *
             * Returned Observable emits the same notifications (nexted values, complete and error events) as the source Observable,
             * but rescheduled with provided scheduler. Note that this doesn't mean that source Observables internal
             * scheduler will be replaced in any way. Original scheduler still will be used, but when the source Observable emits
             * notification, it will be immediately scheduled again - this time with scheduler passed to `observeOn`.
             * An anti-pattern would be calling `observeOn` on Observable that emits lots of values synchronously, to split
             * that emissions into asynchronous chunks. For this to happen, scheduler would have to be passed into the source
             * Observable directly (usually into the operator that creates it). `observeOn` simply delays notifications a
             * little bit more, to ensure that they are emitted at expected moments.
             *
             * As a matter of fact, `observeOn` accepts second parameter, which specifies in milliseconds with what delay notifications
             * will be emitted. The main difference between {@link delay} operator and `observeOn` is that `observeOn`
             * will delay all notifications - including error notifications - while `delay` will pass through error
             * from source Observable immediately when it is emitted. In general it is highly recommended to use `delay` operator
             * for any kind of delaying of values in the stream, while using `observeOn` to specify which scheduler should be used
             * for notification emissions in general.
             *
             * @example <caption>Ensure values in subscribe are called just before browser repaint.</caption>
             * const intervals = Rx.Observable.interval(10); // Intervals are scheduled
             *                                               // with async scheduler by default...
             *
             * intervals
             * .observeOn(Rx.Scheduler.animationFrame)       // ...but we will observe on animationFrame
             * .subscribe(val => {                           // scheduler to ensure smooth animation.
             *   someDiv.style.height = val + 'px';
             * });
             *
             * @see {@link delay}
             *
             * @param {IScheduler} scheduler Scheduler that will be used to reschedule notifications from source Observable.
             * @param {number} [delay] Number of milliseconds that states with what delay every notification should be rescheduled.
             * @return {Observable<T>} Observable that emits the same notifications as the source Observable,
             * but with provided scheduler.
             *
             * @method observeOn
             * @owner Observable
             */
            function observeOn(scheduler, delay) {
                if (delay === void 0) { delay = 0; }
                return function observeOnOperatorFunction(source) {
                    return source.lift(new ObserveOnOperator(scheduler, delay));
                };
            }
            exports.observeOn = observeOn;
            var ObserveOnOperator = (function () {
                function ObserveOnOperator(scheduler, delay) {
                    if (delay === void 0) { delay = 0; }
                    this.scheduler = scheduler;
                    this.delay = delay;
                }
                ObserveOnOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new ObserveOnSubscriber(subscriber, this.scheduler, this.delay));
                };
                return ObserveOnOperator;
            }());
            exports.ObserveOnOperator = ObserveOnOperator;
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var ObserveOnSubscriber = (function (_super) {
                __extends(ObserveOnSubscriber, _super);
                function ObserveOnSubscriber(destination, scheduler, delay) {
                    if (delay === void 0) { delay = 0; }
                    _super.call(this, destination);
                    this.scheduler = scheduler;
                    this.delay = delay;
                }
                ObserveOnSubscriber.dispatch = function (arg) {
                    var notification = arg.notification, destination = arg.destination;
                    notification.observe(destination);
                    this.unsubscribe();
                };
                ObserveOnSubscriber.prototype.scheduleMessage = function (notification) {
                    this.add(this.scheduler.schedule(ObserveOnSubscriber.dispatch, this.delay, new ObserveOnMessage(notification, this.destination)));
                };
                ObserveOnSubscriber.prototype._next = function (value) {
                    this.scheduleMessage(Notification_1.Notification.createNext(value));
                };
                ObserveOnSubscriber.prototype._error = function (err) {
                    this.scheduleMessage(Notification_1.Notification.createError(err));
                };
                ObserveOnSubscriber.prototype._complete = function () {
                    this.scheduleMessage(Notification_1.Notification.createComplete());
                };
                return ObserveOnSubscriber;
            }(Subscriber_1.Subscriber));
            exports.ObserveOnSubscriber = ObserveOnSubscriber;
            var ObserveOnMessage = (function () {
                function ObserveOnMessage(notification, destination) {
                    this.notification = notification;
                    this.destination = destination;
                }
                return ObserveOnMessage;
            }());
            exports.ObserveOnMessage = ObserveOnMessage;
//# sourceMappingURL=observeOn.js.map

            /***/ }),
        /* 165 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var Observable_1 = __webpack_require__(0);
            /**
             * Represents a push-based event or value that an {@link Observable} can emit.
             * This class is particularly useful for operators that manage notifications,
             * like {@link materialize}, {@link dematerialize}, {@link observeOn}, and
             * others. Besides wrapping the actual delivered value, it also annotates it
             * with metadata of, for instance, what type of push message it is (`next`,
             * `error`, or `complete`).
             *
             * @see {@link materialize}
             * @see {@link dematerialize}
             * @see {@link observeOn}
             *
             * @class Notification<T>
             */
            var Notification = (function () {
                function Notification(kind, value, error) {
                    this.kind = kind;
                    this.value = value;
                    this.error = error;
                    this.hasValue = kind === 'N';
                }
                /**
                 * Delivers to the given `observer` the value wrapped by this Notification.
                 * @param {Observer} observer
                 * @return
                 */
                Notification.prototype.observe = function (observer) {
                    switch (this.kind) {
                        case 'N':
                            return observer.next && observer.next(this.value);
                        case 'E':
                            return observer.error && observer.error(this.error);
                        case 'C':
                            return observer.complete && observer.complete();
                    }
                };
                /**
                 * Given some {@link Observer} callbacks, deliver the value represented by the
                 * current Notification to the correctly corresponding callback.
                 * @param {function(value: T): void} next An Observer `next` callback.
                 * @param {function(err: any): void} [error] An Observer `error` callback.
                 * @param {function(): void} [complete] An Observer `complete` callback.
                 * @return {any}
                 */
                Notification.prototype.do = function (next, error, complete) {
                    var kind = this.kind;
                    switch (kind) {
                        case 'N':
                            return next && next(this.value);
                        case 'E':
                            return error && error(this.error);
                        case 'C':
                            return complete && complete();
                    }
                };
                /**
                 * Takes an Observer or its individual callback functions, and calls `observe`
                 * or `do` methods accordingly.
                 * @param {Observer|function(value: T): void} nextOrObserver An Observer or
                 * the `next` callback.
                 * @param {function(err: any): void} [error] An Observer `error` callback.
                 * @param {function(): void} [complete] An Observer `complete` callback.
                 * @return {any}
                 */
                Notification.prototype.accept = function (nextOrObserver, error, complete) {
                    if (nextOrObserver && typeof nextOrObserver.next === 'function') {
                        return this.observe(nextOrObserver);
                    }
                    else {
                        return this.do(nextOrObserver, error, complete);
                    }
                };
                /**
                 * Returns a simple Observable that just delivers the notification represented
                 * by this Notification instance.
                 * @return {any}
                 */
                Notification.prototype.toObservable = function () {
                    var kind = this.kind;
                    switch (kind) {
                        case 'N':
                            return Observable_1.Observable.of(this.value);
                        case 'E':
                            return Observable_1.Observable.throw(this.error);
                        case 'C':
                            return Observable_1.Observable.empty();
                    }
                    throw new Error('unexpected notification kind value');
                };
                /**
                 * A shortcut to create a Notification instance of the type `next` from a
                 * given value.
                 * @param {T} value The `next` value.
                 * @return {Notification<T>} The "next" Notification representing the
                 * argument.
                 */
                Notification.createNext = function (value) {
                    if (typeof value !== 'undefined') {
                        return new Notification('N', value);
                    }
                    return Notification.undefinedValueNotification;
                };
                /**
                 * A shortcut to create a Notification instance of the type `error` from a
                 * given error.
                 * @param {any} [err] The `error` error.
                 * @return {Notification<T>} The "error" Notification representing the
                 * argument.
                 */
                Notification.createError = function (err) {
                    return new Notification('E', undefined, err);
                };
                /**
                 * A shortcut to create a Notification instance of the type `complete`.
                 * @return {Notification<any>} The valueless "complete" Notification.
                 */
                Notification.createComplete = function () {
                    return Notification.completeNotification;
                };
                Notification.completeNotification = new Notification('C');
                Notification.undefinedValueNotification = new Notification('N', undefined);
                return Notification;
            }());
            exports.Notification = Notification;
//# sourceMappingURL=Notification.js.map

            /***/ }),
        /* 166 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var mergeAll_1 = __webpack_require__(65);
            /**
             * Converts a higher-order Observable into a first-order Observable by
             * concatenating the inner Observables in order.
             *
             * <span class="informal">Flattens an Observable-of-Observables by putting one
             * inner Observable after the other.</span>
             *
             * <img src="./img/concatAll.png" width="100%">
             *
             * Joins every Observable emitted by the source (a higher-order Observable), in
             * a serial fashion. It subscribes to each inner Observable only after the
             * previous inner Observable has completed, and merges all of their values into
             * the returned observable.
             *
             * __Warning:__ If the source Observable emits Observables quickly and
             * endlessly, and the inner Observables it emits generally complete slower than
             * the source emits, you can run into memory issues as the incoming Observables
             * collect in an unbounded buffer.
             *
             * Note: `concatAll` is equivalent to `mergeAll` with concurrency parameter set
             * to `1`.
             *
             * @example <caption>For each click event, tick every second from 0 to 3, with no concurrency</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var higherOrder = clicks.map(ev => Rx.Observable.interval(1000).take(4));
             * var firstOrder = higherOrder.concatAll();
             * firstOrder.subscribe(x => console.log(x));
             *
             * // Results in the following:
             * // (results are not concurrent)
             * // For every click on the "document" it will emit values 0 to 3 spaced
             * // on a 1000ms interval
             * // one click = 1000ms-> 0 -1000ms-> 1 -1000ms-> 2 -1000ms-> 3
             *
             * @see {@link combineAll}
             * @see {@link concat}
             * @see {@link concatMap}
             * @see {@link concatMapTo}
             * @see {@link exhaust}
             * @see {@link mergeAll}
             * @see {@link switch}
             * @see {@link zipAll}
             *
             * @return {Observable} An Observable emitting values from all the inner
             * Observables concatenated.
             * @method concatAll
             * @owner Observable
             */
            function concatAll() {
                return mergeAll_1.mergeAll(1);
            }
            exports.concatAll = concatAll;
//# sourceMappingURL=concatAll.js.map

            /***/ }),
        /* 167 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var switchMap_1 = __webpack_require__(168);
            /* tslint:enable:max-line-length */
            /**
             * Projects each source value to an Observable which is merged in the output
             * Observable, emitting values only from the most recently projected Observable.
             *
             * <span class="informal">Maps each value to an Observable, then flattens all of
             * these inner Observables using {@link switch}.</span>
             *
             * <img src="./img/switchMap.png" width="100%">
             *
             * Returns an Observable that emits items based on applying a function that you
             * supply to each item emitted by the source Observable, where that function
             * returns an (so-called "inner") Observable. Each time it observes one of these
             * inner Observables, the output Observable begins emitting the items emitted by
             * that inner Observable. When a new inner Observable is emitted, `switchMap`
             * stops emitting items from the earlier-emitted inner Observable and begins
             * emitting items from the new one. It continues to behave like this for
             * subsequent inner Observables.
             *
             * @example <caption>Rerun an interval Observable on every click event</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var result = clicks.switchMap((ev) => Rx.Observable.interval(1000));
             * result.subscribe(x => console.log(x));
             *
             * @see {@link concatMap}
             * @see {@link exhaustMap}
             * @see {@link mergeMap}
             * @see {@link switch}
             * @see {@link switchMapTo}
             *
             * @param {function(value: T, ?index: number): ObservableInput} project A function
             * that, when applied to an item emitted by the source Observable, returns an
             * Observable.
             * @param {function(outerValue: T, innerValue: I, outerIndex: number, innerIndex: number): any} [resultSelector]
             * A function to produce the value on the output Observable based on the values
             * and the indices of the source (outer) emission and the inner Observable
             * emission. The arguments passed to this function are:
             * - `outerValue`: the value that came from the source
             * - `innerValue`: the value that came from the projected Observable
             * - `outerIndex`: the "index" of the value that came from the source
             * - `innerIndex`: the "index" of the value from the projected Observable
             * @return {Observable} An Observable that emits the result of applying the
             * projection function (and the optional `resultSelector`) to each item emitted
             * by the source Observable and taking only the values from the most recently
             * projected inner Observable.
             * @method switchMap
             * @owner Observable
             */
            function switchMap(project, resultSelector) {
                return switchMap_1.switchMap(project, resultSelector)(this);
            }
            exports.switchMap = switchMap;
//# sourceMappingURL=switchMap.js.map

            /***/ }),
        /* 168 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var OuterSubscriber_1 = __webpack_require__(5);
            var subscribeToResult_1 = __webpack_require__(6);
            /* tslint:enable:max-line-length */
            /**
             * Projects each source value to an Observable which is merged in the output
             * Observable, emitting values only from the most recently projected Observable.
             *
             * <span class="informal">Maps each value to an Observable, then flattens all of
             * these inner Observables using {@link switch}.</span>
             *
             * <img src="./img/switchMap.png" width="100%">
             *
             * Returns an Observable that emits items based on applying a function that you
             * supply to each item emitted by the source Observable, where that function
             * returns an (so-called "inner") Observable. Each time it observes one of these
             * inner Observables, the output Observable begins emitting the items emitted by
             * that inner Observable. When a new inner Observable is emitted, `switchMap`
             * stops emitting items from the earlier-emitted inner Observable and begins
             * emitting items from the new one. It continues to behave like this for
             * subsequent inner Observables.
             *
             * @example <caption>Rerun an interval Observable on every click event</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var result = clicks.switchMap((ev) => Rx.Observable.interval(1000));
             * result.subscribe(x => console.log(x));
             *
             * @see {@link concatMap}
             * @see {@link exhaustMap}
             * @see {@link mergeMap}
             * @see {@link switch}
             * @see {@link switchMapTo}
             *
             * @param {function(value: T, ?index: number): ObservableInput} project A function
             * that, when applied to an item emitted by the source Observable, returns an
             * Observable.
             * @param {function(outerValue: T, innerValue: I, outerIndex: number, innerIndex: number): any} [resultSelector]
             * A function to produce the value on the output Observable based on the values
             * and the indices of the source (outer) emission and the inner Observable
             * emission. The arguments passed to this function are:
             * - `outerValue`: the value that came from the source
             * - `innerValue`: the value that came from the projected Observable
             * - `outerIndex`: the "index" of the value that came from the source
             * - `innerIndex`: the "index" of the value from the projected Observable
             * @return {Observable} An Observable that emits the result of applying the
             * projection function (and the optional `resultSelector`) to each item emitted
             * by the source Observable and taking only the values from the most recently
             * projected inner Observable.
             * @method switchMap
             * @owner Observable
             */
            function switchMap(project, resultSelector) {
                return function switchMapOperatorFunction(source) {
                    return source.lift(new SwitchMapOperator(project, resultSelector));
                };
            }
            exports.switchMap = switchMap;
            var SwitchMapOperator = (function () {
                function SwitchMapOperator(project, resultSelector) {
                    this.project = project;
                    this.resultSelector = resultSelector;
                }
                SwitchMapOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new SwitchMapSubscriber(subscriber, this.project, this.resultSelector));
                };
                return SwitchMapOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var SwitchMapSubscriber = (function (_super) {
                __extends(SwitchMapSubscriber, _super);
                function SwitchMapSubscriber(destination, project, resultSelector) {
                    _super.call(this, destination);
                    this.project = project;
                    this.resultSelector = resultSelector;
                    this.index = 0;
                }
                SwitchMapSubscriber.prototype._next = function (value) {
                    var result;
                    var index = this.index++;
                    try {
                        result = this.project(value, index);
                    }
                    catch (error) {
                        this.destination.error(error);
                        return;
                    }
                    this._innerSub(result, value, index);
                };
                SwitchMapSubscriber.prototype._innerSub = function (result, value, index) {
                    var innerSubscription = this.innerSubscription;
                    if (innerSubscription) {
                        innerSubscription.unsubscribe();
                    }
                    this.add(this.innerSubscription = subscribeToResult_1.subscribeToResult(this, result, value, index));
                };
                SwitchMapSubscriber.prototype._complete = function () {
                    var innerSubscription = this.innerSubscription;
                    if (!innerSubscription || innerSubscription.closed) {
                        _super.prototype._complete.call(this);
                    }
                };
                SwitchMapSubscriber.prototype._unsubscribe = function () {
                    this.innerSubscription = null;
                };
                SwitchMapSubscriber.prototype.notifyComplete = function (innerSub) {
                    this.remove(innerSub);
                    this.innerSubscription = null;
                    if (this.isStopped) {
                        _super.prototype._complete.call(this);
                    }
                };
                SwitchMapSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {
                    if (this.resultSelector) {
                        this._tryNotifyNext(outerValue, innerValue, outerIndex, innerIndex);
                    }
                    else {
                        this.destination.next(innerValue);
                    }
                };
                SwitchMapSubscriber.prototype._tryNotifyNext = function (outerValue, innerValue, outerIndex, innerIndex) {
                    var result;
                    try {
                        result = this.resultSelector(outerValue, innerValue, outerIndex, innerIndex);
                    }
                    catch (err) {
                        this.destination.error(err);
                        return;
                    }
                    this.destination.next(result);
                };
                return SwitchMapSubscriber;
            }(OuterSubscriber_1.OuterSubscriber));
//# sourceMappingURL=switchMap.js.map

            /***/ }),
        /* 169 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var take_1 = __webpack_require__(170);
            /**
             * Emits only the first `count` values emitted by the source Observable.
             *
             * <span class="informal">Takes the first `count` values from the source, then
             * completes.</span>
             *
             * <img src="./img/take.png" width="100%">
             *
             * `take` returns an Observable that emits only the first `count` values emitted
             * by the source Observable. If the source emits fewer than `count` values then
             * all of its values are emitted. After that, it completes, regardless if the
             * source completes.
             *
             * @example <caption>Take the first 5 seconds of an infinite 1-second interval Observable</caption>
             * var interval = Rx.Observable.interval(1000);
             * var five = interval.take(5);
             * five.subscribe(x => console.log(x));
             *
             * @see {@link takeLast}
             * @see {@link takeUntil}
             * @see {@link takeWhile}
             * @see {@link skip}
             *
             * @throws {ArgumentOutOfRangeError} When using `take(i)`, it delivers an
             * ArgumentOutOrRangeError to the Observer's `error` callback if `i < 0`.
             *
             * @param {number} count The maximum number of `next` values to emit.
             * @return {Observable<T>} An Observable that emits only the first `count`
             * values emitted by the source Observable, or all of the values from the source
             * if the source emits fewer than `count` values.
             * @method take
             * @owner Observable
             */
            function take(count) {
                return take_1.take(count)(this);
            }
            exports.take = take;
//# sourceMappingURL=take.js.map

            /***/ }),
        /* 170 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var Subscriber_1 = __webpack_require__(1);
            var ArgumentOutOfRangeError_1 = __webpack_require__(171);
            var EmptyObservable_1 = __webpack_require__(25);
            /**
             * Emits only the first `count` values emitted by the source Observable.
             *
             * <span class="informal">Takes the first `count` values from the source, then
             * completes.</span>
             *
             * <img src="./img/take.png" width="100%">
             *
             * `take` returns an Observable that emits only the first `count` values emitted
             * by the source Observable. If the source emits fewer than `count` values then
             * all of its values are emitted. After that, it completes, regardless if the
             * source completes.
             *
             * @example <caption>Take the first 5 seconds of an infinite 1-second interval Observable</caption>
             * var interval = Rx.Observable.interval(1000);
             * var five = interval.take(5);
             * five.subscribe(x => console.log(x));
             *
             * @see {@link takeLast}
             * @see {@link takeUntil}
             * @see {@link takeWhile}
             * @see {@link skip}
             *
             * @throws {ArgumentOutOfRangeError} When using `take(i)`, it delivers an
             * ArgumentOutOrRangeError to the Observer's `error` callback if `i < 0`.
             *
             * @param {number} count The maximum number of `next` values to emit.
             * @return {Observable<T>} An Observable that emits only the first `count`
             * values emitted by the source Observable, or all of the values from the source
             * if the source emits fewer than `count` values.
             * @method take
             * @owner Observable
             */
            function take(count) {
                return function (source) {
                    if (count === 0) {
                        return new EmptyObservable_1.EmptyObservable();
                    }
                    else {
                        return source.lift(new TakeOperator(count));
                    }
                };
            }
            exports.take = take;
            var TakeOperator = (function () {
                function TakeOperator(total) {
                    this.total = total;
                    if (this.total < 0) {
                        throw new ArgumentOutOfRangeError_1.ArgumentOutOfRangeError;
                    }
                }
                TakeOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new TakeSubscriber(subscriber, this.total));
                };
                return TakeOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var TakeSubscriber = (function (_super) {
                __extends(TakeSubscriber, _super);
                function TakeSubscriber(destination, total) {
                    _super.call(this, destination);
                    this.total = total;
                    this.count = 0;
                }
                TakeSubscriber.prototype._next = function (value) {
                    var total = this.total;
                    var count = ++this.count;
                    if (count <= total) {
                        this.destination.next(value);
                        if (count === total) {
                            this.destination.complete();
                            this.unsubscribe();
                        }
                    }
                };
                return TakeSubscriber;
            }(Subscriber_1.Subscriber));
//# sourceMappingURL=take.js.map

            /***/ }),
        /* 171 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            /**
             * An error thrown when an element was queried at a certain index of an
             * Observable, but no such index or position exists in that sequence.
             *
             * @see {@link elementAt}
             * @see {@link take}
             * @see {@link takeLast}
             *
             * @class ArgumentOutOfRangeError
             */
            var ArgumentOutOfRangeError = (function (_super) {
                __extends(ArgumentOutOfRangeError, _super);
                function ArgumentOutOfRangeError() {
                    var err = _super.call(this, 'argument out of range');
                    this.name = err.name = 'ArgumentOutOfRangeError';
                    this.stack = err.stack;
                    this.message = err.message;
                }
                return ArgumentOutOfRangeError;
            }(Error));
            exports.ArgumentOutOfRangeError = ArgumentOutOfRangeError;
//# sourceMappingURL=ArgumentOutOfRangeError.js.map

            /***/ }),
        /* 172 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var takeUntil_1 = __webpack_require__(173);
            /**
             * Emits the values emitted by the source Observable until a `notifier`
             * Observable emits a value.
             *
             * <span class="informal">Lets values pass until a second Observable,
             * `notifier`, emits something. Then, it completes.</span>
             *
             * <img src="./img/takeUntil.png" width="100%">
             *
             * `takeUntil` subscribes and begins mirroring the source Observable. It also
             * monitors a second Observable, `notifier` that you provide. If the `notifier`
             * emits a value, the output Observable stops mirroring the source Observable
             * and completes.
             *
             * @example <caption>Tick every second until the first click happens</caption>
             * var interval = Rx.Observable.interval(1000);
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var result = interval.takeUntil(clicks);
             * result.subscribe(x => console.log(x));
             *
             * @see {@link take}
             * @see {@link takeLast}
             * @see {@link takeWhile}
             * @see {@link skip}
             *
             * @param {Observable} notifier The Observable whose first emitted value will
             * cause the output Observable of `takeUntil` to stop emitting values from the
             * source Observable.
             * @return {Observable<T>} An Observable that emits the values from the source
             * Observable until such time as `notifier` emits its first value.
             * @method takeUntil
             * @owner Observable
             */
            function takeUntil(notifier) {
                return takeUntil_1.takeUntil(notifier)(this);
            }
            exports.takeUntil = takeUntil;
//# sourceMappingURL=takeUntil.js.map

            /***/ }),
        /* 173 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var OuterSubscriber_1 = __webpack_require__(5);
            var subscribeToResult_1 = __webpack_require__(6);
            /**
             * Emits the values emitted by the source Observable until a `notifier`
             * Observable emits a value.
             *
             * <span class="informal">Lets values pass until a second Observable,
             * `notifier`, emits something. Then, it completes.</span>
             *
             * <img src="./img/takeUntil.png" width="100%">
             *
             * `takeUntil` subscribes and begins mirroring the source Observable. It also
             * monitors a second Observable, `notifier` that you provide. If the `notifier`
             * emits a value or a complete notification, the output Observable stops
             * mirroring the source Observable and completes.
             *
             * @example <caption>Tick every second until the first click happens</caption>
             * var interval = Rx.Observable.interval(1000);
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var result = interval.takeUntil(clicks);
             * result.subscribe(x => console.log(x));
             *
             * @see {@link take}
             * @see {@link takeLast}
             * @see {@link takeWhile}
             * @see {@link skip}
             *
             * @param {Observable} notifier The Observable whose first emitted value will
             * cause the output Observable of `takeUntil` to stop emitting values from the
             * source Observable.
             * @return {Observable<T>} An Observable that emits the values from the source
             * Observable until such time as `notifier` emits its first value.
             * @method takeUntil
             * @owner Observable
             */
            function takeUntil(notifier) {
                return function (source) { return source.lift(new TakeUntilOperator(notifier)); };
            }
            exports.takeUntil = takeUntil;
            var TakeUntilOperator = (function () {
                function TakeUntilOperator(notifier) {
                    this.notifier = notifier;
                }
                TakeUntilOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new TakeUntilSubscriber(subscriber, this.notifier));
                };
                return TakeUntilOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var TakeUntilSubscriber = (function (_super) {
                __extends(TakeUntilSubscriber, _super);
                function TakeUntilSubscriber(destination, notifier) {
                    _super.call(this, destination);
                    this.notifier = notifier;
                    this.add(subscribeToResult_1.subscribeToResult(this, notifier));
                }
                TakeUntilSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {
                    this.complete();
                };
                TakeUntilSubscriber.prototype.notifyComplete = function () {
                    // noop
                };
                return TakeUntilSubscriber;
            }(OuterSubscriber_1.OuterSubscriber));
//# sourceMappingURL=takeUntil.js.map

            /***/ }),
        /* 174 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var async_1 = __webpack_require__(26);
            var timestamp_1 = __webpack_require__(175);
            /**
             * @param scheduler
             * @return {Observable<Timestamp<any>>|WebSocketSubject<T>|Observable<T>}
             * @method timestamp
             * @owner Observable
             */
            function timestamp(scheduler) {
                if (scheduler === void 0) { scheduler = async_1.async; }
                return timestamp_1.timestamp(scheduler)(this);
            }
            exports.timestamp = timestamp;
//# sourceMappingURL=timestamp.js.map

            /***/ }),
        /* 175 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var async_1 = __webpack_require__(26);
            var map_1 = __webpack_require__(66);
            /**
             * @param scheduler
             * @return {Observable<Timestamp<any>>|WebSocketSubject<T>|Observable<T>}
             * @method timestamp
             * @owner Observable
             */
            function timestamp(scheduler) {
                if (scheduler === void 0) { scheduler = async_1.async; }
                return map_1.map(function (value) { return new Timestamp(value, scheduler.now()); });
                // return (source: Observable<T>) => source.lift(new TimestampOperator(scheduler));
            }
            exports.timestamp = timestamp;
            var Timestamp = (function () {
                function Timestamp(value, timestamp) {
                    this.value = value;
                    this.timestamp = timestamp;
                }
                return Timestamp;
            }());
            exports.Timestamp = Timestamp;
            ;
//# sourceMappingURL=timestamp.js.map

            /***/ }),
        /* 176 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var withLatestFrom_1 = __webpack_require__(177);
            /* tslint:enable:max-line-length */
            /**
             * Combines the source Observable with other Observables to create an Observable
             * whose values are calculated from the latest values of each, only when the
             * source emits.
             *
             * <span class="informal">Whenever the source Observable emits a value, it
             * computes a formula using that value plus the latest values from other input
             * Observables, then emits the output of that formula.</span>
             *
             * <img src="./img/withLatestFrom.png" width="100%">
             *
             * `withLatestFrom` combines each value from the source Observable (the
             * instance) with the latest values from the other input Observables only when
             * the source emits a value, optionally using a `project` function to determine
             * the value to be emitted on the output Observable. All input Observables must
             * emit at least one value before the output Observable will emit a value.
             *
             * @example <caption>On every click event, emit an array with the latest timer event plus the click event</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var timer = Rx.Observable.interval(1000);
             * var result = clicks.withLatestFrom(timer);
             * result.subscribe(x => console.log(x));
             *
             * @see {@link combineLatest}
             *
             * @param {ObservableInput} other An input Observable to combine with the source
             * Observable. More than one input Observables may be given as argument.
             * @param {Function} [project] Projection function for combining values
             * together. Receives all values in order of the Observables passed, where the
             * first parameter is a value from the source Observable. (e.g.
             * `a.withLatestFrom(b, c, (a1, b1, c1) => a1 + b1 + c1)`). If this is not
             * passed, arrays will be emitted on the output Observable.
             * @return {Observable} An Observable of projected values from the most recent
             * values from each input Observable, or an array of the most recent values from
             * each input Observable.
             * @method withLatestFrom
             * @owner Observable
             */
            function withLatestFrom() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i - 0] = arguments[_i];
                }
                return withLatestFrom_1.withLatestFrom.apply(void 0, args)(this);
            }
            exports.withLatestFrom = withLatestFrom;
//# sourceMappingURL=withLatestFrom.js.map

            /***/ }),
        /* 177 */
        /***/ (function(module, exports, __webpack_require__) {

            "use strict";

            var __extends = (this && this.__extends) || function (d, b) {
                for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
            var OuterSubscriber_1 = __webpack_require__(5);
            var subscribeToResult_1 = __webpack_require__(6);
            /* tslint:enable:max-line-length */
            /**
             * Combines the source Observable with other Observables to create an Observable
             * whose values are calculated from the latest values of each, only when the
             * source emits.
             *
             * <span class="informal">Whenever the source Observable emits a value, it
             * computes a formula using that value plus the latest values from other input
             * Observables, then emits the output of that formula.</span>
             *
             * <img src="./img/withLatestFrom.png" width="100%">
             *
             * `withLatestFrom` combines each value from the source Observable (the
             * instance) with the latest values from the other input Observables only when
             * the source emits a value, optionally using a `project` function to determine
             * the value to be emitted on the output Observable. All input Observables must
             * emit at least one value before the output Observable will emit a value.
             *
             * @example <caption>On every click event, emit an array with the latest timer event plus the click event</caption>
             * var clicks = Rx.Observable.fromEvent(document, 'click');
             * var timer = Rx.Observable.interval(1000);
             * var result = clicks.withLatestFrom(timer);
             * result.subscribe(x => console.log(x));
             *
             * @see {@link combineLatest}
             *
             * @param {ObservableInput} other An input Observable to combine with the source
             * Observable. More than one input Observables may be given as argument.
             * @param {Function} [project] Projection function for combining values
             * together. Receives all values in order of the Observables passed, where the
             * first parameter is a value from the source Observable. (e.g.
             * `a.withLatestFrom(b, c, (a1, b1, c1) => a1 + b1 + c1)`). If this is not
             * passed, arrays will be emitted on the output Observable.
             * @return {Observable} An Observable of projected values from the most recent
             * values from each input Observable, or an array of the most recent values from
             * each input Observable.
             * @method withLatestFrom
             * @owner Observable
             */
            function withLatestFrom() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i - 0] = arguments[_i];
                }
                return function (source) {
                    var project;
                    if (typeof args[args.length - 1] === 'function') {
                        project = args.pop();
                    }
                    var observables = args;
                    return source.lift(new WithLatestFromOperator(observables, project));
                };
            }
            exports.withLatestFrom = withLatestFrom;
            var WithLatestFromOperator = (function () {
                function WithLatestFromOperator(observables, project) {
                    this.observables = observables;
                    this.project = project;
                }
                WithLatestFromOperator.prototype.call = function (subscriber, source) {
                    return source.subscribe(new WithLatestFromSubscriber(subscriber, this.observables, this.project));
                };
                return WithLatestFromOperator;
            }());
            /**
             * We need this JSDoc comment for affecting ESDoc.
             * @ignore
             * @extends {Ignored}
             */
            var WithLatestFromSubscriber = (function (_super) {
                __extends(WithLatestFromSubscriber, _super);
                function WithLatestFromSubscriber(destination, observables, project) {
                    _super.call(this, destination);
                    this.observables = observables;
                    this.project = project;
                    this.toRespond = [];
                    var len = observables.length;
                    this.values = new Array(len);
                    for (var i = 0; i < len; i++) {
                        this.toRespond.push(i);
                    }
                    for (var i = 0; i < len; i++) {
                        var observable = observables[i];
                        this.add(subscribeToResult_1.subscribeToResult(this, observable, observable, i));
                    }
                }
                WithLatestFromSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {
                    this.values[outerIndex] = innerValue;
                    var toRespond = this.toRespond;
                    if (toRespond.length > 0) {
                        var found = toRespond.indexOf(outerIndex);
                        if (found !== -1) {
                            toRespond.splice(found, 1);
                        }
                    }
                };
                WithLatestFromSubscriber.prototype.notifyComplete = function () {
                    // noop
                };
                WithLatestFromSubscriber.prototype._next = function (value) {
                    if (this.toRespond.length === 0) {
                        var args = [value].concat(this.values);
                        if (this.project) {
                            this._tryProject(args);
                        }
                        else {
                            this.destination.next(args);
                        }
                    }
                };
                WithLatestFromSubscriber.prototype._tryProject = function (args) {
                    var result;
                    try {
                        result = this.project.apply(this, args);
                    }
                    catch (err) {
                        this.destination.error(err);
                        return;
                    }
                    this.destination.next(result);
                };
                return WithLatestFromSubscriber;
            }(OuterSubscriber_1.OuterSubscriber));
//# sourceMappingURL=withLatestFrom.js.map

            /***/ }),
        /* 178 */
        /***/ (function(module, exports, __webpack_require__) {

            module.exports = __webpack_require__.p + "style.css";

            /***/ })
        /******/ ]);
});
//# sourceMappingURL=hy-drawer.js.map