<?php
$number_services=$this->totalRecord;
$input = Factory::getInput();
$sort = $input->getString('key_sort', "a.ordering");
$direction = $input->getString('direction', "ASC");
 ?>
<div class="service-item-table ">
    <div class="row">
        <div class="col-sm-12">
            <div class="filter-price">
                <div class="number">
                    <?php if ($number_services<=1) {?>
                        <?php esc_attr_e($number_services) ?> <?php esc_attr_e('Result Found', 'wpbookingpro') ?>
                    <?php } else{ ?>
                        <?php esc_attr_e($number_services) ?> <?php esc_attr_e('Results Found', 'wpbookingpro') ?>
                    <?php }?>
                </div>
                <div class="sort-by-price">
                    <p class="sort-by"><?php esc_attr_e('Sort By', 'wpbookingpro') ?>:</p>
                    <div class="dropdown">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:;">
                            <p class="lowest <?php echo $direction=="DESC"?' active ':'' ?>"><?php esc_attr_e('Lowest Price', 'wpbookingpro') ?></p>
                            <span>
                                <i class="fas fa-sort-down"></i>
                            </span>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <ul class="sort-display">
                                <li class="<?php echo $sort=="price ASC"?' active ':'' ?>"><a  class="lowest-price" data-key_sort="a.price" data-direction="ASC"  href="javascript:void()"><?php esc_attr_e('Lowest Price', 'wpbookingpro') ?></i></a>
                                </li>
                                <li class="<?php echo $sort=="price DESC"?' active ':'' ?>"><a class="highest-price" data-key_sort="a.price" data-direction="DESC"   href="javascript:void()"><?php esc_attr_e('Highest Price', 'wpbookingpro') ?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <?php foreach ( $this->list as $item){ ?>
            <div class="col-sm-6">
                <div class="img-box-service">
                    <div class="image-price-star">
                        <a href="<?php esc_html_e($this->frontendGoToLink("service.detail_new",
                            "service_id=" . $item->id)) ?>"><img class="image-service-image service-image-cover" src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($item->image) ?>" alt="image-service-trainer"/></a>
                        <ul class="list-rating-star ">
                            <?php
                                $number_review=count($item->list_reviews);
                                $total_rating_avg = 0;
                                foreach ($item->list_reviews as $list_review){
                                    $total_rating_avg +=$list_review->rating_avg;
                                }
                                if($number_review>0){
                                    $rating_avg_avg = $total_rating_avg / $number_review;
                                } else{
                                    $rating_avg_avg=0;
                                }
                                $list_star_sum = WpBookingPro_FrontEndHelper::get_rating_star($rating_avg_avg);
                            ?>
                            <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                <li class="item-star"><i class="fas fa-star"></i></li>
                            <?php }?>
                            <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                            <?php }?>
                            <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                <li class="item-star"><i class="far fa-star"></i></li>
                            <?php }?>
                        </ul>
                        <span class="event_price_format label label-primary "><?php  esc_html_e(WpBookingPro_FrontEndHelper::format_currency($item->price)) ?></span>
                        <span class="heart"><i class="far fa-heart"></i></span>
                    </div>
                    <div class="wrapper-center">
                        <h4><a href="<?php esc_html_e($this->frontendGoToLink("service.detail_new",
                                "service_id=" . $item->id)) ?>" class="service_name"><?php esc_attr_e($item->name)?></a></h4>
                        <div class="line-content">
                                <span class="property">
                                    <span class="category"><?php  esc_attr_e($item->category_name) ?></span>
                                </span>
                        </div>
                        <div class="duration">
                                <span class="property">
                                    <span>
                                        <i class="icon-nb-clock"></i>
                                    </span>
                                    <span class="service_duration">
                                        <?php if ($item->duration<=1) {?>
                                            <?php esc_attr_e($item->duration) ?> <?php esc_attr_e('Hour', 'wpbookingpro') ?>
                                        <?php }else{ ?>
                                            <?php esc_attr_e($item->duration) ?> <?php esc_attr_e('Hours', 'wpbookingpro') ?>
                                        <?php } ?>
                                    </span>
                                </span>
                        </div>
                        <div class="location">
                                <span>
                                    <i class="icon-nb-pin"></i>
                                    <?php esc_attr_e('', 'wpbookingpro') ?>
                                </span>
                            <span class="service_address"><?php  esc_attr_e($item->location_name) ?></span>
                        </div>
                        <div class="wrapper-employee">
                            <?php foreach ($item->list_employee as $list_employee) { ?>
                                    <img src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($list_employee->image) ?>" alt="employee-cover" />
                            <?php } ?>
                        </div>
                        <div class="wrapper-button-action">
                            <a class="div-link" href="<?php esc_html_e($this->frontendGoToLink("service.detail_new",
                                "service_id=" . $item->id)) ?>"><?php esc_attr_e('Link', 'wpbookingpro') ?></a>
                            <div class="btn-booknow">
                                <a class="book-service" href="<?php esc_html_e($this->frontendGoToLink("service.detail_new",
                                    "service_id=" . $item->id)) ?>"><?php esc_attr_e('Book now', 'wpbookingpro') ?></a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        <?php } ?>
    </div>
</div>
