<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_list_service.less');
?>
<div class="view-list-service">
    <h1 class="title"><?php esc_attr_e('Our service','wpbookingpro') ?></h1>
    <p class="des"><?php esc_attr_e('Exercise with the leading bodybuilding experts on the world, helping to improve the overall health','wpbookingpro'); ?></p>
    <div class="row">
		<?php foreach ($this->list as $item) { ?>
            <div class="col-md-4 col-sm-6">
                <div class="wrapper-service-item">
                    <div class="layer-grey">
                        <a href="<?php esc_html_e($this->frontendGoToLink("service.detail_new",
							"service_id=" . $item->id)) ?>" class="btn btn-outline-secondary view-more"><i
                                    class="fas fa-info-circle"></i><span><?php esc_attr_e('View more','wpbookingpro') ?></span></a>
                    </div>
                    <div class="layer-content">
                        <div class="block-img"
                             style="background-image: url('<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($item->service_image_intro) ?>')"></div>
                        <div class="block-content">
                            <div class="avatar-service-item">
                                <span><?php
									$name = $item->name;
									$name = Utility::clean($name);
									$name = Utility::clean_all_space_to_single_space($name);
									$arrName = explode(' ', $name);
									$arrName = array_splice($arrName, 0, 3);
									$result = '';
									foreach ($arrName as $value) {
										$result .= substr($value, 0, 1);
									}
									esc_html_e($result);
									?></span>
                            </div>
                            <div class="block-info-service">
                                <h3><a href="<?php esc_html_e($this->goToLink("service.detail_new",
                                        "service_id=" . $item->id)) ?>"><?php esc_html_e($item->name) ?></a></h3>

                                <p><?php esc_attr_e('Price','wpbookingpro') ?>
                                    : <?php echo WpBookingPro_FrontEndHelper::format_currency($item->price) ?></p>
                            </div>
                            <div class="img-avatar-employee">
                                <?php foreach ($item->list_employee as $list_employee) { ?>
                                    <div class="img-box">
                                        <img src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($list_employee->image) ?>" alt="employee-cover" />
                                    </div>
                                <?php } ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
		<?php } ?>
    </div>
</div>