block-review-by-customer<?php

use Grafika\Grafika;
use WooBooking\CMS\Utilities\Utility;
require_once WPBOOKINGPRO_PATH_ROOT . "/nb_apps/nb_woobooking/helpers/ConfigHelper.php";
WpBookingPro_HtmlFrontend::_('jquery.slick');
WpBookingPro_HtmlFrontend::_('jquery.validate');
WpBookingPro_HtmlFrontend::_('jquery.confirm');

$editor = Grafika::createEditor();
$doc = Factory::getDocument();
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_service_detail_new.less');
$appConfig = Factory::getAppConfig();
$booking_style = $appConfig->get('booking_style', 'in_line');
$is_multi_product_in_cart = WpBookingPro_FrontEndHelper::is_multi_product_in_cart();
$open_time = $this->item->open_time;
$open_time=date('h:i A',strtotime($open_time));
$close_time= $this->item->close_time;
$close_time=date('h:i A',strtotime($close_time));
$working_day= $this->item->working_day;
$working_day=isset($working_day)?json_decode($working_day):array();
?>
    <div class="view-service-detail-new">
        <div class="bread-crumb">
            <a class="link-category" href="<?php esc_html_e($this->frontendGoToLink("category.list")); ?>"><?php esc_attr_e('Category','wpbookingpro')?></a>
            <i class="icon-nb-down-arrow"></i>
            <a class="link-category" href="<?php esc_html_e($this->frontendGoToLink("service.list", "category_id=" . $this->item->category_id)) ?>"><?php esc_html_e($this->item->category->name);?></a>
            <i class="icon-nb-down-arrow"></i>
            <span><?php esc_html_e($this->item->name);?></span>
        </div>
        <div class="block-alert"></div>
        <div class="row">
            <div class="col-md-12">
                <div class="block-title-service">
                    <h2><?php esc_html_e($this->item->name);?></h2>
                    <p><?php echo(isset($this->item->location->address)?$this->item->location->address:'');?></p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-8">
                <div class="wrapper-gallery-slider">
                    <a class="arrow-prev"><i class="icon-nb-down-arrow"></i></a>
                    <a class="arrow-next"><i class="icon-nb-down-arrow"></i></a>
                    <div class="block-gallery-slider-large">
                        <?php foreach ($this->item->list_image as $image) { ?>
                            <div class="img-gallery-large">
                                <div>
                                    <img src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($image->path) ?>" alt="image-gallery">
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="block-gallery-slider-small">
                        <?php foreach ($this->item->list_image as $image) { ?>
                            <div class="gallery-img-box">
                                <div>
                                    <img class="demo cursor" src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($image->path) ?>" alt="The Woods">
                                </div>
                            </div>
                        <?php }?>
                    </div>
                </div>
                <div class="service-information">
                    <p><?php echo(html_entity_decode($this->item->description));?></p>
                </div>
                <div class="block-list-event-service">
                    <?php
                    $field = $this->form->getField('list_event');
                    echo($field->input);
                    ?>
                </div>
                <form action="<?php echo Factory::getRootUrl() ?>wp-booking-pro" method="post" class="booking-form" name="client-form">
                    <div class="block-booking-information">
                        <h5><?php esc_attr_e('Select expert','wpbookingpro')?></h5>
                        <?php
                        $field = $this->form->getField('employee_id');
                        echo($field->input);
                        ?>
                        <h5><?php esc_attr_e('Select time','wpbookingpro')?></h5>
                        <?php
                        $field = $this->form->getField('calendar');
                        echo($field->input);
                        ?>
                    </div>
                    <?php if ($booking_style == "in_line") { ?>
                        <div class="wrapper-block-check-out">
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="infor-payment-left">
                                        <p><?php esc_attr_e('Expert','wpbookingpro') ?>: <span class="trainer-info"></span></p>
                                        <p><?php esc_attr_e('Local time','wpbookingpro') ?>: <span class="local-time"></span></p>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="info-payment-right">
                                        <p><?php esc_attr_e('Date','wpbookingpro') ?>: <span class="date-info"></span></p>
                                        <p><?php esc_attr_e('Location','wpbookingpro') ?>: <span class="location-info"><?php echo(isset($this->item->location->address)?$this->item->location->address:'')?></span></p>
                                    </div>
                                </div>
                            </div>
                            <div class="block-check-out">
                                <div class="row">
                                    <div class="col-sm-6 col-md-6">
                                        <div class="input-firstname">
                                            <?php
                                            $field = $this->form->getField('first_name');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="input-lastname">
                                            <?php
                                            $field = $this->form->getField('last_name');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6 col-md-6">
                                        <div class="input-email">
                                            <?php
                                            $field = $this->form->getField('email');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="input-phone">
                                            <?php
                                            $field = $this->form->getField('phone');
                                            $field->setId('phone' . rand(700, 30000));
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="block-select-payment">
                                <?php
                                $field = $this->form->getField('payment_id');
                                $disable_payment_online = (boolean)isset($item->disable_payment_online) ? $item->disable_payment_online : false;
                                $field->setDisablePaymentOnline($disable_payment_online);
                                ?>
                                <h6><?php esc_attr_e('Select payment','wpbookingpro')?></h6>
                                <?php echo($field->input); ?>
                            </div>
                            <div class="block-select-quantity">
                                <h6><?php esc_attr_e('Quantity','wpbookingpro')?></h6>
                                <?php
                                $field = $this->form->getField('number_person');
                                echo($field->input);
                                ?>
                            </div>
                            <div class="block-payment-item">
                                <h4><?php esc_attr_e('Payment info','wpbookingpro') ?></h4>
                                <div class="detail-payment-item">
                                    <span><?php esc_attr_e('Total number of persons','wpbookingpro') ?>:</span>
                                    <span class="number-person">1</span>
                                </div>
                                <div class="detail-payment-item">
                                    <span><?php esc_attr_e('Base price','wpbookingpro') ?>:</span>
                                    <span class="base-price"><?php echo WpBookingPro_FrontEndHelper::format_currency($this->item->price)?></span>
                                </div>
                                <div class="detail-payment-item total-cost">
                                    <span><?php esc_attr_e('Total','wpbookingpro') ?>:</span>
                                    <span class="total-cost-sum"><?php echo WpBookingPro_FrontEndHelper::format_currency($this->item->price)?></span>
                                </div>
                            </div>
                            <div class="wrapper-btn-checkout">
                                <button type="button" class="btn btn-primary btn-cancel mr-3">
                                    <span><?php esc_attr_e('Cancel','wpbookingpro') ?></span>
                                </button>
                                <button type="button" class="btn btn-danger btn-book-now">
                                    <span><?php esc_attr_e('Book now','wpbookingpro') ?></span>
                                </button>
                                <?php if ($is_multi_product_in_cart) { ?>
                                    <button type="button" class="btn btn-primary btn-add-to-cart">
                                        <span><?php esc_attr_e('Add to cart','wpbookingpro') ?></span>
                                    </button>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                    <input type="hidden" name="task" value="booking.book_service" />
                    <input type="hidden" name="service_id" value="<?php esc_html_e($this->item->id) ?>" />
                    <input type="hidden" name="event_id" value="" />
                </form>
                <div class="block-review-by-customer">
                    <h4>
                        <?php echo ucfirst(WoobookingText::_('our beloved customer reviews'))?>
                    </h4>
                    <?php foreach ($this->list_reviews as $list_reviews){
                        $rating_review_avg=WpBookingPro_FrontEndHelper::get_rating_star(($list_reviews->rating_service+ $list_reviews->rating_staff + $list_reviews->rating_ambience )/3);
                        $rating_service=WpBookingPro_FrontEndHelper::get_rating_star($list_reviews->rating_service);
                        $rating_staff=WpBookingPro_FrontEndHelper::get_rating_star($list_reviews->rating_staff);
                        $rating_ambience=WpBookingPro_FrontEndHelper::get_rating_star($list_reviews->rating_ambience);

                        ?>
                        <div class="block-review-item">
                            <div class="img-block">
                                <div>
                                    <img src="<?php echo Factory::getRootUrlPlugin()?>upload/employees/images/cover/12 Nov 1998458x494_img1-450x468.jpg" alt="">
                                </div>
                            </div>
                            <div class="block-content">
                                <h5><?php esc_html_e($list_reviews->name) ?></h5>
                                <ul class="list-rating-star">
                                    <?php for ($i=0; $i < $rating_review_avg[0]; $i++) {?>
                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                    <?php }?>
                                    <?php for ($i=0; $i <$rating_review_avg[1]; $i++) {?>
                                        <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                    <?php }?>
                                    <?php for ($i=0; $i <$rating_review_avg[2]; $i++) {?>
                                        <li class="item-star"><i class="far fa-star"></i></li>
                                    <?php }?>
                                </ul>
                                <p><?php esc_html_e($list_reviews->comment) ?></p>
                            </div>
                            <div class="block-time-review">
                                <?php
                                $date_review = date('F d, Y',strtotime($list_reviews->created_date));
                                $time_review = date('H:i',strtotime($list_reviews->created_date));
                                ?>
                                <h6><?php esc_html_e($date_review) ?> <?php esc_attr_e('at','wpbookingpro') ?> <?php esc_html_e($time_review) ?></h6>
                            </div>
                        </div>
                    <?php } ?>
                    <form action="<?php echo Factory::getRootUrl() ?>wp-booking-pro?page=service-detail_new&service_id=<?php esc_html_e($this->item->id) ?>" method="post" class="review-form" name="reviewer-form">
                        <div class="review">
                            <div class="add-review">
                                <div class="row">
                                    <div class="col-md-12">
                                        <h4><?php echo ucfirst(WoobookingText::_('Add review'))?></h4>
                                        <p><?php echo ucfirst(WoobookingText::_('Your email address will not be published. Required fields are marked *'))?></p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class=" col-sm-4 col-md-4">
                                        <div class="service-rating">
                                            <span><?php echo ucfirst(WoobookingText::_('Services Rating'))?></span>
                                            <div class='rating-stars'>
                                                <?php
                                                $field = $this->form->getField('rating_service');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=" col-sm-4 col-md-4">
                                        <div class="service-rating">
                                            <span><?php echo ucfirst(WoobookingText::_('Staff Rating'))?></span>
                                            <div class='rating-stars'>
                                                <?php
                                                $field = $this->form->getField('rating_staff');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class=" col-sm-4 col-md-4">
                                        <div class="service-rating">
                                            <span><?php echo ucfirst(WoobookingText::_('Ambience Rating'))?></span>
                                            <div class='rating-stars'>
                                                <?php
                                                $field = $this->form->getField('rating_ambience');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class=" col-sm-6 col-md-6">
                                        <div class="reviewer-first-name">
                                            <?php
                                            $field = $this->form->getField('full_name');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                    <div class=" col-sm-6 col-md-6">
                                        <div class="reviewer-last-name">
                                            <?php
                                            $field = $this->form->getField('email');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12 col-md-12">
                                        <div class="review-comment">
                                            <?php
                                            $field = $this->form->getField('note');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class=" col-sm-12 col-md-12">
                                        <button type="button" class="btn btn-danger btn-add-review">
                                            <span><?php esc_attr_e('Post Comment','wpbookingpro') ?></span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="task" value="review.add_review" />
                    </form>
                </div>
            </div>
            <div class="col-md-4">
                <div class="block-rating-service">
                    <div class="row">
                        <div class="col-xs-5 col-sm-5 col-md-5">
                            <div class="block-rating-left">
                                <?php

                                    $number_review=count($this->list_reviews);
                                    $total_rating_avg = 0;
                                    $total_rating_service = 0;
                                    $total_rating_staff = 0;
                                    $total_rating_ambience = 0;
                                    foreach ($this->list_reviews as $list_review){
                                        $total_rating_avg +=$list_review->rating_avg;
                                        $total_rating_service +=$list_review->rating_service;
                                        $total_rating_staff +=$list_review->rating_staff;
                                        $total_rating_ambience +=$list_review->rating_ambience;
                                    }
                                if ($number_review>0) {
                                    $rating_avg_avg = $total_rating_avg / $number_review;
                                    $rating_service_avg = $total_rating_service / $number_review;
                                    $rating_staff_avg = $total_rating_staff / $number_review;
                                    $rating_ambience_avg = $total_rating_ambience / $number_review;
                                } else{
                                    $rating_avg_avg=0;
                                    $rating_service_avg=0;
                                    $rating_staff_avg=0;
                                    $rating_ambience_avg=0;

                                }

                                    $list_star_sum = WpBookingPro_FrontEndHelper::get_rating_star($rating_avg_avg);
                                    $list_star_ambience = WpBookingPro_FrontEndHelper::get_rating_star($rating_ambience_avg);
                                    $list_star_staff = WpBookingPro_FrontEndHelper::get_rating_star($rating_staff_avg);
                                    $list_star_service = WpBookingPro_FrontEndHelper::get_rating_star($rating_service_avg);

                                ?>
                                <h6><?php esc_attr_e('Venue rating','wpbookingpro')?></h6>
                                <p><?php esc_html_e(round($rating_avg_avg,1));?></p>
                                <div class="block-rating">
                                    <ul class="list-rating-star">
                                        <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                    <div class="rating-review">
                                        <span>
                                            <?php if ($number_review>1){?>
                                                <?php esc_attr_e($number_review) ?> <?php esc_attr_e('reviews','wpbookingpro');?>
                                            <?php } else{?>
                                                <?php esc_attr_e($number_review) ?> <?php esc_attr_e('review','wpbookingpro');?>
                                            <?php } ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-7 col-sm-7 col-md-7">
                            <div class="block-rating-right">
                                <div class="item-rating">
                                    <p><?php esc_attr_e('Ambience','wpbookingpro')?></p>
                                    <ul class="list-rating-star">
                                        <?php for ($i=0; $i <$list_star_ambience[0]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_ambience[1]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_ambience[2]; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                </div>
                                <div class="item-rating">
                                    <p><?php esc_attr_e('Service','wpbookingpro')?></p>
                                    <ul class="list-rating-star">
                                        <?php for ($i=0; $i <$list_star_service[0]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_service[1]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_service[2]; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                </div>
                                <div class="item-rating">
                                    <p><?php esc_attr_e('Staff','wpbookingpro')?></p>
                                    <ul class="list-rating-star">
                                        <?php for ($i=0; $i <$list_star_staff[0]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_staff[1]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_staff[2]; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="block-location-info">
                    <div class="map-block">
                        <?php echo(isset($this->item->location->iframe) ?html_entity_decode($this->item->location->iframe): '');?>
                    </div>
                    <h5><?php echo(isset($this->item->location->name)?$this->item->location->name:'');?></h5>
                    <p><?php echo(isset($this->item->location->address)?$this->item->location->address:'');?></p>
                    <div class="block-social-icon">
                        <a class="item-social" href="<?php esc_html_e($this->item->params->get('facebook')) ?>">
                            <i class="icon-nb-facebook"></i>
                        </a>
                        <a class="item-social" href="<?php echo(isset($this->item->mobile)?'tel:'.$this->item->mobile:'#');?>">
                            <i class="icon-nb-phone-call"></i>
                        </a>
                        <a class="item-social" href="<?php esc_html_e($this->item->params->get('instagram')) ?>">
                            <i class="icon-nb-instagram"></i>
                        </a>
                    </div>
                </div>
                <div class="block-info-working-time">
                    <?php if(count((array)$working_day)) {?>
                        <?php foreach ($working_day as $day) {?>
                            <div class="work-time-item">
                                <span><?php esc_attr_e($day)?></span>
                                <span><?php esc_html_e($open_time);?> - <?php esc_html_e($close_time);?></span>
                            </div>
                        <?php }?>
                    <?php }?>
                </div>
            </div>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-service-detail-new','view_service_detail_new',array(
    'list_event'=>$this->list_event,
    'service_item'=>$this->item,
    'title'=>''
),'nb_apps/nb_woobooking/assets/js/view_service_detail_new.js');