<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_PaymentView")) {
    /**
     * Class WpBookingPro_PaymentView
     */
    class WpBookingPro_PaymentView extends WooBookingView
    {
        /**
         * @var
         */
        public $item;
        /**
         * @var
         */
        public $order;
        /**
         * @var
         */
        public $paymentPlugin;

        /**
         * @param null $tpl
         * @return false|string
         * @throws Exception
         */
        public function display($tpl = null)
        {
            $input = Factory::getInput();
            switch ($tpl) {
                case "paynow":
                    $orderModel = WoobookingModel::getInstance('order');
                    $order_id = $input->getInt('order_id', 0);
                    $this->order = $orderModel->getItem($order_id);
                    $orderPackageModel = WoobookingModel::getInstance('packageOrder');
                    $this->order_package = $orderPackageModel->getItem($order_id);
                    $paymentModel = WoobookingModel::getInstance('payment');
                    $list_rate = (array)($this->order->list_rate);
                    if (!empty($list_rate)) {
                        $this->paymentPlugin = $paymentModel->getPaymentPlugin($this->order->payment_id);
                    } else {
                        $this->paymentPlugin = $paymentModel->getPaymentPlugin($this->order_package->payment_id);
                    }
                    break;
                case "return":
                    $orderModel = WoobookingModel::getInstance('order');
                    $order_id = $input->getInt('order_id', 0);
                    $this->order = $orderModel->getItem($order_id);
                    $orderPackageModel = WoobookingModel::getInstance('packageOrder');
                    $this->order_package = $orderPackageModel->getItem($order_id);
                    $paymentModel = WoobookingModel::getInstance('payment');
                    $list_rate = (array)($this->order->list_rate);
                    if (!empty($list_rate)) {
                        $this->paymentPlugin = $paymentModel->getPaymentPlugin($this->order->payment_id);
                    } else {
                        $this->paymentPlugin = $paymentModel->getPaymentPlugin($this->order_package->payment_id);
                    }
                    $appConfig = Factory::getAppConfig();
                    $complete_order_status_id = $appConfig->get('complete_order_status_id', 5);
                    $data = array(
                        'id' => $order_id,
                        "order_status_id" => $complete_order_status_id
                    );
                    $orderModel->save($data);
                    break;
                case "cancel":
                    $orderModel = WoobookingModel::getInstance('order');
                    $order_id = $input->getInt('order_id', 0);
                    $this->order = $orderModel->getItem($order_id);
                    $orderPackageModel = WoobookingModel::getInstance('packageOrder');
                    $this->order_package = $orderPackageModel->getItem($order_id);
                    $paymentModel = WoobookingModel::getInstance('payment');
                    $list_rate = (array)($this->order->list_rate);
                    if (!empty($list_rate)) {
                        $this->paymentPlugin = $paymentModel->getPaymentPlugin($this->order->payment_id);
                    } else {
                        $this->paymentPlugin = $paymentModel->getPaymentPlugin($this->order_package->payment_id);
                    }
            }

            return parent::display($tpl);
        }
    }
}