<?php
$doc = Factory::getDocument();
$doc->addScript('resources/js/twbs-pagination/jquery.twbsPagination.js');
$doc->addScript('nb_apps/nb_woobooking/js/view_list_finance.js');
$doc->addLessStyleSheet('nb_apps/nb_woobooking/less/view_list_finance.less');
?>
<div class="view-list-finance">
    <div class="toolbar">
        <div class="row">
            <div class="col-md-3"><h3><?php esc_attr_e('List finance','wpbookingpro')?></h3></div>
            <div class="col-md-9">
                <div class="pull-right">
                    <button class="btn btn-primary btn-add-new"><?php esc_attr_e('Add new','wpbookingpro')?></button>
                    <button class="btn btn-primary btn-delete"><?php esc_attr_e('Delete','wpbookingpro')?></button>
                </div>
            </div>
        </div>
    </div>
    <div class="filter">
        <div class="row">
            <div class="col-md-12">
                <?php

                echo LayoutHelper::render('WooBooking.searchtools.default', array('view' => $this));
                ?>
            </div>
        </div>
    </div>
    <table class="table table-bordered tab-content table-striped table-hover list-finance main-table">
        <thead>
        <tr>
            <th><input type="checkbox" class="checked-all"></th>
            <th><?php esc_attr_e('Payment date','wpbookingpro')?>:</th>
            <th><?php esc_attr_e('Customer','wpbookingpro')?>:</th>
            <th><?php esc_attr_e('Employee','wpbookingpro')?>:</th>
            <th><?php esc_attr_e('Service/Event','wpbookingpro')?>:</th>
            <th><?php esc_attr_e('Status','wpbookingpro')?>:</th>
            <th></th>
        </tr>
        </thead>
        <tbody>
		<?php foreach ($this->list as $item) { ?>
			<?php $this->item = $item ?>
			<?php $this->loadTemplate('list_item') ?>
		<?php } ?>
        </tbody>
    </table>
    <div class="row">
        <div class="col-md-12">
            <div class="pagination-list-finance"></div>
        </div>
    </div>
</div>