<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_list_category.less');
?>
<div class="view-list-category">
    <h1 class="title"><?php esc_attr_e('Our category','wpbookingpro') ?></h1>
    <p class="des"><?php esc_attr_e('Exercise with the leading bodybuilding experts on the world, helping to improve the overall health','wpbookingpro'); ?></p>
    <div class="row">
		<?php foreach ($this->list as $item) { ?>
			<?php
			$list_service = $item->list_service;
			$a_list_service = array_slice($list_service, 0, 3);
			?>
            <div class="col-md-4 col-sm-6">
                <div class="wrapper-category-item">
                    <div class="img-block">
                        <div>
                            <img src="<?php esc_html_e(Factory::getRootUrlPlugin())?>/<?php esc_html_e($item->image) ?>" alt="category-image" />
                        </div>
                    </div>
                    <div class="layer-blur"></div>
                    <div class="layer-content">
                        <h3><a href="<?php esc_html_e($this->frontendGoToLink("service.list",
                                "category_id=" . $item->id)) ?>"><?php esc_html_e($item->name) ?></a></h3>
                        <div class="training">
                            <ul class="list-service pull-left">
                                <?php foreach ($a_list_service as $service) { ?>
                                    <li>
                                        <img class="service-image" src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($service->image) ?>" alt="image-service">
                                    </li>
                                <?php } ?>
                            </ul>
                            <p><?php esc_attr_e('Training','wpbookingpro') ?>:<?php echo count($list_service) ?></p>
                        </div>
                    </div>
                </div>
            </div>
		<?php } ?>
    </div>
</div>
<?php
$doc->addScriptApplySelector('.view-list-category','view_list_category',array(),'nb_apps/nb_woobooking/assets/js/employee/view_list_category.js');