<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_booking_thanks.less');
$item = $this->item;
?>
<div class="view-booking-thanks">
    <div class="col-md-2">
        <?php $this->loadSharedTemplate('account_menu.account_menu') ?>
    </div>
    <div class="col-md-10">
        <div class="wrapper-booking-thanks-content">
            <p><?php esc_attr_e('Thank you! Your order has been recieved','wpbookingpro')?></p>
            <h4><?php esc_attr_e('Order Bank Details','wpbookingpro')?></h4>
            <table class="table table-striped table-order-bank-detail">
                <thead>
                <tr>
                    <th><?php esc_attr_e('Order number','wpbookingpro')?>:</th>
                    <th><?php esc_attr_e('Date','wpbookingpro')?>:</th>
                    <th><?php esc_attr_e('Total','wpbookingpro')?></th>
                    <th><?php esc_attr_e('Payment method','wpbookingpro')?></th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>12</td>
                    <td>January 18, 2016</td>
                    <td>DKK10</td>
                    <td>Direct Bank Transfer</td>
                </tr>
                </tbody>
            </table>
            <p>Il Laboratorio di Oceanologia Sperimentale ed Ecologia Marina è stato fondato nel 2001 e dal 2005
                ha sede all’interno del Porto di Civitavecchia; la struttura consta di 200 mq tra uffici e laboratori
                (laboratorio di elettronica, laboratorio di ecologia, laboratorio di ottica, laboratorio di
                strumentazione oceanografica e biblioteca con circa 1000 titoli di riferimento) e di 180 mq di</p>
            <h4>Order Details</h4>
            <table class="table table-bordered my-order">
                <thead>
                <tr>
                    <th scope="col"><?php esc_attr_e('Customer','wpbookingpro') ?></th>
                    <th scope="col"><?php esc_attr_e('Date','wpbookingpro') ?></th>
                    <th scope="col"><?php esc_attr_e('Time','wpbookingpro') ?></th>
                    <th scope="col"><?php esc_attr_e('Employee','wpbookingpro') ?></th>
                    <th scope="col"><?php esc_attr_e('Service','wpbookingpro') ?></th>
                    <th scope="col"><?php esc_attr_e('Location','wpbookingpro') ?></th>
                    <th scope="col"><?php esc_attr_e('Payment','wpbookingpro') ?></th>
                </tr>
                </thead>
                <tbody class="tbody-my-order">
				<?php foreach ($item->list_order_detail as $order) { ?>
                    <tr>
                        <th scope="row"><?php esc_html_e($item->customer_full_name) ?></th>
                        <td>
							<?php esc_html_e($order->rate[0]->list_date_detail) ?>
                        </td>
                        <td><?php esc_html_e($order->rate[0]->list_time_detail) ?></td>
                        <td><?php esc_html_e($order->rate[0]->employee_fullname) ?></td>
                        <td><?php esc_html_e($order->rate[0]->service_name) ?></td>
                        <td><?php esc_html_e($order->rate[0]->location_address) ?></td>
                        <td><?php esc_html_e(WpBookingPro_FrontEndHelper::format_currency($item->total)) ?></td>
                    </tr>
				<?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php
$doc->addScriptApplySelector('.view-booking-thanks','view_booking_thanks',array(),'nb_apps/nb_woobooking/assets/js/view_booking_thanks.js');