<?php

use WooBooking\CMS\Utilities\Utility;

WpBookingPro_HtmlFrontend::_('jquery.slider_pro_master');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_service_detail.less');
?>
    <div class="view-service-detail">
        <div class="slideshow">
            <div class="slider-pro" id="my-slider">
                <div class="sp-slides">
					<?php foreach ($this->item->list_image as $image) { ?>
                        <div class="sp-slide">
                            <img class="sp-image" src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($image->path); ?>" alt="service-iamge" />
                        </div>
					<?php } ?>
                </div>
            </div>
        </div>
        <div class="wrapper-content">
            <div class="row">
                <div class="col-md-6">
                    <div class="pull-left">
                        <img class="cover-image-service" src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($this->item->image) ?>" alt="image-service" />
                    </div>
                    <div class="pull-left">
                        <p><?php $this->item->category_name ?></p>
                        <h3><?php $this->item->name ?></h3>
                        <p> <?php esc_attr_e('Capacity','wpbookingpro') ?>:<?php $this->item->minimum_capacity ?>
                            - <?php $this->item->maximum_capacity ?></p>
                        <p> <?php esc_attr_e('Duration','wpbookingpro') ?>:<?php $this->item->duration ?>h</p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="pull-right">
                        <button class="price-service">$<?php $this->item->price ?></button>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <h4 class="service-detail-training-info"><?php esc_attr_e('Training info','wpbookingpro') ?></h4>
                </div>
                <div class="col-md-6">
                    <h4><?php esc_attr_e('Trainers','wpbookingpro') ?></h4>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="pull-left service-content">
                        <h4><?php esc_attr_e('Category','wpbookingpro') ?>:</h4>
                        <h4><?php esc_attr_e('Duration','wpbookingpro') ?>:</h4>
                        <h4><?php esc_attr_e('Capacity','wpbookingpro') ?>:</h4>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="pull-right ">
                        <h4 class="service-detail-name-category"><?php esc_html_e($this->item->category->name) ?></h4>
                        <h4><?php esc_html_e($this->item->duration) ?>h</h4>
                        <h4><?php esc_html_e($this->item->minimum_capacity) ?> - <?php esc_html_e($this->item->maximum_capacity) ?></h4>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="trainer-service">
						<?php foreach ($this->item->list_employee as $list_employee) { ?>
                            <div class="trainer-service-detail">
                                <div class="row ">
                                    <img class="cover-image-service-trainer" src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($list_employee->image); ?>" alt="service-trainer" />
                                    <h4 class="trainer-service-detail-name"><?php esc_html_e($list_employee->full_name); ?></h4>
                                </div>
                            </div>
						<?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-service-detail','view_service_detail',array(),'nb_apps/nb_woobooking/assets/js/view_service_detail.js');