<?php
defined('_WPBOOKINGPRO_EXEC') or die;

use WooBooking\CMS\Registry\Registry;
use WooBooking\CMS\Utilities\Utility;
if(!class_exists("WpBookingPro_serviceModel")) {
    /**
     * Class WpBookingPro_serviceModel
     */
    class WpBookingPro_serviceModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $table_name = "service";
        /**
         * @var string
         */
        public $context = "service";

        /**
         * @param int $id
         * @return mixed|object
         */
        public function getItem($id = 0)
        {

            $item = (object)parent::getItem($id); // TODO: Change the autogenerated stub

            $input = Factory::getInput();
            $input->set('id', $id);
            $query = $this->db->getQuery(true);
            $query->select('gallery.*')
                ->from($this->getTableName('gallery') . ' as gallery')
                ->where('gallery.object_id=' . (int)$item->id)
                ->where('gallery.type=' . $query->quote("service"));
            $item->list_image = $this->db->setQuery($query)->loadObjectList();
            $query->clear()
                ->select('category.*')
                ->from($this->getTableName('category') . ' AS category')
                ->where('category.id=' . (int)$item->category_id);
            $item->category = $this->db->setQuery($query)->loadObject();
            $query->clear()
                ->select('employee.*')
                ->from($this->getTableName('employee') . ' AS employee')
                ->leftJoin($this->getTableName('service_employee') . ' AS service_employee ON service_employee.employee_id=employee.id')
                ->where('service_employee.service_id=' . (int)$item->id);
            $list_employee = $this->db->setQuery($query)->loadObjectList();
            $list_employee_id = [];
            foreach ($list_employee as $employee) {
                $employee->full_name = Utility::getFullName($employee->first_name, $employee->last_name);
                array_push($list_employee_id, $employee->id);
            }
            $item->list_employee = $list_employee;
            $item->list_employee_id = $list_employee_id;
            $query->clear()
                ->select('location.*')
                ->from($this->getTableName('location') . ' AS location')
                ->where('location.id=' . (int)$item->location_id)
            ;
            $location = $this->db->setQuery($query)->loadObjectList();
            $item->location = reset($location);

            $register = new Registry();
            $register->loadString($item->params);
            $item->params = $register;
            return $item;
        }
        public function getReviewByServiceId($id=0) {
            $list_reviews=[];
            $query = $this->db->getQuery(true);
            $query->select('review.*')
                ->from($this->getTableName('review').' AS review')
                ->where('review.service_id='.(int)$id)
            ;
            $list_reviews = $this->db->setQuery($query)->loadObjectList();
            foreach ($list_reviews as &$review){
                $review->rating_avg=($review->rating_service + $review->rating_staff + $review->rating_ambience)/3;
            }
            return $list_reviews;
        }
        public function getEventByServiceId($id=0) {
            $list_event=[];
            $query = $this->db->getQuery(true);
            $query->select('event.*')
                ->from($this->getTableName('event').' AS event')
                ->where('event.service_id='.(int)$id)
                ;
            $list_event = $this->db->setQuery($query)->loadObjectList();
            foreach ($list_event as &$item) {
                $query->clear()
                    ->select("employee.*")
                    ->from($this->getTableName('employee') . ' AS employee')
                    ->leftJoin($this->getTableName('event_employee') . ' AS event_employee ON event_employee.employee_id=employee.id')
                    ->where('event_employee.event_id=' . (int)$item->id);
                $list_employee = $this->db->setQuery($query)->loadObjectList();
                foreach ($list_employee as &$employee) {
                    $employee->full_name = Utility::getFullName($employee->first_name, $employee->last_name);
                }
                $item->list_employee = $list_employee;
                $query->clear()
                    ->select('location.*')
                    ->from($this->getTableName('location') . ' AS location')
                    ->where('location.id=' . (int)$item->location_id);
                $item->list_location = $this->db->setQuery($query)->loadObjectList();

                $query->clear()
                    ->select('rate.*')
                    ->from($this->getTableName('rate') . ' AS rate')
                    ->where('rate.object_id=' . (int)$item->id)
                    ->where('rate.type=' . $query->quote(WpBookingPro_RateHelper::getEventName()));
                $list_rate = $this->db->setQuery($query)->loadObjectList();
                $arrDate = [];
                $dateView = '';
                foreach ($list_rate as &$rate) {
                    $arrDateFrom = date_parse_from_format('Y-m-d H:i:s', $rate->from);
                    $arrDateTo = date_parse_from_format('Y-m-d H:i:s', $rate->to);
                    $dateFromTs = mktime(0, 0, 0, $arrDateFrom['month'], $arrDateFrom['day'], $arrDateFrom['year']);
                    $dateToTs = mktime(0, 0, 0, $arrDateTo['month'], $arrDateTo['day'], $arrDateTo['year']);
                    $timeFromTs = mktime($arrDateFrom['hour'], $arrDateFrom['minute'], $arrDateFrom['second'],
                        $arrDateFrom['month'], $arrDateFrom['day'], $arrDateFrom['year']);
                    $timeToTs = mktime($arrDateTo['hour'], $arrDateTo['minute'], $arrDateTo['second'], $arrDateTo['month'],
                        $arrDateTo['day'], $arrDateTo['year']);
                    $dateFrom = date('F j, Y', $dateFromTs);
                    $dateTo = date('F j, Y', $dateToTs);
                    $timeFrom = date('g:i a', $timeFromTs);
                    $timeTo = date('g:i a', $timeToTs);
                    if ($dateFromTs != $dateToTs) {
                        $dateView .= ' , ' . $dateFrom . ' - ' . $dateTo . ' ' . $timeFrom . ' - ' . $timeTo;
                    } else {
                        $dateView .= ' , ' . $dateFrom . ' ' . $timeFrom . ' - ' . $timeTo;
                    }
                    $arrDate[] = $dateFromTs;
                    $arrDate[] = $dateToTs;
                    $rate->start_time = date('g:i A', $timeFromTs);
                    $rate->end_time = date('g:i A', $timeToTs);

                }
                $item->date_view = $dateView;
                if (!empty($arrDate)) {
                    $item->min_date = min($arrDate);
                    $item->max_date = max($arrDate);
                } else {
                    $item->min_date = 0;
                    $item->max_date = 0;
                }
                $item->list_rate = $list_rate;
            }
            return $list_event;
        }
    }
}
