<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_GalleriesModel")) {
    /**
     * Class WpBookingPro_GalleriesModel
     */
    class WpBookingPro_GalleriesModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $table_name = "gallery";
        /**
         * @var string
         */
        public $context = "galleries";

        /**
         * @return mixed
         */
        public function getList()
        {
            $list = parent::getList(); // TODO: Change the autogenerated stub
            foreach ($list as &$item) {
                $item->full_name = Utility::getFullName($item->first_name, $item->last_name);
            }
            return $list;
        }

        /**
         * @param $list_gallery_id
         * @return mixed
         */
        public function getListGalleryByArrayGalleryId($list_gallery_id)
        {
            $query = $this->db->getQuery(true);
            $query->select("gallery.*")
                ->from($this->getTableName('gallery') . ' AS gallery')
                ->where('gallery.id IN(' . implode(',', $list_gallery_id) . ')');
            $listGallery = $this->db->setQuery($query)->loadObjectList();
            return $listGallery;
        }
    }
}
