<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_CategoriesModel")) {
    /**
     * Class WpBookingPro_CategoriesModel
     */
    class WpBookingPro_CategoriesModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $table_name = "category";
        /**
         * @var string
         */
        public $context = "categories";

        /**
         * @return \WooBooking\CMS\Database\DatabaseQuery
         */
        public function getListQuery()
        {
            $query = $this->db->getQuery(true);
            $query->select("a.*")
                ->from($this->getTableName() . ' AS a')
                ->where('a.published=1');
            $query->order($this->getState('list.ordering', 'a.ordering') . ' ' . $this->getState('list.direction', 'ASC'));
            return $query;
        }

        /**
         * @return mixed
         */
        public function getList()
        {
            $list = parent::getList(); // TODO: Change the autogenerated stub
            $query = $this->db->getQuery(true);
            foreach ($list as &$item) {
                $query->clear()
                    ->select('service.*')
                    ->from($this->getTableName('service') . ' AS service')
                    ->where('service.category_id=' . (int)$item->id)
                    ->where('service.published=1')
                    ;
                $item->list_service = $this->db->setQuery($query)->loadObjectList();
            }
            return $list;
        }

        /**
         * @param array $list_category_id
         * @return mixed
         */
        public function getListCategoryByArrayCategoryId($list_category_id = array())
        {
            $query = $this->db->getQuery(true);
            $query->select("category.*")
                ->from($this->getTableName('category') . ' AS category');
            if (!empty($list_category_id)) {
                $query->where('category.id IN(' . implode(',', $list_category_id) . ')');
            }
            $listCategory = $this->db->setQuery($query)->loadObjectList();
            return $listCategory;
        }
    }
}
