<?php

defined('_WPBOOKINGPRO_EXEC') or die;

$item = (object)$displayData['data'];
$display = $item->text;
switch ((string)$item->text) {

	case WoobookingText::_('JLIB_HTML_START') :
		$icon = 'fas fa-fast-backward icon-first';
		break;

	case $item->text === WoobookingText::_('JPREV') :
		$item->text = WoobookingText::_('JPREVIOUS');
		$icon = 'fas fa-caret-left icon-previous';
		break;

	case WoobookingText::_('JNEXT') :
		$icon = 'fas fa-caret-right icon-next';
		break;

	case WoobookingText::_('JLIB_HTML_END') :
		$icon = 'fas fa-fast-forward icon-last';
		break;
	default:
		$icon = null;
		break;
}
if ($icon !== null) {
	$display = '<span class="' . $icon . '"></span>';
}
if ($displayData['active']) {
	if ($item->base > 0) {
		$limit = 'limitstart.value=' . $item->base;
	} else {
		$limit = 'limitstart.value=0';
	}
	$cssClasses = array();
	$title = '';
	if (!is_numeric($item->text)) {
		WpBookingPro_HtmlFrontend::_('bootstrap.tooltip');
		$cssClasses[] = 'hasTooltip';
		$title = ' title="' . $item->text . '" ';
	}
	$onClick = 'document.adminForm.' . $item->prefix . 'limitstart.value=' . ($item->base > 0 ? $item->base : '0') . '; WooBooking.submitform();return false;';
} else {
	$class = (property_exists($item, 'active') && $item->active) ? 'active' : 'disabled';
}
?>
<?php if ($displayData['active']) : ?>
    <li>
        <a <?php echo($cssClasses ? 'class="' . implode(' ',
				$cssClasses) . '"' : ''); ?> <?php esc_html_e($title); ?> href="#"
                                                                                           onclick="<?php esc_html_e($onClick); ?>">
			<?php echo($display); ?>
        </a>
    </li>
<?php else : ?>
    <li class="<?php esc_html_e($class); ?>">
        <span><?php echo($display); ?></span>
    </li>
<?php endif;
