<?php

defined('_WPBOOKINGPRO_EXEC') or die;

extract($displayData);

if ($multiple) {
	WpBookingPro_HtmlFrontend::_('jquery.ui', array('core', 'sortable'));
	WpBookingPro_HtmlFrontend::_('script', 'system/subform-repeatable.js', array('version' => 'auto', 'relative' => true));
}

$table_head = '';
if (!empty($groupByFieldset)) {
	foreach ($tmpl->getFieldsets() as $fieldset) {
		$table_head .= '<th>' . WoobookingText::_($fieldset->label);
		if ($fieldset->description) {
			$table_head .= '<br /><small style="font-weight:normal">' . WoobookingText::_($fieldset->description) . '</small>';
		}
		$table_head .= '</th>';
	}
	$sublayout = 'section-byfieldsets';
} else {
	foreach ($tmpl->getGroup('') as $field) {
		$table_head .= '<th>' . strip_tags($field->label);
		if ($field->description) {
			$table_head .= '<br /><small style="font-weight:normal">' . WoobookingText::_($field->description) . '</small>';
		}
		$table_head .= '</th>';
	}
	$sublayout = 'section';
	
	Factory::getDocument()->addStyleDeclaration(
		'.subform-table-sublayout-section .controls { margin-left: 0px }'
	);
}
?>
<div class="row-fluid">
    <div class="subform-repeatable-wrapper subform-table-layout subform-table-sublayout-<?php esc_html_e($sublayout); ?> form-vertical">
        <div
                class="subform-repeatable"
                data-bt-add="a.group-add-<?php esc_html_e($unique_subform_id); ?>"
                data-bt-remove="a.group-remove-<?php esc_html_e($unique_subform_id); ?>"
                data-bt-move="a.group-move-<?php esc_html_e($unique_subform_id); ?>"
                data-repeatable-element="tr.subform-repeatable-group-<?php esc_html_e($unique_subform_id); ?>"
                data-rows-container="tbody.rows-container-<?php esc_html_e($unique_subform_id); ?>"
                data-minimum="<?php esc_html_e($min); ?>" data-maximum="<?php esc_html_e($max); ?>"
        >
            <table class="adminlist table table-striped table-bordered">
                <thead>
                <tr>
					<?php esc_html_e($table_head); ?>
					<?php if (!empty($buttons)) : ?>
                        <th style="width:8%;">
							<?php if (!empty($buttons['add'])) : ?>
                                <div class="btn-group">
                                    <a
                                            class="btn btn-mini button btn-success group-add group-add-<?php esc_html_e($unique_subform_id); ?>"
                                            aria-label="<?php esc_attr_e('Jglobal field add','wpbookingpro'); ?>"
                                    >
                                        <span class="icon-plus" aria-hidden="true"></span>
                                    </a>
                                </div>
							<?php endif; ?>
                        </th>
					<?php endif; ?>
                </tr>
                </thead>
                <tbody class="rows-container-<?php esc_html_e($unique_subform_id); ?>">
				<?php foreach ($forms as $k => $form):
					esc_html_e($this->sublayout(
						$sublayout,
						array(
							'form' => $form,
							'basegroup' => $fieldname,
							'group' => $fieldname . $k,
							'buttons' => $buttons,
							'unique_subform_id' => $unique_subform_id,
						)
					));
				endforeach; ?>
                </tbody>
            </table>
			<?php if ($multiple) : ?>
                <template class="subform-repeatable-template-section" style="display: none;"><?php
					
					echo str_replace(
						array('<', '>'),
						array('SUBFORMLT', 'SUBFORMGT'),
						trim(
							$this->sublayout(
								$sublayout,
								array(
									'form' => $tmpl,
									'basegroup' => $fieldname,
									'group' => $fieldname . 'X',
									'buttons' => $buttons,
									'unique_subform_id' => $unique_subform_id,
								)
							)
						)
					);
					?></template>
			<?php endif; ?>
        </div>
    </div>
</div>
