(function ($) {
    $.field_reviewstar = function (element, options) {
        var defaults = {
            field_name: 0
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let field_name = plugin.settings.field_name;
            $element.find('.stars li').on('mouseover', function () {
                let onStar = parseInt($(this).data('value'), 10);
                $(this).parent().children('li.star').each(function (e) {
                    if (e < onStar) {
                        $(this).addClass('hover');
                    } else {
                        $(this).removeClass('hover');
                    }
                });
            }).on('mouseout', function () {
                $(this).parent().children('li.star').each(function (e) {
                    $(this).removeClass('hover');
                });
            });

            $element.find('.stars li').on('click', function () {
                let onStar = parseInt($(this).data('value'), 10);
                $element.find(`input[name="${field_name}"]`).val(onStar);
                let stars = $(this).parent().children('li.star');
                $(this).parent().children('li.star').each(function (e) {
                    if (e < onStar) {
                        $(this).addClass('hover');
                    } else {
                        $(this).removeClass('hover');
                    }
                });

            }).on('mouseout', function () {
                $(this).parent().children('li.star').each(function (e) {
                    $(this).removeClass('hover');
                });
            });
            $element.find('.stars_service li').on('click', function () {
                let onStar = parseInt($(this).data('value'), 10);
                let stars = $(this).parent().children('li.star');
                let i =0;
                for (i = 0; i < stars.length; i++) {
                    $(stars[i]).removeClass('selected');
                }

                for (i = 0; i < onStar; i++) {
                    $(stars[i]).addClass('selected');
                }
                let ratingValue = parseInt($('#stars li.selected').last().data('value'), 10);
                let msg = "";
                if (ratingValue > 1) {
                    msg = "Thanks! You rated this " + ratingValue + " stars.";
                } else {
                    msg = "We will improve ourselves. You rated this " + ratingValue + " stars.";
                }
                plugin.responseMessage(msg);

            });
        };
        plugin.responseMessage = function(msg) {
            $('.success-box').fadeIn(200);
            $('.success-box div.text-message').html("<span>" + msg + "</span>");
        }
        plugin.getValue = function () {
            let field_name = plugin.settings.field_name;
            return $element.find(`input[name="${field_name}"]`).val();
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_reviewstar = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_reviewstar')) {
                var plugin = new $.field_reviewstar(this, options);
                $(this).data('field_reviewstar', plugin);
            }
        });
    }
})(jQuery);
