<?php
use WooBooking\CMS\Utilities\Utility;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_HtmlFrontend::_('jquery.fontawesome');
WpBookingPro_HtmlFrontend::_('jquery.daterangepicker');
WpBookingPro_HtmlFrontend::_('jquery.select2');
WpBookingPro_HtmlFrontend::_('jquery.moment');

$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>"
         class="<?php esc_html_e($class); ?> element-field-recurring hide-option">
        <label class="label"><input type="checkbox" class="recurring" name="<?php esc_html_e($name); ?>" value="1"  />
            <?php esc_attr_e('This is recurring event','wpbookingpro')?></label>
        <div class="option form-horizontal invisible">
            <div class="form-group">
                <label for="repeat" class="col-sm-2 control-label "><?php esc_attr_e('Repeat event','wpbookingpro')?></label>
                <div class="col-sm-10">
                    <select id="repeat-event" name="<?php esc_html_e($name_recurring_repeat) ?>" class="form-control repeat-event">
                        <option value="weekly"><?php esc_attr_e('Weekly','wpbookingpro')?></option>
                        <option value="monthly"><?php esc_attr_e('Monthly'.'wpbookingpro')?></option>
                        <option value="yearly"><?php esc_attr_e('Yearly','wpbookingpro')?></option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label for="until-when" class="col-sm-2 control-label"><?php esc_attr_e('Until when','wpbookingpro')?></label>
                <div class="col-sm-10">
                    <input type="text" class="form-control until-when" id="recurring_state" />
                    <input type="hidden" name="<?php esc_html_e($name_recurring_until) ?>" />
                </div>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.element-field-recurring','field_recurring',array(),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/recurring.jquery.js');