<?php


use WooBooking\CMS\Utilities\Utility;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$doc = Factory::getDocument();
WpBookingPro_HtmlFrontend::_('jquery.moment');
WpBookingPro_HtmlFrontend::_('jquery.daterangepicker');
WpBookingPro_HtmlFrontend::_('jquery.ui');
$doc->addLessStylesheet('nb_apps/nb_woobooking/layouts/WooBooking/form/field/pickdatetimedropdown.less');
$data = $displayData['field']->getForm()->getData();
$event_id = $data->def('id', 0);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>"
         class="<?php esc_html_e($class); ?> field-pickdatetimedropdown-<?php esc_html_e($name_format) ?> field-pickdatetimedropdown">
        <div class="select-date-time">
            <span class="pick-icon-calendar"><i class="far fa-calendar-alt"></i></span>
            <input type="text" class="calendar form-control" />
            <input type="hidden" name="<?php esc_html_e($name); ?>" value="<?php esc_html_e($value) ?>" />
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.field-pickdatetimedropdown','field_pickdatetimedropdown',array(
    "field_name"=>  $name,
),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/pickdatetimedropdown.jquery.js');
