<?php
defined('_WPBOOKINGPRO_EXEC') or die;use WooBooking\CMS\Utilities\Utility;extract($displayData);
WpBookingPro_HtmlFrontend::_('jquery.framework');
WpBookingPro_HtmlFrontend::_('jquery.select2');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "field-paymentsimage-" . Utility::gen_random_integer();
$name_format = str_replace(array('[', ']'), '_', $name);
$paymentsModel = WoobookingModel::getInstance('payments');
$list_payment = $paymentsModel->getList();
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-paymentsimage-<?php esc_html_e($name_format) ?> field-paymentsimage">
        <ul class="list-payment">
			<?php foreach ($list_payment as $item) { ?>
				<?php
				if ($disable_payment_online && $item->is_payment_online) {
					continue;
				}
				?>
                <li class="<?php echo($item->is_payment_online ? ' payment-online ' : '') ?>">
                    <div class="wrapper-payment" data-payment_id="<?php esc_html_e($item->id); ?>">
                        <div class="non-selected" ><i class="far fa-circle"></i></div>
                        <div class="selected" style="display: none"><i class="fas fa-check-circle"></i></div>
                        <span class="payment-name"><?php esc_html_e($item->name);?></span>
                    </div>
                </li>
			<?php } ?>
        </ul>
        <input type="text" name="<?php esc_html_e($name); ?>" required="true" style="display: none" />
        <input type="hidden" name="<?php esc_html_e($name); ?>" value="<?php esc_html_e($value) ?>" />
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('nb_apps/nb_woobooking/layouts/WooBooking/form/field/paymentsimage.less');
$doc->addScriptApplySelector('.field-paymentsimage','field_paymentsimage',array(
    "field_name"=>  $name,
),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/paymentsimage.jquery.js');