<?php

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


WpBookingPro_HtmlFrontend::_('jquery.framework');
WpBookingPro_HtmlFrontend::_('jquery.ui');
$doc = Factory::getDocument();
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$name_title = $data->def('name');
$arrName = explode(' ', $name_title);
$iconImg = '';
for ($i = 0; $i < 3; $i++) {
	$iconImg .= substr($arrName[$i], 0, 1);
}
$iconImg = strtoupper($iconImg);
$images = $value;
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-gallery hide-option">
        <select name="<?php esc_html_e($name); ?>" <?php echo($multiple ? ' multiple ' : '') ?>
                class="form-control list-category">
            <option value=""><?php esc_attr_e('Select location','wpbookingpro')?></option>
			<?php foreach ($images as $image) { ?>
                <li data-id="<?php esc_html_e($image->id); ?>" class="image-item">
                    <i class="far fa-trash-alt remove"></i>
                    <img class="image" src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($image->path); ?>" alt="image-item">
                </li>
			<?php } ?>
            <li>
                <div class="upload"><i class="far fa-plus-square"></i></div>
            </li>
        </select>
        <input type="file" class="upload" style="display: none"/>
        <input type="hidden" class="deleted" name="<?php esc_html_e($name_field_deleted) ?>"  style="display: none"/>
    </div>
<?php

$doc->addScriptApplySelector('.field-gallery','field_gallery',array(
    "input_name"=>  $name,
    "name_field_deleted"=>  $name_field_deleted
),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/gallery.jquery.js');