<?php

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


WpBookingPro_HtmlFrontend::_('jquery.framework');
WpBookingPro_HtmlFrontend::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));

$format = '<input type="checkbox" id="%1$s" name="%2$s" value="%3$s" %4$s />';

$alt = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $name);
?>
<fieldset id="<?php esc_html_e($id); ?>" class="<?php echo(trim($class . ' checkboxes')); ?>"
	<?php echo($required ? 'required aria-required="true"' : ''); ?>
	<?php echo($autofocus ? 'autofocus' : ''); ?>
	<?php foreach ($options as $i => $option) : ?>
		<?php

		$checked = in_array((string)$option->value, $checkedOptions, true) ? 'checked' : '';

		$checked = (!$hasValue && $option->checked) ? 'checked' : $checked;
		$optionClass = !empty($option->class) ? 'class="' . $option->class . '"' : '';
		$optionDisabled = !empty($option->disable) || $disabled ? 'disabled' : '';

		$onclick = !empty($option->onclick) ? 'onclick="' . $option->onclick . '"' : '';
		$onchange = !empty($option->onchange) ? 'onchange="' . $option->onchange . '"' : '';
		$oid = $id . $i;
		$value = htmlspecialchars($option->value, ENT_COMPAT, 'UTF-8');
		$attributes = array_filter(array($checked, $optionClass, $optionDisabled, $onchange, $onclick));
		?>
        <label for="<?php esc_html_e($oid); ?>" class="checkbox">
			<?php echo(sprintf($format, $oid, $name, $value, implode(' ', $attributes))); ?>
			<?php esc_html_e($option->text); ?></label>
	<?php endforeach; ?>
</fieldset>
