<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_woobooking_event_controller")) {
    /**
     * Class WpBookingPro_woobooking_event_controller
     */
    class WpBookingPro_woobooking_event_controller extends woobooking_controller_frontend
    {
        /**
         * @return mixed
         * @throws Exception
         */
        public function ajax_get_item()
        {
            return self::view("event.form");
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function ajax_add_new_event()
        {
            //TODO check permission add new
            return self::view("event.form");
        }

        /**
         * @param string $data_post
         * @return array|bool|mixed
         * @throws Exception
         */
        public function ajax_save($data_post = "")
        {
            $input = Factory::getInput();
            if (!$data_post) {
                $data_post = $input->getData()['data'];
            }
            $rates = $data_post['rates'];
            $custom_address = $data_post['custom_address'];
            if ($data_post['location_id'] == "" && $custom_address != "") {
                $modelLocation = $this->getModel('location');
                $location = [
                    'address' => $custom_address,
                    'published' => 1
                ];
                $dataLocation = $modelLocation->save($location);
                $data_post['location_id'] = $dataLocation['id'];
            }
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $tags = $data_post['tags'];
            $event = parent::save($data_post); // TODO: Change the autogenerated stub
            $modelRate = $this->getModel('rate');
            $query->clear()
                ->delete(WoobookingTable::getWBTable('rate'))
                ->where('event_id=' . $event['id']);
            $db->setQuery($query)->execute();
            if (count($rates)) {
                foreach ($rates as $rate) {
                    list($from, $to) = explode(";", $rate);
                    $item_rate = [
                        "from" => Factory::getDate($from)->toSql(),
                        "to" => Factory::getDate($to)->toSql(),
                        "event_id" => $event['id']
                    ];
                    $item_rate = $modelRate->save($item_rate);
                }
            }
            $list_tag_id = [];
            if (count($tags)) {
                $query->clear()
                    ->delete(WoobookingTable::getWBTable('event_tag'))
                    ->where('event_id=' . $event['id']);
                $db->setQuery($query)->execute();
                $modelTags = $this->getModel('tags');
                foreach ($tags as $tag) {
                    $item = $modelTags->getTagByName($tag);
                    if (!$item) {
                        $data_tag = [
                            "name" => $tag
                        ];
                        $item = $modelTags->save($data_tag);
                    }
                    $list_tag_id[] = $item->id;
                }
            }
            if ($event && count($list_tag_id)) {
                $query->clear()
                    ->delete(WoobookingTable::getWBTable('event_tag'))
                    ->where('event_id=' . $event['id']);
                $db->setQuery($query)->execute();
                foreach ($list_tag_id as $rate_id) {
                    $query->clear()
                        ->insert(WoobookingTable::getWBTable('event_tag'))
                        ->set('event_id=' . $event['id'])
                        ->set('tag_id=' . $rate_id);
                    $db->setQuery($query)->execute();
                }
            }
            return $event;
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function ajax_get_rang_time_avail()
        {
            $data = json_decode(file_get_contents('php://input'));
            $date = $data->date;
            $event_id = $data->event_id;
            $event_model = $this->getModel('event');
            $list_date = $event_model->get_rang_time_avail($event_id, $date);
            return $list_date;
        }
    }
}

?>