<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Utilities\Utility;
if(!class_exists("WpBookingPro_BookingController")) {
    /**
     * Class WpBookingPro_BookingController
     */
    class WpBookingPro_BookingController extends woobooking_controller_frontend
    {
        /**
         * @return bool
         * @throws Exception
         */
        public function ajax_add_rate_to_cart()
        {
            $input = Factory::getInput();
            $data = $input->getData();
            $list_range_time = $data['list_range_time'];
            WC()->frontend_includes();
            WC()->init();
            wc_load_cart();
            $modelEvents = WoobookingModel::getInstance('events');
            $events = $modelEvents->getListEventByListRateId($list_range_time);
            foreach ($events as $event) {
                if ($event->open_source_link_id) {
                    $product = wc_get_product($event->open_source_link_id);
                    WC()->cart->add_to_cart($event->open_source_link_id);
                }
            }
            return true;
        }

        /**
         * @throws Exception
         */
        public function book_now()
        {
            $app = Factory::getApplication();
            $input = Factory::getInput();
            $data = $input->getData();
            $modelBooking = WoobookingModel::getInstance('booking');
            $order = $modelBooking->book_now($data);
            Utility::redirect(Utility::getFrontendGoToLink("payment.paynow", array("order_id" => $order->id)));
        }
        public function book_service()
        {
            $app = Factory::getApplication();
            $input = Factory::getInput();
            $data = $input->getData();
            $modelBooking = WoobookingModel::getInstance('booking');
            $order = $modelBooking->book_service($data);
            Utility::redirect(Utility::getFrontendGoToLink("payment.paynow", array("order_id" => $order->id)));
        }

        /**
         * @return bool
         * @throws Exception
         */
        public function book_now_from_calendar()
        {
            $app = Factory::getApplication();
            $input = Factory::getInput();
            $data = $input->getData();
            $data['rate_id'] = reset($data['rates']);
            $modelBooking = WoobookingModel::getInstance('booking');
            $order = $modelBooking->book_now($data);
            if ($order->id) {
                //$this->frontendGoToLink('booking.thanks','order_id='.$order->id);
                return true;
            } else {
                return false;
            }
        }

        /**
         * @return bool
         * @throws Exception
         */
        public function add_rate_to_cart()
        {
            $input = Factory::getInput();
            $data = $input->getData();
            $list_range_time = $data['list_range_time'];
            if (null === \WC()->cart) {
                WC()->cart = new \WC_Cart();
            }
            require_once ABSPATH . "/wp-content/plugins/woocommerce/includes/wc-notice-functions.php";
            $modelEvents = WoobookingModel::getInstance('events');
            $events = $modelEvents->getListEventByListRateId($list_range_time);
            foreach ($events as $event) {
                $product = wc_get_product($event->open_source_link_id);
                WC()->cart->add_to_cart($event->open_source_link_id);
            }
            return true;
        }
    }
}