"use strict";
(function ($) {
    $.view_service_detail = function (element, options) {
        let defaults = {
        }
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.sp-slides').slick({
                dots: true,
                infinite: true,
                slidesToShow: 1,
                slidesToScroll: 1,
                arrows: true,
                responsive: [{
                    breakpoint: 600,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                    {
                        breakpoint: 400,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }]
            });
            let checkbox = $element.find('input[name="checkbox"].yes-no');
            $element.delegate('input.yes-no', 'lcs-statuschange', function () {
                var status = ($(this).is(':checked')) ? 'checked' : 'unchecked';
                if (status === "checked") {
                    $element.find('.number-person').show(100, 'swing')
                } else {
                    $element.find('.number-person').hide(100, 'swing')
                }
            });
            $element.find('form[name="client-form"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.btn-save-booking').click(function (e) {
                let $form = $(this).closest('form');
                let employee_id = $form.find('input[name="employee_id"]').val();
                let location_id = $form.find('select[name="location"].list-location').val();
                if (!$form.valid()) {
                    return false;
                }
                if (employee_id == '') {
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your employee</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-confirm',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (location_id == '') {
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your location</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-confirm',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                $form.submit();
            });
            $element.find('.btn-show-calendar').click(function (e) {
                $element.find('.select-bringing_anyone').animate({width: '40%'}, 500);
                $element.find('.select-date-picker').addClass('active-picker');
                $element.find('.btn-show-calendar').hide();
            });
            $element.find('.btn-hide-calendar').click(function (e) {
                $element.find('.select-date-picker').removeClass('active-picker');
                $element.find('.select-bringing_anyone').animate({width: '100%'}, 500);
                $element.find('.btn-show-calendar').show();
            });
            $element.find('.rate-item .time').live('click', function (e) {
                $element.find('.btn-book-now').show();
            });
            $element.find('.btn-book-now').live('click', function (e) {
                $element.find('.form-input').addClass('active-form-input');
                $element.find('.wrapper-book-form-item-1').addClass('remove-calendar')
            });
            $element.find('.btn-cancel-booking').click(function (e) {
                $element.find('.form-input').removeClass('active-form-input');
                $element.find('.wrapper-book-form-item-1').removeClass('remove-calendar')
            });
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_service_detail = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_service_detail')) {
                let plugin = new $.view_service_detail(this, options);
                $(this).data('view_service_detail', plugin);
            }
        });
    }
})(jQuery);
