<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Filesystem\File;

require_once WPBOOKINGPRO_PATH_ROOT . "/nb_apps/nb_woobooking/html/WooBookingHtmlFrontend.php";
require_once WPBOOKINGPRO_PATH_ROOT . "/nb_apps/nb_woobooking/helpers/RateHelper.php";
if(!class_exists("WpBookingPro_FrontEndHelper")) {
    /**
     * Class WpBookingPro_FrontEndHelper
     */
    class WpBookingPro_FrontEndHelper
    {
        /**
         * @param int $cost
         * @param string $currency
         * @return string
         */
        public static function format_currency($cost = 0, $currency = "$")
        {
            return "$currency $cost";
        }

        /**
         * @param int $cost
         * @param string $hour
         * @return string
         */
        public static function format_hour($cost = 0, $hour = "h")
        {
            return "$cost $hour ";
        }

        public static function get_rating_star($rating = 0,$max_star=5)
        {
            $list_star =[];
            while ($rating > $max_star) {
                $rating = $rating - $max_star;
            }
            $star = $rating % 10;
            $non_star = ($max_star - $rating) % 10;
            $half_star = ceil($max_star-$star-$non_star);
            $list_star=array($star, $half_star, $non_star);
            return $list_star;
        }

        /**
         * @return bool
         */
        public static function is_multi_product_in_cart()
        {
            $appConfig = Factory::getAppConfig();
            return (boolean)$appConfig->get('multi_product_in_cart', 0);
        }

        /**
         * @param $dir
         * @param array $results
         * @param $exclude
         * @param $filter
         * @return array
         */
        public function getDirContents($dir, &$results = array(), $exclude, $filter)
        {
            $files = scandir($dir);
            foreach ($files as $key => $value) {
                $extension = File::getExt($value);
                if (in_array($value, $exclude) || !in_array($extension, $filter)) {
                    continue;
                }
                $path = realpath($dir . DIRECTORY_SEPARATOR . $value);
                if (!is_dir($path)) {
                    $results[] = $path;
                } else {
                    if ($value != "." && $value != "..") {
                        self::getDirContents($path, $results, $exclude, $filter);
                        $results[] = $path;
                    }
                }
            }
            return $results;
        }
    }
}