<?php
/**
 * @package     woobooking.Platform
 * @subpackage  Form
 *
 * @copyright   Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('_WPBOOKINGPRO_EXEC') or die;

FormHelper::loadFieldClass('list');

/**
 * Form Field class for the woobooking Platform.
 * Provides a list of available database connections, optionally limiting to
 * a given list.
 *
 * @see    JDatabaseDriver
 * @since  1.7.3
 */
class WpBookingPro_FormFieldDatabaseConnection extends JFormFieldList
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 * @since  1.7.3
	 */
	protected $type = 'DatabaseConnection';

	/**
	 * Method to get the list of database options.
	 *
	 * This method produces a drop down list of available databases supported
	 * by JDatabaseDriver classes that are also supported by the application.
	 *
	 * @return  array  The field option objects.
	 *
	 * @since   1.7.3
	 * @see     JDatabaseDriver::getConnectors()
	 */
	protected function getOptions()
	{
		// This gets the connectors available in the platform and supported by the server.
		$available = JDatabaseDriver::getConnectors();

		/**
		 * This gets the list of database types supported by the application.
		 * This should be entered in the form definition as a comma separated list.
		 * If no supported databases are listed, it is assumed all available databases
		 * are supported.
		 */
		$supported = $this->element['supported'];

		if (!empty($supported))
		{
			$supported = explode(',', $supported);

			foreach ($supported as $support)
			{
				if (in_array($support, $available))
				{
					$options[$support] = WoobookingText::_(ucfirst($support));
				}
			}
		}
		else
		{
			foreach ($available as $support)
			{
				$options[$support] = WoobookingText::_(ucfirst($support));
			}
		}

		// This will come into play if an application is installed that requires
		// a database that is not available on the server.
		if (empty($options))
		{
			$options[''] = WoobookingText::_('JNONE');
		}

		return $options;
	}
}
