<?php
/**
 * @package     woobookingpro.Platform
 * @subpackage  Archive
 *
 * @copyright   Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('_WPBOOKINGPRO_EXEC') or die;



use WooBooking\CMS\NBArchive\Archive;

/**
 * An Archive handling class
 *
 * @since       1.5
 * @deprecated  4.0 use the Woobookingpro\Archive\Archive class instead
 */
class NBArchive
{
	/**
	 * The array of instantiated archive adapters.
	 *
	 * @var    ArchiveExtractable[]
	 * @since  3.0.0
	 */
	protected static $adapters = array();

	/**
	 * Extract an archive file to a directory.
	 *
	 * @param   string  $archivename  The name of the archive file
	 * @param   string  $extractdir   Directory to unpack into
	 *
	 * @return  boolean  True for success
	 *
	 * @since   1.5
	 * @throws  InvalidArgumentException
	 * @deprecated  4.0 use the Woobookingpro\Archive\Archive class instead
	 */
	public static function extract($archivename, $extractdir)
	{
		// The archive instance
		$archive = new Archive(array('tmp_path' => JFactory::getConfig()->get('tmp_path')));

		// Extract the archive
		return $archive->extract($archivename, $extractdir);
	}

	/**
	 * Get a file compression adapter.
	 *
	 * @param   string  $type  The type of adapter (bzip2|gzip|tar|zip).
	 *
	 * @return  ArchiveExtractable  Adapter for the requested type
	 *
	 * @since   1.5
	 * @throws  UnexpectedValueException
	 * @deprecated  4.0 use the Woobookingpro\Archive\Archive class instead
	 */
	public static function getAdapter($type)
	{
		if (!isset(self::$adapters[$type]))
		{
			// Try to load the adapter object
			$class = 'NBArchive' . ucfirst($type);

			if (!class_exists($class))
			{
				throw new UnexpectedValueException('Unable to load archive', 500);
			}

			self::$adapters[$type] = new $class;
		}

		return self::$adapters[$type];
	}
}
