<?php

defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\Utilities\ArrayHelper;
extract($displayData);

if (!$readonly)
{
	WpBookingPro_Html::_('behavior.modal', 'a.modal_' . $id);
	WpBookingPro_Html::_('script', 'jui/fielduser.min.js', array('version' => 'auto', 'relative' => true));
}

$uri = new NBUri('index.php?option=com_users&view=users&layout=modal&tmpl=component&required=0');

$uri->setVar('field', $this->escape($id));

if ($required)
{
	$uri->setVar('required', 1);
}

if (!empty($groups))
{
	$uri->setVar('groups', base64_encode(json_encode($groups)));
}

if (!empty($excluded))
{
	$uri->setVar('excluded', base64_encode(json_encode($excluded)));
}


if ($this->escape($userName) === WoobookingText::_('JLIB_FORM_SELECT_USER'))
{
	$userName = '';
}

$inputAttributes = array(
	'type' => 'text', 'id' => $id, 'value' => $this->escape($userName)
);

if ($size)
{
	$inputAttributes['size'] = (int) $size;
}

if ($required)
{
	$inputAttributes['required'] = 'required';
}

if (!$readonly)
{
	$inputAttributes['placeholder'] = WoobookingText::_('JLIB_FORM_SELECT_USER');
}

$anchorAttributes = array(
	'class' => 'btn btn-primary modal_' . $id, 'title' => WoobookingText::_('JLIB_FORM_CHANGE_USER'), 'rel' => '{handler: \'iframe\', size: {x: 800, y: 500}}'
);

?>
<div class="input-append">
	<input <?php echo ArrayHelper::toString($inputAttributes); ?> readonly />
	<?php if (!$readonly) : ?>
		<?php echo WpBookingPro_Html::_('link', (string) $uri, '<span class="icon-user"></span>', $anchorAttributes); ?>
	<?php endif; ?>
</div>
<?php if (!$readonly) : ?>
	<input type="hidden" id="<?php wpbookingpro_render_content($id); ?>_id" name="<?php wpbookingpro_render_content($name); ?>" value="<?php echo (int) $value; ?>" data-onchange="<?php $this->escape($onchange); ?>" />
<?php endif; ?>