<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$list = '';

if ($options)
{
	$list = 'list="' . $id . '_datalist"';
}

$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;

$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name="element_field_".str_replace(array('[',']'),'_',$name);
?>
<div id="<?php wpbookingpro_render_content($id_by_name) ?>" class="<?php wpbookingpro_render_content($class); ?> element-field-trainer hide-option">
    <select name="<?php wpbookingpro_render_content($name); ?>" class="form-control list-location">
        <option value="weekly"><?php echo WoobookingText::_('WEEKLY')?></option>
        <option value="monthly"><?php echo WoobookingText::_('MONTHLY')?></option>
        <option value="yearly"><?php echo WoobookingText::_('YEARLY')?></option>
    </select>
</div>
<?php
$doc=Factory::getDocument();
WpBookingPro_HtmlFrontend::_('jquery.moment');
WpBookingPro_HtmlFrontend::_('jquery.daterangepicker');
WpBookingPro_HtmlFrontend::_('jquery.select2');
WpBookingPro_HtmlFrontend::_('jquery.fontawesome');
$doc->addScriptApplySelector('.element-field-trainer','field_trainer',array(
),'layouts/WooBooking/form/field/trainer.jquery.js');