<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$list = '';

if ($options)
{
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;

$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name="element_field_".str_replace(array('[',']'),'_',$name);
?>
<div id="<?php wpbookingpro_render_content($id_by_name) ?>" class="<?php wpbookingpro_render_content($class); ?> element-field-recurring hide-option">
    <label class="label"><input type="checkbox" name="<?php wpbookingpro_render_content($name); ?>" value="1" class="recurring" /><?php WoobookingText::_('THIS_IS_RECURRING_EVENT')?></label>
    <div class="option form-horizontal invisible">
        <div class="form-group">
            <label for="repeat" class="col-sm-2 control-label ">Repeat Event</label>
            <div class="col-sm-10">
                <select id="repeat-event" name="<?php $name_recurring_repeat ?>" class="form-control repeat-event">
                    <option value="weekly"><?php echo WoobookingText::_('WEEKLY')?></option>
                    <option value="monthly"><?php echo WoobookingText::_('MONTHLY')?></option>
                    <option value="yearly"><?php echo WoobookingText::_('YEARLY')?></option>
                </select>
            </div>
        </div>
        <div class="form-group">
            <label for="until-when" class="col-sm-2 control-label">Until when?</label>
            <div class="col-sm-10">
                <input type="text" class="form-control until-when"   id="recurring_state" />
                <input type="hidden"  name="<?php $name_recurring_until ?>" />
            </div>
        </div>
    </div>
</div>
<?php
$doc=Factory::getDocument();
WpBookingPro_HtmlFrontend::_('jquery.moment');
WpBookingPro_HtmlFrontend::_('jquery.daterangepicker');
WpBookingPro_HtmlFrontend::_('jquery.select2');
WpBookingPro_HtmlFrontend::_('jquery.fontawesome');
$doc->addScriptApplySelector('.element-field-recurring','field_recurring',array(
),'layouts/WooBooking/form/field/recurring.jquery.js');