<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;

extract($displayData);
WpBookingPro_Html::_('jquery.select2');

$list = '';

if ($options)
{
	$list = 'list="' . $id . '_datalist"';
}

$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;

$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name="element_field_".str_replace(array('[',']'),'_',$name);
$locationsModel=WoobookingModel::getInstance('locations');
$list_location=$locationsModel->getList();

?>
<div id="<?php wpbookingpro_render_content($id_by_name) ?>" class="<?php wpbookingpro_render_content($class); ?> field-location">
    <select name="<?php wpbookingpro_render_content($name); ?>" class="form-control list-location">
        <option value=""><?php echo WoobookingText::_('SELECT_LOCATION')?></option>
        <?php foreach ($list_location as $location){ ?>
            <option <?php wpbookingpro_render_content($value==$location->id?' selected ':'') ?> value="<?php wpbookingpro_render_content($location->id);?>"><?php wpbookingpro_render_content($location->address);?></option>
        <?php } ?>
    </select>
</div>
<?php
$doc=Factory::getDocument();
$doc->addScriptApplySelector('.field-location','field_location',array(
),'layouts/WooBooking/form/field/location.jquery.js');