<?php
use WooBooking\CMS\Utilities\Utility;

defined('_WPBOOKINGPRO_EXEC') or die;

extract($displayData);

WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('script', 'system/html5fallback.js', array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));

$list = '';

if ($options)
{
	$list = 'list="' . $id . '_datalist"';
}

$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;

$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name="element_field_".str_replace(array('[',']'),'_',$name);
$data=$displayData['field']->getForm()->getData();
$name=$data->def('name');
$arrName = explode(' ', $name);
$iconImg='';
for ($i=0; $i<3; $i++) {
    $iconImg .= substr($arrName[$i], 0, 1);
}
$iconImg = strtoupper($iconImg);
?>
    <div id="<?php wpbookingpro_render_content($id_by_name) ?>" class="<?php wpbookingpro_render_content($class); ?> field-cover hide-option">
       <div class="img-location">
           <i class="far fa-plus-square upload"></i>
           <img class="cover-image" src="<?php echo Factory::getRootUrl() ?>/<?php wpbookingpro_render_content($value) ?>" alt="cover-image" />
           <span><?php wpbookingpro_render_content($iconImg);?></span>
       </div>
        <p><?php wpbookingpro_render_content($name);?></p>
        <input type="file" class="upload" style="display: none" />
    </div>
<?php

$doc=Factory::getDocument();
$doc->addStyleSheet('assets/admin/less/main_style.less');
$doc->addScriptApplySelector('.field-cover','field_cover',array(
),'layouts/WooBooking/form/field/cover.jquery.js');