<?php
use WooBooking\CMS\Application\NBAppHelper;
use WooBooking\CMS\Utilities\Utility;
$doc = Factory::getDocument();
$appConfig = Factory::getAppConfig();
$doc->addLessStyleSheet('blocks/block_startservice/assets/lesss/default.less');
$start_service=array_slice($list_startservice,0,3,false);
?>
    <div class="block-startservice-default">
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <h4 class="title"><?php esc_attr_e('started services','wpbookingpro')?></h4>
            </div>
        </div>
        <?php foreach ($start_service as $startservice) { ?>
            <div class="row">
                <div class="col-sm-12 col-md-12">
                    <div class="wrapper-banner-startservice">
                        <div class="img-startservice">
                            <div>
                                <a href="<?php esc_html_e($this->frontendGoToLink("service.detail_new",
                                    "service_id=" . $startservice->id)) ?>"><img src="<?php echo Factory::getRootUrlPlugin()?>/<?php esc_html_e($startservice->image)  ?>" alt="img-startservice" /></a>
                            </div>
                        </div>
                        <div class="name-startservice">
                            <a href="<?php esc_html_e($this->frontendGoToLink("service.detail_new",
                                "service_id=" . $startservice->id)) ?>"><p class="name"><?php esc_html_e($startservice->name)?></p></a>
                            <h4 class="price"><?php esc_html_e(WpBookingPro_FrontEndHelper::format_currency($startservice->price))?></h4>
                            <div class="time">
                                <i class="far fa-clock"></i>
                                <p class="duration"><?php esc_html_e(WpBookingPro_FrontEndHelper::format_hour($startservice->duration))?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
        </div>

<?php
$doc->addScriptApplySelector('.block-startservice-default','block_startservice_default',array(
),'blocks/block_startservice/assets/js/jquery.block_startservice_default.js');