(function ($) {
    $.block_priceplanclass_default = function (element, options) {
        let defaults = {
            list_package:[]
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let list_package=plugin.settings.list_package;
            let wrapper_block_priceplanclass=$element.find('wrapper-block-priceplanclass');
            $element.find('.wrapper-block-priceplanclass').mouseover(function (e) {
                $element.find('.wrapper-block-priceplanclass').removeClass('priceplanclass-hover');
                $(this).addClass('priceplanclass-hover');
            })
            $element.find('.wrapper-block-priceplanclass').mouseout(function (e) {
                $(this).removeClass('priceplanclass-hover');
                $element.find('#priceplanclass-hover').addClass('priceplanclass-hover');
            });
            $element.find('form[name="client-form"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.btn-buying-modal-now').click(function (e) {
                let $form=$(this).closest('form');
                $form.find('input[name="task"]').val('packageBooking.book_now');
                if(!$form.valid())
                {
                    return false;
                }
                $form.submit();
            });
            $element.find('.btn-continue-booking').click(function (e) {
                let is_ok=true;
                let $list_event_package=$(this).closest('.list-event-package');
                let $list_block_event=$list_event_package.find('.block-event');
                for (let i=0; i<$list_block_event.length;i++) {
                    let $currentTabContent=$($list_block_event[i]);
                    let event_id=$currentTabContent.data('event_id');
                    let employee_id = $currentTabContent.find('.wrapper-list-employee .wrapper-employee.active').data('employee_id');
                    let rate_id = $currentTabContent.find('.wrapper-list-rate  .rate-item.active').data('rate_id');
                    if($currentTabContent.find('.wrapper-list-rate  .rate-item.active').length===0){
                        $.alert({
                            title:'',
                            content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your time</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                            container:'.block-confirm-2',
                            buttons: {
                                formSubmit: {
                                    text: '<i class="icon-nb-close"></i>',
                                    btnClass: 'btn-red',
                                }
                            }
                        })
                        is_ok=false;
                            let href_link_event=$element.find(`.tab-list-event li.event-item-${event_id} a.link-tab`).attr('href');
                            if(`#event-${event_id}`==href_link_event) {
                                $element.find(`.tab-list-event li`).removeClass('active');
                                $element.find('.block-event').removeClass('active');
                                $element.find(`.tab-list-event li.event-item-${event_id}`).addClass('in');
                                $element.find(`#event-${event_id}`).addClass('in');
                                $element.find(`.tab-list-event li.event-item-${event_id}`).addClass('active');
                                $element.find(`#event-${event_id}`).addClass('active');
                            }
                        break;
                    }
                    if($currentTabContent.find('.wrapper-list-employee .wrapper-employee.active').length===0){
                        $.alert({
                            title:'',
                            content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your employee</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                            container:'.block-confirm-2',
                            buttons: {
                                formSubmit: {
                                    text: '<i class="icon-nb-close"></i>',
                                    btnClass: 'btn-red',
                                }
                            }
                        });
                        is_ok=false;
                        let href_link_event=$element.find(`.tab-list-event li.event-item-${event_id} a.link-tab`).attr('href');
                        if(`#event-${event_id}`==href_link_event) {
                            $element.find(`.tab-list-event li`).removeClass('active');
                            $element.find('.block-event').removeClass('active');
                            $element.find(`.tab-list-event li.event-item-${event_id}`).addClass('in');
                            $element.find(`#event-${event_id}`).addClass('in');
                            $element.find(`.tab-list-event li.event-item-${event_id}`).addClass('active');
                            $element.find(`#event-${event_id}`).addClass('active');
                        }
                        break;
                    }
                    if(is_ok) {
                        $currentTabContent.find('input[name="employee_id[]"]').val(employee_id);
                        $currentTabContent.find('input[name="rate_id[]"]').val(rate_id);
                    }
                }
                if(is_ok) {
                    $element.find('.list-event-package').hide();
                    $element.find('.form-customer-info').show();
                    $element.find('.form-info-payment').show();
                    $element.find('.form-input-info-footer').show();

                }
            });
            $element.find('.back-to-step').click(function (e) {
                e.preventDefault();
                $element.find('.list-event-package').show();
                $element.find('.form-customer-info').hide();
                $element.find('.form-info-payment').hide();
                $element.find('.form-input-info-footer').hide();
            })
            $element.find('.btn-close-modal').click(function (e) {

            });
            $element.find('.btn-action-priceplanclass').click(function (e) {
                $element.find('.list-event-package').show();
                $element.find('.form-customer-info').hide();
                $element.find('.form-info-payment').hide();
                $element.find('.form-input-info-footer').hide();
                $element.find('.form-input-info').modal('show');
                $('.custom-wrapper-dialog').find('.ui-widget-header').remove();
                let package_id=$(this).closest('.wrapper-block-priceplanclass').data('package_id');
                $element.find('input[name="package_id"]').val(package_id);
                let select_package=list_package[package_id];

                $element.find('.service-cover').attr('src',`${wpbookingpro_root_url_plugin}/${select_package.image}`);
                $element.find('.service-name').text(select_package.name);
                $element.find('.base-price').text('$ '+ select_package.price);
                $element.find('.total-cost-sum').text('$ '+ select_package.price);
                let $list_event=select_package.list_event;
                let $list_event_package=$element.find('.list-event-package');
                let $tab_list_event=$element.find('ul.tab-list-event');
                $tab_list_event.empty();
                let $tab_list_event_content=$element.find('.tab-list-event-content');
                $tab_list_event_content.empty();
                let $i=1;
                $.each($list_event, function (index,event) {
                    let $li=$(`<li class="${index=='0' ? 'active':''} tab-list-event-item event-item-${event.id}"><a class="link-tab" data-toggle="tab" href="#event-${event.id}">Event-${$i}</a></li>`);
                    $i++;
                    $li.appendTo($tab_list_event);
                    let $list_rate=event.list_rate;
                    let $list_employee=event.list_employee;
                    let $wrapper_list_rate=$(`<div class="wrapper-list-rate"></div>`);
                    let $wrapper_list_employee=$(`<div class="wrapper-list-employee"></div>`);
                    let $link_tab_event=$(`<div id="event-${event.id}" data-event_id="${event.id}" class="block-event tab-pane fade in ${index=='0' ? 'active':''}"></div>`);
                    let $ul=$(`<ul></ul>`);
                    let $h5_1=$(`<h5>Select Time: </h5>`);
                    $.each($list_rate, function (index,rate) {
                        let $li=$(`<li><span data-rate_id="${rate.id}"  class="el-radio-button__inner rate-item"><i class="far fa-circle"></i> <i class="far fa-check-circle"></i>  <span>${rate.start_time}-${rate.end_time}</span></span></li>`);
                        $li.appendTo($ul);
                    });
                    $h5_1.appendTo($wrapper_list_rate);
                    $ul.appendTo($wrapper_list_rate);
                    $wrapper_list_rate.append('<input type="hidden" name="rate_id[]">');
                    $wrapper_list_rate.appendTo($link_tab_event);
                    let $row=$(`<div class="row"></div>`);
                    let $ul2=$(`<ul  class="list-employee"></ul>`);
                    let $h5_2=$(`<h5>Select Trainer: </h5>`);
                    $.each($list_employee, function (index, employee) {
                        let $li = $(`<div class="col-sm-3">
                                        <li >
                                            <div class="wrapper-employee" data-employee_id="${employee.id}">
                                                <div class="selected" style="display: none"><i class="fas fa-check-circle"></i></div>
                                                <div class="img-box">
                                                    <div>
                                                        <img class="employee-image-choose" src="${wpbookingpro_root_url_plugin}/${employee.image}" alt="" />
                                                    </div>
                                                </div>
                                                <div class="employee-name">${employee.first_name + employee.last_name}</div>
                                            </div>
                                        </li>
                                     </div>`);
                        $li.appendTo($ul2);
                    });
                    $h5_2.appendTo($wrapper_list_employee);
                    $ul2.appendTo($row);
                    $row.appendTo($wrapper_list_employee);
                    $wrapper_list_employee.append('<input type="hidden" name="employee_id[]">');
                    $wrapper_list_employee.appendTo($link_tab_event);
                    $link_tab_event.appendTo($tab_list_event_content);
                    $ul2.find('.wrapper-employee').click(function (e) {
                        $ul2.find('.wrapper-employee').removeClass('active');
                        $ul2.find('.selected').hide();
                        let $self=$(this);
                        $self.addClass('active');
                        $element.find('.wrapper-employee .selected').hide();
                        let employee_id=$self.data('employee_id');
                        $self.find('.selected').show();
                        $element.find(`input[name="employee_id"]`).val(employee_id);
                    });
                    $ul.find('.rate-item').click(function (e) {
                        let $self=$(this);
                        $ul.find('.rate-item').removeClass('active');
                        $self.addClass('active');
                    });
                });
                $tab_list_event.prependTo($list_event_package);

            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    };

    $.fn.block_priceplanclass_default = function (options) {

        return this.each(function () {

            if (undefined === $(this).data('block_priceplanclass_default')) {
                let plugin = new $.block_priceplanclass_default(this, options);
                $(this).data('block_priceplanclass_default', plugin);
            }
        });
    }
})(jQuery);