<?php

use WooBooking\CMS\Utilities\Utility;

WpBookingPro_Html::_('jquery.icheck');
WpBookingPro_Html::_('jquery.confirm');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_tool.less');
$input = Factory::getInput();
$step = $input->getInt('step', 0);
$step++;
$toolChecked = $input->get('tool', array(), 'array');
?>
    <div class="view-tool-form">
        <div class="notification-before-download hide">
            <p><?php esc_attr_e('Before download please check database structor','wpbookingpro') ?> </p>
            <p><?php esc_attr_e('When you successfully download, please open with phpstorm then check the error code','wpbookingpro') ?> </p>
        </div>
        <div class="tool-bar">
            <div class="row">
                <div class="col-md-12">
                    <div class="pull-right">
                        <a class="btn btn-primary"
                           href="<?php esc_html_e($this->goToTaskLink('tool', 'create_view')) ?>"><?php esc_attr_e('Create view','wpbookingpro') ?></a>
                        <a class="btn btn-primary"
                           href="<?php esc_html_e($this->goToTaskLink('tool', 'list_page_front_end')) ?>"><?php esc_attr_e('List page frontend','wpbookingpro') ?></a>

                        <a class="btn btn-primary"
                           href="<?php esc_html_e($this->goToTaskLink('tool', 'setup_view')) ?>"><?php esc_attr_e('Setup view','wpbookingpro') ?></a>
                        <a class="btn btn-primary"
                           href="<?php esc_html_e($this->goToTaskLink('tool', 'create_sample_data')) ?>"><?php esc_attr_e('Create sample data','wpbookingpro') ?></a>
                        <a class="btn btn-primary btn-download-package"
                           href="<?php esc_html_e($this->goToTaskLink('tool', 'download_package')) ?>"><?php esc_attr_e('Download package','wpbookingpro') ?></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-main-tool">
            <form action="#" name="admin-form" method="post">
                <div class="row">
                    <div class="col-md-offset-3 col-md-9">
                        <h3 class="setup"><?php esc_attr_e('Setup','wpbookingpro') ?></h3>
                    </div>
                </div>
                <div class="body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="wrapper-tool">
                                <ul class="list-tool">
                                    <li>
                                        <label>
                                            <input class="tool-item" name="tool[]" <?php echo(in_array("setup_sample_page", $toolChecked) ? ' checked ' : '')  ?> value="setup_sample_page" type="checkbox" />
                                            <?php esc_attr_e('Setup page sample','wpbookingpro') ?>
                                        </label>
                                    </li>
                                    <li>
                                        <label>
                                            <input class="tool-item" name="tool[]" <?php echo(in_array("setup_sample_database", $toolChecked) ? ' checked ' : '')  ?> value="setup_sample_database" type="checkbox" />
                                            <?php esc_attr_e('Setup sample database','wpbookingpro') ?>
                                        </label>
                                    </li>
                                    <li>
                                        <label>
                                            <input class="tool-item" name="tool[]" <?php echo(in_array("backup_database", $toolChecked) ? ' checked ' : '')  ?> value="backup_database" type="checkbox" />
                                            <?php esc_attr_e('Backup database','wpbookingpro') ?>
                                        </label>
                                    </li>
                                    <li>
                                        <label>
                                            <input class="tool-item" name="tool[]" <?php echo(in_array("backup_media", $toolChecked) ? ' checked ' : '')  ?> value="backup_media" type="checkbox" />
                                            <?php esc_attr_e('Backup media','wpbookingpro') ?>
                                        </label>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-9">
                            <div class="description">
                                <?php esc_attr_e('Description when hover tool','wpbookingpro') ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="tool-bar pull-right">
                            <button class="btn btn-primary btn-next" type="button"><?php esc_attr_e('Next','wpbookingpro') ?></button>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="step" value="<?php esc_html_e($step) ?>" />
                <input type="hidden" name="task" value="tool.next" />
            </form>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-tool-form','view_tool',array(
    "step"=>  (int)$step,
    "tool_check"=>  json_encode($toolChecked),
),'admin/nb_apps/nb_woobooking/assets/js/view_tool.js');
