<?php
$item = $this->item;
?>
<div class="wrapper-category-item <?php esc_html_e($this->index_category == 0 ? ' active ' : '') ?> "
     data-id="<?php esc_html_e($item->id); ?>" data-ordering="<?php esc_html_e($item->ordering); ?>"
     href="#tab-category-<?php esc_html_e($item->id); ?>"
     aria-controls="tab-category-<?php esc_html_e($item->id); ?>" role="tab" data-toggle="tab">
    <div class="wrapper-category-content">
        <div class="header">
            <div class="row">
                <div class="col-md-12">
                    <div class="category-item-content">
                        <div class="pull-left"><i class="menu-icon flaticon-menu-1"></i></div>
                        <div class="category-item-content pull-left">
                            <div class="name"><?php esc_html_e($item->name); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="body">
            <div class="row">
                <div class="col-md-12">
                    <div class="wrapper-body">
                        <div class="pull-left">
                            <span class="label label-info"><?php printf('%s Services',
									count((array)$item->list_service)) ?></span>
                        </div>
                        <div class="pull-right">
                            <ul class="list-action">
                                <li class="category-edit">
                                    <a href="javascript:void(0)" class="btn-category-edit" data-id="<?php esc_html_e($item->id); ?>">
                                        <i class="far fa-edit"></i>
                                    </a>
                                </li>
                                <li class="category-save" style="display: none">
                                    <a href="javascript:void(0)" class="btn-category-save" data-id="<?php esc_html_e($item->id); ?>">
                                        <i class="far fa-save"></i>
                                    </a>
                                </li>
                                <li class="category-cancel" style="display: none">
                                    <a href="javascript:void(0)" class="btn-category-cancel" data-id="<?php esc_html_e($item->id); ?>">
                                        <i class="far fa-times-circle"></i>
                                    </a>
                                </li>
                                <li class="category-clone" style="display: none">
                                    <a href="javascript:void(0)" class="btn-category-clone" data-id="<?php esc_html_e($item->id); ?>">
                                        <i class="far fa-copy" data-id="<?php esc_html_e($item->id); ?>"></i>
                                    </a>
                                </li>
                                <li class="category-remove">
                                    <a href="javascript:void(0)" class="btn-category-remove" data-id="<?php esc_html_e($item->id); ?>">
                                        <i class="far fa-trash-alt"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
