<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
WpBookingPro_Html::_('jquery.ui');
WpBookingPro_Html::_('jquery.icheck');
$doc->addScript('resources/js/Content-editable/src/jquery-contenteditable.es6');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_list_service.less');
ob_start();
$this->loadTemplate('list_service_item');
$html_service_item = ob_get_clean();
ob_start();
$this->loadTemplate('list_category_item');
$html_category_item = ob_get_clean();
?>
    <div class="view-list-service">
        <div class="toolbar">
            <div class="row">
                <div class="col-md-3"><h3><?php esc_attr_e('List service','wpbookingpro') ?></h3></div>
                <div class="col-md-9">
                    <div class="pull-right">
                        <button class="btn btn-primary btn-add-new-service"><i class="far fa-plus-square"></i><span><?php esc_attr_e('Add new','wpbookingpro') ?></span>
                        </button>
                        <button class="btn btn-primary btn-delete-service"><i
                                    class="fas fa-trash-alt"></i><span><?php esc_attr_e('Delete','wpbookingpro') ?></span></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="list-service-service main-table">
            <div class="row">
                <div class="col-md-4">
                    <h4><?php esc_attr_e('All categories','wpbookingpro') ?></h4>
                    <div class="list-category nav nav-tabs" role="tablist">
                    <?php foreach ($this->list_service_by_category as $index_category=>  $category) { ?>
                        <?php $this->item=$category ?>
                        <?php $this->index_category=$index_category ?>
                        <?php  $this->loadTemplate('list_category_item') ?>
                    <?php } ?>
                </div>
                    <button class="btn btn-primary btn-block btn-add-category"><i class="far fa-plus-square"></i><?php esc_attr_e('Add category','wpbookingpro') ?></button>
                </div>
                <div class="col-md-8">
                    <h4><?php esc_attr_e('All services','wpbookingpro') ?></h4>
                    <div class="wrapper-list-service-by-category tab-content">
						<?php foreach ($this->list_service_by_category as $index_category => $category) { ?>
                            <div class="list-service-by-category tab-pane <?php esc_html_e($index_category == 0 ? ' active ' : null) ?>"
                                 role="tabpanel" id="tab-category-<?php esc_html_e($category->id); ?>"
                                 data-category_id="<?php esc_html_e($category->id); ?>">
                             <?php foreach ($category->list_service as $service) { ?>
                                 <?php $this->item=$service ?>
                                <?php  $this->loadTemplate('list_service_item') ?>
                             <?php } ?>
                         </div>
						<?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-service','view_list_service',array(
    "list_service_by_category"=>  $this->list_service_by_category,
    "html_service_item"=>  $html_service_item,
    "html_category_item"=>  $html_category_item,
),'admin/nb_apps/nb_woobooking/assets/js/view_list_service.js');