<?php

use WooBooking\CMS\Utilities\Utility;



WpBookingPro_Html::_('jquery.icheck');
$doc = Factory::getDocument();
$doc->addScript('resources/js/twbs-pagination/jquery.twbsPagination.js');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_list_review.less');
ob_start();
$this->loadTemplate('list_item');
$row_review_template = ob_get_clean();
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
$saveOrder = $listOrder == 'a.ordering';
$columns = 10;
if (strpos($listOrder, 'publish_up') !== false) {
	$orderingColumn = 'publish_up';
} elseif (strpos($listOrder, 'publish_down') !== false) {
	$orderingColumn = 'publish_down';
} elseif (strpos($listOrder, 'modified') !== false) {
	$orderingColumn = 'modified';
} else {
	$orderingColumn = 'created';
}
if ($saveOrder) {
	$saveOrderingUrl = 'index.php?option=com_content&task=articles.saveOrderAjax&tmpl=component';
	WpBookingPro_Html::_('sortablelist.sortable', 'articleList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}
?>
    <div class="view-list-review">
        <form action="#" method="post" name="adminForm" id="adminForm">
            <div class="toolbar">
                <div class="row">
                    <div class="col-md-3"><?php esc_attr_e('List review','wpbookingpro')?></h3></div>
                    <div class="col-md-9">
                        <div class="pull-right">
                            <button class="btn btn-primary btn-add-new" type="button"><i class="fas fa-plus-square"></i><span><?php esc_attr_e('Add new','wpbookingpro')?></span>
                            </button>
                            <button class="btn btn-primary btn-delete" type="button"><i class="fas fa-trash-alt"></i><span><?php esc_attr_e('Delete','wpbookingpro')?></span></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table-review">
                <table class="table  tab-content table-striped table-hover list-review main-table table-responsive">
                    <thead>
                    <tr>
                        <th class="nowrap"><i class="fas fa-sort-down"></i></th>
                        <th class="nowrap"><input type="checkbox" class="checked-all" /></th>
                        <th class="view-list-review-th nowrap"><?php echo (WpBookingPro_Html::_('searchtools.sort',
								'REVIEWER', 'review.name', $listDirn, $listOrder, null, 'asc',
								'GRID_HEADING_ORDERING', 'fas fa-sort-amount-down-alt')); ?></th>
                        <th class="view-list-review-th nowrap"><?php esc_attr_e('Comment','wpbookingpro')?></th>
                        <th class="view-list-review-th nowrap"><?php esc_attr_e('Email','wpbookingpro')?></th>
                        <th class="view-list-review-th nowrap"><?php esc_attr_e('Rating','wpbookingpro')?></th>
                        <th class="view-list-review-th nowrap"><?php esc_attr_e('Service Name','wpbookingpro')?></th>
                        <th class="view-list-review-th nowrap"><?php esc_attr_e('Note','wpbookingpro')?></th>
                        <th class="view-list-review-th nowrap"><?php esc_attr_e('Id','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody class="list-review main-table">
					<?php foreach ($this->list as $item) { ?>
						<?php $this->item = $item ?>
						<?php $this->loadTemplate('list_item') ?>
					<?php } ?>
                    </tbody>
                </table>
            </div>
            <input type="hidden" name="list[ordering]" />
        </form>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-review','view_list_review',array(
    "row_review_template"=>  $row_review_template,
),'admin/nb_apps/nb_woobooking/assets/js/view_list_review.js');