<?php

use WooBooking\CMS\Utilities\Utility;

WpBookingPro_Html::_('jquery.select2');
WpBookingPro_Html::_('jquery.icheck');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/list_view_order_package.less');
?>
    <div class="view-list-order-package">
        <div class="toolbar">
            <div class="row">
                <div class="col-md-3"><h3><?php esc_attr_e('List order package','wpbookingpro') ?></h3></div>
                <div class="col-md-9">
                    <div class="pull-right">
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="pull-right">
                    <button class="btn btn-primary btn-delete" type="button"><i
                            class="fas fa-trash-alt"></i><span><?php esc_attr_e('Delete','wpbookingpro') ?></span></button>
                </div>
            </div>
        </div>
        <div class="wrapper-table-package">
            <table class="table table-list-order_package table-responsive">
                <thead>
                <tr class="header">
                    <th class="nowrap"></th>
                    <th class="nowrap"><?php esc_attr_e('Package','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_attr_e('Customer','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_attr_e('Payment','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_attr_e('Status','wpbookingpro') ?></th>
                    <th class="nowrap"></th>
                    <th class="nowrap"></th>
                    <th class="nowrap"></th>
                </tr>
                </thead>
                <?php foreach ($this->list as $item) { ?>
                    <tbody>
                    <tr class="row-item-order table-warning" data-order_id="<?php esc_html_e($item->id) ?>">
                        <td class="nowrap">
                            <div class="wrapper-check-item">
                                <input type="checkbox" class="checkbox-item" name="list_delete_order_id[]"  value="<?php esc_html_e($item->id) ?>" />
                            </div>
                        </td>
                        <td class="nowrap"><?php esc_html_e($item->package->name); ?></td>
                        <td class="nowrap"><?php esc_html_e($item->customer->customer_full_name); ?></td>
                        <td class="nowrap"><?php esc_html_e(WpBookingPro_Helper::format_currency($item->total)); ?></td>
                        <td class="nowrap">
                            <div class="list-order-status">
                                <select class="order-status">
                                    <?php foreach ($this->list_order_status as $order_status) { ?>
                                        <option <?php echo((isset($item->order_status_id)&&$order_status->id == $item->order_status_id) ? ' selected ' : '') ?>
                                                value="<?php esc_html_e($order_status->id); ?>"><?php esc_html_e($order_status->title); ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </td>
                        <td class="nowrap"></td>
                        <td class="nowrap">
                            <button style="display: none" class="btn btn-primary btn-edit-order_package"><i
                                        class="fas fa-pencil-alt"></i><span><?php esc_attr_e('Edit order','wpbookingpro') ?></span>
                            </button>
                        </td>
                        <td class="show-rate-detail">
                            <i class="fas fa-sort-down"></i>
                        </td>
                    </tr>
                    <?php if(count((array)$item->list_order_package )) {?>
                        <tr class="list-rate-info list-rate-info-<?php esc_html_e($item->id); ?>">
                            <th class="nowrap"></th>
                            <th class="nowrap"><?php esc_attr_e('Start time','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('End time','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('Assigned to','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('Service','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('Duration','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('Location','wpbookingpro') ?></th>
                            <th class="nowrap"></th>
                        </tr>
                        <?php foreach ($item->list_order_package as $order_package) { ?>
                            <tr class="list-rate-info list-rate-info-<?php esc_html_e($item->id); ?>"
                                data-id="<?php esc_html_e($order_package->id); ?>">
                                <td class="nowrap"></td>
                                <td class="nowrap"><?php esc_html_e(WpBookingPro_Html::_('date', isset($order_package->rate->start_date)?$order_package->rate->start_date:"",
                                        WoobookingText::_('DATETIME_FORMAT_2'))); ?></td>
                                <td class="nowrap"><?php esc_html_e(WpBookingPro_Html::_('date', isset($order_package->rate->end_date)?$order_package->rate->end_date:"",
                                        WoobookingText::_('DATETIME_FORMAT_2'))); ?></td>
                                <td class="nowrap">
                                    <img class="employee-item-image pull-left" src="<?php echo Factory::getRootUrlPlugin() . $order_package->employee_image ?>" alt="employee-item-image" />
                                    <h4 class="pull-left employee-item-name"><?php echo(isset($order_package->employee_full_name)?$order_package->employee_full_name:""); ?></h4>
                                </td>
                                <td class="nowrap"><?php esc_html_e($order_package->service_name); ?></td>
                                <td class="nowrap"><?php esc_html_e($order_package->rate->duration); ?></td>
                                <td class="nowrap"><?php esc_html_e($order_package->location_address); ?></td>
                                <td class="nowrap">
                                    <button style="display: none" class="btn btn-primary btn-edit-order-detail"><i
                                            class="fas fa-pencil-alt"></i><span><?php esc_attr_e('Edit','wpbookingpro') ?></span>
                                    </button>
                                </td>
                            </tr>
                        <?php } ?>
                    <?php }?>
                    </tbody>
                <?php } ?>
            </table>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-order-package','list_view_order_package',array(
),'admin/nb_apps/nb_woobooking/assets/js/list_view_order_package.js');