<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
$doc->addScript('resources/js/twbs-pagination/jquery.twbsPagination.js');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_list_location.less');
?>

    <div class="view-list-location">
        <div class="toolbar">
            <div class="row">
                <div class="col-md-3"><h3><?php esc_attr_e('List location','wpbookingpro') ?></h3></div>
                <div class="col-md-9">
                    <div class="pull-right">
                        <button class="btn btn-primary btn-add-new"><i
                                    class="fas fa-plus-square"></i><span><?php esc_attr_e('Add new','wpbookingpro') ?></span></button>
                        <button class="btn btn-primary btn-delete"><i class="fas fa-trash-alt"></i><span><?php esc_attr_e('Delete','wpbookingpro') ?></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="list-location main-table">
            <div class="row">
				<?php foreach ($this->list as $item) { ?>
                    <div class="col-md-6 col-lg-6 col-xl-4">
                    <?php $this->item=$item ?>
                    <?php  $this->loadTemplate('list_item') ?>
                </div>
				<?php } ?>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-location','view_list_location',array(
),'admin/nb_apps/nb_woobooking/assets/js/view_list_location.js');