<?php
$doc = Factory::getDocument();
WpBookingPro_Html::_('jquery.icheck');
$doc->addScript('resources/js/twbs-pagination/jquery.twbsPagination.js');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_list_event.less');

use WooBooking\CMS\Utilities\Utility;

ob_start();
$this->loadTemplate('list_item');
$row_event_template = ob_get_clean();

?>
    <div class="view-list-event">
        <form action="#" method="post" id="adminForm" name="adminForm">
            <div class="toolbar">
                <div class="row">
                    <div class="col-md-3"><h3><?php esc_attr_e('List event','wpbookingpro') ?></h3></div>
                    <div class="col-md-9">
                        <div class="pull-right">
                            <button class="btn btn-primary btn-add-new" type="button"><i
                                        class="fas fa-plus-square"></i><span><?php esc_attr_e('Add new','wpbookingpro') ?></span></button>
                            <button class="btn btn-primary btn-delete" type="button"><i
                                        class="fas fa-trash-alt"></i><span><?php esc_attr_e('Delete','wpbookingpro') ?></span></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table-event">
                <table class="table-responsive table table-bordered   tab-content table-hover list-event main-table">
                    <thead>
                    <tr>
                        <th class="nowrap"><input type="checkbox" class="checked-all" /></th>
                        <th class="nowrap"><?php esc_attr_e('Name','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Total order','wpbookingpro') ?></th>
                        <th class="hidden-md-up nowrap"><?php esc_attr_e('Spots','wpbookingpro') ?></th>
                        <th class="hidden-md-up nowrap"><?php esc_attr_e('Min max', 'wpbookingpro') ?></th>
                        <th class="hidden-md-up nowrap"><?php esc_attr_e('Recurring','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Booking opens','wpbookingpro') ?> </th>
                        <th class="nowrap"><?php esc_attr_e('Booking close','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Status','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('ID','wpbookingpro') ?></th>
                        <th class="nowrap"></th>
                        <th class="nowrap"></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $i = 0;
                    ?>
                    <?php foreach ($this->list as $item) { ?>
                        <?php
                        $item->index = $i;
                        $this->item = $item;
                        ?>
                        <?php $this->loadTemplate('list_item') ?>
                        <?php
                        $i++;
                        ?>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
        </form>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-event','view_list_event',array(
    "row_event_template"=> $row_event_template
),'admin/nb_apps/nb_woobooking/assets/js/view_list_event.js');
?>